/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.distribution.extracted;

import eu.plumbr.wrapper.deps.org.slf4j.Logger;
import eu.plumbr.wrapper.deps.org.slf4j.LoggerFactory;
import eu.plumbr.wrapper.distribution.extracted.ExtractedDistribution;
import eu.plumbr.wrapper.tools.DigestTools;
import eu.plumbr.wrapper.tools.FileTools;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class DistributionValidator {
    private static final Logger log = LoggerFactory.getLogger(DistributionValidator.class);
    private static final String PROPERTY_HASH = "hash";
    private static final String PROPERTY_MODIFICATION_TIME = "modificationTime";
    private static final String PROPERTY_CHECKSUM = "checksum";

    public boolean validate(ExtractedDistribution distribution) {
        try {
            this.check(distribution);
            return true;
        }
        catch (Exception e) {
            log.error("Validation of extracted distribution {} failed.", (Object)distribution, (Object)e);
            return false;
        }
    }

    private void check(ExtractedDistribution distribution) throws IOException {
        if (!this.performWeakValidation(distribution)) {
            this.performStrongValidation(distribution);
        }
    }

    private boolean performWeakValidation(ExtractedDistribution distribution) throws IOException {
        Properties validationData;
        File directory = distribution.jarLocation.getParentFile();
        File validationFile = new File(directory, "plumbr-agent.checked");
        if (!validationFile.isFile()) {
            log.debug("Validation file does not exist, not performing weak validation.");
            return false;
        }
        try {
            validationData = FileTools.readToProperties(validationFile);
        }
        catch (Exception e) {
            log.debug("Validation file does not exist or is not readable.");
            return false;
        }
        String savedHash = validationData.getProperty(PROPERTY_HASH);
        String savedModificationTime = validationData.getProperty(PROPERTY_MODIFICATION_TIME);
        String savedChecksum = validationData.getProperty(PROPERTY_CHECKSUM);
        if (savedHash == null || savedModificationTime == null || savedChecksum == null) {
            log.debug("Unknown data format in validation file.");
            return false;
        }
        if (!distribution.hash.equals(savedHash)) {
            log.debug("Validation data is for a different hash ({} instead of {}).", (Object)savedHash, (Object)distribution.hash);
            return false;
        }
        String fileModificationTime = String.valueOf(distribution.jarLocation.lastModified());
        if (!fileModificationTime.equals(savedModificationTime)) {
            log.debug("File modification changed from {} to {} since strong validation.", (Object)savedModificationTime, (Object)fileModificationTime);
            return false;
        }
        String fileCrc = String.valueOf(DigestTools.checksumFile(distribution.jarLocation));
        if (!fileCrc.equals(savedChecksum)) {
            log.debug("File CRC32 changed from {} to {} since strong validation.", (Object)savedChecksum, (Object)fileCrc);
            return false;
        }
        log.debug("Distribution {} is valid (weak validation).", (Object)distribution);
        return true;
    }

    private void performStrongValidation(ExtractedDistribution distribution) throws IOException {
        log.debug("Performing strong validation on {}", (Object)distribution);
        String fileHash = DigestTools.digestToHex("SHA-256", distribution.jarLocation);
        if (!fileHash.equalsIgnoreCase(distribution.hash)) {
            throw new RuntimeException("plumbr-agent.jar hash does not match the one specified in hash file.");
        }
        log.debug("Distribution {} is valid (strong validation).", (Object)distribution);
        File validationFile = new File(distribution.jarLocation.getParentFile(), "plumbr-agent.checked");
        try {
            Properties validationInfo = new Properties();
            validationInfo.setProperty(PROPERTY_HASH, distribution.hash);
            validationInfo.setProperty(PROPERTY_MODIFICATION_TIME, String.valueOf(distribution.jarLocation.lastModified()));
            validationInfo.setProperty(PROPERTY_CHECKSUM, String.valueOf(DigestTools.checksumFile(distribution.jarLocation)));
            FileTools.writeToFile(validationInfo, validationFile);
        }
        catch (Exception e) {
            log.error("Failed to save successful validation data to {}", (Object)validationFile.getAbsolutePath());
        }
    }
}

