/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.distribution.bundled;

import eu.plumbr.wrapper.configuration.WrapperConfiguration;
import eu.plumbr.wrapper.deps.org.slf4j.Logger;
import eu.plumbr.wrapper.deps.org.slf4j.LoggerFactory;
import eu.plumbr.wrapper.distribution.AgentVersion;
import eu.plumbr.wrapper.distribution.DistributionRegistry;
import eu.plumbr.wrapper.distribution.DistributionScanner;
import eu.plumbr.wrapper.distribution.bundled.BundledDistribution;

public class BundledDistributionScanner
implements DistributionScanner {
    private static final Logger log = LoggerFactory.getLogger(BundledDistributionScanner.class);

    @Override
    public void scan(WrapperConfiguration configuration, DistributionRegistry registry) {
        AgentVersion version = configuration.getBundleVersion();
        String path = configuration.getBundlePath();
        log.debug("Determined bundled distribution: version {} path {}.", (Object)version, (Object)path);
        if (version != null && path != null) {
            String hash = configuration.getBundleHash();
            if (this.getClass().getResource("/" + path) != null) {
                log.debug("Bundled distribution JAR present in classpath.");
                registry.builderFor(version).setBundledDistribution(new BundledDistribution(version, "/" + path, hash, this.getClass()));
            } else {
                log.error("Bundled distribution file not found in classpath.");
            }
        } else {
            log.warn("No bundled distribution detected from configuration.");
        }
    }
}

