/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.distribution.bundled;

import eu.plumbr.wrapper.configuration.WrapperConfiguration;
import eu.plumbr.wrapper.distribution.AgentVersion;
import eu.plumbr.wrapper.distribution.extracted.ExtractedDistribution;
import eu.plumbr.wrapper.tools.FileTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class BundledDistribution {
    private final AgentVersion version;
    private final String path;
    private final String hash;
    private final Class<?> referenceClass;

    public BundledDistribution(AgentVersion version, String path, String hash, Class<?> referenceClass) {
        this.version = version;
        this.path = path;
        this.hash = hash;
        this.referenceClass = referenceClass;
    }

    public String getHash() {
        return this.hash;
    }

    public ExtractedDistribution extract(WrapperConfiguration configuration) {
        File directory = configuration.getAgentWrapperDirectory();
        File versionDirectory = new File(directory, "version-" + this.version.version);
        File jarPath = new File(versionDirectory, "plumbr-agent.jar");
        if (!versionDirectory.mkdir() && !versionDirectory.isDirectory()) {
            throw new RuntimeException("Could not create directory for version at: " + versionDirectory.getAbsolutePath(), null);
        }
        if (!versionDirectory.canWrite()) {
            throw new RuntimeException("Version directory is not writable at: " + versionDirectory.getAbsolutePath(), null);
        }
        try {
            FileTools.writeToFile(this.hash, new File(versionDirectory, "plumbr-agent.hash"));
            this.writeJarFile(jarPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to extract agent to: " + versionDirectory.getAbsolutePath(), e);
        }
        return new ExtractedDistribution(this.version, jarPath, this.hash);
    }

    private void writeJarFile(File jarPath) throws IOException {
        InputStream stream = this.referenceClass.getResourceAsStream(this.path);
        try {
            FileTools.writeToFile(stream, jarPath);
        }
        finally {
            stream.close();
        }
    }

    public String toString() {
        return "BundledDistribution{version=" + this.version + ",path=" + this.path + ",hash=" + this.hash + "}";
    }
}

