/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.distribution;

import eu.plumbr.wrapper.configuration.WrapperConfiguration;
import eu.plumbr.wrapper.deps.org.slf4j.Logger;
import eu.plumbr.wrapper.deps.org.slf4j.LoggerFactory;
import eu.plumbr.wrapper.distribution.AgentVersion;
import eu.plumbr.wrapper.distribution.DistributionBuilder;
import eu.plumbr.wrapper.distribution.extracted.DistributionValidator;
import eu.plumbr.wrapper.distribution.extracted.ExtractedDistribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class DistributionRegistry {
    private static final Logger log = LoggerFactory.getLogger(DistributionRegistry.class);
    private final Map<AgentVersion, DistributionBuilder> builders = new HashMap<AgentVersion, DistributionBuilder>();
    private final WrapperConfiguration configuration;

    public DistributionRegistry(WrapperConfiguration configuration) {
        this.configuration = configuration;
    }

    public DistributionBuilder builderFor(AgentVersion version) {
        DistributionBuilder distributionBuilder = this.builders.get(version);
        if (distributionBuilder == null) {
            log.debug("Builder for version {} created.", (Object)version);
            distributionBuilder = new DistributionBuilder(version);
            this.builders.put(version, distributionBuilder);
        }
        return distributionBuilder;
    }

    public ExtractedDistribution prepareVersion(DistributionValidator validator, AgentVersion version) {
        DistributionBuilder builder = this.builders.get(version);
        if (builder == null) {
            log.debug("No record of requested version {}.", (Object)version);
            return null;
        }
        return builder.build(validator, this.configuration);
    }

    public ExtractedDistribution prepareLatestValid(DistributionValidator validator) {
        ArrayList<DistributionBuilder> builderList = new ArrayList<DistributionBuilder>(this.builders.values());
        log.debug("Choosing latest version among {} detected versions.", (Object)builderList.size());
        Collections.sort(builderList, new Comparator<DistributionBuilder>(){

            @Override
            public int compare(DistributionBuilder o1, DistributionBuilder o2) {
                int diff = o2.getVersion().buildNumber - o1.getVersion().buildNumber;
                return diff != 0 ? diff : -o1.getVersion().version.compareTo(o2.getVersion().version);
            }
        });
        for (DistributionBuilder builder : builderList) {
            log.debug("Attempting to prepare version {}.", (Object)builder.getVersion());
            try {
                ExtractedDistribution installation = builder.build(validator, this.configuration);
                if (installation == null) continue;
                return installation;
            }
            catch (Exception e) {
                log.error("Failed to prepare version {}, trying next.", (Object)builder.getVersion(), (Object)e);
            }
        }
        return null;
    }
}

