/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.distribution;

import eu.plumbr.wrapper.configuration.WrapperConfiguration;
import eu.plumbr.wrapper.deps.org.slf4j.Logger;
import eu.plumbr.wrapper.deps.org.slf4j.LoggerFactory;
import eu.plumbr.wrapper.distribution.DistributionRegistry;
import eu.plumbr.wrapper.distribution.DistributionRegistryFactory;
import eu.plumbr.wrapper.distribution.DistributionScanner;
import eu.plumbr.wrapper.distribution.bundled.BundledDistributionScanner;
import eu.plumbr.wrapper.distribution.extracted.DistributionValidator;
import eu.plumbr.wrapper.distribution.extracted.ExtractedDistribution;
import eu.plumbr.wrapper.distribution.extracted.ExtractedDistributionScanner;
import java.util.Arrays;
import java.util.List;

public class DistributionLoader {
    private static final Logger log = LoggerFactory.getLogger(DistributionLoader.class);
    private final WrapperConfiguration configuration;
    private final List<DistributionScanner> scanners;
    private final DistributionValidator validator;
    private final DistributionRegistryFactory distributionRegistryFactory;

    public DistributionLoader(WrapperConfiguration configuration) {
        this(configuration, Arrays.asList(new BundledDistributionScanner(), new ExtractedDistributionScanner()), new DistributionValidator(), new DistributionRegistryFactory());
    }

    public DistributionLoader(WrapperConfiguration configuration, List<DistributionScanner> scanners, DistributionValidator validator, DistributionRegistryFactory distributionRegistryFactory) {
        this.configuration = configuration;
        this.scanners = scanners;
        this.validator = validator;
        this.distributionRegistryFactory = distributionRegistryFactory;
    }

    public ExtractedDistribution load() {
        DistributionRegistry registry = this.distributionRegistryFactory.create(this.configuration);
        for (DistributionScanner scanner : this.scanners) {
            log.debug("Scanning for distributions with {}", (Object)scanner.getClass().getSimpleName());
            scanner.scan(this.configuration, registry);
        }
        if (this.configuration.getSelectedVersion() != null) {
            log.debug("Version to use is explicitly specified: {}", (Object)this.configuration.getSelectedVersion());
            return registry.prepareVersion(this.validator, this.configuration.getSelectedVersion());
        }
        log.debug("Version to use is not explicitly specified, choosing latest valid version.");
        return registry.prepareLatestValid(this.validator);
    }
}

