/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.distribution;

import eu.plumbr.wrapper.configuration.WrapperConfiguration;
import eu.plumbr.wrapper.deps.org.slf4j.Logger;
import eu.plumbr.wrapper.deps.org.slf4j.LoggerFactory;
import eu.plumbr.wrapper.distribution.AgentVersion;
import eu.plumbr.wrapper.distribution.bundled.BundledDistribution;
import eu.plumbr.wrapper.distribution.extracted.DistributionValidator;
import eu.plumbr.wrapper.distribution.extracted.ExtractedDistribution;

public class DistributionBuilder {
    private static final Logger log = LoggerFactory.getLogger(DistributionBuilder.class);
    private final AgentVersion version;
    private BundledDistribution bundledDistribution;
    private ExtractedDistribution extractedDistribution;

    public DistributionBuilder(AgentVersion version) {
        this.version = version;
    }

    public AgentVersion getVersion() {
        return this.version;
    }

    public void setBundledDistribution(BundledDistribution bundledDistribution) {
        this.bundledDistribution = bundledDistribution;
        log.debug("Assigned bundled distribution {}.", (Object)bundledDistribution);
    }

    public void setDistribution(ExtractedDistribution distribution) {
        this.extractedDistribution = distribution;
        log.debug("Assigned extracted distribution {}.", (Object)distribution);
    }

    public ExtractedDistribution build(DistributionValidator validator, WrapperConfiguration configuration) {
        if (this.extractedDistribution != null && this.canUseExtractedDistribution(validator, configuration)) {
            return this.extractedDistribution;
        }
        if (this.bundledDistribution != null) {
            try {
                log.debug("Extracting bundled distribution {}.", (Object)this.bundledDistribution);
                ExtractedDistribution unpacked = this.bundledDistribution.extract(configuration);
                if (validator.validate(unpacked)) {
                    log.debug("Bundled distribution {} validation successful.", (Object)this.bundledDistribution);
                    return unpacked;
                }
                log.error("Bundled distribution {} failed to validate.", (Object)this.bundledDistribution);
            }
            catch (Exception e) {
                log.error("Extracting agent {} failed.", (Object)this.version, (Object)e);
            }
        }
        log.error("No valid distribution for version {}.", (Object)this.version);
        return null;
    }

    private boolean canUseExtractedDistribution(DistributionValidator validator, WrapperConfiguration configuration) {
        if (configuration.isValidationEnabled()) {
            if (this.hasConflictingHashes()) {
                log.debug("Exracted distribution for {} present, but with different hash, replacing with bundled distribution.", (Object)this.version);
                return false;
            }
            if (!validator.validate(this.extractedDistribution)) {
                log.debug("Exracted distribution for {} present, but failed validation, replacing with bundled distribution.", (Object)this.version);
                return false;
            }
        } else {
            log.debug("Exracted distribution for {} present, validation disabled, using.", (Object)this.version);
        }
        return true;
    }

    private boolean hasConflictingHashes() {
        return this.extractedDistribution != null && this.bundledDistribution != null && !this.extractedDistribution.hash.equalsIgnoreCase(this.bundledDistribution.getHash());
    }
}

