/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.distribution;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentVersion {
    public static final int SNAPSHOT_BUILD_NUMBER = 99999;
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\d{2}\\.\\d{2}\\.\\d{2}\\.(.*)");
    public final String version;
    public final int buildNumber;

    private AgentVersion(String version, int buildNumber) {
        this.version = version;
        this.buildNumber = buildNumber;
    }

    public static AgentVersion fromVersionInSuffix(String text) {
        int dashPosition = text.lastIndexOf(45);
        if (dashPosition != -1) {
            return AgentVersion.fromFullVersionString(text.substring(dashPosition + 1));
        }
        return AgentVersion.fromFullVersionString(text);
    }

    public static AgentVersion fromFullVersionString(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            try {
                return new AgentVersion(version, Integer.valueOf(matcher.group(1)));
            }
            catch (NumberFormatException e) {
                return new AgentVersion(version, 99999);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.version.equals(((AgentVersion)o).version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }
}

