/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.configuration;

import eu.plumbr.wrapper.configuration.WrapperConfigurationLoader;
import eu.plumbr.wrapper.deps.ch.qos.logback.classic.LoggerContext;
import eu.plumbr.wrapper.deps.ch.qos.logback.classic.joran.JoranConfigurator;
import eu.plumbr.wrapper.deps.ch.qos.logback.core.joran.spi.JoranException;
import eu.plumbr.wrapper.deps.ch.qos.logback.core.util.StatusPrinter;
import eu.plumbr.wrapper.deps.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class WrapperLogConfigurator {
    private static final String PLUMBR_HOME_ARGUMENT = "plumbrHome";
    private static final String PLUMBR_HOME_ENV_VARIABLE = "PLUMBR_HOME";
    private static final String WRAPPER_HOME_PROPERTY = "PLUMBR_WRAPPER_HOME";
    private static final String DEFAULT_LOG_PATH = "logs/plumbr-wrapper.log";
    private static volatile String latestLogFileLocation = "logs/plumbr-wrapper.log";

    public static String getLogFileLocation() {
        return latestLogFileLocation;
    }

    public static void configureLogging(Map<String, String> arguments) {
        String jarPath = WrapperConfigurationLoader.findJarPath();
        File homeDirectory = WrapperLogConfigurator.findHomeDirectory(jarPath, arguments);
        latestLogFileLocation = new File(homeDirectory, DEFAULT_LOG_PATH).getAbsolutePath();
        try {
            URL configurationUrl = WrapperLogConfigurator.getConfigurationUrl(jarPath);
            System.setProperty(WRAPPER_HOME_PROPERTY, homeDirectory.getAbsolutePath());
            WrapperLogConfigurator.configureFromUrl(configurationUrl);
        }
        catch (Exception e) {
            System.err.println("Failed to configure logging.");
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureFromUrl(URL configurationUrl) {
        LoggerContext context;
        block17: {
            block16: {
                String oldConfigLocation = System.getProperty("logback.configurationFile");
                context = null;
                try {
                    InputStream stream = configurationUrl.openStream();
                    try {
                        System.setProperty("logback.configurationFile", configurationUrl.toString());
                        context = (LoggerContext)LoggerFactory.getILoggerFactory();
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext(context);
                        context.reset();
                        configurator.doConfigure(stream);
                    }
                    finally {
                        stream.close();
                    }
                    if (oldConfigLocation == null) break block16;
                }
                catch (JoranException stream) {
                    if (oldConfigLocation != null) {
                        System.setProperty("logback.configurationFile", oldConfigLocation);
                    } else {
                        System.clearProperty("logback.configurationFile");
                    }
                    if (context != null) {
                        StatusPrinter.printInCaseOfErrorsOrWarnings(context);
                    }
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        if (oldConfigLocation != null) {
                            System.setProperty("logback.configurationFile", oldConfigLocation);
                        } else {
                            System.clearProperty("logback.configurationFile");
                        }
                        if (context != null) {
                            StatusPrinter.printInCaseOfErrorsOrWarnings(context);
                        }
                        throw throwable;
                    }
                }
                System.setProperty("logback.configurationFile", oldConfigLocation);
                break block17;
            }
            System.clearProperty("logback.configurationFile");
        }
        if (context != null) {
            StatusPrinter.printInCaseOfErrorsOrWarnings(context);
        }
    }

    private static File findHomeDirectory(String jarPath, Map<String, String> arguments) {
        String home = arguments.get(PLUMBR_HOME_ARGUMENT);
        if (home == null) {
            home = System.getenv(PLUMBR_HOME_ENV_VARIABLE);
        }
        if (home == null && jarPath != null) {
            home = new File(jarPath).getParent();
        }
        if (home == null) {
            home = "./";
        }
        return new File(home).getAbsoluteFile();
    }

    private static URL getConfigurationUrl(String jarPath) throws IOException {
        File configurationFile;
        if (jarPath != null && (configurationFile = new File(new File(jarPath).getParentFile(), "plumbr-wrapper-logback.xml")).isFile()) {
            return configurationFile.toURI().toURL();
        }
        return WrapperLogConfigurator.class.getResource("/plumbr-wrapper-logback.xml");
    }
}

