/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.configuration;

import eu.plumbr.wrapper.configuration.WrapperConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;

public class WrapperConfigurationLoader {
    private static final String JAR_URL_PREFIX = "jar:file:";
    private static final String JAR_URL_SPLITTER = ".jar!";
    private static final String CLASSPATH_CONFIGURATION = "/plumbr-wrapper.properties";

    public static WrapperConfiguration load() {
        Properties properties = new Properties();
        WrapperConfigurationLoader.applyFrom(properties, System.getProperties());
        WrapperConfigurationLoader.applyFrom(properties, WrapperConfigurationLoader.fromClassPath(CLASSPATH_CONFIGURATION));
        String jarPath = WrapperConfigurationLoader.findJarPath();
        if (jarPath != null) {
            properties.put("plumbr.wrapper.agentWrapperJarPath", jarPath);
        }
        return new WrapperConfiguration(properties);
    }

    private static void applyFrom(Properties destination, Properties source) {
        for (String property : source.stringPropertyNames()) {
            if (!property.startsWith("plumbr.wrapper.")) continue;
            destination.put(property, source.getProperty(property));
        }
    }

    private static Properties fromClassPath(String path) {
        Properties properties = new Properties();
        InputStream stream = WrapperConfiguration.class.getResourceAsStream(path);
        if (stream != null) {
            try {
                try {
                    properties.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    public static String findJarPath() {
        String classFileName = WrapperConfigurationLoader.class.getName().replace('.', '/') + ".class";
        URL url = ClassLoader.getSystemResource(classFileName);
        if (url != null) {
            String classUrl = url.toString();
            try {
                classUrl = URLDecoder.decode(classUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (classUrl.startsWith(JAR_URL_PREFIX) && classUrl.contains(JAR_URL_SPLITTER)) {
                String jarPath = classUrl.substring(JAR_URL_PREFIX.length(), classUrl.indexOf(JAR_URL_SPLITTER) + 4);
                if (jarPath.startsWith("/") && File.separatorChar != '/') {
                    jarPath = jarPath.substring(1);
                }
                return jarPath;
            }
        }
        return null;
    }
}

