/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.configuration;

import eu.plumbr.wrapper.distribution.AgentVersion;
import java.io.File;
import java.util.Properties;

public class WrapperConfiguration {
    public static final String PROPERTY_PREFIX = "plumbr.wrapper.";
    public static final String JAR_PATH_PROPERTY = "plumbr.wrapper.agentWrapperJarPath";
    private final Properties properties;

    public WrapperConfiguration(Properties properties) {
        this.properties = properties;
    }

    public boolean isValidationEnabled() {
        String value = this.properties.getProperty("plumbr.wrapper.validationEnabled");
        return value != null ? Boolean.valueOf(value) : true;
    }

    public AgentVersion getSelectedVersion() {
        String value = this.properties.getProperty("plumbr.wrapper.selectedVersion");
        return value != null ? AgentVersion.fromFullVersionString(value) : null;
    }

    public AgentVersion getBundleVersion() {
        String value = this.properties.getProperty("plumbr.wrapper.bundleVersion");
        return value != null ? AgentVersion.fromFullVersionString(value) : null;
    }

    public String getBundlePath() {
        return this.properties.getProperty("plumbr.wrapper.bundlePath");
    }

    public String getBundleHash() {
        return this.properties.getProperty("plumbr.wrapper.bundleHash");
    }

    public File getAgentWrapperDirectory() {
        String wrapperJarPath = this.properties.getProperty(JAR_PATH_PROPERTY);
        return wrapperJarPath != null ? new File(wrapperJarPath).getParentFile() : null;
    }

    public File getAgentWrapperJarPath() {
        String wrapperJarPath = this.properties.getProperty(JAR_PATH_PROPERTY);
        return wrapperJarPath != null ? new File(wrapperJarPath) : null;
    }
}

