/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper;

import eu.plumbr.wrapper.AbstractEntryPoint;
import eu.plumbr.wrapper.FatalErrorReporting;
import eu.plumbr.wrapper.configuration.WrapperConfiguration;
import eu.plumbr.wrapper.configuration.WrapperConfigurationLoader;
import eu.plumbr.wrapper.configuration.WrapperLogConfigurator;
import eu.plumbr.wrapper.deps.org.slf4j.LoggerFactory;
import eu.plumbr.wrapper.distribution.extracted.ExtractedDistribution;
import eu.plumbr.wrapper.tools.Jdk6ClassPathTools;
import eu.plumbr.wrapper.tools.Jdk9ClassPathTools;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;

public class AgentEntryPoint
extends AbstractEntryPoint {
    private static final String AGENT_ENTRY_CLASS = "eu.plumbr.runtime.agent.AgentEntryPoint";
    private static final String AGENT_ENTRY_METHOD = "premain";

    public static void premain(String agentArguments, Instrumentation instrumentation) {
        try {
            WrapperLogConfigurator.configureLogging(AgentEntryPoint.parseAgentArguments(agentArguments));
            log = LoggerFactory.getLogger(AgentEntryPoint.class);
            AgentEntryPoint.startAgent(agentArguments, instrumentation, WrapperConfigurationLoader.load());
        }
        catch (Throwable e) {
            if (log != null) {
                log.error("Agent wrapper failed to initialize", e);
            }
            FatalErrorReporting.reportFailedInitialization(e);
        }
    }

    private static void startAgent(String agentArguments, Instrumentation instrumentation, WrapperConfiguration configuration) throws Exception {
        ExtractedDistribution installation = AgentEntryPoint.loadDistribution(configuration);
        if (installation == null) {
            return;
        }
        AgentEntryPoint.setupBootstrapClassPath(instrumentation, installation.jarLocation);
        AgentEntryPoint.bootstrapAgent(agentArguments, instrumentation);
    }

    private static void setupBootstrapClassPath(Instrumentation instrumentation, File jarLocation) throws IOException {
        JarFile jarFile = new JarFile(jarLocation);
        instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
        AgentEntryPoint.setupBootClasspathSystemProperty(jarLocation);
        if (AgentEntryPoint.isJavaVersionAtLeast(9)) {
            if (AgentEntryPoint.isJavaVersionAtLeast(12)) {
                log.info("Deferring bootstrap classpath resource path list update, will be performed in agent itself (due to JDK12+)");
            } else {
                Jdk9ClassPathTools.addToClassPath(jarLocation);
            }
        } else {
            Jdk6ClassPathTools.addToClassPath(jarLocation);
        }
    }

    private static void setupBootClasspathSystemProperty(File jarLocation) {
        String bootClassPath = System.getProperty("sun.boot.class.path");
        if (bootClassPath != null) {
            String newValue = bootClassPath + (bootClassPath.isEmpty() ? "" : File.pathSeparator) + jarLocation;
            System.setProperty("sun.boot.class.path", newValue);
            log.debug("System property sun.boot.class.path set to: {}", (Object)newValue);
        } else {
            log.debug("System property sun.boot.class.path is not present.");
        }
    }

    private static void bootstrapAgent(String agentArguments, Instrumentation instrumentation) throws Exception {
        Class<?> premainClass = Class.forName(AGENT_ENTRY_CLASS);
        Method method = premainClass.getDeclaredMethod(AGENT_ENTRY_METHOD, String.class, Instrumentation.class);
        method.invoke(null, agentArguments, instrumentation);
        log.info("Synchronous agent bootstrap finished.");
    }

    private static Map<String, String> parseAgentArguments(String argumentText) {
        if (argumentText == null || argumentText.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        String[] parts = argumentText.split(";");
        HashMap<String, String> arguments = new HashMap<String, String>();
        for (String part : parts) {
            String[] keyValue = part.split("=", 1);
            if (keyValue.length != 2) continue;
            arguments.put(keyValue[0], keyValue[1]);
        }
        return arguments;
    }

    private static boolean isJavaVersionAtLeast(int threshold) {
        String specification = System.getProperty("java.specification.version");
        try {
            return specification != null && Integer.parseInt(specification.split("\\.")[0]) >= threshold;
        }
        catch (RuntimeException e) {
            log.warn("Invalid value for java.specification.version: {}. Assuming version < 9.", (Object)specification);
            return false;
        }
    }
}

