/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper;

import eu.plumbr.wrapper.FatalErrorReporting;
import eu.plumbr.wrapper.configuration.WrapperConfiguration;
import eu.plumbr.wrapper.deps.org.slf4j.Logger;
import eu.plumbr.wrapper.distribution.DistributionLoader;
import eu.plumbr.wrapper.distribution.extracted.ExtractedDistribution;
import java.io.File;

public abstract class AbstractEntryPoint {
    private static final String WRAPPER_JAR_EXPORTED_PROPERTY_NAME = "plumbr.agentWrapperJarPath";
    private static final String WRAPPER_VERSION_EXPORTED_PROPERTY_NAME = "plumbr.agentWrapperVersion";
    private static final String JAR_EXPORTED_PROPERTY_NAME = "plumbr.agentJarPath";
    protected static Logger log;

    protected static ExtractedDistribution loadDistribution(WrapperConfiguration configuration) {
        DistributionLoader loader;
        ExtractedDistribution distribution;
        File selfPath = configuration.getAgentWrapperJarPath();
        if (selfPath != null) {
            System.getProperties().setProperty(WRAPPER_JAR_EXPORTED_PROPERTY_NAME, selfPath.getAbsolutePath());
            if (configuration.getBundleVersion() != null) {
                System.getProperties().setProperty(WRAPPER_VERSION_EXPORTED_PROPERTY_NAME, configuration.getBundleVersion().toString());
            }
        }
        if ((distribution = (loader = new DistributionLoader(configuration)).load()) == null) {
            log.error("Failed to select any valid agent distribution.");
            FatalErrorReporting.reportNoAgentDistribution();
        } else {
            log.info("Selected extracted distribution {}.", (Object)distribution);
            System.getProperties().setProperty(JAR_EXPORTED_PROPERTY_NAME, distribution.jarLocation.getAbsolutePath());
        }
        return distribution;
    }
}

