/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.gzip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import org.codehaus.plexus.archiver.util.Streams;
import org.codehaus.plexus.components.io.attributes.FileAttributes;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoCompressedFileResourceCollection;
import org.codehaus.plexus.util.IOUtil;

public class PlexusIoGzipResourceCollection
extends PlexusIoCompressedFileResourceCollection {
    @Override
    protected String getDefaultExtension() {
        return ".gz";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected InputStream getInputStream(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            BufferedInputStream result = Streams.bufferedInputStream(new GZIPInputStream(fis));
            fis = null;
            BufferedInputStream bufferedInputStream = result;
            return bufferedInputStream;
        }
        finally {
            IOUtil.close(fis);
        }
    }

    @Override
    protected PlexusIoResourceAttributes getAttributes(File file) throws IOException {
        return new FileAttributes(file, new HashMap<Integer, String>(), new HashMap<Integer, String>());
    }
}

