/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer.asm;

import org.apache.maven.shared.dependency.analyzer.asm.ResultCollector;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class DefaultMethodVisitor
extends MethodVisitor {
    private final AnnotationVisitor annotationVisitor;
    private final SignatureVisitor signatureVisitor;
    private final ResultCollector resultCollector;

    public DefaultMethodVisitor(AnnotationVisitor annotationVisitor, SignatureVisitor signatureVisitor, ResultCollector resultCollector) {
        super(393216);
        this.annotationVisitor = annotationVisitor;
        this.signatureVisitor = signatureVisitor;
        this.resultCollector = resultCollector;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.resultCollector.addDesc(desc);
        return this.annotationVisitor;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.resultCollector.addDesc(desc);
        return this.annotationVisitor;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.resultCollector.addDesc(desc);
        return this.annotationVisitor;
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        if (desc.charAt(0) == '[') {
            this.resultCollector.addDesc(desc);
        } else {
            this.resultCollector.addName(desc);
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.resultCollector.addName(owner);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.resultCollector.addName(owner);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            this.resultCollector.addType((Type)cst);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.resultCollector.addDesc(desc);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.resultCollector.addName(type);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (signature == null) {
            this.resultCollector.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType(this.signatureVisitor);
        }
    }
}

