/*
 * Decompiled with CFR 0.152.
 */
package com.pg.sync.service.impl;

import com.parablu.pcbd.dao.EncryptionKeyDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EncryptionKey;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.pg.dao.FileDao;
import com.pg.dao.Office365Dao;
import com.pg.dao.SyncFileDao;
import com.pg.domain.FileInfo;
import com.pg.element.FileElement;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.element.RestoreElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.exception.BlukryptClientAbortException;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.paracloud.to.DownloadFileTO;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.CloudSupportService;
import com.pg.service.DownloadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import com.pg.util.ResourceFileHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.zeroturnaround.zip.ZipUtil;

@Service
public class SyncDownloadServiceImpl
implements SyncDownloadService {
    private static Logger logger = LoggerFactory.getLogger(SyncDownloadServiceImpl.class);
    @Autowired
    private FileDao fileDao;
    private static final String MERGE = "merge";
    private static final String DECRYPTED = "decrypted";
    private static final String TEMP_DOWNLOAD_SYNC = "tempdownloadsync";
    private static final String ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH = "ERROR Trying to download from orginal source path ..... ";
    private static final String AZURE_DOWNLOAD_ERROR = "Azure download error";
    private static final String CHUNK = "chunk";
    private static final String SENDING_FILE = "Sending file ";
    private static final String FINISHED_FILE = "Finished file ";
    private static final String EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD = "Exception While Downloading File From Cloud :";
    private static final String IS_COMPRESSED = "$$$$$ isCompressed>>>>";
    private static final String BACKUP = "backup";
    private static final String PRODUCT_TYPE_SYNC = "sync";
    private static final String CHUNK_DETAILS_NULL = "Chunk detail is null>>>>>>>>";
    private static final String CLOUD_CHUNK_NAME = "CLOUD CHUNK NAME>>>>>>>>>";
    private static final String LOOP_BEFORE_DOWNLOAD_FILE = "for loop  BEFORE DOWNLOADING Chunks file  >>>>>> ";
    private static final String SYNC_DECRYPT_KEY = "d8e87c0927539672f54462c837be0b7f";
    @Autowired
    private SyncFileDao syncFileDao;
    @Autowired
    private Office365Dao office365Dao;
    @Autowired
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private FileEncryptionService fileEncryptionService;
    @Autowired
    private CloudSupportService cloudSupportService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private EncryptionKeyDao encryptionKeyDao;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private UserDao userDao;

    public void setDownloadService(DownloadService downloadService) {
        this.downloadService = downloadService;
    }

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setSyncFileDao(SyncFileDao syncFileDao) {
        this.syncFileDao = syncFileDao;
    }

    public void setOffice365Dao(Office365Dao office365Dao) {
        this.office365Dao = office365Dao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
        this.fileEncryptionService = fileEncryptionService;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setCloudSupportService(CloudSupportService cloudSupportService) {
        this.cloudSupportService = cloudSupportService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setEncryptionKeyDao(EncryptionKeyDao encryptionKeyDao) {
        this.encryptionKeyDao = encryptionKeyDao;
    }

    @Override
    public DownloadTO restoreFile(Cloud cloud, String cloudName, String userName, String fileName1, String folderPath, String saltKey, String deviceUUID, String syncRevisionId, String gatewayName, boolean isExternalDownload) {
        logger.debug(" @@@@@ Folder path for external Storage " + folderPath);
        com.pg.domain.BackupFile backupFile = this.utilService.getSyncFile(1, cloudName, userName, syncRevisionId);
        logger.error(syncRevisionId + " BACKUPFILE FOR MUTILSERVICE ............" + backupFile);
        if (backupFile == null) {
            logger.debug(" @@@@@ FILE NOT FOUND .... " + syncRevisionId);
            throw new ParacloudBackupException("File not found", 507);
        }
        if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId())) {
            backupFile = this.utilService.getSyncFile(1, cloudName, userName, backupFile.getDedupBackupId());
        }
        String fileMD5 = backupFile.getMd5();
        ArrayList<String> nameList = new ArrayList<String>();
        logger.debug(" BEFORE DOWNLOADING File  >>>>>> " + backupFile.getFileName());
        this.downloadFileFromCloud(cloud, cloudName, userName, backupFile, nameList, saltKey);
        logger.debug(" After DOWNLOADING File  >>>>>> " + backupFile.getFileName());
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String destPath = path + MERGE;
        String destFile = destPath + "/" + backupFile.getFileName();
        File destFolder = new File(destPath);
        if (destFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)destFolder);
        }
        com.pg.util.FileUtils.merge(nameList, (String)(path + DECRYPTED), (String)destFile);
        InputStream decryptedStream = null;
        String mimeType = "application/octet-stream";
        logger.debug(isExternalDownload + " Mimetype for file1 ............" + mimeType);
        long fileSize = backupFile.getSize();
        long fileSize1 = destFile.length();
        logger.debug(backupFile.getSize() + " size of file .merged..... " + fileSize1);
        mimeType = "application/octet-stream";
        DownloadTO downloadTO = new DownloadTO(mimeType, decryptedStream, fileSize, fileMD5);
        downloadTO.setPath(destFile);
        downloadTO.setMd5(fileMD5);
        ArrayList<Object> downloadReturnList = new ArrayList<Object>();
        downloadReturnList.add(decryptedStream);
        downloadReturnList.add(mimeType);
        downloadReturnList.add(String.valueOf(fileSize));
        downloadReturnList.add(fileMD5);
        logger.debug(" Mimetype for file ............" + mimeType);
        return downloadTO;
    }

    private void downloadFileFromCloud(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKeys) {
        BufferedInputStream inputStream = null;
        if (StringUtils.isEmpty((String)PCHelperConstant.getPropertyFileValueEncryptionEnabled()) || !"true".equals(PCHelperConstant.getPropertyFileValueEncryptionEnabled())) {
            try {
                String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
                File tempdownloadDir = new File(path + TEMP_DOWNLOAD_SYNC);
                if (!tempdownloadDir.exists()) {
                    tempdownloadDir.mkdirs();
                }
                String fileNameToDownload = backupFile.getFileName();
                logger.debug(" BEFORE DOWNLOADING file without encrypt file  >>>>>> " + fileNameToDownload);
                com.pg.domain.ChunkFile chunkFile = (com.pg.domain.ChunkFile)backupFile.getChunkFiles().get(0);
                FileStatusElement fileStatusElement = new FileStatusElement();
                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                String fileToDownload = fileNameToDownload;
                if (isGDEnabled) {
                    fileToDownload = chunkFile.getFileId();
                }
                inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), null, chunkFile, true, backupFile, fileStatusElement, "", null);
                logger.debug("File Download from Cloud..........." + inputStream);
                this.convertIntoFile(inputStream, cloudName, backupFile.getDeviceUUID(), backupFile.getFileName());
            }
            catch (Exception e) {
                logger.trace("" + e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error("Exception while downloading files from cloud :" + e1.getMessage());
                }
                logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                throw new ParacloudBackupException("Cloud download error", 507);
            }
            nameList.add(backupFile.getFileName());
            return;
        }
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path + TEMP_DOWNLOAD_SYNC);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        for (com.pg.domain.ChunkFile chunkFile : backupFile.getChunkFiles()) {
            String syncDecryptKey = SYNC_DECRYPT_KEY;
            String productType = PRODUCT_TYPE_SYNC;
            try {
                StringBuilder fileNameToDownload;
                int occurance;
                String dedupVal = this.getDedupValue(userName);
                ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupVal, userName, false, false);
                if (chunkDetail == null) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupVal, userName, false, true);
                }
                if (chunkDetail == null) {
                    logger.debug(CHUNK_DETAILS_NULL);
                    chunkDetail = new ChunkDetail();
                    chunkDetail.setCloudChunkName(chunkFile.getFileName());
                }
                logger.debug(backupFile.getDedupBackupId() + CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                String backupId = backupFile.getBackupId().toString();
                if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId())) {
                    backupId = backupFile.getDedupBackupId();
                }
                if ((occurance = StringUtils.countMatches((String)(fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName())).toString(), (String)".")) == 0 || occurance == 1 && backupFile.getChunkFiles().size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                    fileNameToDownload.append("." + backupId);
                }
                String containerName = null;
                if (chunkDetail != null) {
                    containerName = chunkDetail.getContainerName();
                    if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                    }
                }
                if (!StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !"ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                    productType = BACKUP;
                    syncDecryptKey = chunkDetail.getContainerName();
                }
                logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileNameToDownload);
                com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                FileStatusElement fileStatusElement = new FileStatusElement();
                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                String fileToDownload = fileNameToDownload.toString();
                if (isGDEnabled) {
                    fileToDownload = chunkDetail.getCloudChunkName();
                }
                inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, true, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail);
            }
            catch (Exception e) {
                logger.trace("" + e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                }
                logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
            }
            String saltKeyTemp = this.getEncryptOrDecryptKey(1, chunkFile.getUploadedTimeStamp(), productType);
            this.getDecryptedFile(cloudName, saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
            nameList.add(chunkFile.getFileName());
        }
    }

    private File getDecryptedFile(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream, String restorePath, String syncUniqueKey) {
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File decryptedDir = new File(path + DECRYPTED);
        if (!decryptedDir.exists()) {
            decryptedDir.mkdirs();
        }
        this.createFolders(path);
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, syncUniqueKey, inputStream, decryptedFile);
        return decryptedFile;
    }

    private File getDecryptedFileFromPath(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream, String restorePath, String syncUniqueKey) {
        File decryptedDir;
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File pathDir = new File(path);
        if (!pathDir.exists()) {
            pathDir.mkdir();
        }
        if (!(decryptedDir = new File(path + DECRYPTED)).exists()) {
            decryptedDir.mkdir();
        }
        this.createFolders(path);
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, syncUniqueKey, inputStream, decryptedFile);
        return decryptedFile;
    }

    private void createFolders(String pathname) {
        File mergeDir;
        File decryptedDir = new File(pathname + DECRYPTED);
        if (!decryptedDir.exists()) {
            decryptedDir.mkdir();
        }
        if (!(mergeDir = new File(pathname + MERGE)).exists()) {
            mergeDir.mkdir();
        }
    }

    private void convertIntoFile(BufferedInputStream inputStream, String cloudName, String deviceUUID, String fileName) {
        try {
            int bytesRead;
            String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            File decryptedDir = new File(path + DECRYPTED);
            if (!decryptedDir.exists()) {
                decryptedDir.mkdir();
            }
            this.createFolders(path);
            BufferedInputStream is = inputStream;
            FileOutputStream os = new FileOutputStream(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
            byte[] buffer = new byte[1024];
            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((InputStream)is).close();
            os.flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception While Converting Into File :" + e.getMessage());
        }
    }

    @Override
    public DownloadTO restoreFileForPortal(Cloud cloud, String cloudName, String userName, String fileName1, String folderPath, String saltKey, String deviceUUID, String syncRevisionId, String gatewayName, boolean isExternalDownload, HttpServletResponse response, String browserType) {
        logger.debug(" @@@@@ Folder path for external Storage " + folderPath);
        com.pg.domain.BackupFile backupFile = this.utilService.getSyncFile(1, cloudName, userName, syncRevisionId);
        FileInfo fileInfo = null;
        DownloadTO downloadTO = new DownloadTO("");
        if (backupFile == null) {
            fileInfo = this.fileDao.getFileFromPG(userName, cloudName, syncRevisionId, true);
            this.restoreFromPG(cloudName, response, fileInfo, true, browserType);
        }
        if (fileInfo != null) {
            downloadTO.setSize(fileInfo.getSize().longValue());
            return downloadTO;
        }
        logger.error(syncRevisionId + " BACKUPFILE FOR MUTILSERVICE ............" + backupFile);
        if (backupFile == null) {
            logger.debug(" @@@@@ FILE NOT FOUND .... " + syncRevisionId);
            throw new ParacloudBackupException("File not found", 507);
        }
        String fileName = backupFile.getFileName();
        if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId())) {
            backupFile = this.utilService.getSyncFile(1, cloudName, userName, backupFile.getDedupBackupId());
        }
        ArrayList<String> nameList = new ArrayList<String>();
        logger.debug(" BEFORE DOWNLOADING File  >>>>>> " + backupFile.getFileName());
        response.addHeader("Pragma", "public");
        response.addHeader("Expires", String.valueOf(200));
        response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.addHeader("Content-Transfer-Encoding", "binary");
        response.addHeader("Content-Length", String.valueOf(backupFile.getSize()));
        response.addHeader("filename", fileName);
        response.addHeader("Content-Transfer-Encodingsdasda", "binary");
        response.setContentType("application/octet-stream");
        boolean fileExists = true;
        fileExists = this.downloadFileFromCloud(cloud, cloudName, backupFile.getUserName(), backupFile, nameList, saltKey, response, fileExists);
        if (!fileExists) {
            nameList = new ArrayList();
            logger.debug(" portal .. try parent file for md5..........");
            com.pg.domain.BackupFile backupFileObj = this.syncFileDao.getSyncFileForMd5(1, cloudName, userName, deviceUUID, backupFile.getMd5());
            if (backupFileObj != null) {
                logger.debug(" portal .. parent file for md5 exists ..........");
                this.downloadFileFromCloud(cloud, cloudName, backupFile.getUserName(), backupFileObj, nameList, saltKey, response, fileExists);
            }
        }
        logger.debug(" After DOWNLOADING File  >>>>>> " + backupFile.getFileName());
        downloadTO.setSize(backupFile.getSize().longValue());
        return downloadTO;
    }

    private boolean downloadFileFromCloud(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, HttpServletResponse response, boolean fileExists) {
        boolean fileExistsTemp = fileExists;
        BufferedInputStream inputStream = null;
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path + TEMP_DOWNLOAD_SYNC);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        List chunkFilesList = backupFile.getChunkFiles();
        int totalChunks = chunkFilesList.size();
        Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

            @Override
            public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
            }
        });
        String dedupVal = this.getDedupValue(userName);
        for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
            String syncDecryptKey = SYNC_DECRYPT_KEY;
            String productType = PRODUCT_TYPE_SYNC;
            try {
                ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, false, false);
                if (chunkDetail == null) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, false, true);
                }
                if (chunkDetail == null) {
                    logger.debug(CHUNK_DETAILS_NULL);
                    chunkDetail = new ChunkDetail();
                    chunkDetail.setCloudChunkName(chunkFile.getFileName());
                }
                logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                String backupId = backupFile.getId();
                StringBuilder fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName());
                int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                    fileNameToDownload.append("." + backupId);
                }
                String containerName = null;
                if (chunkDetail != null) {
                    containerName = chunkDetail.getContainerName();
                    if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                    }
                }
                if (!StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !"ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                    productType = BACKUP;
                    syncDecryptKey = chunkDetail.getContainerName();
                }
                logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileNameToDownload);
                com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                FileStatusElement fileStatusElement = new FileStatusElement();
                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                String fileToDownload = fileNameToDownload.toString();
                if (isGDEnabled) {
                    fileToDownload = chunkDetail.getCloudChunkName();
                }
                if ((inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, true, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail)) == null) {
                    fileExistsTemp = false;
                }
                if (inputStream == null) {
                    break;
                }
            }
            catch (Exception e) {
                logger.trace("" + e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                }
                logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
            }
            String saltKeyTemp = this.getEncryptOrDecryptKey(1, chunkFile.getUploadedTimeStamp(), productType);
            File decryptedFile = this.getDecryptedFile(cloudName, saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
            this.writeDataToStream(response, decryptedFile, backupFile);
            nameList.add(chunkFile.getFileName());
            logger.debug(" remaining chunks ......" + --totalChunks);
        }
        return fileExistsTemp;
    }

    private boolean isGDEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isGDEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"Google Drive Enabled".equalsIgnoreCase(license.getName())) continue;
            isGDEnabled = true;
            break;
        }
        return isGDEnabled;
    }

    private boolean downloadFileFromCloud(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, HttpServletResponse response, boolean fileExists, boolean isSyncEnabled) {
        boolean fileExistsTemp = fileExists;
        boolean isSync = isSyncEnabled;
        BufferedInputStream inputStream = null;
        String deviceUUID = backupFile.getDeviceUUID();
        int cloudId = cloud.getCloudId();
        String path = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + TEMP_DOWNLOAD_SYNC : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        List chunkFilesList = backupFile.getChunkFiles();
        int totalChunks = chunkFilesList.size();
        Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

            @Override
            public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
            }
        });
        for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
            File decryptedFile;
            String saltKeyTemp;
            String syncDecryptKey = SYNC_DECRYPT_KEY;
            String productType = PRODUCT_TYPE_SYNC;
            String dedupVal = this.getDedupValue(userName);
            logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + chunkFile.getMd5());
            ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, false, false);
            if (chunkDetail == null) {
                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, false, true);
            }
            try {
                if (chunkDetail == null) {
                    logger.debug(CHUNK_DETAILS_NULL);
                    chunkDetail = new ChunkDetail();
                    chunkDetail.setCloudChunkName(chunkFile.getFileName());
                    chunkDetail.setUserName(userName);
                    chunkDetail.setContainerName(userName.toLowerCase());
                    chunkDetail.setMd5(chunkFile.getMd5());
                }
                logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                String backupId = backupFile.getId();
                String containerName = null;
                if (!isSync) {
                    containerName = chunkDetail.getContainerName();
                }
                StringBuilder fileNameToDownload = new StringBuilder();
                fileNameToDownload.append(chunkDetail.getCloudChunkName());
                int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                    fileNameToDownload.append(".").append(backupId);
                }
                if (chunkDetail != null) {
                    containerName = chunkDetail.getContainerName();
                    if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                    }
                }
                if (!StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !"ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                    productType = BACKUP;
                    syncDecryptKey = chunkDetail.getContainerName();
                }
                com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                String fileToDownload = fileNameToDownload.toString();
                if (isGDEnabled) {
                    fileToDownload = chunkDetail.getCloudChunkName();
                    logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
                }
                logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
                FileStatusElement fileStatusElement = new FileStatusElement();
                inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, isSync, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail);
                if (inputStream == null) {
                    fileExistsTemp = false;
                }
                if (inputStream == null) {
                    break;
                }
            }
            catch (Exception e) {
                logger.trace("" + e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error(EXCEPTION_WHILE_DOWNLOADING_FILE_FROM_CLOUD + e1.getMessage());
                }
                logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
            }
            isSync = !productType.equalsIgnoreCase(BACKUP);
            logger.debug("..isSync Value>>>>>" + isSync);
            if (isSync) {
                saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkFile.getUploadedTimeStamp(), productType);
                decryptedFile = this.getDecryptedFile(cloudName, saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
            } else {
                saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkFile.getUploadedTimeStamp(), BACKUP);
                logger.debug(userName + "...users...." + chunkDetail.getUserName());
                decryptedFile = this.downloadService.getDecryptedFileForPortal(cloudName, saltKeyTemp, deviceUUID, chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), path, chunkFile, cloudId, chunkDetail);
            }
            this.writeDataToStream(response, decryptedFile, backupFile);
            nameList.add(chunkFile.getFileName());
            logger.debug(" remaining chunks ......" + --totalChunks);
        }
        return fileExistsTemp;
    }

    private void writeDataToStream(HttpServletResponse response, File decryptedFile, com.pg.domain.BackupFile backupFile) {
        try {
            int buff;
            logger.debug(SENDING_FILE + decryptedFile.getName());
            FileInputStream fis = new FileInputStream(decryptedFile);
            FilterInputStream fif = new BufferedInputStream(fis);
            logger.debug(IS_COMPRESSED + backupFile.isCompressed());
            if (backupFile.isCompressed()) {
                fif = new GZIPInputStream(fif);
            }
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
            }
            ((InputStream)fif).close();
            response.getOutputStream().flush();
            logger.debug(FINISHED_FILE + decryptedFile.getName());
            decryptedFile.delete();
            logger.debug("deleting  file  under path " + decryptedFile.getPath());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" error trying to send ...." + e.getMessage());
        }
    }

    @Override
    public void restoreFilesFromCloud(Cloud cloud, RestoreElement restoreElement, String userName, HttpServletResponse response, int skipValue, long totalCount, long downloadedCount, Map<String, Long> fileVersionMap, List<FileElement> list) {
        long downloadedCountTemp = downloadedCount;
        String cloudName = restoreElement.getCloudName();
        String deviceUUID = restoreElement.getDeviceUUID();
        String restoreId = restoreElement.getRestoreBatchId();
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String restorePath = path + restoreId + "/";
        File restorePathDir = new File(restorePath);
        if (!restorePathDir.exists()) {
            restorePathDir.mkdirs();
        }
        List licenseDetails = cloud.getCloudCustomisableDetails();
        int cloudId = cloud.getCloudId();
        boolean isODBEnabled = false;
        licenseDetails.removeAll(Collections.singleton(null));
        for (CloudCustomisableDetails cloudCustomisableDetails : licenseDetails) {
            if (!"ODB Enabled".equals(cloudCustomisableDetails.getName())) continue;
            isODBEnabled = true;
            break;
        }
        PciAuthorizationTokenElement element = null;
        if (isODBEnabled) {
            logger.debug("  USER NAME .................... " + userName);
            User user = this.utilService.getUserInfoByName(cloudId, userName);
            element = this.utilService.getPCITokenElement(cloudId, user.getUserId());
            if (user != null && element != null) {
                element.setUserName(user.getUserName());
            }
        }
        for (FileElement fileElement : list) {
            String fileRevisionId = fileElement.getFileRevisionId();
            logger.debug(fileElement.getFileName() + " File revision id ..........................." + fileRevisionId);
            com.pg.domain.BackupFile backupFile = this.syncFileDao.getSyncFileForId(cloudId, cloudName, userName, deviceUUID, fileRevisionId);
            if (backupFile != null && !StringUtils.isEmpty((String)backupFile.getDedupBackupId())) {
                logger.debug(fileRevisionId + " dedup file ..... " + backupFile.getDedupBackupId());
                String fileName = backupFile.getFileName();
                String filePath = backupFile.getFilePath();
                backupFile = this.syncFileDao.getSyncFileForId(cloudId, cloudName, userName, deviceUUID, backupFile.getDedupBackupId());
                backupFile.setFileName(fileName);
                backupFile.setFilePath(filePath);
            }
            FileInfo fileInfo = null;
            if (backupFile == null) {
                fileInfo = this.fileDao.getFileFromPG(userName, cloudName, fileRevisionId, true);
                this.restoreFromPGForAgent(cloudName, response, fileInfo);
            }
            FileStatusElement fileStatusElement = new FileStatusElement();
            if (fileInfo != null || backupFile == null) {
                try {
                    String isChunk = "false";
                    backupFile = new com.pg.domain.BackupFile();
                    backupFile.setFileName(fileElement.getFileName());
                    backupFile.setFilePath(fileElement.getFileCompletePath());
                    backupFile.setMd5(fileElement.getMd5checksum());
                    fileStatusElement.setUploadStatuscode(507);
                    downloadedCountTemp = this.sendHeadersForMultipart(response, totalCount, downloadedCountTemp, backupFile, isChunk, fileStatusElement);
                }
                catch (IOException e) {
                    logger.error("Exception in send headers>>>" + e);
                }
                continue;
            }
            String backupId = backupFile.getId();
            String fileName = backupFile.getFileName();
            String folderPath = backupFile.getFilePath();
            List chunkFileList = backupFile.getChunkFiles();
            Collections.sort(chunkFileList, new Comparator<com.pg.domain.ChunkFile>(){

                @Override
                public int compare(com.pg.domain.ChunkFile d1, com.pg.domain.ChunkFile d2) {
                    return d1.getFileName().compareTo(d2.getFileName());
                }
            });
            BufferedInputStream inputStream = null;
            ArrayList<String> nameList = new ArrayList<String>();
            logger.debug(backupFile.getFileName() + "@#@#@#@##### Writing outside to stream ....download count>>" + downloadedCountTemp);
            try {
                String isChunk = "true";
                downloadedCountTemp = this.sendHeadersForMultipart(response, totalCount, downloadedCountTemp, backupFile, isChunk, fileStatusElement);
            }
            catch (Exception e) {
                String simpleName = e.getCause().getClass().getSimpleName();
                logger.trace("" + e);
                logger.error("Error trying to write data .....%%%%%%%%% " + simpleName + "file path>>>" + backupFile.getFilePath() + "file name>>>" + backupFile.getFileName() + e.getMessage());
                try {
                    if ("ClientAbortException".equals(simpleName) || "SocketException".equals(simpleName)) {
                        this.deleteFilesUnderMergeAndDecrypt(path);
                        logger.error(" throw client abort exception .......");
                        throw new BlukryptClientAbortException("Client Aborted", 1);
                    }
                    response.getOutputStream().close();
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error("Exception While Restoring File From Cloud :" + e1.getMessage());
                }
            }
            boolean parentFileExists = false;
            logger.debug("BakcupFile userName>>>>>$$$$$$$$$$$" + backupFile.getUserName());
            boolean fileExists = this.downloadFile(cloud, backupFile.getUserName(), response, cloudName, deviceUUID, path, restorePath, cloudId, element, backupFile, backupId, fileName, folderPath, chunkFileList, inputStream, nameList, fileStatusElement);
            logger.debug(" file exists flag ....... " + fileExists);
            if (!fileExists) {
                logger.debug(" try parent file for md5..........");
                com.pg.domain.BackupFile backupFileObj = this.syncFileDao.getSyncFileForMd5(cloudId, cloudName, userName, deviceUUID, backupFile.getMd5());
                if (backupFileObj != null) {
                    logger.debug(" parent file for md5 exists ..........");
                    chunkFileList = backupFileObj.getChunkFiles();
                    parentFileExists = this.downloadFile(cloud, backupFile.getUserName(), response, cloudName, deviceUUID, path, restorePath, cloudId, element, backupFileObj, backupFileObj.getId(), fileName, folderPath, chunkFileList, inputStream, nameList, fileStatusElement);
                }
                logger.debug("************" + parentFileExists + "***" + fileRevisionId);
            }
            String isChunk = "false";
            try {
                ++downloadedCountTemp;
                downloadedCountTemp = this.sendHeadersForMultipart(response, totalCount, downloadedCountTemp, backupFile, isChunk, fileStatusElement);
            }
            catch (IOException e) {
                logger.error("Error in setting headers for multipart" + e);
            }
        }
    }

    private long sendHeadersForMultipart(HttpServletResponse response, long totalCount, long downloadedCountTemp, com.pg.domain.BackupFile backupFile, String isChunk, FileStatusElement fileStatusElement) throws IOException {
        response.getOutputStream().println();
        response.getOutputStream().println("----PARABLUEOF");
        String partHeader = "Content-Disposition: form-data;";
        response.getOutputStream().println(partHeader);
        String fileNameHeader = "fileName:" + backupFile.getFileName();
        response.getOutputStream().println(fileNameHeader);
        String filePathHeader = "filePath:" + backupFile.getFilePath();
        response.getOutputStream().println(filePathHeader);
        String md5 = "md5Checksum:" + backupFile.getMd5();
        response.getOutputStream().println(md5);
        logger.debug(" File md5 .......... " + md5);
        response.getOutputStream().println("count:" + downloadedCountTemp + "/" + totalCount);
        response.getOutputStream().println("isAChunkFile:" + isChunk);
        response.getOutputStream().println("downloadStatus:" + fileStatusElement.getUploadStatuscode());
        response.getOutputStream().println();
        return downloadedCountTemp;
    }

    private boolean downloadFile(Cloud cloud, String userName, HttpServletResponse response, String cloudName, String deviceUUID, String path, String restorePath, int cloudId, PciAuthorizationTokenElement element, com.pg.domain.BackupFile backupFile, String backupId, String fileName, String folderPath, List<com.pg.domain.ChunkFile> chunkFileList, BufferedInputStream inputStreams, List<String> nameList, FileStatusElement fileStatusElement) {
        boolean fileExists = true;
        BufferedInputStream inputStreamTemp = null;
        for (com.pg.domain.ChunkFile chunkFile : chunkFileList) {
            String syncDecryptKey;
            String productType;
            String saltKey;
            block25: {
                saltKey = null;
                productType = PRODUCT_TYPE_SYNC;
                syncDecryptKey = SYNC_DECRYPT_KEY;
                try {
                    if (StringUtils.isEmpty((String)chunkFile.getMd5())) {
                        logger.debug("Md5 is null so setting it from chunk file");
                        chunkFile.setMd5(SyncDownloadServiceImpl.getMd5FromFileName(chunkFile.getFileName()));
                    }
                    String dedupVal = this.getDedupValue(userName);
                    ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupVal, userName, false, false);
                    if (chunkDetail == null) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupVal, userName, false, true);
                    }
                    if (chunkDetail == null) {
                        logger.debug(CHUNK_DETAILS_NULL);
                        chunkDetail = new ChunkDetail();
                        chunkDetail.setCloudChunkName(chunkFile.getFileName());
                    }
                    if (!StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !"ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                        productType = BACKUP;
                        syncDecryptKey = chunkDetail.getContainerName();
                    }
                    StringBuilder fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName());
                    saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), productType);
                    int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                    if (occurance == 0 || occurance == 1 && chunkFileList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                        fileNameToDownload.append("." + backupId);
                    }
                    String containerName = null;
                    if (chunkDetail != null) {
                        containerName = chunkDetail.getContainerName();
                        if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                            chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                        }
                    }
                    if (this.isGDEnabled(cloud.getCloudCustomisableDetails())) {
                        chunkFile.setFileId(chunkDetail.getCloudChunkName());
                    }
                    if (chunkFile.getSize() == null) {
                        chunkFile.setSize(Long.valueOf(0L));
                    }
                    logger.debug(" trying to download .......... " + fileNameToDownload);
                    inputStreamTemp = this.downloadFileFromCloud(cloud, restorePath, fileNameToDownload.toString(), userName.toLowerCase(), cloudName, backupFile.getDeviceUUID(), element, chunkFile, backupFile, containerName, fileStatusElement, chunkDetail.getUserName(), chunkDetail);
                    if (inputStreamTemp == null) {
                        logger.debug(" input stream null .........");
                        fileExists = false;
                    }
                    if (!fileExists) {
                        break;
                    }
                }
                catch (ParacloudBackupException e) {
                    logger.trace("" + (Object)((Object)e));
                    logger.error("THE error code is>>>>>$$>>>>>" + e.getResponseCode());
                    if (e.getResponseCode() != 404) break block25;
                    nameList.clear();
                    try {
                        File decryptedFile = this.searchReplicaAndRestore(cloud, cloudName, userName, backupFile, nameList, saltKey, fileName, folderPath, element, restorePath);
                        logger.debug(" Before writeDatatoStream searchReplicaAndRestore... ");
                        this.writeDataToStream(response, path, restorePath, backupFile, decryptedFile);
                        logger.debug(" After writeDatatoStream searchReplicaAndRestore... ");
                        continue;
                    }
                    catch (Exception ex) {
                        logger.trace("" + ex);
                        logger.error(" Error in searchReplicaAndRestore - File not found ...." + ex.getMessage());
                        try {
                            if (inputStreamTemp != null) {
                                inputStreamTemp.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error("Exception While Downloading File :" + e1.getMessage());
                        }
                        inputStreamTemp = null;
                    }
                }
                catch (Exception e) {
                    logger.debug("Exception = " + e);
                    try {
                        if (inputStreamTemp != null) {
                            inputStreamTemp.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.trace("" + e1);
                        logger.error("Exception While Downloading File :" + e1.getMessage());
                    }
                    logger.error("Error trying to write data .....22222%%%%%%%%% file path>>>" + backupFile.getFilePath() + "file name>>>" + backupFile.getFileName());
                    logger.debug(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                    throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                }
            }
            saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), productType);
            if (saltKey == null) {
                throw new ParacloudBackupException("Azure download error while get decrypt key", 400);
            }
            File decryptedFile = this.getDecryptedFileFromPath(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), inputStreamTemp, restorePath, syncDecryptKey);
            if (decryptedFile == null) {
                logger.debug(" decryptedFile null so breaking.........");
                fileExists = false;
                break;
            }
            this.writeDataToStream(response, path, restorePath, backupFile, decryptedFile);
            nameList.add(chunkFile.getFileName());
        }
        return fileExists;
    }

    public String getEncryptOrDecryptKey(int cloudId, long timeStamp, String productType) {
        EncryptionKey encryptionKey = this.encryptionKeyDao.getKeyForDecrypt(cloudId, timeStamp, productType);
        String encryptionKeyVal = "";
        if (encryptionKey != null) {
            encryptionKeyVal = encryptionKey.getSaltKey();
            logger.debug("Recieved salt key  for file ..... " + encryptionKeyVal);
        }
        return encryptionKeyVal;
    }

    private void deleteFilesUnderMergeAndDecrypt(String path) {
        String mergePath = path + MERGE;
        String decryptedPath = path + DECRYPTED;
        File mergeFolder = new File(mergePath);
        File decryptedFolder = new File(decryptedPath);
        if (mergeFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)mergeFolder);
        }
        if (decryptedFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)decryptedFolder);
        }
    }

    private static String getMd5FromFileName(String fileName) {
        int occurance = StringUtils.countMatches((String)fileName, (String)".");
        String md5 = "";
        logger.debug("File name inside getmd5$$$$>>:" + fileName);
        if (occurance == 0) {
            md5 = fileName;
        } else if (occurance == 1) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        return md5;
    }

    private BufferedInputStream downloadFileFromCloud(Cloud cloud, String restorePathDir, String fileNameToDownload, String userName, String cloudName, String deviceUUID, PciAuthorizationTokenElement pciAuthorizationTokenElement, com.pg.domain.ChunkFile chunkFile, com.pg.domain.BackupFile backupFile, String containerName, FileStatusElement fileStatusElement, String folderName, ChunkDetail chunkDetailTemp) {
        logger.debug(chunkFile.getCloudStoragePath() + " downloading files using cloudsupport service  >>>>>> " + fileNameToDownload);
        com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
        BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
        ChunkDetail chunkDetail = new ChunkDetail();
        BeanUtils.copyProperties((Object)chunkFile, (Object)chunkDetail);
        if (chunkFile.getSize() == null) {
            chunkFile.setSize(Long.valueOf(0L));
        }
        boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
        String fileToDownload = fileNameToDownload;
        chunkDetail.setEncodedName(chunkDetailTemp.getEncodedName());
        if (isGDEnabled) {
            fileToDownload = pgChunkFile.getFileId();
        }
        BufferedInputStream inputStream = this.cloudSupportService.downloadFile(cloud, restorePathDir, fileToDownload, userName, deviceUUID, containerName, pgChunkFile, true, backupFile, fileStatusElement, folderName, chunkDetail);
        return inputStream;
    }

    private void writeDataToStream(HttpServletResponse response, String path, String restorePath, com.pg.domain.BackupFile backupFile, File decryptedFile) {
        try {
            logger.debug("!!!!NO MERGE..................");
            this.writeDataToStream(decryptedFile, backupFile, response, restorePath);
        }
        catch (Exception e) {
            try {
                String simpleName = e.getCause().getClass().getSimpleName();
                logger.trace("" + e);
                logger.error("Error trying to write data ..... " + simpleName + e.getMessage());
                if (decryptedFile.exists()) {
                    decryptedFile.delete();
                }
                if ("ClientAbortException".equals(simpleName) || "SocketException".equals(simpleName)) {
                    this.deleteFilesUnderMergeAndDecrypt(path);
                    logger.error(" throw client abort exception .......");
                    throw new BlukryptClientAbortException("Client Aborted", 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error("Exception While Writting Data to Stream :" + e1.getMessage());
            }
        }
    }

    private void writeDataToStream(File file, com.pg.domain.BackupFile backupFile, HttpServletResponse response, String path) throws IOException {
        int buff;
        logger.debug(SENDING_FILE + file.getName());
        FileInputStream fis = new FileInputStream(file);
        FilterInputStream fif = new BufferedInputStream(fis);
        logger.debug(IS_COMPRESSED + backupFile.isCompressed());
        if (backupFile.isCompressed()) {
            fif = new GZIPInputStream(fif);
        }
        byte[] b = new byte[4096];
        while ((buff = ((InputStream)fif).read(b)) != -1) {
            response.getOutputStream().write(b, 0, buff);
        }
        ((InputStream)fif).close();
        response.getOutputStream().flush();
        logger.debug(FINISHED_FILE + file.getName());
        file.delete();
        logger.debug("deleting  file  under path " + file.getPath());
    }

    private File searchReplicaAndRestore(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, String fileName, String folderPath, PciAuthorizationTokenElement element, String restorePath) {
        return null;
    }

    private void restoreFromPGForAgent(String cloudName, HttpServletResponse response, FileInfo fileInfo) {
        if (fileInfo != null) {
            String fileInfoFileName = fileInfo.getFileName();
            try {
                response.getOutputStream().println();
                response.getOutputStream().println("----PARABLUEOF");
                String partHeader = "Content-Disposition: form-data;";
                response.getOutputStream().println(partHeader);
                String fileNameHeader = "fileName:" + fileInfoFileName;
                response.getOutputStream().println(fileNameHeader);
                String filePathHeader = "filePath:" + fileInfo.getFilePath();
                response.getOutputStream().println(filePathHeader);
                String md5 = "md5Checksum:" + fileInfo.getMd5();
                response.getOutputStream().println(md5);
                logger.debug(" File md5 .......... " + md5);
                response.getOutputStream().println();
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("Exception While Restoring From PG For Agent :" + e.getMessage());
            }
            logger.debug(" file is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
            List list = fileInfo.getChunkFiles();
            Collections.sort(list);
            String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
            if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
            }
            String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
            for (String chunkName : list) {
                logger.debug(" file from pg.................." + chunkName);
                String filePath = chunkFilePath + "/" + chunkName;
                File file = new File(filePath);
                if (file.exists()) {
                    long size = file.length();
                    logger.debug(size + " file from pg.size................." + filePath);
                    this.writeDataToStreamFromPg(response, file, fileInfo);
                    continue;
                }
                logger.error(" file does not exists........" + filePath);
            }
            logger.debug(" before returning.........");
        }
    }

    private void restoreFromPG(String cloudName, HttpServletResponse response, FileInfo fileInfo, boolean isSync, String browserType) {
        if (fileInfo != null) {
            String fileInfoFileName = fileInfo.getFileName();
            Long filesize = fileInfo.getSize();
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            String encodedFilename = fileInfoFileName;
            try {
                encodedFilename = URLEncoder.encode(fileInfoFileName, "UTF-8").replace("+", "%20");
                if (browserType.contains("Firefox")) {
                    response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
                } else if (browserType.contains("Chrome")) {
                    response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename);
                } else {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileInfoFileName + "\"");
                }
                response.addHeader("Content-Transfer-Encoding", "binary");
                response.addHeader("Content-Length", String.valueOf(filesize));
                response.addHeader("filename", fileInfoFileName);
                response.addHeader("Content-Transfer-Encodingsdasda", "binary");
                response.setContentType("application/octet-stream");
                logger.debug(" file is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
                List list = fileInfo.getChunkFiles();
                Collections.sort(list);
                String deviceTempPath = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID() : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                    deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                }
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                for (String chunkName : list) {
                    int endIndex;
                    if (!isSync && !StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                        chunkName = chunkName.substring(0, endIndex);
                    }
                    logger.debug(" file from pg.................." + chunkName);
                    String filePath = chunkFilePath + "/" + chunkName;
                    File file = new File(filePath);
                    if (file.exists()) {
                        long size = file.length();
                        logger.debug(size + " file from pg.size................." + filePath);
                        this.writeDataToStreamFromPg(response, file, fileInfo);
                        continue;
                    }
                    logger.error(" file does not exists........" + filePath);
                }
                logger.debug(" before returning.........");
            }
            catch (UnsupportedEncodingException e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        }
    }

    private void writeDataToStreamFromPg(HttpServletResponse response, File file, FileInfo fileInfo) {
        try {
            int buff;
            logger.debug(SENDING_FILE + file.getName());
            FileInputStream fis = new FileInputStream(file);
            FilterInputStream fif = new BufferedInputStream(fis);
            logger.debug(IS_COMPRESSED + fileInfo.isCompressed());
            if (fileInfo.isCompressed()) {
                fif = new GZIPInputStream(fif);
            }
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
            }
            ((InputStream)fif).close();
            response.getOutputStream().flush();
            logger.debug(FINISHED_FILE + file.getName());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" error trying to send ...." + e.getMessage());
        }
    }

    @Override
    public void downloadFileFromPGForPortal(String cloudName, HttpServletResponse response, FileInfo fileInfo, String browserType) {
        this.restoreFromPG(cloudName, response, fileInfo, false, browserType);
    }

    @Override
    public boolean downloadFileFromCloudForPortal(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, HttpServletResponse response, boolean fileExists, boolean isSync) {
        return this.downloadFileFromCloud(cloud, cloudName, userName, backupFile, nameList, saltKey, response, fileExists, isSync);
    }

    private String getDedupValue(String userName) {
        String dedupVal = null;
        int cloudId = 1;
        User user = this.utilService.getUserInfoByName(1, userName);
        if (user != null && !StringUtils.isEmpty((String)user.getPolicyName())) {
            BackupPolicy backupPolicy = this.utilService.getBackupPolicy(cloudId, user.getPolicyName());
            dedupVal = backupPolicy.getDedup();
        }
        return dedupVal;
    }

    private String getDedupValueByUserName(String userName) {
        String dedupVal = null;
        int cloudId = 1;
        String syncPolicyName = this.userDao.getSyncPolicyNameByUserName(cloudId, userName);
        if (!StringUtils.isEmpty((String)syncPolicyName)) {
            SyncPolicy syncPolicy = this.utilService.getSyncPolicy(cloudId, syncPolicyName);
            dedupVal = syncPolicy.getDedup();
        }
        return dedupVal;
    }

    private void getAllFolderChildrenByDevicePath(String cloudName, String userName, String filePath, Device device, int cloudId, List<BackUpImage> backupImages) {
        List backUpImagesTemp = this.externalStorageBackupFileDao.getBackupFolderForBasePath(cloudId, cloudName, userName, device, filePath);
        backupImages.addAll(backUpImagesTemp);
        if (!CollectionUtils.isEmpty((Collection)backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                logger.debug("Inside loop after getting folders..bkpimages list size:" + backUpImagesTemp.size());
                if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                logger.debug("Inside loop to get immediate folders deevicePath:" + devicePath);
                this.getAllFolderChildrenByDevicePath(cloudName, userName, devicePath, device, cloudId, backupImages);
            });
        }
    }

    private void downloadZipFileFromPGForPortal(String cloudName, FileInfo fileInfo, boolean isSync, FileInputStream copyFileInput, DownloadFileTO downloadFileTO, String restorePath) {
        logger.debug(" file is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
        List list = fileInfo.getChunkFiles();
        Collections.sort(list);
        String deviceTempPath = isSync ? PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID() : PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
            deviceTempPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getBatchId();
        }
        String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        String folderPath = "";
        if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
            folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        }
        String backupFileName = fileInfo.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        String tempPath = restorePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFilePath();
        String filePathForRestore = tempPath.replaceAll("//", "\\");
        String fileCompletePath = filePathForRestore + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        for (String chunkName : list) {
            int endIndex;
            if (!isSync && !StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                chunkName = chunkName.substring(0, endIndex);
            }
            logger.debug(" file from pg.................." + chunkName);
            String filePath = chunkFilePath + "/" + chunkName;
            File file = new File(filePath);
            if (file.exists()) {
                logger.debug(fileCompletePath + " file from pg.size................." + filePath);
                try {
                    File copied = new File(fileCompletePath);
                    FileUtils.copyFile((File)file, (File)copied);
                }
                catch (IOException e) {
                    logger.error("Exception" + e.getMessage());
                }
                continue;
            }
            logger.error(" file does not exists........" + filePath);
        }
    }

    @Override
    public DownloadTO downloadZipSyncFileForPortal(Cloud cloud, String fileName, String filePath, String syncRevisionId, String userName, HttpServletResponse response) {
        DownloadTO downloadTO = new DownloadTO("");
        String path = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + cloud.getCloudName() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "sync-download" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        long currentMills = System.currentTimeMillis();
        String restorePath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + currentMills + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File restoreFolder = new File(restorePath);
        if (!restoreFolder.exists()) {
            restoreFolder.mkdirs();
        }
        logger.debug("Download path..." + restoreFolder);
        logger.debug(filePath + " BEFORE DOWNLOADING folder  >>>>>> " + restoreFolder);
        try {
            BufferedInputStream inputStream = null;
            int cloudId = cloud.getCloudId();
            if (!StringUtils.isEmpty((String)filePath)) {
                FileInputStream copyFileInput = null;
                Long folderSize = 0L;
                ArrayList<ConsolidatedImage> syncFolderList = new ArrayList<ConsolidatedImage>();
                ConsolidatedImage syncFile = this.externalStorageBackupFileDao.getSyncFolderById(cloudId, syncRevisionId);
                if (syncFile != null) {
                    syncFolderList.add(syncFile);
                }
                ArrayList<ConsolidatedImage> syncFileFolderRecursion = new ArrayList<ConsolidatedImage>();
                this.syncFileFolderRecursion(userName, filePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName, cloudId, syncFileFolderRecursion);
                syncFolderList.addAll(syncFileFolderRecursion);
                if (!CollectionUtils.isEmpty(syncFolderList)) {
                    for (ConsolidatedImage consolidatedImage : syncFolderList) {
                        ArrayList<ConsolidatedImage> restoreFilesList = new ArrayList<ConsolidatedImage>();
                        List files = this.externalStorageBackupFileDao.getAllChildFilesOfFolder(cloudId, userName, consolidatedImage.getDevicePath() + "/" + consolidatedImage.getFileName(), false);
                        restoreFilesList.addAll(files);
                        folderSize = this.restoreSyncFolder(cloud, userName, restoreFilesList, folderSize, inputStream, copyFileInput, filePath, restoreFolder);
                    }
                }
                ZipUtil.pack((File)new File(restorePath), (File)new File(path + "/" + fileName + ".zip"));
                logger.debug("Path..." + path);
                response.setHeader("filePath", path + "/" + fileName + ".zip");
                downloadTO.setSize(folderSize.longValue());
                try {
                    FileUtils.deleteDirectory((File)new File(restorePath));
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error(" error trying to delete dir ...." + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception" + e.getMessage());
        }
        return downloadTO;
    }

    private Long restoreSyncFolder(Cloud cloud, String userName, List<ConsolidatedImage> restoreFilesList, long folderSize, BufferedInputStream inputStream, FileInputStream copyFileInput, String filePath, File restoreFolder) {
        BackupFile backupFileData = new BackupFile();
        block14: for (ConsolidatedImage consolidatedImage : restoreFilesList) {
            String path;
            File tempdownloadDir;
            backupFileData = this.externalStorageBackupFileDao.getBkpFileByFileName(cloud.getCloudId(), cloud.getCloudName(), userName, consolidatedImage.getDevicePath(), consolidatedImage.getFileName());
            if (backupFileData == null) {
                String filePathTemp = consolidatedImage.getDevicePath().replace("/", "\\");
                backupFileData = this.externalStorageBackupFileDao.getBkpFileByFileName(cloud.getCloudId(), cloud.getCloudName(), userName, filePathTemp, consolidatedImage.getFileName());
            }
            if (backupFileData == null) {
                folderSize = this.restorePgFile(cloud, userName, folderSize, copyFileInput, filePath, consolidatedImage, restoreFolder.getAbsolutePath());
                continue;
            }
            String tempPath = consolidatedImage.getDevicePath();
            String fileCompletePath = restoreFolder.getAbsolutePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath;
            File tempdownloadDir1 = new File(fileCompletePath);
            if (!tempdownloadDir1.exists()) {
                tempdownloadDir1.mkdirs();
            }
            if (backupFileData.getSize() != 0L) {
                folderSize += backupFileData.getSize().longValue();
            }
            if (!(tempdownloadDir = new File(path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloud.getCloudName()) + backupFileData.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + TEMP_DOWNLOAD_SYNC)).exists()) {
                tempdownloadDir.mkdirs();
            }
            fileCompletePath = fileCompletePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + consolidatedImage.getFileName();
            com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
            this.convertPcbdToPgDomainOfBackupFile(backupFileData, backupFile);
            List chunkFilesList = backupFile.getChunkFiles();
            int totalChunks = chunkFilesList.size();
            this.sortChunkFileListByChunkFileName(chunkFilesList);
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileCompletePath));
                Throwable throwable = null;
                try {
                    for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
                        String syncDecryptKey = SYNC_DECRYPT_KEY;
                        String productType = PRODUCT_TYPE_SYNC;
                        try {
                            int buff;
                            String dedupVal = this.getDedupValueByUserName(userName);
                            ChunkDetail chunkDetail = this.getChunkDetailsByMd5(userName, chunkFile, dedupVal);
                            logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                            String backupId = backupFile.getId();
                            StringBuilder fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName());
                            int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                            if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                                fileNameToDownload.append("." + backupId);
                            }
                            String containerName = null;
                            if (chunkDetail != null) {
                                containerName = chunkDetail.getContainerName();
                                if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                                    chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                                }
                            }
                            if (!StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !"ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                                productType = BACKUP;
                                syncDecryptKey = chunkDetail.getContainerName();
                            }
                            com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                            BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                            FileStatusElement fileStatusElement = new FileStatusElement();
                            boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                            String fileToDownload = fileNameToDownload.toString();
                            if (isGDEnabled) {
                                fileToDownload = chunkDetail.getCloudChunkName();
                            }
                            if ((inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, true, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail)) == null) continue block14;
                            String saltKeyTemp = this.getEncryptOrDecryptKey(1, chunkFile.getUploadedTimeStamp(), productType);
                            File decryptedFile = this.getDecryptedFile(cloud.getCloudName(), saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, syncDecryptKey);
                            if (decryptedFile.exists()) {
                                copyFileInput = new FileInputStream(decryptedFile.getAbsolutePath());
                            }
                            FilterInputStream fif = new BufferedInputStream(copyFileInput);
                            logger.debug(IS_COMPRESSED + backupFile.isCompressed());
                            if (backupFile.isCompressed()) {
                                fif = new GZIPInputStream(copyFileInput);
                            }
                            byte[] b = new byte[4096];
                            while ((buff = ((InputStream)fif).read(b)) != -1) {
                                bos.write(b, 0, buff);
                            }
                            ((InputStream)fif).close();
                        }
                        catch (IOException e) {
                            logger.error("Exception" + e.getMessage());
                        }
                        logger.debug(" remaining chunks ......" + --totalChunks);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bos == null) continue;
                    if (throwable != null) {
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bos.close();
                }
            }
            catch (FileNotFoundException e2) {
                logger.trace("" + e2);
                logger.error("EXCPTION" + e2.getMessage());
            }
            catch (IOException e3) {
                logger.trace("" + e3);
                logger.error("EXCPTION" + e3.getMessage());
            }
        }
        return folderSize;
    }

    private void sortChunkFileListByChunkFileName(List<com.pg.domain.ChunkFile> chunkFilesList) {
        Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

            @Override
            public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
            }
        });
    }

    private ChunkDetail getChunkDetailsByMd5(String userName, com.pg.domain.ChunkFile chunkFile, String dedupVal) {
        ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, false, false);
        if (chunkDetail == null) {
            logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
            chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, false, true);
        }
        if (chunkDetail == null) {
            logger.debug(CHUNK_DETAILS_NULL);
            chunkDetail = new ChunkDetail();
            chunkDetail.setCloudChunkName(chunkFile.getFileName());
        }
        return chunkDetail;
    }

    private long restorePgFile(Cloud cloud, String userName, long folderSize, FileInputStream copyFileInput, String filePath, ConsolidatedImage consolidatedImage, String restorePath) {
        String syncId = this.fileDao.getRevisionFileByconsolidatedImageId(cloud.getCloudId(), consolidatedImage);
        FileInfo fileInfo = this.fileDao.getFileFromPG(userName, cloud.getCloudName(), syncId, true);
        if (fileInfo != null) {
            folderSize += fileInfo.getSize().longValue();
            String filePath1 = fileInfo.getFilePath();
            filePath1 = filePath1.replace("\\", "/");
            fileInfo.setFilePath(filePath1);
            DownloadFileTO downloadFileTO = new DownloadFileTO();
            downloadFileTO.setFilePath(filePath);
            this.downloadZipFileFromPGForPortal(cloud.getCloudName(), fileInfo, true, copyFileInput, downloadFileTO, restorePath);
        }
        return folderSize;
    }

    private void convertPcbdToPgDomainOfBackupFile(BackupFile backupFileData, com.pg.domain.BackupFile backupFile) {
        BeanUtils.copyProperties((Object)backupFileData, (Object)backupFile);
        ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
        for (ChunkFile chunkFile : backupFileData.getChunkFiles()) {
            com.pg.domain.ChunkFile file = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)file);
            chunkList.add(file);
        }
        backupFile.setChunkFiles(chunkList);
    }

    private void syncFileFolderRecursion(String userName, String filePath, int cloudId, List<ConsolidatedImage> syncFileFolderRecursion) {
        List syncFilesTemp = this.externalStorageBackupFileDao.getAllChildFilesOfFolder(cloudId, userName, filePath, true);
        syncFileFolderRecursion.addAll(syncFilesTemp);
        if (!CollectionUtils.isEmpty((Collection)syncFilesTemp)) {
            Stream stream = syncFilesTemp.parallelStream();
            stream.forEach(syncFile -> {
                String devicePath = syncFile.getDevicePath() + "/" + syncFile.getFileName();
                if (StringUtils.isEmpty((String)syncFile.getDevicePath())) {
                    devicePath = syncFile.getFileName();
                }
                this.syncFileFolderRecursion(userName, devicePath, cloudId, syncFileFolderRecursion);
            });
        }
    }
}

