/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.google.common.util.concurrent.RateLimiter;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupJob;
import com.parablu.pcbd.domain.User;
import com.pg.dao.BackupFileDao;
import com.pg.dao.FileDao;
import com.pg.dao.OneDriveDao;
import com.pg.dao.UtilDao;
import com.pg.domain.BackupFile;
import com.pg.domain.FileInfo;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.exception.BaseException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.odb.util.OneDriveUtil;
import com.pg.service.CloudSupportService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import com.pg.service.impl.BaseUploadService;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UploadServiceImpl
extends BaseUploadService
implements UploadService {
    private static Logger logger = LoggerFactory.getLogger(UploadServiceImpl.class);
    public static final int HTTP_FILE_ALREADY_MOVED = 555;
    public static final int HTTP_FILE_NOT_PRESENT_LOCALLY = 556;
    private static final String BLACK_LIST_USERS = "BlackListUsers";
    @Autowired
    private FileDao fileDao;
    @Autowired
    private OneDriveDao oneDriveDao;
    @Autowired
    private FileEncryptionService fileEncryptionService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private BackupFileDao backupFileDao;
    @Autowired
    private UtilDao utilDao;
    private static final String BACKUP = "backup";
    private static final String IS_JOB_RUNNING = "isJobRunning";
    @Autowired
    private CloudSupportService cloudSupportService;

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setCloudSupportService(CloudSupportService cloudSupportService) {
        this.cloudSupportService = cloudSupportService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setOneDriveDao(OneDriveDao oneDriveDao) {
        this.oneDriveDao = oneDriveDao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
        this.fileEncryptionService = fileEncryptionService;
    }

    @Override
    public boolean saveFileInfo(String cloudName, String userName, FileInfo fileInfo) {
        return this.fileDao.saveFileInfo(fileInfo, cloudName, userName);
    }

    @Override
    public boolean saveFileInfoForSync(String cloudName, String gatewayName, FileInfo fileInfo) {
        return this.fileDao.saveFileInfoForSync(fileInfo, cloudName, gatewayName);
    }

    @Override
    public BackupFile getBackupFile(String userName, String cloudName, String backupId, String gatewayName) {
        return this.fileDao.getBackupFile(userName, cloudName, backupId, gatewayName);
    }

    @Override
    public String getOneDriveAccessToken(PciAuthorizationTokenElement pciAuthorizationTokenElement) {
        return this.oneDriveDao.getOneDriveAccessToken(pciAuthorizationTokenElement);
    }

    @Override
    public void deleteBackupFile(String userName, String cloudName, String backupId, String accessToken) {
        this.fileDao.deleteBackupFile(userName, cloudName, backupId, accessToken);
    }

    @Override
    public FileInfo getFileInfo(String cloudName, String userName, String gatewayName, String dedupifiedBackupId) {
        return this.fileDao.getFileInfo(cloudName, userName, gatewayName, dedupifiedBackupId);
    }

    @Override
    public FileInfo getBackupFileInfo(String cloudName, String userName, String gatewayName, String dedupifiedBackupId) {
        return this.fileDao.getBackupFileInfo(cloudName, userName, gatewayName, dedupifiedBackupId);
    }

    @Override
    public void deleteUploadedFiles(FileInfo fileInfo, String cloudName) {
        this.fileDao.deleteFile(fileInfo, cloudName);
    }

    @Override
    public boolean uploadAllFilesToCloud(String cloudName, FileInfo fileInfo, Cloud cloud, RateLimiter rateLimiter) {
        logger.debug("  INSIDE uploadAllFilesToCloud..... " + fileInfo.getId());
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        String batchId = fileInfo.getBatchId();
        logger.debug("@#@#@#Inside uploadAllChunksToCloud ..... " + batchId);
        if (!StringUtils.isEmpty((String)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        logger.debug("@#@#@#Inside devicetempath ..... " + deviceTempPath);
        String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "chunk";
        BackupFile backupFile = new BackupFile();
        backupFile.setChunkFiles(new ArrayList());
        backupFile.setFileName(fileInfo.getFileName());
        backupFile.setFilePath(fileInfo.getFilePath());
        backupFile.setMd5(fileInfo.getMd5());
        backupFile.setSize(fileInfo.getSize());
        backupFile.setBackupId(new ObjectId(fileInfo.getId()));
        backupFile.setDeviceUUID(fileInfo.getDeviceUUID());
        backupFile.setCompressed(fileInfo.isCompressed());
        backupFile.setId(fileInfo.getId());
        backupFile.setBackupId(new ObjectId(fileInfo.getId()));
        String userName = fileInfo.getUserName();
        String gatewayName = fileInfo.getGatewayName();
        logger.debug("@#@#@# before Inside uploadAllChunksToCloud ..... " + fileInfo.getBatchId());
        Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), fileInfo.getDeviceUUID());
        if (device == null || device.isDeleted()) {
            return true;
        }
        long storageInPG = 0L;
        long storageInCloud = 0L;
        FileStatusElement fileStatusElement = this.uploadAllChunksToCloud(cloudName, userName, fileInfo, gatewayName, chunkFilePath, backupFile, cloud, rateLimiter, device, storageInPG, storageInCloud);
        boolean isFileUploaded = fileStatusElement.isUploadStatus();
        backupFile.setBackupId(new ObjectId(fileInfo.getId()));
        backupFile.setId(fileInfo.getId());
        if (fileStatusElement.getUploadStatuscode() == 555 || fileStatusElement.getUploadStatuscode() == 556) {
            logger.debug("..file not present locally .. " + fileStatusElement.getUploadStatuscode());
            if (PCHelperConstant.getPropertyFileValueUpdatepgnameWhenChunkNotFoundMultipgenv()) {
                logger.debug("inside update gateway name when pg not found");
                FileInfo fileInfoObj = this.utilService.getFileInfoFromMongo(cloud.getCloudId(), cloudName, fileInfo.getId());
                logger.debug("fileInfo:" + fileInfoObj);
                if (fileInfoObj != null) {
                    ArrayList<String> processedFileList = CollectionUtils.isEmpty((Collection)fileInfoObj.getProcessedPgList()) ? new ArrayList<String>() : fileInfoObj.getProcessedPgList();
                    processedFileList.add(PCHelperConstant.getPropertyFileValueGatewayname());
                    logger.debug("processed pg list before remove duplicates:" + processedFileList.size());
                    processedFileList = new ArrayList(new HashSet(processedFileList));
                    logger.debug("processed pg list after remove duplicates:" + processedFileList.size());
                    fileInfoObj.setProcessedPgList(processedFileList);
                    this.utilService.saveFileInfoInMongo(fileInfoObj);
                } else {
                    logger.debug("fileInfo is null when taking from backup_pg");
                }
            } else {
                BackUpImage backUpImage;
                logger.debug(fileStatusElement.getUploadStatuscode() + "...NOT PRESENT.........status coode...." + fileStatusElement.getUploadStatuscode());
                logger.debug("......FILE_INFO....." + fileInfo.getFileName() + "...." + fileInfo.getSize());
                if (fileStatusElement.getUploadStatuscode() == 556 && (backUpImage = this.utilService.getBackupImageFile(1, fileInfo.getId(), device)) != null && !"CLOUD".equals(backUpImage.getStoragePlace())) {
                    long filesizeInKB = (long)Math.ceil((double)backupFile.getSize().longValue() / 1024.0);
                    logger.debug(fileStatusElement.getUploadStatuscode() + "...DELETE...... " + filesizeInKB + "...." + fileInfo.getUserName());
                    OneDriveUtil.getInstance().updateBkpOverviewForDeletedFiles(cloud.getCloudId(), device.getDeviceUUID(), filesizeInKB);
                    logger.debug("......completed updating deleted.....");
                }
                logger.debug(fileInfo.getUserName() + "...deleting file......" + fileInfo.getFileName());
                this.utilService.removeBackupFromTempDb(cloud, backupFile.getBackupId(), true);
            }
        } else if (isFileUploaded) {
            logger.debug(fileInfo.getId() + "update maindb2....." + device.getDestCollection());
            logger.debug("...chunks info...." + backupFile.getChunkFiles());
            try {
                if (!fileInfo.isReducePGSize()) {
                    logger.debug("Its old file so no need to reduse pgCompressed Size..........");
                    fileStatusElement.setPgFileSize(0L);
                }
                this.utilService.saveChunksAndUpdateStorageForBackup(cloud, backupFile, cloudName, userName, gatewayName, fileInfo.isFullBackup(), device, fileStatusElement.getUploadedFileSize(), fileStatusElement.getPgFileSize(), fileInfo);
                logger.debug("after update saveChunksAndUpdateStorageForBackup....");
                logger.debug("update removeBackupFromTempDb.....");
                if (backupFile.getBackupId() != null) {
                    this.utilService.removeBackupFromTempDb(cloud, backupFile.getBackupId(), true);
                }
                logger.debug("after removeBackupFromTempDb.....");
            }
            catch (Exception e) {
                isFileUploaded = false;
                logger.debug(" trying to remove from tmp table....." + e);
                logger.error(" trying to remove from tmp table.....");
            }
        } else {
            logger.error("Unable to upload file ....");
        }
        logger.debug("after upload....." + isFileUploaded);
        return isFileUploaded;
    }

    private FileStatusElement uploadAllChunksToCloud(String cloudName, String userName, FileInfo fileInfo, String gatewayName, String chunkFilePath, BackupFile backupFile, Cloud cloudTemp, RateLimiter rateLimiter, Device device, long storageInPG, long storageInCloud) {
        int[] chunkDetails = new int[2];
        Cloud cloud = cloudTemp;
        User user = this.utilService.getUserInfoByName(1, userName);
        if (user == null) {
            Set<String> blackUsersList = new HashSet<String>();
            Object obj = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj != null) {
                blackUsersList = (Set)obj;
            }
            blackUsersList.add(userName.toLowerCase());
            logger.debug("......user is not found so mark as blacklisted ..." + userName);
            MemoryStore.add((String)BLACK_LIST_USERS, blackUsersList, (long)240000L);
            return new FileStatusElement();
        }
        BackupPolicy backupPolicy = this.utilService.getBackupPolicy(1, user.getPolicyName());
        String dedupVal = this.getDedupValue(backupPolicy);
        if (StringUtils.isEmpty((String)PCHelperConstant.getPropertyFileValueEncryptionEnabled()) || !"true".equals(PCHelperConstant.getPropertyFileValueEncryptionEnabled())) {
            String filePath = this.mergeAllChunksAndCreateSingleFile(fileInfo, chunkFilePath, cloudName);
            File file = new File(filePath);
            logger.debug("Cloud upload  FILE started inside no encryption..... " + file.getName());
            logger.debug("Cloud upload  file.length() started inside no encryption..... " + file.length());
            long fileSize = file.length();
            FileStatusElement fileStatusElement = new FileStatusElement();
            fileStatusElement.setUploadedFileSize(fileSize);
            try {
                fileStatusElement = this.checkNThrottleAndUploadChunkFileToCloud(cloudName, userName, fileInfo, gatewayName, backupFile, file.getName(), file, fileSize, cloud, rateLimiter, dedupVal, null, null);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("...error while uploading....." + e.getMessage());
            }
            if (fileStatusElement.isUploadStatus()) {
                this.updateCloudStorageConsumed(fileInfo, file.length());
            }
            return fileStatusElement;
        }
        logger.debug(chunkFilePath + "...Inside uploadallchunkstocloud ....... " + fileInfo.getBatchId() + "....." + backupFile.getBackupId());
        if (backupPolicy != null) {
            int chunkSize = backupPolicy.getFileChunkableSize();
            int pftSize = backupPolicy.getPftSize();
            chunkDetails[0] = chunkSize;
            chunkDetails[1] = pftSize;
        } else {
            logger.debug("User backup mapping policy is empty so set default values........so set deafilt chunk size 4 and ptf size as 4");
            chunkDetails[0] = 4;
            chunkDetails[1] = 4;
        }
        logger.debug(fileInfo.getSize() + "..chunk info ..... " + chunkDetails[1]);
        logger.debug(fileInfo.getChunkFiles().size() + "..chunk info1 ..... " + chunkDetails[1]);
        String largeFilePath = "";
        if (fileInfo.getSize() > (long)(chunkDetails[1] * 1024 * 1024) && fileInfo.getChunkFiles().size() == 1 && fileInfo.getSize() > 0x1400000L || fileInfo.getSize() == 0L) {
            int occuranceTemp = StringUtils.countMatches((String)((String)fileInfo.getChunkFiles().get(0)), (String)".");
            String fileNameExcludeIdTemp = (String)fileInfo.getChunkFiles().get(0);
            if (occuranceTemp > 1) {
                fileNameExcludeIdTemp = ((String)fileInfo.getChunkFiles().get(0)).substring(0, ((String)fileInfo.getChunkFiles().get(0)).lastIndexOf(46));
            }
            logger.debug(new File(chunkFilePath + "/" + fileNameExcludeIdTemp).length() + "..........size........." + chunkDetails[0] * 1024 * 1024 + "......" + fileInfo.getSize());
            if (new File(chunkFilePath + "/" + fileNameExcludeIdTemp).length() > (long)(chunkDetails[0] * 1024 * 1024)) {
                logger.debug(" largefile .... so split and upload...........");
                for (String fileName : fileInfo.getChunkFiles()) {
                    logger.debug(fileInfo.getId() + "Cloud upload  FILE started ..... " + fileName);
                    int occurance = StringUtils.countMatches((String)fileName, (String)".");
                    String fileNameExcludeId = fileName;
                    if (occurance > 1) {
                        fileNameExcludeId = fileName.substring(0, fileName.lastIndexOf(46));
                    }
                    largeFilePath = chunkFilePath + "/" + fileNameExcludeId;
                    logger.debug("large file path>>>" + largeFilePath);
                }
                ArrayList chunks = new ArrayList();
                try {
                    Map chunkMap = com.pg.util.FileUtils.splitAndWrite((int[])chunkDetails, (String)largeFilePath, (String)(chunkFilePath + "/"), (String)userName);
                    for (Map.Entry entry : chunkMap.entrySet()) {
                        File file = new File(chunkFilePath + "/" + (String)entry.getValue());
                        logger.debug((String)entry.getKey() + " .........after chunk.with chunkDetails........... " + (String)entry.getValue() + "....." + file.exists());
                        chunks.add((String)entry.getValue() + "." + backupFile.getBackupId().toString());
                    }
                }
                catch (Exception e) {
                    logger.error("exception .." + e.getMessage());
                    logger.error("exception .." + e);
                }
                Collections.sort(chunks);
                if (!CollectionUtils.isEmpty((Collection)chunks)) {
                    fileInfo.setChunkFiles(new ArrayList());
                    fileInfo.setChunkFiles((List)chunks);
                }
            }
        }
        FileStatusElement fileStatusElement = new FileStatusElement();
        HashMap<String, com.pg.domain.ChunkFile> uploadedFiles = fileInfo.getUploadedChunks();
        if (CollectionUtils.isEmpty((Map)uploadedFiles)) {
            uploadedFiles = new HashMap<String, com.pg.domain.ChunkFile>();
        }
        for (String fileName : fileInfo.getChunkFiles()) {
            File dir;
            Object[] files;
            boolean isJobRunning = true;
            if (MemoryStore.get((String)IS_JOB_RUNNING) != null) {
                isJobRunning = (Boolean)MemoryStore.get((String)IS_JOB_RUNNING);
            }
            logger.debug("........Is tomcat job running........." + isJobRunning);
            if (!isJobRunning) {
                logger.error("..Tomcat job is going to be stopped.. so stopping upload ....");
                fileStatusElement.setUploadStatus(false);
                return fileStatusElement;
            }
            logger.debug(fileInfo.getId() + "....inside Cloud upload  FILE started ..... " + fileName + "..uploadedFiles.size().." + uploadedFiles.size());
            String chunkNameInFileInfo = fileName.replaceAll("\\.", "_");
            if (!CollectionUtils.isEmpty(uploadedFiles) && uploadedFiles.keySet().contains(chunkNameInFileInfo)) {
                logger.debug("fileName present in uploaded files list so skip...." + chunkNameInFileInfo + "..uploadedFiles.size().." + uploadedFiles.size());
                backupFile.getChunkFiles().add(uploadedFiles.get(chunkNameInFileInfo));
                fileStatusElement.setUploadStatus(true);
                continue;
            }
            fileStatusElement.setUploadStatus(false);
            int occurance = StringUtils.countMatches((String)fileName, (String)".");
            String md5 = UploadServiceImpl.getMd5FromFileName(fileName, occurance);
            String fileNameExcludeId = fileName;
            if (occurance > 1) {
                fileNameExcludeId = fileName.substring(0, fileName.lastIndexOf(46));
            } else if (occurance == 0) {
                fileName = fileName + "." + backupFile.getBackupId().toString();
            }
            File file = new File(chunkFilePath + "/" + fileNameExcludeId);
            if (!file.exists() && ArrayUtils.isNotEmpty((Object[])(files = (dir = new File(chunkFilePath)).list((FilenameFilter)new PrefixFileFilter(fileNameExcludeId))))) {
                File fileDup = new File(chunkFilePath + "/" + (String)files[0]);
                if (!file.exists()) {
                    fileDup.renameTo(file);
                }
            }
            if (!file.exists()) {
                logger.debug("....file does not exist..... ");
                BackUpImage backUpImage = this.utilService.getBackupImageFile(1, fileInfo.getId(), device);
                if (!fileInfo.isRebackupFile() && backUpImage != null && "CLOUD".equals(backUpImage.getStoragePlace())) {
                    logger.debug(" File is already moved to cloud........ " + fileInfo.getId());
                    fileStatusElement.setUploadStatus(true);
                    fileStatusElement.setUploadStatuscode(555);
                    return fileStatusElement;
                }
            }
            logger.debug(md5 + ".....Cloud upload  FILE started after changed filename ..... " + fileName);
            long fileSize = file.length();
            logger.debug((storageInPG += fileSize / 1024L) + ".....uploadedFileSize before...." + fileStatusElement.getUploadedFileSize());
            logger.debug(".....uploadedFileSize after...." + fileStatusElement.getUploadedFileSize());
            if (!fileInfo.isRebackupFile()) {
                ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5(1, md5, dedupVal, userName, true, false);
                if (chunkDetail == null) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5(1, md5, dedupVal, userName, true, true);
                }
                if (chunkDetail != null && !fileInfo.isFullBackup()) {
                    logger.debug("Chunk alreadyexists............");
                    File cFile = new File(chunkFilePath + "/" + fileNameExcludeId);
                    long fileSize1 = cFile.length();
                    com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                    chunkFile.setFileName(fileName);
                    chunkFile.setMd5(md5);
                    chunkFile.setfSPath(chunkFile.getCloudStoragePath());
                    chunkFile.setFileId(fileName);
                    chunkFile.setSize(Long.valueOf(fileSize1));
                    chunkFile.setUploadedTimeStamp(System.currentTimeMillis());
                    chunkFile.setCloudStoragePath(chunkFile.getCloudStoragePath());
                    backupFile.getChunkFiles().add(chunkFile);
                    fileStatusElement.setUploadStatus(true);
                    uploadedFiles.put(chunkNameInFileInfo.replaceAll("\\.", "_"), chunkFile);
                }
                if (chunkDetail != null && !fileInfo.isFullBackup()) {
                    this.updateRefChunks(userName, cloud, dedupVal, md5, chunkDetail);
                    logger.debug(" chunkDetail already exists.... ");
                    this.updateUploadedChunks(cloud.getCloudName(), uploadedFiles, fileInfo);
                    continue;
                }
            }
            if (!file.exists()) {
                logger.error("File not present in the local mnt");
                File mntPath = new File(PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName));
                boolean isMountPointAvailable = false;
                try {
                    if (mntPath.exists()) {
                        isMountPointAvailable = true;
                    }
                }
                catch (Exception e) {
                    logger.error(".......unable to check mount point..... ");
                }
                if (!isMountPointAvailable) {
                    logger.error(".../parablu unmounted..............");
                    fileStatusElement.setUploadStatus(false);
                    return fileStatusElement;
                }
                if (PCHelperConstant.getPropertyFileValueDeleteBkptblWhenChunksNotFound()) {
                    logger.debug("....file does not exist..... ");
                    BackUpImage backUpImage = this.utilService.getBackupImageFile(1, fileInfo.getId(), device);
                    if (!fileInfo.isRebackupFile() && backUpImage != null && !"CLOUD".equals(backUpImage.getStoragePlace())) {
                        long filesizeInKB = backUpImage.getSize();
                        logger.debug(fileStatusElement.getUploadStatuscode() + "...DELETE...... " + filesizeInKB + "...." + fileInfo.getUserName());
                        OneDriveUtil.getInstance().updateBkpOverviewForDeletedFiles(cloud.getCloudId(), device.getDeviceUUID(), filesizeInKB);
                        this.deleteFilesAndDbEntries(cloudName, userName, fileInfo, device);
                    }
                }
                fileStatusElement.setUploadStatuscode(556);
                fileStatusElement.setUploadStatus(true);
                return fileStatusElement;
            }
            logger.debug("Cloud upload  file.length() started.... " + file.length());
            logger.debug("uploadAllChunksToCloud inside fileInfo.getServerBackupJobId()  ..... " + fileInfo.getServerBackupJobId());
            cloud = this.utilService.getCloud(cloud.getCloudId());
            fileStatusElement = this.checkNThrottleAndUploadChunkFileToCloud(cloudName, userName, fileInfo, gatewayName, backupFile, fileName, file, fileSize, cloud, rateLimiter, dedupVal, chunkNameInFileInfo, uploadedFiles);
            if (fileStatusElement.isUploadStatus() && !fileStatusElement.isChunkAlreadyExist()) {
                logger.debug("..........................Cloud size before..........." + storageInCloud);
                logger.debug("..........................Cloud size after..........." + (storageInCloud += file.length() / 1024L));
                this.updateCloudStorageConsumed(fileInfo, file.length());
            }
            if (fileStatusElement.isUploadStatus()) continue;
            logger.error("file upload to cloud exception so return false");
            return fileStatusElement;
        }
        if (fileStatusElement.isUploadStatus()) {
            File file;
            logger.debug("File uploaded successfully in blob.withut........" + backupFile.getBackupId().toString());
            if (!StringUtils.isEmpty((String)largeFilePath) && (file = new File(largeFilePath)).exists()) {
                file.delete();
            }
        }
        fileStatusElement.setUploadedFileSize(storageInCloud);
        fileStatusElement.setPgFileSize(storageInPG);
        return fileStatusElement;
    }

    private void updateRefChunks(String userName, Cloud cloud, String dedupVal, String md5, ChunkDetail chunkDetail) {
        try {
            int refCount = chunkDetail.getRefCount() + 1;
            chunkDetail.setRefCount(refCount);
            this.externalStorageBackupFileDao.saveChunkDetail(cloud.getCloudId(), chunkDetail);
            logger.debug(refCount + " Chunk updated succcessfully  .........." + chunkDetail.getCloudChunkName());
        }
        catch (OptimisticLockingFailureException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while updating ref chunks :" + (Object)((Object)e));
            int maxTries = 5;
            int count = 0;
            while (true) {
                try {
                    Thread.sleep(2000L);
                    logger.debug(" retry chunk update ..............." + md5);
                    ChunkDetail chunkDetailObj = this.externalStorageBackupFileDao.getChunkDetailForMd5(1, md5, dedupVal, userName, true, false);
                    if (chunkDetailObj == null) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetailObj = this.externalStorageBackupFileDao.getChunkDetailForMd5(1, md5, dedupVal, userName, true, true);
                    }
                    int refCount = chunkDetailObj.getRefCount() + 1;
                    chunkDetailObj.setRefCount(refCount);
                    this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
                }
                catch (Exception ex) {
                    logger.trace("" + ex);
                    logger.error(" ex ..." + ex.getMessage());
                    if (++count != maxTries) continue;
                }
                break;
            }
        }
    }

    private void deleteFilesAndDbEntries(String cloudName, String userName, FileInfo fileInfo, Device device) {
        try {
            this.utilService.deleteBackupFiles(1, cloudName, userName, fileInfo.getId(), fileInfo.getDedupBackupId(), device);
        }
        catch (Exception e) {
            logger.debug("Exception :" + e);
            logger.error("Exception :" + e.getMessage());
        }
    }

    private String mergeAllChunksAndCreateSingleFile(FileInfo fileInfo, String chunkFilePath, String cloudName) {
        logger.debug("inside merge into a single file............");
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        String destinationPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "merge" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        com.pg.util.FileUtils.merge((List)fileInfo.getChunkFiles(), (String)chunkFilePath, (String)destinationPath);
        return destinationPath;
    }

    private FileStatusElement checkNThrottleAndUploadChunkFileToCloud(String cloudName, String userName, FileInfo fileInfo, String gatewayName, BackupFile backupFile, String fileName, File file, long fileSize, Cloud cloud, RateLimiter rateLimiter, String dedupType, String chunkName, Map<String, com.pg.domain.ChunkFile> uploadedFiles) {
        FileStatusElement fileStatusElement = new FileStatusElement();
        try {
            fileStatusElement = this.uploadFileToCloud(cloudName, userName, file, fileInfo.getDeviceUUID(), backupFile, gatewayName, false, fileName, cloud, fileInfo.getBatchId(), rateLimiter, dedupType, fileInfo.isFullBackup(), fileInfo.isRebackupFile(), fileInfo.getGatewayName(), chunkName, uploadedFiles, fileInfo);
            logger.debug("......................" + fileStatusElement.isChunkAlreadyExist());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Checking Throttle and Uploading Chunk File to Cloud :" + e.getMessage());
            logger.debug(" UNABLE TO UPLOAD FILES ..... " + file.getName());
        }
        return fileStatusElement;
    }

    private FileStatusElement uploadFileToCloud(String cloudName, String userName, File file, String deviceUUID, BackupFile fileInfo, String gatewayName, boolean nonChunkable, String fileName, Cloud cloud, String batchId, RateLimiter rateLimiter, String dedupType, boolean isFullBackup, boolean isRebackupFile, String gateWayName, String chunkName, Map<String, com.pg.domain.ChunkFile> uploadedFiles, FileInfo loclalFileInfo) throws BaseException {
        File encryptedFile;
        String pathname = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/upload/" + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        if (!StringUtils.isEmpty((String)batchId)) {
            pathname = pathname + batchId + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        }
        this.createFolders(pathname);
        String encryptedFileName = fileName;
        if (!StringUtils.isEmpty((String)PCHelperConstant.getPropertyFileValueEncryptionEnabled()) && "true".equals(PCHelperConstant.getPropertyFileValueEncryptionEnabled())) {
            encryptedFile = new File(pathname + "encrypted/" + encryptedFileName);
            String saltKey = this.utilService.getEncryptionKey(1, BACKUP);
            encryptedFile = this.fileEncryptionService.encrypt(saltKey, userName, file, encryptedFile);
            logger.debug("after Encryption........^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        } else {
            encryptedFile = file;
            logger.debug("fileName...." + encryptedFile.getName());
        }
        long fileSize = 0L;
        if (encryptedFile.exists()) {
            fileSize = encryptedFile.length() / 1024L;
            logger.debug(".........Encrypted file size........." + fileSize);
        }
        String containerName = this.checkPreConditionForCreateContainer(userName, cloud);
        logger.debug(" Calling cloudsupportservice .........." + containerName);
        String lastStoragePathForSameFile = "";
        lastStoragePathForSameFile = this.getLastStoragePath(fileInfo, lastStoragePathForSameFile);
        String fileMd5 = "";
        long fileLength = 0L;
        if (file.exists()) {
            fileMd5 = MD5Generator.generateMD5OfFile((File)file);
            fileLength = file.length();
        }
        FileStatusElement fileStatusElement = this.cloudSupportService.uploadToCloud(cloud, containerName, encryptedFile, userName, false, lastStoragePathForSameFile, rateLimiter, fileInfo, gatewayName);
        logger.debug(" end of uploading using  cloudsupportservice .........." + fileStatusElement.isUploadStatus());
        if (fileStatusElement.isUploadStatus()) {
            try {
                String unwantedChar;
                logger.debug(fileInfo.getId() + ">>>>>>>>>>>>>>>> BEFORE ...." + encryptedFileName);
                String encodedNameInCloud = this.convertStringTOBase64(this.removeIdFromChunkName(fileInfo.getId(), encryptedFile)).replaceAll("/", "_");
                String encodedFileName = this.convertStringTOBase64(encryptedFile.getName()).replaceAll("/", "_");
                logger.debug(">>>>>>>>>>>>>>> Before .... " + encryptedFileName);
                if (encryptedFileName.contains("_") && encryptedFileName.contains(".") && !StringUtils.isEmpty((String)(unwantedChar = encryptedFileName.substring(encryptedFileName.lastIndexOf("_"), encryptedFileName.lastIndexOf("."))))) {
                    encryptedFileName = encryptedFileName.replace(unwantedChar, "");
                }
                logger.debug(">>>>>>>>>>>>>>> After .... " + encryptedFileName);
                com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                chunkFile.setFileName(encryptedFileName);
                chunkFile.setEncodedName(encodedNameInCloud);
                chunkFile.setfSPath(encodedFileName);
                chunkFile.setFileId(fileStatusElement.getFileId());
                chunkFile.setGatewayName(gateWayName);
                if (fileStatusElement.isUploadStatus()) {
                    chunkFile.setMd5(fileMd5);
                    chunkFile.setSize(Long.valueOf(fileLength));
                }
                chunkFile.setUploadedTimeStamp(System.currentTimeMillis());
                chunkFile.setCloudStoragePath(fileStatusElement.getCloudStoragePath());
                ChunkFile chunkFileRef = new ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)chunkFileRef);
                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                if (isGDEnabled) {
                    chunkFileRef.setFileName(fileStatusElement.getFileId());
                }
                boolean isJobRunning = true;
                if (MemoryStore.get((String)IS_JOB_RUNNING) != null) {
                    isJobRunning = (Boolean)MemoryStore.get((String)IS_JOB_RUNNING);
                }
                logger.debug("........Is job running........." + isJobRunning);
                if (isJobRunning) {
                    this.updateRefChunks(chunkFileRef, fileInfo.getId(), this.externalStorageBackupFileDao, containerName, dedupType, userName, isFullBackup, isRebackupFile, deviceUUID, cloud, fileSize, gateWayName);
                    uploadedFiles.put(chunkName.replaceAll("\\.", "_"), chunkFile);
                    logger.debug("........updateRefChunks.....is completed ....");
                    long sizeInCloud = loclalFileInfo.getStorageUtilizedInCloud();
                    if (fileStatusElement.isChunkAlreadyExist()) {
                        fileSize = 0L;
                    }
                    this.updateUploadedChunksAndSize(cloud, uploadedFiles, loclalFileInfo, deviceUUID, fileSize);
                    logger.debug("........updateUploadedChunksAndSize is completed.........");
                    fileInfo.getChunkFiles().add(chunkFile);
                    loclalFileInfo.setStorageUtilizedInCloud(sizeInCloud += fileSize);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(" JSON EXEPTION " + e);
                fileStatusElement.setUploadStatus(false);
            }
        } else if (!CollectionUtils.isEmpty((Collection)fileInfo.getChunkFiles())) {
            for (com.pg.domain.ChunkFile chunk : fileInfo.getChunkFiles()) {
                ChunkFile chunkFileRef = new ChunkFile();
                BeanUtils.copyProperties((Object)chunk, (Object)chunkFileRef);
                this.updateChunksRefForFailedChunks(chunkFileRef, this.externalStorageBackupFileDao, containerName, dedupType, userName, isFullBackup, isRebackupFile, deviceUUID);
            }
        }
        if (encryptedFile.exists()) {
            logger.debug(encryptedFile.getName() + " Delete encryptedFile using delete method  ........  " + encryptedFile.getPath());
            encryptedFile.delete();
        }
        return fileStatusElement;
    }

    private String removeIdFromChunkName(String bkpFileId, File encryptedFile) {
        String encryptedFileName = encryptedFile.getName();
        try {
            logger.debug(encryptedFileName + ">>>>>>>>>>>>>>> BEFORE...." + encryptedFileName);
            if (encryptedFileName.contains("." + bkpFileId)) {
                encryptedFileName = encryptedFileName.replaceAll("." + bkpFileId, "");
            }
            logger.debug(encryptedFileName);
            if (encryptedFileName.contains("_")) {
                encryptedFileName = encryptedFileName.substring(0, encryptedFileName.indexOf("_"));
            }
        }
        catch (Exception e) {
            logger.error("error in Encoding the chunk name " + encryptedFileName + e.getMessage());
            logger.trace("" + e);
        }
        return encryptedFileName;
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private boolean isGDEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isGDEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"Google Drive Enabled".equalsIgnoreCase(license.getName())) continue;
            isGDEnabled = true;
            break;
        }
        return isGDEnabled;
    }

    private String getDedupValue(BackupPolicy backupPolicy) {
        String dedupVal = null;
        if (backupPolicy != null) {
            dedupVal = backupPolicy.getDedup();
        }
        return dedupVal;
    }

    private String checkPreConditionForCreateContainer(String userName, Cloud cloud) {
        String userNameTemp = userName;
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)userNameTemp)) {
            boolean isLocalStorageEnabled;
            if (userNameTemp.length() < 3) {
                userNameTemp = userNameTemp + "-parablu";
            }
            if (isLocalStorageEnabled = this.isLocalStorageEnabled(cloud)) {
                userNameTemp = userNameTemp.replaceAll("[^A-Za-z0-9,]", "-");
                userNameTemp = userNameTemp.replaceAll(" ", "-");
            } else {
                userNameTemp = userNameTemp.replaceAll(" ", "-");
                userNameTemp = userNameTemp.replace(".", "-46");
                userNameTemp = userNameTemp.replace("@", "-64");
                userNameTemp = userNameTemp.replace("_", "-95");
            }
            sb.append(userNameTemp);
            return sb.toString();
        }
        return userNameTemp;
    }

    private boolean isLocalStorageEnabled(Cloud cloud) {
        boolean isLocalStorageEnabled = false;
        for (CloudCredentials cc : cloud.getCloudCredentials()) {
            if (cc == null || !"localStorage".equalsIgnoreCase(cc.getCloudName())) continue;
            isLocalStorageEnabled = true;
            break;
        }
        return isLocalStorageEnabled;
    }

    private String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5((String)name);
            byte[] bytesEncoded = Base64.encodeBase64((byte[])bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            logger.debug("encoded value for given file is " + base64EncodeString);
        }
        return base64EncodeString;
    }

    public void createFolders(String pathname) {
        File chunkDir;
        File encryptedDir = new File(pathname + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "encrypted");
        if (!encryptedDir.exists()) {
            encryptedDir.mkdir();
        }
        if (!(chunkDir = new File(pathname + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "chunk")).exists()) {
            chunkDir.mkdir();
        }
    }

    private String getLastStoragePath(BackupFile fileInfo, String lastStoragePathForSameFile) {
        List files = fileInfo.getChunkFiles();
        String lastStoragePathForSameFileTemp = lastStoragePathForSameFile;
        if (!CollectionUtils.isEmpty((Collection)files)) {
            Collections.sort(files, new Comparator<com.pg.domain.ChunkFile>(){

                @Override
                public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                    long t1 = c1.getUploadedTimeStamp();
                    long t2 = c2.getUploadedTimeStamp();
                    if (t2 > t1) {
                        return 1;
                    }
                    if (t1 > t2) {
                        return -1;
                    }
                    return 0;
                }
            });
            com.pg.domain.ChunkFile chunkFile = (com.pg.domain.ChunkFile)files.get(0);
            lastStoragePathForSameFileTemp = chunkFile.getCloudStoragePath();
        }
        return lastStoragePathForSameFileTemp;
    }

    @Override
    public FileInfo getFileFromPG(String userName, String cloudName, String id, boolean sync) {
        return this.fileDao.getFileFromPG(userName, cloudName, id, sync);
    }

    private static String getMd5FromFileName(String fileName, int occurance) {
        String md5 = "";
        if (occurance == 1 && !fileName.startsWith("part")) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance == 1 && fileName.startsWith("part")) {
            md5 = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else if (occurance == 0) {
            md5 = fileName;
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        if (StringUtils.isNotEmpty((String)md5) && md5.contains("_")) {
            md5 = md5.substring(0, md5.lastIndexOf("_"));
        }
        return md5;
    }

    private void updateCloudStorageConsumed(FileInfo fileInfo, long fileSize) {
        logger.debug("updateCloudStorageConsumed > fileSize > " + fileSize);
        if (!StringUtils.isEmpty((String)fileInfo.getServerBackupJobId())) {
            ObjectId jobObjId = new ObjectId(fileInfo.getServerBackupJobId());
            DeviceBackupJob dbj = this.utilDao.getDeviceBackupJob(1, fileInfo.getDeviceUUID(), jobObjId);
            dbj.setBackupSizeOnCloudInBytes(dbj.getBackupSizeOnCloudInBytes() + fileSize);
            this.utilDao.registerJob(dbj, 1);
            logger.debug("updateCloudStorageConsumed > fileSize > dbj.getBackupSizeOnCloudInKB() > UPDATED > " + dbj.getBackupSizeOnCloudInBytes());
        }
    }

    private void deleteFileFromMnt(File file) {
        try {
            if (file.exists()) {
                FileUtils.forceDelete((File)file);
            }
        }
        catch (IOException e) {
            logger.error("error in deleting file" + e.getMessage());
            logger.trace("" + e);
        }
    }

    @Override
    public void updateFileInfo(String cloudName, String gatewayName, FileInfo fileInfo) {
        this.fileDao.updateFileInfo(cloudName, gatewayName, fileInfo);
    }

    @Override
    public void moveFailedFilesToBkpQueue(String cloudName, FileInfo fileInfo) {
        this.fileDao.moveFailedFilesToBkpQueue(fileInfo, cloudName);
    }

    @Override
    public boolean deleteFileInfoFromReBackup(String cloudName, ObjectId backupId) {
        return this.backupFileDao.deleteBackupFileForIDFromReBackup(1, backupId);
    }

    @Override
    public boolean restoreQueue(FileInfo fileInfo, Cloud cloud) {
        return this.fileDao.restoreQueue(fileInfo, cloud);
    }

    @Override
    public List<FileInfo> getFilesForUpload(String cloudName) {
        return this.fileDao.getFilesForUpload(cloudName);
    }

    @Override
    public void updateUploadedChunks(String cloudName, Map<String, com.pg.domain.ChunkFile> uploadedFiles, FileInfo fileInfo) {
        logger.debug("Saving updateUploadedChunks in " + fileInfo.getId() + "....size is..." + uploadedFiles.size());
        this.fileDao.updateUploadedChunks(cloudName, uploadedFiles, fileInfo);
    }

    @Override
    public List<FileInfo> getFaileFilesForReUpload(String cloudName) {
        return this.fileDao.getFaileFilesForReUpload(cloudName);
    }

    @Override
    public boolean restoreFailedFiles(FileInfo fileInfo, Cloud cloud) {
        return this.fileDao.restoreFailedFiles(fileInfo, cloud);
    }

    @Override
    public boolean restoreSyncFailedFiles(FileInfo fileInfo, Cloud cloud) {
        return this.fileDao.restoreFailedFiles(fileInfo, cloud);
    }

    public void updateUploadedChunksAndSize(Cloud cloud, Map<String, com.pg.domain.ChunkFile> uploadedFiles, FileInfo fileInfo, String deviceUUID, Long sizeInCloud) {
        logger.debug("Inside ....updateUploadedChunksAndSize ");
        this.fileDao.updateUploadedChunksAndSize(cloud, sizeInCloud, fileInfo, uploadedFiles);
    }

    @Override
    public void removeSyncFile(int cloudId, String syncrevisionId, String consolidatedImageId) {
        this.fileDao.removeSyncFile(cloudId, syncrevisionId, consolidatedImageId);
    }

    @Override
    public void removeBackupFile(int cloudId, String backupId, String destCollection) {
        this.fileDao.removeBackupFile(cloudId, backupId, destCollection);
    }

    @Override
    public void saveFileInfoForODB(String cloudName, String userName, FileInfo fileInfo, String driveFileInfoId) {
        this.fileDao.saveFileInfoForODB(cloudName, userName, fileInfo, driveFileInfoId);
    }

    @Override
    public void removeFileInfoForAlreadyExists(String driveFileInfoId) {
        this.fileDao.removeFileInfoForAlreadyExists(driveFileInfoId);
    }

    @Override
    public void removeBackupFromTempDb(Cloud cloud, ObjectId backupId) {
        this.utilService.removeBackupFromTempDb(cloud, backupId, true);
        logger.debug("after removeBackupFromTempDb....." + backupId);
    }

    @Override
    public BackUpImage getBkpFileByIdAndDevice(int cloudId, ObjectId backupId, Device device) {
        return this.backupFileDao.getBkpFileByIdAndDevice(cloudId, backupId, device);
    }

    @Override
    public void saveImageToBackUp(int cloudId, BackUpImage backUpImage, Device device) {
        this.backupFileDao.saveImageToBackUp(cloudId, backUpImage, device);
    }

    @Override
    public StringBuilder checkOdbFolders(Cloud cloud, StringBuilder result) throws ClientProtocolException, IOException {
        List usersList = this.utilDao.getAllUsers(cloud.getCloudId(), cloud.getCloudName());
        for (User user : usersList) {
            if (user == null) continue;
            String emailId = user.getEmailId();
            if (StringUtils.isNotEmpty((String)user.getOdbLoginId())) {
                emailId = user.getOdbLoginId();
            }
            HashMap<String, Long> foldersMap = new HashMap<String, Long>();
            this.cloudSupportService.checkOdbFolders(cloud, user.getUserName(), emailId, foldersMap, result);
        }
        return result;
    }
}

