/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.domain.EncryptionKey;
import com.pg.dao.BackupFileDao;
import com.pg.dao.FileDao;
import com.pg.dao.Office365Dao;
import com.pg.dao.UtilDao;
import com.pg.domain.ChunkFile;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.Office365DownloadService;
import com.pg.service.UtilService;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Office365DownloadServiceImpl
implements Office365DownloadService {
    private static Logger logger = LoggerFactory.getLogger(Office365DownloadServiceImpl.class);
    private static final int BUFFER_CHUNK_SIZE = 1024;
    @Autowired
    private BackupFileDao backupFileDao;
    @Autowired
    private FileDao fileDao;
    @Autowired
    private BackUpImageDao backUpImageDao;
    @Autowired
    private UtilService utilService;
    @Autowired
    private Office365Dao office365Dao;
    @Autowired
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private UtilDao utilDao;
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private FileEncryptionService fileEncryptionService;
    private static final String BEARER = "Bearer ";

    public void setBackupFileDao(BackupFileDao backupFileDao) {
        this.backupFileDao = backupFileDao;
    }

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setOffice365Dao(Office365Dao office365Dao) {
        this.office365Dao = office365Dao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
        this.fileEncryptionService = fileEncryptionService;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public String getKeyForDecrypt(int cloudId, long timeStamp) {
        EncryptionKey encryptionKey = this.utilDao.getKeyForDecrypt(cloudId, timeStamp, "");
        String encryptionKeyVal = "";
        if (encryptionKey != null) {
            encryptionKeyVal = encryptionKey.getSaltKey();
            logger.debug("Recieved salt key  for file ..... " + encryptionKeyVal);
        }
        return encryptionKeyVal;
    }

    @Override
    public BufferedInputStream downloadFileFromOneDrive(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID) {
        String fileNameTemp = fileName;
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String pbFolderName = this.office365Dao.getOdbFolderName(1);
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        }
        String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
        logger.debug(chunkFile.getFileName() + " ............new path................." + downloadurl);
        BufferedInputStream bufferedInputStream = null;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        HttpGet httpGet = new HttpGet(downloadurl);
        httpGet.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
            httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
            logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
        }
        HttpResponse result = null;
        try {
            if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                logger.debug(" without proxy ....");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                logger.debug(" using proxy ....");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(host, port);
                RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                httpGet.setConfig(config);
                result = httpclient.execute((HttpUriRequest)httpGet);
            }
            String userName = authorizationTokenElementTemp.getUserName();
            int responseCode = result.getStatusLine().getStatusCode();
            logger.debug("Retry Response status code: " + responseCode);
            if (responseCode == 200) {
                InputStream inputStream = result.getEntity().getContent();
                result.getEntity().getContentLength();
                bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                logger.debug(userName + "download url : " + downloadurl);
            } else if (responseCode == 401) {
                if ((authorizationTokenElementTemp = this.office365Dao.getAccessToken(authorizationTokenElementTemp)) != null) {
                    if (authorizationTokenElement.isServiceAcct()) {
                        authorizationTokenElementTemp.setServiceAcct(true);
                        this.office365Dao.updatePciAuthorizationTokensForServiceAcct(1, authorizationTokenElementTemp.getAccessToken(), authorizationTokenElementTemp.getRefreshToken());
                    } else {
                        this.utilService.updatePciAuthorizationToken(authorizationTokenElementTemp, userName);
                    }
                    bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID);
                }
            } else {
                bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Downloading File From One Drive :" + e.getMessage());
            bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID);
        }
        return bufferedInputStream;
    }

    public BufferedInputStream retryDownloadFileFromOneDrive(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID) {
        boolean retry;
        logger.debug("Retrying file download form ODB");
        String pbFolderName = this.office365Dao.getOdbFolderName(1);
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        }
        String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        BufferedInputStream bufferedInputStream = null;
        String originalPath = chunkFile.getCloudStoragePath();
        boolean incrementPath = false;
        boolean decrementPath = false;
        boolean newPathCheck = false;
        boolean newRetryPathCheck = false;
        boolean oldStylePath = false;
        boolean customOldStylePath = false;
        boolean increOldStylePath = false;
        boolean decreOldStylePath = false;
        boolean newPathCheckOnly = false;
        int newRetryPath = 1;
        int retryCount = 0;
        int maxRetryCount = 8;
        int sleepMultiplier = 1;
        long sleepTime = 5000L * (long)sleepMultiplier;
        do {
            retry = false;
            HttpGet httpGet = null;
            String modifiedPath = chunkFile.getCloudStoragePath();
            try {
                String cloudPath;
                HttpResponse result;
                logger.debug(downloadurl + "......download path........." + retryCount);
                httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
                httpGet.addHeader("Accept", "application/json;odata=verbose");
                httpGet.addHeader("Content-Type", "*/*");
                if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                    httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                    logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
                }
                if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                    logger.debug(" without proxy ...");
                    HttpClient httpclient = HttpClientUtil.getSSlConnection();
                    result = httpclient.execute((HttpUriRequest)httpGet);
                } else {
                    logger.debug(" using proxy ...");
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                    CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                    HttpHost proxy = new HttpHost(host, port);
                    RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                    httpGet.setConfig(config);
                    result = httpclient.execute((HttpUriRequest)httpGet);
                }
                int responseCode = result.getStatusLine().getStatusCode();
                logger.debug("Retry Response status code: " + responseCode);
                if (responseCode == 200) {
                    InputStream inputStream = result.getEntity().getContent();
                    bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                    logger.debug(originalPath + "...Retry download url : " + downloadurl);
                    if (originalPath.equals(modifiedPath)) continue;
                    logger.debug("....path modified......");
                    continue;
                }
                if (responseCode == 401) {
                    retry = true;
                    ++retryCount;
                    sleepTime = this.sleepForGivenTime(sleepTime);
                    authorizationTokenElementTemp = this.office365Dao.getAccessToken(authorizationTokenElementTemp);
                    continue;
                }
                if (responseCode == 200) continue;
                retry = true;
                sleepTime = responseCode != 404 ? this.sleepForGivenTime(sleepTime) : 0L;
                logger.debug("..retry attempt for response code ...." + responseCode + "...." + ++retryCount + "....." + authorizationTokenElementTemp.getEmailId());
                logger.debug("..retry url ...." + downloadurl);
                if (responseCode != 404) continue;
                if (!increOldStylePath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    modifiedPath = cloudPath;
                    logger.debug("...increOldStylePath..." + modifiedPath);
                    increOldStylePath = true;
                    continue;
                }
                if (!newPathCheckOnly && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    cloudPath = "" + PCHelperConstant.getRetryOdbFolderValue();
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    newPathCheckOnly = true;
                    modifiedPath = cloudPath;
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!newPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    newPathCheck = true;
                    modifiedPath = cloudPath;
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!newRetryPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    logger.debug("...Inside new logic...");
                    int retryPath = PCHelperConstant.getRetryOdbFolderValue() + newRetryPath;
                    String cloudPath2 = "" + retryPath;
                    logger.debug("...retryPath..." + retryPath);
                    logger.debug("...downloadurl..." + downloadurl);
                    String folderExistsPath = PCHelperConstant.getParabluLibraryUrlForFolderCheck((String)authorizationTokenElementTemp.getSharePointUrl(), (String)authorizationTokenElementTemp.getAccountId(), (String)("PB/" + userNameInPath + "/" + retryPath));
                    boolean isFolderExists = this.office365Dao.isFolderExists(folderExistsPath, authorizationTokenElementTemp.getAccessToken());
                    logger.debug(isFolderExists + "...isFolderExists..." + folderExistsPath);
                    if (isFolderExists) {
                        downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath2, (String)pbFolderName);
                        modifiedPath = cloudPath2;
                        ++newRetryPath;
                        ++maxRetryCount;
                    } else {
                        newRetryPathCheck = true;
                        logger.debug("...Folder not exists....");
                    }
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!decrementPath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    decrementPath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...decre new path..." + modifiedPath);
                    continue;
                }
                if (!incrementPath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    modifiedPath = cloudPath;
                    logger.debug("...incre new path..." + modifiedPath);
                    incrementPath = true;
                    continue;
                }
                if (!oldStylePath) {
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
                    oldStylePath = true;
                    logger.debug("...oldStylePath restore ...");
                    continue;
                }
                if (!customOldStylePath && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    customOldStylePath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...customOldStylePath retryodbValue ..." + modifiedPath);
                    continue;
                }
                if (decreOldStylePath) continue;
                cloudPath = chunkFile.getCloudStoragePath();
                if (StringUtils.isNotEmpty((String)cloudPath)) {
                    int path = Integer.parseInt(cloudPath);
                    cloudPath = "" + (path - 1);
                }
                downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                decreOldStylePath = true;
                modifiedPath = cloudPath;
                logger.debug("...decreOldStylePath..." + modifiedPath);
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                sleepTime = this.sleepForGivenTime(sleepTime);
                logger.trace("" + e);
                logger.error("Exception While Retying Download File From One Drive :" + e.getMessage());
            }
        } while (retry && retryCount < maxRetryCount);
        return bufferedInputStream;
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString((String)deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    private long sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            logger.debug("SleepTime is" + sleepTimeTemp);
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException e1) {
            logger.error("Thread interupted error");
        }
        return sleepTimeTemp;
    }
}

