/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.ParentReference;
import com.pg.dao.Office365Dao;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.GoogleDriveService;
import com.pg.service.UtilService;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.activation.MimetypesFileTypeMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GoogleDriveServiceImpl
implements GoogleDriveService {
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static Logger logger = LoggerFactory.getLogger(GoogleDriveServiceImpl.class);
    private static final int BUFFER_CHUNK_SIZE = 1024;
    private Office365Dao office365Dao;
    @Autowired
    private UtilService utilService;
    private static final String FOLDER_CREATION_FALSE_REFRESH_TOKEN = "Success for creating folder is false so refresh the token";
    private static final String PARACLOUD_CLOUD_PATH = "/paracloud/cloud/";

    public void setOffice365Dao(Office365Dao office365Dao) {
        this.office365Dao = office365Dao;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    private static Drive getDrive(String refreshToken, String clientId, String clientSecret) {
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        GoogleCredential credential = new GoogleCredential.Builder().setJsonFactory((JsonFactory)jsonFactory).setTransport((HttpTransport)httpTransport).setClientSecrets(clientId, clientSecret).build();
        credential.setRefreshToken(refreshToken);
        return new Drive.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).build();
    }

    @Override
    public String uploadFileToGD(String accessToken, PciAuthorizationTokenElement pciTokenElement, File encryptedFile, String cloudStoragePath) {
        String encodedFileName = "";
        PciAuthorizationTokenElement pciTokenElementTemp = pciTokenElement;
        String userName = pciTokenElementTemp.getUserName();
        if (!StringUtils.isEmpty((String)accessToken)) {
            String pbFolderName = this.office365Dao.getOdbFolderName(1);
            if (StringUtils.isEmpty((String)pbFolderName)) {
                pbFolderName = "PB";
            }
            Drive drive = GoogleDriveServiceImpl.getDrive(pciTokenElementTemp.getAccessToken(), pciTokenElementTemp.getClientId(), pciTokenElementTemp.getClientSecret());
            String parabluFolderId = GoogleDriveServiceImpl.getOrCreateParaBluFolder(drive, pbFolderName);
            logger.debug(" **Parablu folder created *** " + parabluFolderId);
            if (StringUtils.isEmpty((String)parabluFolderId)) {
                logger.debug(FOLDER_CREATION_FALSE_REFRESH_TOKEN);
                pciTokenElementTemp = GoogleDriveServiceImpl.getGoogleDriveAccessToken(pciTokenElementTemp);
                logger.debug("token.... " + pciTokenElementTemp);
                if (pciTokenElementTemp != null) {
                    logger.debug(pciTokenElementTemp.getCloudName() + ".....before update...." + userName);
                    this.utilService.updatePciAuthorizationToken(pciTokenElementTemp, userName);
                    logger.debug("after update....");
                    drive = GoogleDriveServiceImpl.getDrive(pciTokenElementTemp.getAccessToken(), pciTokenElementTemp.getClientId(), pciTokenElementTemp.getClientSecret());
                    logger.debug("after update. getDrive...");
                    parabluFolderId = GoogleDriveServiceImpl.getOrCreateParaBluFolder(drive, pbFolderName);
                    logger.debug(" **Parablu folder created after refresh token *** " + parabluFolderId);
                }
            }
            if (pciTokenElementTemp != null && !StringUtils.isEmpty((String)parabluFolderId)) {
                encodedFileName = GoogleDriveServiceImpl.uploadFileToGoogleDrive(encryptedFile, drive, parabluFolderId);
            }
        }
        return encodedFileName;
    }

    private static String uploadFileToGoogleDrive(File encryptedFile, Drive drive, String folderId) {
        String fileId = "";
        try {
            String mimetype = new MimetypesFileTypeMap().getContentType(encryptedFile);
            com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
            fileMetadata.setParents(Arrays.asList(new ParentReference().setId(folderId)));
            fileMetadata.setTitle(encryptedFile.getName());
            FileContent mediaContent = new FileContent(mimetype, encryptedFile);
            Drive.Files.Insert insert = drive.files().insert(fileMetadata, (AbstractInputStreamContent)mediaContent);
            MediaHttpUploader uploader = insert.getMediaHttpUploader();
            uploader.setDirectUploadEnabled(true);
            com.google.api.services.drive.model.File uploadedFile = (com.google.api.services.drive.model.File)insert.execute();
            logger.debug(uploadedFile.getId() + " @@@@@@@@@  uploadFile   ...." + uploadedFile.getTitle());
            fileId = uploadedFile.getId();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" error uploadFileToGoogleDrive ... " + e.getMessage());
        }
        return fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deleteEntryForBackup(String backupId, String cloudName, String userName, String dedupedBkId) {
        logger.debug("Delete entry for backup ..... ");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD_PATH + cloudName + "/externalbackup/" + userName + "/delete/";
        HttpPost httpPost = new HttpPost(url);
        try {
            Header[] headerarr;
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("backupId", (ContentBody)new StringBody(backupId));
            entity.addPart("dedupedBkId", (ContentBody)new StringBody(dedupedBkId));
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            for (Header header : headerarr = response.getAllHeaders()) {
                if (!"isFileDeleted".equals(header.getName())) continue;
                logger.debug("Deleted backup Id for file ..... " + header.getName());
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Deleting Entry For Backup :" + e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
            httpclient.getConnectionManager().closeIdleConnections(1L, TimeUnit.MICROSECONDS);
            httpclient.getConnectionManager().shutdown();
        }
        return backupId;
    }

    @Override
    public int getCountOfFilesInFolder(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath) {
        return 1;
    }

    private static String getOrCreateParaBluFolder(Drive drive, String pbFolderName) {
        String folderId = "";
        try {
            List files = ((FileList)drive.files().list().setQ("mimeType='application/vnd.google-apps.folder' and trashed=false").execute()).getItems();
            for (com.google.api.services.drive.model.File file : files) {
                if (!pbFolderName.equals(file.getTitle())) continue;
                folderId = file.getId();
                break;
            }
            if (StringUtils.isEmpty((String)folderId)) {
                com.google.api.services.drive.model.File file;
                com.google.api.services.drive.model.File body = new com.google.api.services.drive.model.File();
                body.setTitle(pbFolderName);
                body.setMimeType("application/vnd.google-apps.folder");
                file = (com.google.api.services.drive.model.File)drive.files().insert(body).execute();
                folderId = file.getId();
            }
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Error trying to get ParaBlu folder Id for Google Drive " + e.getMessage());
        }
        return folderId;
    }

    private static PciAuthorizationTokenElement getGoogleDriveAccessToken(PciAuthorizationTokenElement elementParam) {
        PciAuthorizationTokenElement element = elementParam;
        Client client = Client.create();
        WebResource webResource = client.resource("https://accounts.google.com/o/oauth2/token");
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"client_id", (Object)element.getClientId());
        queryParams.add((Object)"client_secret", (Object)element.getClientSecret());
        queryParams.add((Object)"refresh_token", (Object)element.getRefreshToken());
        queryParams.add((Object)"grant_type", (Object)"refresh_token");
        webResource.queryParams((MultivaluedMap)queryParams);
        webResource.accept(new String[]{APPLICATION_X_WWW_FORM_URLENCODED});
        webResource.type(APPLICATION_X_WWW_FORM_URLENCODED);
        String output = (String)((WebResource.Builder)webResource.type(APPLICATION_X_WWW_FORM_URLENCODED).accept(new String[]{"application/xml"})).post(String.class, (Object)queryParams);
        String accessToken = "";
        try {
            JSONObject json = new JSONObject(output);
            accessToken = json.get("access_token").toString();
        }
        catch (JSONException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(" ERROR fetching access token for Google drive account :" + e.getMessage());
        }
        element.setAccessToken(accessToken);
        return element;
    }

    @Override
    public BufferedInputStream downloadFileFromGD(PciAuthorizationTokenElement pciTokenElement, String fileNameToDownload, boolean isGDServiceAcctEnabled) {
        BufferedInputStream bufferedInputStream = null;
        com.google.api.services.drive.model.File serviceFile = null;
        try {
            logger.debug(pciTokenElement.getAccessToken() + " file to download .....gd latest..token.... " + fileNameToDownload + "....." + pciTokenElement.getUserName());
            String accessToken = pciTokenElement.getAccessToken();
            try {
                Drive drive = GoogleDriveServiceImpl.getDrive(pciTokenElement.getAccessToken(), pciTokenElement.getClientId(), pciTokenElement.getClientSecret());
                serviceFile = (com.google.api.services.drive.model.File)drive.files().get(fileNameToDownload).execute();
            }
            catch (Exception e) {
                logger.error("error trying to get file... so retry .... " + e.getMessage());
                logger.trace("" + e);
                PciAuthorizationTokenElement element = GoogleDriveServiceImpl.getGoogleDriveAccessToken(pciTokenElement);
                Drive drive = GoogleDriveServiceImpl.getDrive(element.getAccessToken(), pciTokenElement.getClientId(), pciTokenElement.getClientSecret());
                serviceFile = (com.google.api.services.drive.model.File)drive.files().get(fileNameToDownload).execute();
                accessToken = element.getAccessToken();
                if (isGDServiceAcctEnabled) {
                    this.utilService.updateServiceAcctPciAuthorizationToken(element);
                } else {
                    this.utilService.updatePciAuthorizationToken(element, element.getUserName());
                }
                logger.debug("..token updated successfully....");
            }
            HttpGet get = new HttpGet(serviceFile.getDownloadUrl());
            get.addHeader("Authorization", "Bearer " + accessToken);
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpResponse response = httpclient.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            InputStream inputStream = entity.getContent();
            bufferedInputStream = new BufferedInputStream(inputStream, 1024);
            return bufferedInputStream;
        }
        catch (Exception e) {
            logger.error(" Download File failed old token..... " + e.getMessage());
            logger.trace("" + e);
            return bufferedInputStream;
        }
    }

    @Override
    public boolean deleteFromGD(PciAuthorizationTokenElement pciTokenElement, String fileNameToDownload, boolean isGDServiceAcctEnabled) {
        boolean isDeleted = false;
        logger.debug(pciTokenElement.getAccessToken() + "... %%%%%%%file to delete... " + fileNameToDownload + "....." + pciTokenElement.getUserName());
        try {
            Drive drive = GoogleDriveServiceImpl.getDrive(pciTokenElement.getAccessToken(), pciTokenElement.getClientId(), pciTokenElement.getClientSecret());
            Drive.Files.Delete delete = drive.files().delete(fileNameToDownload);
            delete.execute();
            isDeleted = true;
            logger.debug("chunk successfully deleted............");
        }
        catch (GoogleJsonResponseException e) {
            logger.debug("error trying to get file... so retry .... " + e.getStatusCode() + "...");
            if (e.getStatusCode() == 404) {
                logger.debug("File " + fileNameToDownload + " not not present in GD so return true");
                isDeleted = true;
                return isDeleted;
            }
        }
        catch (Exception e) {
            logger.debug("error trying to get file... so retry .... " + e.getCause() + "..." + e.getLocalizedMessage());
            logger.trace("" + e);
            PciAuthorizationTokenElement element = GoogleDriveServiceImpl.getGoogleDriveAccessToken(pciTokenElement);
            Drive drive = GoogleDriveServiceImpl.getDrive(element.getAccessToken(), pciTokenElement.getClientId(), pciTokenElement.getClientSecret());
            try {
                Drive.Files.Delete delete = drive.files().delete(fileNameToDownload);
                delete.execute();
                logger.debug(" file deleted successfully............");
                isDeleted = true;
                if (isGDServiceAcctEnabled) {
                    this.utilService.updateServiceAcctPciAuthorizationToken(element);
                } else {
                    this.utilService.updatePciAuthorizationToken(element, element.getUserName());
                }
                logger.debug("..token updated successfully....");
            }
            catch (Exception e1) {
                logger.error("error trying to get file... so retry .... " + e.getMessage());
                logger.trace("" + e);
                isDeleted = false;
            }
        }
        return isDeleted;
    }
}

