/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.pg.domain.BackupFile;
import com.pg.element.BluKryptBackupFileElement;
import com.pg.element.ChunkFileElement;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.util.PathConversionHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class BaseUploadService {
    private Logger logger = LoggerFactory.getLogger(BaseUploadService.class);
    private static final String CHUNK = "chunk";
    private static final String FOLDER_NOT_CREATED = " folder  Folder Not Created";
    private static final String TEMP_PATH = "  TEMPORARY PATH ............... ";
    private static final String TRANSFER_FILE_FROM_STREAM = "  tranferFileFromStream ................ ";
    private static final String IO_EXCEPTION_WHILE_CREATING_TEMPFILE = "IO Exception while creating tempFile";
    private static final String IO_EXCEPTION_WHILE_TRANSFERING_FROM_CLIENT = "IO Exception while transfering from client";

    protected void uploadFile(String cloudName, InputStream inputStream, ChunkFileElement fileElement, boolean isPortalUpload, String indexPath, String batchId) throws IOException, NoSuchAlgorithmException {
        String intermediateUploadFolder = PCHelperConstant.getMntTempChunkPath() + fileElement.getDeviceUUID();
        String fileName = fileElement.getFileName();
        String pathname = intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
        File intermediateFile = new File(pathname);
        this.readFileItemAndUploadToTempPath(intermediateUploadFolder, intermediateFile, fileElement.getMd5checksum(), inputStream, isPortalUpload, indexPath);
    }

    protected void uploadSyncFile(String cloudName, InputStream inputStream, ChunkFileElement fileElement, boolean isPortalUpload, String indexPath) throws IOException, NoSuchAlgorithmException {
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileElement.getDeviceUUID();
        String fileName = fileElement.getFileName();
        String intermediateUploadFolder = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        String pathname = intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
        this.logger.debug(intermediateUploadFolder + TEMP_PATH + pathname);
        File intermediateFile = new File(pathname);
        this.readFileItemAndUploadToTempPath(intermediateUploadFolder, intermediateFile, fileElement.getMd5checksum(), inputStream, isPortalUpload, indexPath);
    }

    protected void uploadSyncFile(String cloudName, InputStream inputStream, ChunkFileElement fileElement, boolean isPortalUpload, String indexPath, String batchId) throws IOException, NoSuchAlgorithmException {
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileElement.getDeviceUUID();
        if (!StringUtils.isEmpty((String)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileElement.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        String fileName = fileElement.getFileName();
        String intermediateUploadFolder = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        String pathname = intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
        this.logger.debug(intermediateUploadFolder + TEMP_PATH + pathname);
        File intermediateFile = new File(pathname);
        this.readFileItemAndUploadToTempPath(intermediateUploadFolder, intermediateFile, fileElement.getMd5checksum(), inputStream, isPortalUpload, indexPath);
    }

    protected Map<String, String> uploadSyncFileForPortal(int[] chunkDetails, String cloudName, InputStream inputStream, ChunkFileElement fileElement, String indexPath, String userName, String fileTmpPath) throws IOException, NoSuchAlgorithmException {
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileElement.getDeviceUUID();
        String fileName = fileElement.getFileName();
        String intermediateUploadFolder = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        String pathname = intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
        this.logger.debug(intermediateUploadFolder + TEMP_PATH + pathname);
        File intermediateFile = new File(pathname);
        Map<String, String> chunkFilesCheckSum = this.readFileItemAndUploadToTempPathForPortal(chunkDetails, intermediateUploadFolder, intermediateFile, fileElement.getMd5checksum(), inputStream, indexPath, userName, fileTmpPath);
        return chunkFilesCheckSum;
    }

    protected boolean cancelUploadSyncFile(String cloudName, ChunkFileElement fileElement, String indexPath) throws IOException, NoSuchAlgorithmException {
        boolean success = true;
        try {
            String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileElement.getDeviceUUID();
            String fileName = fileElement.getFileName();
            String intermediateUploadFolder = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
            String pathname = intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
            this.logger.debug(intermediateUploadFolder + "  TEMPORARY PATH inside CANCEL SYNC FILE ............... " + pathname);
            File intermediateFile = new File(pathname);
            if (intermediateFile.exists()) {
                intermediateFile.delete();
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception While Canceling Upload of Sync File :" + e.getMessage());
            success = false;
        }
        return success;
    }

    protected void uploadSyncFile(String cloudName, InputStream inputStream, ChunkFileElement fileElement, boolean isPortalUpload) throws IOException, NoSuchAlgorithmException {
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileElement.getDeviceUUID();
        String fileName = fileElement.getFileName();
        String intermediateUploadFolder = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        String pathname = intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
        this.logger.debug(intermediateUploadFolder + TEMP_PATH + pathname);
        File intermediateFile = new File(pathname);
        this.readFileItemAndUploadToTempPath(intermediateUploadFolder, intermediateFile, fileElement.getMd5checksum(), inputStream, isPortalUpload, null);
    }

    protected String convertToServerPath(String fileCompletePath, String osType) {
        boolean type = osType.equals("Android");
        String convertedPath = PathConversionHelper.getServerCompatiblePath((String)fileCompletePath, (boolean)type);
        return convertedPath;
    }

    protected void readFileItemAndUploadToTempPath(String intermediateUploadCompleteFolderPath, File intermediateFile, String md5checksum, InputStream inputStream, boolean isPortalUpload, String indexPath) throws IOException, NoSuchAlgorithmException {
        File intermediateFolder = new File(intermediateUploadCompleteFolderPath);
        if (!intermediateFolder.exists() && !intermediateFolder.mkdirs()) {
            throw new ParacloudBackupException(intermediateFolder + FOLDER_NOT_CREATED, 500);
        }
        this.tranferFileFromStream(inputStream, intermediateFile, md5checksum, isPortalUpload, indexPath);
    }

    protected Map<String, String> readFileItemAndUploadToTempPathForPortal(int[] chunkDetails, String intermediateUploadCompleteFolderPath, File intermediateFile, String md5checksum, InputStream inputStream, String indexPath, String userName, String fileTmpPath) throws IOException, NoSuchAlgorithmException {
        File intermediateFolder = new File(intermediateUploadCompleteFolderPath);
        if (!intermediateFolder.exists() && !intermediateFolder.mkdirs()) {
            throw new ParacloudBackupException(intermediateFolder + FOLDER_NOT_CREATED, 500);
        }
        return this.tranferFileFromStreamForPortal(chunkDetails, inputStream, intermediateFile, md5checksum, indexPath, userName, fileTmpPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tranferFileFromStream(InputStream inputStream, File intermediateFile, String md5Checksum, boolean isPortalUpload, String indexPath) throws NoSuchAlgorithmException, IOException {
        String uploadedFileMd5Checksum;
        byte[] b = new byte[4096];
        MessageDigest md = MessageDigest.getInstance("MD5");
        this.logger.debug(intermediateFile.getAbsolutePath() + TRANSFER_FILE_FROM_STREAM + intermediateFile.getPath());
        intermediateFile.createNewFile();
        try (FileOutputStream outstream = new FileOutputStream(intermediateFile);){
            int buff = -1;
            while ((buff = inputStream.read(b)) != -1) {
                outstream.write(b, 0, buff);
                md.update(b, 0, buff);
            }
            this.logger.debug(intermediateFile.getAbsolutePath() + "  tranferFileFromStream > getSizeinMb(intermediateFile.length()) ................ " + BaseUploadService.getSizeinMb(intermediateFile.length()));
        }
        catch (FileNotFoundException e) {
            this.logger.debug("Exception", (Throwable)e);
            intermediateFile.delete();
            throw new ParacloudBackupException(IO_EXCEPTION_WHILE_CREATING_TEMPFILE + e, 500);
        }
        catch (IOException e) {
            this.logger.debug("Exception", (Throwable)e);
            intermediateFile.delete();
            throw new ParacloudBackupException(IO_EXCEPTION_WHILE_TRANSFERING_FROM_CLIENT + e, 500);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception While Transfering File From Stream :" + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (!isPortalUpload && !(uploadedFileMd5Checksum = MD5Generator.generateMD5OfFile((File)intermediateFile)).equals(md5Checksum)) {
            this.logger.error(uploadedFileMd5Checksum + " MD5CHECKSUMERROR ...... " + md5Checksum);
            throw new ParacloudBackupException("File Upload Not Successful,due to MD5 mismatch", 500);
        }
        if (!StringUtils.isEmpty((String)indexPath)) {
            try {
                File parent = new File(indexPath);
                File f = parent.getParentFile();
                if (!f.exists()) {
                    f.mkdirs();
                }
                this.logger.debug(" move file to search path" + indexPath);
                FileUtils.copyFile((File)intermediateFile, (File)parent);
                this.logger.debug(" end of move file to search path");
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error(" Error trying to create index file ....... " + e.getMessage());
            }
        }
    }

    protected Map<String, String> tranferFileFromStreamForPortal(int[] chunkDetails, InputStream inputStream, File intermediateFile1, String md5Checksum, String indexPath, String userName, String fileTmpPath) throws NoSuchAlgorithmException, IOException {
        File intermediateFile = intermediateFile1;
        String destinationPath = intermediateFile.getParent();
        intermediateFile = new File(fileTmpPath);
        this.logger.debug(" Before call split and write ... " + intermediateFile.length());
        if (!StringUtils.isEmpty((String)indexPath) && intermediateFile.length() < 100000000L) {
            try {
                File parent = new File(indexPath);
                File f = parent.getParentFile();
                if (!f.exists()) {
                    f.mkdirs();
                }
                this.logger.debug(" move file to search path");
                FileUtils.copyFile((File)intermediateFile, (File)parent);
                this.logger.debug(" end of move file to search path");
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error(" Error trying to create index file ....... " + e.getMessage());
            }
        }
        return com.pg.util.FileUtils.splitAndWrite((int[])chunkDetails, (String)intermediateFile.getPath(), (String)(destinationPath + "/"), (String)userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tranferFileFromStream(InputStream inputStream, File intermediateFile, String md5Checksum, boolean isPortalUpload) throws NoSuchAlgorithmException, IOException {
        byte[] b = new byte[4096];
        MessageDigest md = MessageDigest.getInstance("MD5");
        this.logger.debug(intermediateFile.getAbsolutePath() + TRANSFER_FILE_FROM_STREAM + intermediateFile.getPath());
        intermediateFile.createNewFile();
        try (FileOutputStream outstream = new FileOutputStream(intermediateFile);){
            int buff = -1;
            while ((buff = inputStream.read(b)) != -1) {
                outstream.write(b, 0, buff);
                md.update(b, 0, buff);
            }
            this.logger.debug(intermediateFile.getAbsolutePath() + "  tranferFileFromStream > getSizeinMb(intermediateFile.length()) ................ " + BaseUploadService.getSizeinMb(intermediateFile.length()));
        }
        catch (FileNotFoundException e) {
            this.logger.debug("Exception", (Throwable)e);
            intermediateFile.delete();
            throw new ParacloudBackupException(IO_EXCEPTION_WHILE_CREATING_TEMPFILE + e, 500);
        }
        catch (IOException e) {
            this.logger.debug("Exception", (Throwable)e);
            intermediateFile.delete();
            throw new ParacloudBackupException(IO_EXCEPTION_WHILE_TRANSFERING_FROM_CLIENT + e, 500);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception While Transfering File From Stream :" + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String uploadedFileMd5Checksum = MD5Generator.generateMD5OfFile((File)intermediateFile);
        if (!isPortalUpload && !uploadedFileMd5Checksum.equals(md5Checksum)) {
            intermediateFile.delete();
            this.logger.error(uploadedFileMd5Checksum + " MD5CHECKSUMERROR ...... " + md5Checksum);
            throw new ParacloudBackupException("File Upload Not Successful,due to MD5 mismatch", 500);
        }
    }

    public void createFoldersForUpload(String pathname) {
        File chunkDir;
        File encryptedDir = new File(pathname + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "encrypted");
        if (!encryptedDir.exists()) {
            encryptedDir.mkdir();
        }
        if (!(chunkDir = new File(pathname + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK)).exists()) {
            chunkDir.mkdir();
        }
    }

    public void createFoldersForDownload(String pathname) {
        File mergeDir;
        File decryptedDir = new File(pathname + "/decrypted");
        if (!decryptedDir.exists()) {
            decryptedDir.mkdir();
        }
        if (!(mergeDir = new File(pathname + "/merge")).exists()) {
            mergeDir.mkdir();
        }
    }

    public void saveSyncFileInfoInMainDB(BackupFile backupFile, String cloudName, String gatewayName) {
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        BluKryptBackupFileElement element = new BluKryptBackupFileElement();
        BeanUtils.copyProperties((Object)backupFile, (Object)element);
        element.setBackupId(backupFile.getBackupId().toString());
        HttpEntity entity = new HttpEntity((Object)element, (MultiValueMap)headers);
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/save/syncfile/user/userName/";
        restTemplate.put(url, (Object)entity, new Object[0]);
        try {
            reqFactory.destroy();
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception While Saving Sync File Info In Main DB :" + e.getMessage());
        }
    }

    public Long getmillisecondsForTime(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            this.logger.trace("" + e);
            this.logger.error("Exception While Getting Milliseconds For Time :" + e.getMessage());
            return null;
        }
        return date.getTime();
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    protected void updateRefChunks(ChunkFile chunkFile, String backupId, ExternalStorageBackupFileDao externalStorageBackupFileDao, String containerName, String dedupType, String userName, boolean isFullBackup, boolean isRebackupFile, String deviceUUID, Cloud cloud, long size, String gatewayName) {
        this.logger.debug(" update chunk refs ............" + chunkFile.getMd5());
        ChunkDetail chunkDetail = null;
        if (!isFullBackup && (chunkDetail = externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupType, userName, true, false)) == null) {
            this.logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
            chunkDetail = externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupType, userName, true, true);
        }
        String cloudChunkName = chunkFile.getFileName();
        if (chunkDetail == null) {
            chunkDetail = new ChunkDetail();
            chunkDetail.setCloudChunkName(cloudChunkName);
            if (!StringUtils.isEmpty((String)containerName)) {
                if (this.isLocalStorageEnabled(cloud)) {
                    chunkDetail.setContainerName(userName);
                } else {
                    chunkDetail.setContainerName(containerName);
                }
            }
            if (!StringUtils.isEmpty((String)chunkFile.getEncodedName())) {
                chunkDetail.setEncodedName(chunkFile.getEncodedName());
            }
            chunkDetail.setMd5(chunkFile.getMd5());
            chunkDetail.setRefCount(1);
            chunkDetail.setCloudStoragePath(chunkFile.getCloudStoragePath());
            chunkDetail.setProductType(chunkFile.getProductType());
            chunkDetail.setChunkCreatedTime(System.currentTimeMillis());
            chunkDetail.setUserName(userName);
            chunkDetail.setDeviceUUID(deviceUUID);
            chunkDetail.setSize(size);
            externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
            this.logger.debug(" Chunk save succcessfully  .........." + cloudChunkName);
        } else {
            try {
                this.logger.debug(chunkDetail.getRefCount() + " Chunk updated   .........." + cloudChunkName);
                if (!isRebackupFile) {
                    int refCount = chunkDetail.getRefCount() + 1;
                    chunkDetail.setRefCount(refCount);
                    chunkDetail.setDeviceUUID(deviceUUID);
                    chunkDetail.setSize(size);
                    externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                    this.logger.debug(refCount + " Chunk updated succcessfully  .........." + cloudChunkName);
                } else {
                    this.logger.debug(cloudChunkName + " is a rebackup file so skip updating refcount");
                }
            }
            catch (OptimisticLockingFailureException e) {
                this.logger.trace("" + (Object)((Object)e));
                this.logger.error("Exception while updating ref chunks :" + (Object)((Object)e));
                int count = 0;
                try {
                    this.logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                    ChunkDetail chunkDetailObj = externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupType, userName, true, false);
                    if (chunkDetailObj == null) {
                        this.logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetailObj = externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupType, userName, true, true);
                    }
                    if (chunkDetailObj == null) {
                        chunkDetailObj = new ChunkDetail();
                        chunkDetailObj.setCloudChunkName(cloudChunkName);
                        chunkDetailObj.setMd5(chunkFile.getMd5());
                        chunkDetailObj.setDeviceUUID(deviceUUID);
                        if (!StringUtils.isEmpty((String)containerName)) {
                            chunkDetailObj.setContainerName(containerName);
                        }
                        chunkDetailObj.setRefCount(1);
                        chunkDetailObj.setCloudStoragePath(chunkFile.getCloudStoragePath());
                        chunkDetailObj.setProductType(chunkFile.getProductType());
                        chunkDetailObj.setChunkCreatedTime(System.currentTimeMillis());
                        chunkDetailObj.setUserName(userName);
                        chunkDetailObj.setGatewayName(gatewayName);
                        externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
                    } else {
                        int refCount = chunkDetailObj.getRefCount() + 1;
                        chunkDetailObj.setRefCount(refCount);
                        chunkDetailObj.setDeviceUUID(deviceUUID);
                        chunkDetailObj.setGatewayName(gatewayName);
                        this.logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                        externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
                    }
                }
                catch (Exception ex) {
                    this.logger.trace("" + ex);
                    this.logger.error(" ex ..." + ex.getMessage());
                }
            }
        }
    }

    public static double getSizeinMb(long fileSizeInBytes) {
        long filesizeInKB = (long)Math.ceil((double)fileSizeInBytes / 1024.0);
        double m = (double)filesizeInKB / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private boolean isLocalStorageEnabled(Cloud cloud) {
        boolean isLocalStorageEnabled = false;
        for (CloudCredentials cc : cloud.getCloudCredentials()) {
            if (cc == null || !"localStorage".equalsIgnoreCase(cc.getCloudName())) continue;
            isLocalStorageEnabled = true;
            break;
        }
        return isLocalStorageEnabled;
    }

    protected void updateChunksRefForFailedChunks(ChunkFile chunkFile, ExternalStorageBackupFileDao externalStorageBackupFileDao, String containerName, String dedupType, String userName, boolean isFullBackup, boolean isRebackupFile, String deviceUUID) {
        try {
            this.logger.debug(" update chunk refs for failed files............" + chunkFile.getMd5());
            ChunkDetail chunkDetail = externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupType, userName, true, false);
            if (chunkDetail == null) {
                this.logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                chunkDetail = externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupType, userName, true, true);
            }
            try {
                if (chunkFile != null) {
                    String cloudChunkName = chunkFile.getFileName();
                    this.logger.debug(chunkDetail.getRefCount() + " Chunk updated for failed files .........." + cloudChunkName);
                    int refCount = chunkDetail.getRefCount() - 1;
                    chunkDetail.setRefCount(refCount);
                    chunkDetail.setDeviceUUID(deviceUUID);
                    externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                    this.logger.debug(refCount + " Chunk updated succcessfully for failed files .........." + cloudChunkName);
                }
            }
            catch (OptimisticLockingFailureException e) {
                this.logger.trace("" + (Object)((Object)e));
                this.logger.error("Exception while updating ref chunks :" + (Object)((Object)e));
                int count = 0;
                int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                while (true) {
                    try {
                        this.logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                        ChunkDetail chunkDetailObj = externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupType, userName, true, false);
                        if (chunkDetailObj == null) {
                            this.logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                            chunkDetailObj = externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5(), dedupType, userName, true, true);
                        }
                        if (chunkDetailObj != null) {
                            chunkDetail.setDeviceUUID(deviceUUID);
                            int refCount = chunkDetail.getRefCount() - 1;
                            chunkDetailObj.setRefCount(refCount);
                            externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
                        }
                    }
                    catch (Exception ex) {
                        this.logger.trace("" + ex);
                        this.logger.error(" ex ..." + ex.getMessage());
                        if (++count != maxTries) continue;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.trace("" + e);
            this.logger.error("Exception while updating ref chunks :" + e);
        }
    }
}

