/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service;

import com.google.common.util.concurrent.RateLimiter;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.pg.domain.BackupFile;
import com.pg.domain.ChunkFile;
import com.pg.domain.FileInfo;
import com.pg.element.PciAuthorizationTokenElement;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.http.client.ClientProtocolException;
import org.bson.types.ObjectId;

public interface UploadService {
    public boolean saveFileInfo(String var1, String var2, FileInfo var3);

    public BackupFile getBackupFile(String var1, String var2, String var3, String var4);

    public void deleteBackupFile(String var1, String var2, String var3, String var4);

    public String getOneDriveAccessToken(PciAuthorizationTokenElement var1);

    public FileInfo getFileInfo(String var1, String var2, String var3, String var4);

    public FileInfo getBackupFileInfo(String var1, String var2, String var3, String var4);

    public boolean saveFileInfoForSync(String var1, String var2, FileInfo var3);

    public void deleteUploadedFiles(FileInfo var1, String var2);

    public boolean uploadAllFilesToCloud(String var1, FileInfo var2, Cloud var3, RateLimiter var4);

    public FileInfo getFileFromPG(String var1, String var2, String var3, boolean var4);

    public void updateFileInfo(String var1, String var2, FileInfo var3);

    public void moveFailedFilesToBkpQueue(String var1, FileInfo var2);

    public boolean restoreQueue(FileInfo var1, Cloud var2);

    public boolean deleteFileInfoFromReBackup(String var1, ObjectId var2);

    public List<FileInfo> getFilesForUpload(String var1);

    public List<FileInfo> getFaileFilesForReUpload(String var1);

    public boolean restoreFailedFiles(FileInfo var1, Cloud var2);

    public void removeSyncFile(int var1, String var2, String var3);

    public void removeBackupFile(int var1, String var2, String var3);

    public void updateUploadedChunks(String var1, Map<String, ChunkFile> var2, FileInfo var3);

    public void saveFileInfoForODB(String var1, String var2, FileInfo var3, String var4);

    public void removeFileInfoForAlreadyExists(String var1);

    public void removeBackupFromTempDb(Cloud var1, ObjectId var2);

    public boolean restoreSyncFailedFiles(FileInfo var1, Cloud var2);

    public BackUpImage getBkpFileByIdAndDevice(int var1, ObjectId var2, Device var3);

    public void saveImageToBackUp(int var1, BackUpImage var2, Device var3);

    public StringBuilder checkOdbFolders(Cloud var1, StringBuilder var2) throws ClientProtocolException, IOException;
}

