/*
 * Decompiled with CFR 0.152.
 */
package com.pg.odb.util;

import com.parablu.pcbd.dao.BackupOverViewDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.domain.User;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.Office365UploadService;
import com.pg.service.UtilService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class OneDriveUtil {
    private static final int MAX_FILE_COUNT = 4000;
    @Autowired
    private UtilService utilService;
    @Autowired
    private Office365UploadService office365UploadService;
    private DeviceDao deviceDao;
    @Autowired
    private BackupOverViewDao backupOverViewDao;
    private static OneDriveUtil singleton = new OneDriveUtil();
    private static Logger logger = Logger.getLogger(OneDriveUtil.class);
    Map<String, UserOdbElement> userCountMap = new ConcurrentHashMap<String, UserOdbElement>();
    Map<String, Object> userObjectMap = new ConcurrentHashMap<String, Object>();

    private OneDriveUtil() {
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setOffice365UploadService(Office365UploadService office365UploadService) {
        this.office365UploadService = office365UploadService;
    }

    public static OneDriveUtil getInstance() {
        return singleton;
    }

    private synchronized void setUserElement(PciAuthorizationTokenElement pciTokenElement, boolean isSync, String emailId, User user, String deviceUUID, String actualUserName) {
        logger.error((Object)("MAP-VAL................" + this.userCountMap + "...." + emailId));
        if (this.userCountMap.get(actualUserName) == null) {
            ArrayList<Integer> folderNameList;
            logger.debug((Object)("inside getUserElement nulll " + actualUserName));
            String lastCloudStoragePath = this.checkOneDriveStoragePath(pciTokenElement.getCloudName(), pciTokenElement.getUserName(), isSync, user);
            int count = this.getCountOFFilesInFolder(pciTokenElement, lastCloudStoragePath, deviceUUID);
            logger.debug((Object)(".......folder count before assigning setuserElement..... " + count));
            while (count >= 4000 && (count = this.getCountOFFilesInFolder(pciTokenElement, lastCloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList = this.splitPathAndGetFolderDepth(lastCloudStoragePath), count), deviceUUID)) >= 4000) {
            }
            logger.debug((Object)(".......folder count after assigning setuserElement..... " + count + "......." + lastCloudStoragePath));
            UserOdbElement userOdbElement = new UserOdbElement(count, System.currentTimeMillis(), lastCloudStoragePath);
            this.userCountMap.put(actualUserName, userOdbElement);
        }
    }

    private synchronized void updateOdbCount(boolean isSync, String userName, int count, String emailId, PciAuthorizationTokenElement pciTokenElement, String deviceUUID, String actualUserName) {
        if (this.userCountMap.get(actualUserName).getCount() >= 4000) {
            ArrayList<Integer> folderNameList = this.splitPathAndGetFolderDepth(this.userCountMap.get(actualUserName).getPath());
            String cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, this.userCountMap.get(actualUserName).getCount());
            int filesInFoldercount = this.getCountOFFilesInFolder(pciTokenElement, cloudStoragePath, deviceUUID);
            logger.debug((Object)(".......folder count before assigning..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount));
            if (filesInFoldercount != 0 && filesInFoldercount < 4000) {
                this.userCountMap.get(actualUserName).setCount(filesInFoldercount + 1);
            } else {
                while (filesInFoldercount >= 4000) {
                    logger.error((Object)("...greater than 4000.....check here... " + emailId));
                    folderNameList = this.splitPathAndGetFolderDepth(cloudStoragePath);
                    filesInFoldercount = this.getCountOFFilesInFolder(pciTokenElement, cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, filesInFoldercount), deviceUUID);
                    if (filesInFoldercount >= 4000) continue;
                }
                logger.debug((Object)(".......folder count after finding correct path..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount));
                this.userCountMap.get(actualUserName).setCount(1);
                this.userCountMap.get(actualUserName).setPath(cloudStoragePath);
                this.utilService.updateUserStoragePath(1, userName, this.userCountMap.get(actualUserName).getPath(), isSync);
                Set<String> values = this.userCountMap.keySet();
                for (String user : values) {
                    logger.debug((Object)(".................users in memcached...." + user));
                }
            }
        } else {
            this.userCountMap.get(actualUserName).setCount(count + 1);
        }
    }

    public boolean isODBCountApiCallReq(String userName) {
        boolean isODBCountApiCallReq = true;
        if (this.userCountMap.get(userName) != null && this.userCountMap.get(userName).getCount() < 4000 && this.userCountMap.get(userName).getCount() % PCHelperConstant.getODBCallFrequency() != 0) {
            isODBCountApiCallReq = false;
        }
        return isODBCountApiCallReq;
    }

    public FileStatusElement uploadToODB(PciAuthorizationTokenElement pciTokenElement, boolean isSync, FileStatusElement fileStatusElement, File encryptedFile, String lastStoragePathForSameFile, String deviceUUID, String actualUserName, String gateWayName, String uplodingFileName) {
        User user = this.utilService.getUserInfoByName(1, pciTokenElement.getUserName());
        String emailId = user.getOdbLoginId();
        if (StringUtils.isEmpty((Object)emailId)) {
            emailId = user.getEmailId();
        }
        logger.debug((Object)("Email Id>>>>>" + emailId + "....user name:" + user.getUserName()));
        boolean isOdbApiCallRequired = this.isODBCountApiCallReq(emailId);
        if (this.userCountMap.get(actualUserName) == null) {
            this.setUserElement(pciTokenElement, isSync, emailId, user, deviceUUID, actualUserName);
        } else {
            this.setCountForUser(pciTokenElement, isSync, pciTokenElement.getUserName(), isOdbApiCallRequired, emailId, deviceUUID, actualUserName);
        }
        logger.debug((Object)(emailId + " before  setCountForUser.......... " + isOdbApiCallRequired));
        String userStoragepath = this.userCountMap.get(actualUserName).getPath();
        if (StringUtils.isEmpty((Object)userStoragepath)) {
            userStoragepath = isSync ? user.getCloudSyncStoragePath() : user.getCloudBkpStoragePath();
            if (StringUtils.isEmpty((Object)userStoragepath)) {
                userStoragepath = "1";
            }
            logger.debug((Object)("....user storagepath for user ..." + user.getUserName() + "....path...." + userStoragepath));
        }
        logger.error((Object)(userStoragepath + " latest COUNT>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> " + this.userCountMap.get(actualUserName).getCount()));
        String encodedFileName = this.office365UploadService.uploadFileToODB(pciTokenElement.getAccessToken(), pciTokenElement, encryptedFile, userStoragepath, deviceUUID, gateWayName, uplodingFileName, fileStatusElement);
        logger.debug((Object)(" END OF next file ..... " + userStoragepath));
        fileStatusElement.setCloudStoragePath(userStoragepath);
        fileStatusElement.setUploadStatus(true);
        if (StringUtils.isEmpty((Object)encodedFileName)) {
            fileStatusElement.setUploadStatus(false);
            logger.debug((Object)("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount()));
            if (this.userCountMap.get(actualUserName) != null) {
                logger.debug((Object)("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount()));
                this.decreOdbCount(this.userCountMap.get(actualUserName).getCount(), actualUserName);
            }
        }
        if (this.userCountMap.size() > 500) {
            this.removeOldUser();
        }
        return fileStatusElement;
    }

    private synchronized void decreOdbCount(int count, String actualUserName) {
        if (this.userCountMap.get(actualUserName) != null) {
            this.userCountMap.get(actualUserName).setCount(count - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCountForUser(PciAuthorizationTokenElement pciTokenElement, boolean isSync, String userName, boolean isOdbApiCallRequired, String emailId, String deviceUUID, String actualUserName) {
        if (!this.userObjectMap.containsKey(emailId)) {
            Object object = new Object();
            this.userObjectMap.put(emailId, object);
        }
        Object obj = this.userObjectMap.get(emailId);
        logger.debug((Object)(obj + "..... obj synchronized ....." + emailId));
        if (isOdbApiCallRequired) {
            Object object = obj;
            synchronized (object) {
                if (this.isODBCountApiCallReq(emailId)) {
                    int count = this.getCountOFFilesInFolder(pciTokenElement, this.userCountMap.get(actualUserName).getPath(), deviceUUID);
                    if (count <= 0) {
                        count = this.userCountMap.get(actualUserName).getCount();
                    }
                    this.updateOdbCount(isSync, userName, count, emailId, pciTokenElement, deviceUUID, actualUserName);
                } else {
                    this.updateOdbCount(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, pciTokenElement, deviceUUID, actualUserName);
                }
            }
            logger.debug((Object)"INSID isOdbApiCallRequired.....");
        } else {
            this.updateOdbCount(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, pciTokenElement, deviceUUID, actualUserName);
        }
    }

    private void removeOldUser() {
        HashMap<String, Long> userMap = new HashMap<String, Long>();
        for (Map.Entry<String, UserOdbElement> entry : this.userCountMap.entrySet()) {
            String key = entry.getKey();
            UserOdbElement userOdbElement = entry.getValue();
            userMap.put(key, userOdbElement.getTimeMillis());
        }
        String userToBeRemoved = Collections.min(userMap.entrySet(), new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getValue().intValue() - o2.getValue().intValue();
            }
        }).getKey();
        if (!StringUtils.isEmpty((Object)userToBeRemoved)) {
            Long oldestTimeStamp = (Long)userMap.get(userToBeRemoved);
            int fiveMinsInactivePeriod = 300000;
            if (oldestTimeStamp != null && System.currentTimeMillis() > oldestTimeStamp + (long)fiveMinsInactivePeriod) {
                logger.debug((Object)("removing user .... " + userToBeRemoved));
                this.userCountMap.remove(userToBeRemoved);
            }
        }
    }

    private int getCountOFFilesInFolder(PciAuthorizationTokenElement pciTokenElement, String lastCloudStoragePath, String deviceUUID) {
        return this.office365UploadService.getCountOfFilesInFolder(pciTokenElement, lastCloudStoragePath, deviceUUID);
    }

    private synchronized String checkOneDriveStoragePath(String cloudName, String userName, boolean isSync, User user) {
        String cloudStoragePath = "1";
        if (isSync) {
            if (!StringUtils.isEmpty((Object)user.getCloudSyncStoragePath())) {
                cloudStoragePath = user.getCloudSyncStoragePath();
            }
        } else if (!StringUtils.isEmpty((Object)user.getCloudBkpStoragePath())) {
            cloudStoragePath = user.getCloudBkpStoragePath();
        }
        if (StringUtils.isEmpty((Object)cloudStoragePath)) {
            cloudStoragePath = "1";
        }
        logger.debug((Object)(userName + "Inside check onedrivepath>>>>>>>>>>>>" + cloudStoragePath));
        return cloudStoragePath;
    }

    private String checkOneDriveStoragePathAndCount(ArrayList<Integer> folderNameList, int count) {
        int countTemp = count;
        String cloudStoragePath = "";
        int folderDepthSize = folderNameList.size();
        int folderValue = folderNameList.get(0);
        if (folderDepthSize == 1 && folderValue <= 900) {
            logger.debug((Object)("Folder DEpth Size 1 folder value>>>>>>" + folderValue));
            if (countTemp < 4000) {
                cloudStoragePath = String.valueOf(folderValue);
                logger.debug((Object)("Folder DEpth Size 1 folder value count less than 500>>>>>>." + countTemp));
            } else if (folderValue < 900) {
                countTemp = 0;
                folderNameList.set(0, folderValue + 1);
                cloudStoragePath = String.valueOf(folderValue + 1);
                logger.debug((Object)("count >= MAX_FILE_COUNT ........... " + cloudStoragePath));
            } else if (folderValue >= 900) {
                folderNameList.clear();
                countTemp = 0;
                folderNameList.add(0, 1);
                folderNameList.add(1, 1);
                cloudStoragePath = "1/1";
                logger.debug((Object)("folderValue >= 900 ........... " + cloudStoragePath));
            }
            ++countTemp;
        } else {
            int lastFolder = folderNameList.get(folderDepthSize - 1);
            int previousFolder = 0;
            if (folderDepthSize > 1) {
                previousFolder = folderNameList.get(folderDepthSize - 2);
            }
            if (lastFolder <= 900) {
                if (countTemp < 4000) {
                    cloudStoragePath = String.valueOf(previousFolder + "/" + lastFolder);
                    logger.debug((Object)("else count < MAX_FILE_COUNT ........... " + cloudStoragePath));
                } else if (lastFolder < 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, lastFolder + 1);
                    cloudStoragePath = String.valueOf(previousFolder + "/" + ++lastFolder);
                    logger.debug((Object)("else count >= MAX_FILE_COUNT ........... " + cloudStoragePath));
                } else if (lastFolder >= 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, 1);
                    if (folderDepthSize > 1) {
                        folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                    }
                    cloudStoragePath = ++previousFolder + "/1";
                    logger.debug((Object)("else lastFolder >= 900 ........... " + cloudStoragePath));
                }
            } else if (lastFolder >= 900) {
                countTemp = 0;
                folderNameList.set(folderDepthSize - 1, 1);
                if (folderDepthSize > 1) {
                    folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                }
                cloudStoragePath = ++previousFolder + "/1";
                logger.debug((Object)("else lastFolder >= 900 ........... " + cloudStoragePath));
            }
            ++countTemp;
        }
        logger.debug((Object)("4000 max size " + cloudStoragePath + " endo of method ........" + countTemp));
        return cloudStoragePath;
    }

    private ArrayList<Integer> splitPathAndGetFolderDepth(String cloudStoragePath) {
        ArrayList<Integer> pathListNumbers = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)cloudStoragePath)) {
            String[] pathList;
            for (String path : pathList = cloudStoragePath.split("/")) {
                pathListNumbers.add(Integer.parseInt(path));
            }
        } else {
            pathListNumbers.add(1);
        }
        return pathListNumbers;
    }

    public FileStatusElement deleteFromODB(PciAuthorizationTokenElement pciTokenElement, String fileNameTodownload, String lastStoragePathForSameFile, String deviceUUID) {
        return this.office365UploadService.deleteFileFromODB(pciTokenElement, fileNameTodownload, lastStoragePathForSameFile, deviceUUID);
    }

    public void updateBkpOverviewForDeletedFiles(int cloudId, String deviceUUID, Long deletedFileSize) {
        logger.debug((Object)(".....processing for thread...." + Thread.currentThread().getName()));
        try {
            long updatedSize = -deletedFileSize.longValue();
            logger.debug((Object)(deviceUUID + "....updateBkpOverviewForDeletedFiles%%......" + updatedSize + "...rem..." + updatedSize));
            this.backupOverViewDao.updateSizeDeviceBackupOverView(cloudId, deviceUUID, Long.valueOf(updatedSize), null, Long.valueOf(updatedSize), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error ee) {
            ee.printStackTrace();
        }
    }

    public void updateSizeInDeviceBackupOverview(int cloudId, String deviceUUID, Long sizeToUpdatePG, Long sizeToUpdateInCloud, Long latestVersionSize, Long pgCompressedSize) {
        logger.debug((Object)(".....processing for thread...." + Thread.currentThread().getName() + " sizeToUpdatePG " + sizeToUpdatePG + " sizeToUpdateInCloud " + sizeToUpdateInCloud + " latestVersionSize " + latestVersionSize + " pgCompressedSize " + pgCompressedSize));
        this.backupOverViewDao.updateSizeDeviceBackupOverView(cloudId, deviceUUID, sizeToUpdatePG, sizeToUpdateInCloud, latestVersionSize, pgCompressedSize);
    }

    public class UserOdbElement {
        Integer count;
        Long timeMillis;
        String path;

        public UserOdbElement(Integer count, Long timeMillis, String path) {
            this.count = count;
            this.timeMillis = timeMillis;
            this.path = path;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Long getTimeMillis() {
            return this.timeMillis;
        }

        public void setTimeMillis(Long timeMillis) {
            this.timeMillis = timeMillis;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

