/*
 * Decompiled with CFR 0.152.
 */
package com.pg.odb.util;

import com.parablu.pcbd.domain.User;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.service.GoogleDriveService;
import com.pg.service.UtilService;
import java.io.BufferedInputStream;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class GoogleDriveUtil {
    private static final int MAX_FILE_COUNT = 4000;
    @Autowired
    private UtilService utilService;
    @Autowired
    private GoogleDriveService googleDriveService;
    private static GoogleDriveUtil singleton = new GoogleDriveUtil();
    private static Logger logger = Logger.getLogger(GoogleDriveUtil.class);

    private GoogleDriveUtil() {
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setGoogleDriveService(GoogleDriveService googleDriveService) {
        this.googleDriveService = googleDriveService;
    }

    public static GoogleDriveUtil getInstance() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FileStatusElement uploadToGD(PciAuthorizationTokenElement pciTokenElement, boolean isSync, FileStatusElement fileStatusElement, File encryptedFile, String lastStoragePathForSameFile) {
        String lastCloudStoragePath;
        int count;
        if (!StringUtils.isEmpty((Object)lastStoragePathForSameFile)) {
            logger.debug((Object)"SAME_FILE...............................");
            logger.error((Object)(" lastStoragePathForSameFile exists >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> " + lastStoragePathForSameFile));
            count = this.getCountOFFilesInFolder(pciTokenElement, lastStoragePathForSameFile);
            lastCloudStoragePath = count >= 4000 ? this.checkGoogleDriveStoragePath(pciTokenElement.getCloudName(), pciTokenElement.getUserName(), isSync) : lastStoragePathForSameFile;
        } else {
            logger.debug((Object)"DIFFERENT_FILE...............................");
            lastCloudStoragePath = this.checkGoogleDriveStoragePath(pciTokenElement.getCloudName(), pciTokenElement.getUserName(), isSync);
            logger.error((Object)(" lastStoragePathForSameFile does not exist >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> " + lastCloudStoragePath));
            count = this.getCountOFFilesInFolder(pciTokenElement, lastCloudStoragePath);
        }
        GoogleDriveUtil googleDriveUtil = this;
        synchronized (googleDriveUtil) {
            String cloudStoragePath;
            logger.error((Object)(lastCloudStoragePath + " latest COUNT>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> " + count));
            boolean pathChanged = false;
            do {
                ArrayList<Integer> folderNameList;
                if ((count = this.getCountOFFilesInFolder(pciTokenElement, cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList = this.splitPathAndGetFolderDepth(lastCloudStoragePath), count))) < 4000) continue;
                lastCloudStoragePath = cloudStoragePath;
                logger.debug((Object)(lastCloudStoragePath + " ........error case ............. " + cloudStoragePath));
                pathChanged = true;
            } while (count >= 4000);
            if (pathChanged) {
                logger.debug((Object)("updating cloud path for user............. " + pciTokenElement.getUserName()));
                this.utilService.updateUserStoragePath(1, pciTokenElement.getUserName(), cloudStoragePath, isSync);
            }
            String encodedFileName = this.googleDriveService.uploadFileToGD(pciTokenElement.getAccessToken(), pciTokenElement, encryptedFile, cloudStoragePath);
            logger.debug((Object)(" END OF next file ..... " + cloudStoragePath));
            fileStatusElement.setCloudStoragePath(cloudStoragePath);
            fileStatusElement.setUploadStatus(true);
            fileStatusElement.setFileId(encodedFileName);
            if (StringUtils.isEmpty((Object)encodedFileName)) {
                fileStatusElement.setUploadStatus(false);
            }
        }
        return fileStatusElement;
    }

    private synchronized int getCountOFFilesInFolder(PciAuthorizationTokenElement pciTokenElement, String lastCloudStoragePath) {
        return this.googleDriveService.getCountOfFilesInFolder(pciTokenElement, lastCloudStoragePath);
    }

    private synchronized String checkGoogleDriveStoragePath(String cloudName, String userName, boolean isSync) {
        String cloudStoragePath = "1";
        User user = this.utilService.getUserInfoByName(1, userName);
        if (isSync) {
            if (!StringUtils.isEmpty((Object)user.getCloudSyncStoragePath())) {
                cloudStoragePath = user.getCloudSyncStoragePath();
            }
        } else if (!StringUtils.isEmpty((Object)user.getCloudBkpStoragePath())) {
            cloudStoragePath = user.getCloudBkpStoragePath();
        }
        if (StringUtils.isEmpty((Object)cloudStoragePath)) {
            cloudStoragePath = "1";
        }
        logger.debug((Object)(userName + "Inside check google drive path>>>>>>>>>>>>" + cloudStoragePath));
        return cloudStoragePath;
    }

    private synchronized String checkOneDriveStoragePathAndCount(ArrayList<Integer> folderNameList, int count) {
        int countTemp = count;
        String cloudStoragePath = "";
        int folderDepthSize = folderNameList.size();
        if (folderDepthSize == 1) {
            int folderValue = folderNameList.get(0);
            logger.debug((Object)("Folder DEpth Size 1 folder value>>>>>>" + folderValue));
            if (folderValue <= 900) {
                if (countTemp < 4000) {
                    cloudStoragePath = String.valueOf(folderValue);
                    logger.debug((Object)("Folder DEpth Size 1 folder value count less than 500>>>>>>." + countTemp));
                } else if (folderValue < 900) {
                    countTemp = 0;
                    folderNameList.set(0, folderValue + 1);
                    cloudStoragePath = String.valueOf(folderValue + 1);
                    logger.debug((Object)("count >= MAX_FILE_COUNT ........... " + cloudStoragePath));
                } else if (folderValue >= 900) {
                    folderNameList.clear();
                    countTemp = 0;
                    folderNameList.add(0, 1);
                    folderNameList.add(1, 1);
                    cloudStoragePath = "1/1";
                    logger.debug((Object)("folderValue >= 900 ........... " + cloudStoragePath));
                }
            }
            ++countTemp;
        } else {
            int lastFolder = folderNameList.get(folderDepthSize - 1);
            int previousFolder = folderNameList.get(folderDepthSize - 2);
            if (lastFolder <= 900) {
                if (countTemp < 4000) {
                    cloudStoragePath = String.valueOf(previousFolder + "/" + lastFolder);
                    logger.debug((Object)("else count < MAX_FILE_COUNT ........... " + cloudStoragePath));
                } else if (lastFolder < 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, lastFolder + 1);
                    cloudStoragePath = String.valueOf(previousFolder + "/" + ++lastFolder);
                    logger.debug((Object)("else count >= MAX_FILE_COUNT ........... " + cloudStoragePath));
                } else if (lastFolder >= 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, 1);
                    folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                    cloudStoragePath = ++previousFolder + "/1";
                    logger.debug((Object)("else lastFolder >= 900 ........... " + cloudStoragePath));
                }
            }
            ++countTemp;
        }
        logger.debug((Object)("4000 max size " + cloudStoragePath + " endo of method ........" + countTemp));
        return cloudStoragePath;
    }

    private ArrayList<Integer> splitPathAndGetFolderDepth(String cloudStoragePath) {
        ArrayList<Integer> pathListNumbers = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)cloudStoragePath)) {
            String[] pathList;
            for (String path : pathList = cloudStoragePath.split("/")) {
                pathListNumbers.add(Integer.parseInt(path));
            }
        }
        return pathListNumbers;
    }

    public BufferedInputStream downloadFileFromGD(PciAuthorizationTokenElement pciTokenElement, String fileNameToDownload, boolean isGDServiceAcctEnabled) {
        return this.googleDriveService.downloadFileFromGD(pciTokenElement, fileNameToDownload, isGDServiceAcctEnabled);
    }

    public boolean deleteFromGD(PciAuthorizationTokenElement pciTokenElement, String fileNameToDownload, boolean isGDServiceAcctEnabled) {
        return this.googleDriveService.deleteFromGD(pciTokenElement, fileNameToDownload, isGDServiceAcctEnabled);
    }
}

