/*
 * Decompiled with CFR 0.152.
 */
package com.pg.listener;

import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.pcbd.domain.Components;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.ComponentSettingService;
import com.pg.service.JobConfigService;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class InitiateSettings {
    private static Logger logger = LoggerFactory.getLogger(InitiateSettings.class);
    private ComponentSettingService componentSettingService;
    private JobConfigService jobConfigService;

    public ComponentSettingService getComponentSettingService() {
        return this.componentSettingService;
    }

    public void setComponentSettingService(ComponentSettingService componentSettingService) {
        this.componentSettingService = componentSettingService;
    }

    public void setJobConfigService(JobConfigService jobConfigService) {
        this.jobConfigService = jobConfigService;
    }

    public void initiateComponentProperty() {
        this.initiatePropertiesFromDB();
    }

    private void initiatePropertiesFromDB() {
        logger.debug("Inside InitiateSettings1");
        Properties props = null;
        try {
            ClassPathResource resource = new ClassPathResource("privacygateway.properties");
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
            Components components = this.componentSettingService.getComponents(props.getProperty("componentName"), 1);
            logger.debug("getting components properties from db of" + components.getComponentName());
            Map componentProperties = components.getComponentsProperties();
            CloudPropertyElement cloudPropertyElement = this.componentSettingService.getCloudPropertyElement(1);
            if (cloudPropertyElement == null) {
                logger.debug("cloud property element is null at the first time so setting default values");
                cloudPropertyElement = new CloudPropertyElement();
                this.setDefaultValuesToCloudPropertyElement(cloudPropertyElement);
                logger.debug("Cloud property element vlaue adfsurl>>" + cloudPropertyElement.getAdfsUrl());
            }
            PCHelperConstant.setComponentName((String)props.getProperty("componentName"));
            PCHelperConstant.setPropertyFileValueParacloudMountPoint((String)cloudPropertyElement.getMntParacloudPath());
            PCHelperConstant.setPropertyFileValueSslAuthEnabled((String)String.valueOf(cloudPropertyElement.getSslAuthEnabled()));
            logger.debug(PCHelperConstant.getComponentName() + "...Paracloud path----" + PCHelperConstant.getPropertyFileValueParacloudMountPoint());
            if (componentProperties.containsKey("encryptionEnabled")) {
                PCHelperConstant.setPropertyFileValueEncryptionEnabled((String)((String)componentProperties.get("encryptionEnabled")));
            }
            if (componentProperties.containsKey("ftpHost")) {
                PCHelperConstant.setSyncFtpHostProperty((String)((String)componentProperties.get("ftpHost")));
            }
            if (componentProperties.containsKey("syncUploadPath")) {
                PCHelperConstant.setPropertyFileValueSyncUploadPath((String)((String)componentProperties.get("syncUploadPath")));
            }
            if (componentProperties.containsKey("syncFtpEnabled")) {
                PCHelperConstant.setPropertyFileValueSyncFtpEnabled((String)((String)componentProperties.get("syncFtpEnabled")));
            }
            if (componentProperties.containsKey("localStorageEnabled")) {
                PCHelperConstant.setPropertyFileValueLocalStorageEnabled((String)((String)componentProperties.get("localStorageEnabled")));
            }
            if (componentProperties.containsKey("ftpUser")) {
                PCHelperConstant.setSyncFtpUserProperty((String)((String)componentProperties.get("ftpUser")));
            }
            if (componentProperties.containsKey("ftpPwd")) {
                PCHelperConstant.setSyncFtpPwdProperty((String)((String)componentProperties.get("ftpPwd")));
            }
            if (componentProperties.containsKey("odbFrequencyCallValue")) {
                PCHelperConstant.setODBCallFrequency((String)((String)componentProperties.get("odbFrequencyCallValue")));
            }
            if (componentProperties.containsKey("queryLimit")) {
                PCHelperConstant.setQueryLimit((String)((String)componentProperties.get("queryLimit")));
            }
            if (componentProperties.containsKey("proxyPassword")) {
                PCHelperConstant.setProxyPassword((String)((String)componentProperties.get("proxyPassword")));
            }
            if (componentProperties.containsKey("paracloudUrl")) {
                PCHelperConstant.setPropertyFileValueParacloudUrl((String)((String)componentProperties.get("paracloudUrl")));
            }
            if (componentProperties.containsKey("localdbhost")) {
                PCHelperConstant.setPropertyFileValueForLocalDBUrl((String)((String)componentProperties.get("localdbhost")));
            }
            if (componentProperties.containsKey("gatewayName")) {
                PCHelperConstant.setPropertyFileValueGatewayname((String)((String)componentProperties.get("gatewayName")));
            }
            if (componentProperties.containsKey("odbUserAgentVal")) {
                PCHelperConstant.setODBDecorationValue((String)((String)componentProperties.get("odbUserAgentVal")));
            }
            if (componentProperties.containsKey("odbRetryFolderVal")) {
                PCHelperConstant.setRetryOdbFolderValue((String)((String)componentProperties.get("odbRetryFolderVal")));
            }
            if (componentProperties.containsKey("bkpColQueryRequired")) {
                PCHelperConstant.setBackupCollectionQueryRequired((String)((String)componentProperties.get("bkpColQueryRequired")));
            }
            if (componentProperties.containsKey("chunkColQueryRequired")) {
                PCHelperConstant.setChunkCollectionQueryRequired((String)((String)componentProperties.get("chunkColQueryRequired")));
            }
            if (componentProperties.containsKey("chunkTotalBuckets")) {
                PCHelperConstant.setChunkTotalBuckets((String)((String)componentProperties.get("chunkTotalBuckets")));
            }
            if (componentProperties.containsKey("updateGatewayWhenChunkNotFound")) {
                PCHelperConstant.setPropertyFileValueUpdatepgnameWhenChunkNotFoundMultipgenv((String)((String)componentProperties.get("updateGatewayWhenChunkNotFound")));
            }
            if (componentProperties.containsKey("deleteBkpTblWhenChnkNotFound")) {
                PCHelperConstant.setPropertyFileValueDeleteBkptblWhenChunksNotFound((String)((String)componentProperties.get("deleteBkpTblWhenChnkNotFound")));
            }
            if (componentProperties.containsKey("noOfJobThreads")) {
                PCHelperConstant.setJobThreadLimit((String)((String)componentProperties.get("noOfJobThreads")));
            }
            if (componentProperties.containsKey("chunkUpdateMaxRetry")) {
                PCHelperConstant.setMaxRetryForChunkUpdate((String)((String)componentProperties.get("chunkUpdateMaxRetry")));
            }
            if (componentProperties.containsKey("proxyHost")) {
                PCHelperConstant.setProxyHost((String)((String)componentProperties.get("proxyHost")));
            }
            if (componentProperties.containsKey("proxyPort")) {
                PCHelperConstant.setProxyPort((String)((String)componentProperties.get("proxyPort")));
            }
            if (componentProperties.containsKey("proxyUserName")) {
                PCHelperConstant.setProxyUserName((String)((String)componentProperties.get("proxyUserName")));
            }
            if (componentProperties.containsKey("pgOverloadLimit")) {
                PCHelperConstant.setPGOverloadLimit((String)((String)componentProperties.get("pgOverloadLimit")));
            }
            if (componentProperties.containsKey("pgOverLoadInactivityPeriod")) {
                PCHelperConstant.setPGOverLoadInactivityPeriod((String)((String)componentProperties.get("pgOverLoadInactivityPeriod")));
            }
            if (componentProperties.containsKey("resoreQueryLimit")) {
                PCHelperConstant.setRestoreQueryLimit((String)((String)componentProperties.get("resoreQueryLimit")));
            }
            if (componentProperties.containsKey("stopJobsEnabled")) {
                PCHelperConstant.setJobsStopEnabled((String)((String)componentProperties.get("stopJobsEnabled")));
            }
            if (componentProperties.containsKey("noOfThreads")) {
                PCHelperConstant.setThreadLimit((String)((String)componentProperties.get("noOfThreads")));
            }
            if (this.jobConfigService.getJobConfigByServerName(1, components.getComponentName()) != null) {
                PCHelperConstant.setJobConfig(this.jobConfigService.getJobConfigByServerName(1, components.getComponentName()));
            }
            logger.debug("Job Thread Limit" + PCHelperConstant.getJobThreadLimit());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("  ********************EXCEPTION while trying to load " + e.getMessage());
        }
    }

    private void setDefaultValuesToCloudPropertyElement(CloudPropertyElement cloudProperty2Element) {
        CloudPropertyElement cloudPropertyElement = cloudProperty2Element;
        cloudPropertyElement.setMntParacloudPath("/mnt/");
        cloudPropertyElement.setSslAuthEnabled(false);
    }
}

