/*
 * Decompiled with CFR 0.152.
 */
package com.pg.listener;

import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluKryptListener
implements ServletContextListener {
    private static Logger logger = LoggerFactory.getLogger(BluKryptListener.class);
    private static final String IS_TOMCAT_RUNNING = "isTomcatRunning";

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        logger.debug("..............Tomact job has been strated........");
        MemoryStore.add((String)IS_TOMCAT_RUNNING, (Object)true);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        MemoryStore.delete((String)IS_TOMCAT_RUNNING);
        MemoryStore.add((String)IS_TOMCAT_RUNNING, (Object)false);
        logger.debug("....In MemoryStore disable istomcatrunning..");
        logger.debug(".............. Tomact is going to stop after 60 seconds ........" + MemoryStore.get((String)IS_TOMCAT_RUNNING));
        try {
            logger.debug(Thread.currentThread().getName() + ".............start thread sleep.............for 60 seconds .." + System.currentTimeMillis());
            Thread.currentThread();
            Thread.sleep(TimeUnit.SECONDS.toMillis(60L));
            logger.debug(Thread.currentThread().getName() + "............. TomactTHREAD ENDED................." + System.currentTimeMillis());
        }
        catch (InterruptedException e) {
            logger.error(" exception in BlukryptJobStopHandle......." + e.getMessage());
            logger.trace("exception in BlukryptJobStopHandle......." + e);
        }
        logger.debug("Shutting down..... !");
    }

    private void getServerVersion() {
        try (Stream<String> stream = Files.lines(Paths.get(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "installed_version", new String[0]));){
            logger.debug("The Product Version of Server :" + stream.findFirst().orElse("<N/A>"));
        }
        catch (IOException e) {
            logger.trace("Exception for failed to get Server Version..." + e);
            logger.error("error failed to get server version");
        }
    }
}

