/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.mongodb.MongoException;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.SearchIndex;
import com.pg.controller.BaseController;
import com.pg.domain.BackupFile;
import com.pg.domain.BackupLog;
import com.pg.domain.FileInfo;
import com.pg.element.BackupElement;
import com.pg.element.BluKryptElement;
import com.pg.element.ChunkFileElement;
import com.pg.element.FileUploadDetailsElement;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.BackupService;
import com.pg.service.ChunkableUploadService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class UploadController
extends BaseController {
    public static final String HYPHEN_BOTH = "-Both";
    private static Logger logger = LoggerFactory.getLogger(UploadController.class);
    private static final String IS_TOMCAT_RUNNING = "isTomcatRunning";
    @Autowired
    private UploadService uploadService;
    @Autowired
    private ChunkableUploadService chunkableUploadService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private UtilService utilService;
    private static final String USER_STORAGE_LIMIT_REACHED = " User Storage limit reached ..... ";
    private static final String DIRECT_CALL_STORAGE_LIMIT = " direct call .... storage limit .......";
    private static final String UPLOAD_COUNT = "uploadCount";
    private static final String DEVICEUUID_MAP_IN_MEMSTORE = "deviceUUIDMapInMemstore";
    private static final String HYPHEN_FULL = "-FULL";
    private static final String HYPHEN_INCRE = "-INCRE";
    private static final String JOB_ID = "JobId";
    private static final String CHUNK = "chunk";
    private static final String UNABLE_TO_DELETE = " unable to delete ... ";
    private static final String PG_OVERLOAD_LIMIT_REACHED = " PG OVERLOAD limit reached ..... ";
    private static final String ALREADY_EXISTS = "ALREADY_EXISTS";
    private static final String BATCH_ID_LOG = "##batch id >>>>";
    private static final String IS_A_CHUNK_FILE = "isAChunkFile";
    private static final String PARACLOUD_CLOUD = "/paracloud/cloud/";
    private static final String BACKUP_ID = "backupId";
    private static final String FALSE = "false";
    private static final String IS_NORMAL_FILE = "isNormalFile";
    private static final String STOPPED_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSED_BACKUP_ERROR_CODE = "1992";

    @RequestMapping(value={"/upload/files/all"}, method={RequestMethod.POST})
    public void uploadMultiPartFiles(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Start multipart file DEBUG.........");
        String boundary = "--PARABLUEOF";
        byte[] bryBytes = boundary.getBytes();
        String deviceUUID = "";
        String batchId = "";
        BufferedInputStream in = null;
        Map<String, String> headerMap = null;
        int response = 0;
        long startTimeStamp = System.currentTimeMillis();
        try {
            in = new BufferedInputStream((InputStream)request.getInputStream(), 10240);
            MultipartStream multipartStream = new MultipartStream((InputStream)in, bryBytes, 4096);
            boolean nextPart = multipartStream.skipPreamble();
            logger.debug(" nextpart ...... " + nextPart + "<<<<<<<<<");
            boolean isFirstPart = false;
            int totalNoOfFiles = 0;
            long totalSize = 0L;
            Cloud cloud = this.utilService.getCloud(1);
            Device device = null;
            int cloudId = cloud.getCloudId();
            String cloudName = cloud.getCloudName();
            String userName = "";
            boolean isFullBackup = false;
            boolean anySuccessUpload = false;
            ArrayList<BackupFile> failedList = new ArrayList<BackupFile>();
            long totalSizeToUpload = 0L;
            while (nextPart) {
                BackupBatch backupBatch;
                String header = multipartStream.readHeaders();
                logger.debug(header + " header:");
                headerMap = UploadController.parseHeader(header);
                boolean isTomcatRunning = true;
                if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
                    isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
                }
                logger.debug("........Is tomcat running........." + isTomcatRunning);
                if (!isTomcatRunning) {
                    httpResponse.setStatus(502);
                    logger.error("..Tomcat is going to be stopped.. so not accepting backup....");
                    return;
                }
                if (!isFirstPart) {
                    deviceUUID = headerMap.get("deviceUUID");
                    batchId = headerMap.get("backupBatchId");
                    device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
                    if (device == null) {
                        httpResponse.setStatus(400);
                        logger.error(userName + "...Invalid device......" + deviceUUID);
                        return;
                    }
                    isFullBackup = this.isDeviceFullBackup(cloudId, deviceUUID);
                    logger.debug("valof...batchid." + batchId + "..." + "-1".equals(batchId));
                    if (org.springframework.util.StringUtils.isEmpty((Object)batchId) || "-1".equals(batchId)) {
                        logger.debug("#$#$... batchid -1... " + batchId + "...device..." + deviceUUID);
                        httpResponse.setStatus(502);
                        logger.error(PG_OVERLOAD_LIMIT_REACHED);
                        return;
                    }
                    userName = headerMap.get("userName");
                    isFirstPart = true;
                }
                if ((backupBatch = this.utilService.getBackupBatchById(cloudId, batchId)) != null && StringUtils.isNotEmpty((String)backupBatch.getErrorCode()) && (backupBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || backupBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE))) {
                    if (backupBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE)) {
                        httpResponse.setStatus(429);
                    } else {
                        httpResponse.setStatus(428);
                    }
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    return;
                }
                this.updateDeviceMapForChunk(deviceUUID, isFullBackup);
                double fileSizeInMb = this.getFileSizeInMb(headerMap);
                boolean isUserStorageLimitReached = this.utilService.isUserStorageLimitReached(1, fileSizeInMb, userName, deviceUUID);
                logger.debug(DIRECT_CALL_STORAGE_LIMIT + isUserStorageLimitReached);
                if (isUserStorageLimitReached) {
                    httpResponse.setStatus(449);
                    this.sendWarningMail(headerMap, this.utilService.userStorageLimit(cloudId, cloudName, device), device.getDeviceName());
                    logger.error(userName + USER_STORAGE_LIMIT_REACHED);
                    return;
                }
                String fileSizeInString = headerMap.get("file-size");
                boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
                if (isMachineStorageReached) {
                    httpResponse.setStatus(507);
                    logger.error(userName + "...Server disk full...");
                    return;
                }
                logger.debug("...valueof BatchID&...." + batchId + "...");
                httpResponse.setStatus(500);
                response = this.upload(headerMap, multipartStream, httpResponse, cloudId, device, failedList);
                if (response == 400) {
                    httpResponse.setStatus(500);
                    return;
                }
                if (!anySuccessUpload && response == 200) {
                    anySuccessUpload = true;
                }
                String isChunkOfAFile = FALSE;
                if (headerMap.get(IS_A_CHUNK_FILE) != null) {
                    isChunkOfAFile = headerMap.get(IS_A_CHUNK_FILE);
                }
                boolean isChunkOfFile = Boolean.parseBoolean(isChunkOfAFile);
                if (response == 200 && !isChunkOfFile) {
                    ++totalNoOfFiles;
                    long fileSize = Long.parseLong(headerMap.get("file-size"));
                    totalSize += fileSize;
                }
                if (backupBatch.getTotalSizeToUpload() != 0L) {
                    totalSizeToUpload = backupBatch.getTotalSizeToUpload();
                }
                logger.debug("Upload response code#####....." + response);
                nextPart = multipartStream.readBoundary();
            }
            if (anySuccessUpload) {
                this.updateBackupLog(headerMap, false, failedList);
                httpResponse.setStatus(200);
            }
            logger.debug("[backupBatch][" + userName + "][" + deviceUUID + "][" + batchId + "][" + startTimeStamp + "][" + System.currentTimeMillis() + "]");
            this.utilService.updateBackBatchAndOverview(cloudId, batchId, totalNoOfFiles, totalSize, deviceUUID, totalSizeToUpload);
        }
        catch (IOException e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            String path = PCHelperConstant.getMntTempChunkPath() + batchId;
            File deletePath = new File(path);
            if (deletePath.exists()) {
                try {
                    FileUtils.forceDelete((File)deletePath);
                    FileUtils.deleteDirectory((File)deletePath);
                }
                catch (IOException e1) {
                    logger.debug(UNABLE_TO_DELETE + e1);
                    logger.error(UNABLE_TO_DELETE + deletePath.getName() + "....." + deletePath.getPath() + "  ...  " + e1.getMessage());
                }
            }
            logger.error(batchId + ".....IOException While Uploading Multipart Files :" + e.getMessage());
        }
        catch (MongoException | DataAccessResourceFailureException e) {
            logger.debug("................Inside DataAccessResourceFailureException..." + e.getMessage());
            httpResponse.setStatus(500);
            return;
        }
        catch (Exception e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            logger.error(".....Exception While Uploading Multipart Files :" + e.getMessage());
        }
        logger.debug("End multipart file.........DEBUG");
    }

    private int upload(Map<String, String> headerMap, MultipartStream multipartStream, HttpServletResponse httpResponse, int cloudId, Device device, List<BackupFile> failedList) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        try {
            String md5;
            String deviceUUID = headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String chunkFilechecksum = headerMap.get("chunkFileMD5");
            String chunkFileName = headerMap.get("chunkFileName");
            batchId = headerMap.get("backupBatchId");
            String isChunkOfAFile = FALSE;
            String checkSum = md5 = headerMap.get("fileMD5");
            String isCompressed = headerMap.get("isCompressed");
            String isNormalFile = "true";
            if (headerMap.get(IS_A_CHUNK_FILE) != null) {
                isChunkOfAFile = headerMap.get(IS_A_CHUNK_FILE);
            }
            if (headerMap.get(IS_NORMAL_FILE) != null) {
                isNormalFile = headerMap.get(IS_NORMAL_FILE);
            }
            logger.debug(BATCH_ID_LOG + batchId);
            List<String> list = this.getChunkNames(headerMap);
            cloudName = bluKryptElement.getCloudName();
            String orgChunkName = Boolean.parseBoolean(isNormalFile) ? checkSum : (Boolean.parseBoolean(isChunkOfAFile) ? chunkFileName : "chunkHeader");
            File tempFilePath = this.createFileInBackupPath(headerMap, cloudName, orgChunkName + ".tmp");
            FileOutputStream restoreFileOutput = new FileOutputStream(tempFilePath);
            multipartStream.readBodyData((OutputStream)restoreFileOutput);
            restoreFileOutput.flush();
            ((OutputStream)restoreFileOutput).close();
            String fsPath = UploadController.getFsPath(md5);
            Base64InputStream inputStream = new Base64InputStream((InputStream)new FileInputStream(tempFilePath), false);
            String indexPath = "";
            logger.debug("index path" + indexPath);
            if (Boolean.parseBoolean(isChunkOfAFile) || Boolean.parseBoolean(isNormalFile)) {
                ChunkFileElement chunkFileElement = this.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
                String osType = headerMap.get("osType");
                this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), (InputStream)inputStream, chunkFileElement, osType, indexPath, batchId);
            } else if (inputStream != null) {
                list.clear();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)writer);
                String chunkList = writer.toString();
                list = new ArrayList<String>(Arrays.asList(chunkList.split(",")));
                checkSum = MD5Generator.generateMD5OfString((String)chunkList);
                headerMap.put("fileMD5", checkSum);
                if (tempFilePath.exists()) {
                    tempFilePath.delete();
                }
            }
            if (Boolean.parseBoolean(isChunkOfAFile)) {
                logger.debug(BATCH_ID_LOG + batchId + " $$$$$$$$$$$Inside a chunk file upload so return>>>>>>>>");
                this.closeInputStreamAndDelTempFile(tempFilePath, (InputStream)inputStream);
                return 203;
            }
            logger.debug(" Before calling insert query not chunkable ...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), device, list, batchId, tempFilePath, (InputStream)inputStream);
            backupId = fileUploadDetailsElement.getBkpId();
            if (StringUtils.isEmpty((String)fileUploadDetailsElement.getBkpId())) {
                httpResponse.setStatus(500);
                this.closeInputStreamAndDelTempFile(tempFilePath, (InputStream)inputStream);
                return 400;
            }
            httpResponse.setStatus(200);
            if (ALREADY_EXISTS.equalsIgnoreCase(fileUploadDetailsElement.getBkpId())) {
                this.closeInputStreamAndDelTempFile(tempFilePath, (InputStream)inputStream);
                return 200;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.debug(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            if (!StringUtils.isEmpty((String)fileUploadDetailsElement.getBkpId())) {
                FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, list);
                boolean isFullBackup = this.isFullBackupEnabled(headerMap);
                if (isFullBackup) {
                    fileInfo.setFullBackup(true);
                }
                fileInfo.setRebackupFile(false);
                boolean saveSuccess = this.saveToInterimDb(fileInfo, cloudName, fileUploadDetailsElement, batchId, bluKryptElement, chunkFilechecksum, isCompressed, list);
                if (!saveSuccess) {
                    this.uploadService.removeBackupFile(cloudId, backupId, device.getDestCollection());
                    this.addFailedFileList(headerMap, failedList);
                    httpResponse.setStatus(500);
                    this.closeInputStreamAndDelTempFile(tempFilePath, (InputStream)inputStream);
                    return 400;
                }
            } else {
                logger.error(BATCH_ID_LOG + batchId + " Unable to get backupid from EBMS .. ");
                this.addFailedFileList(headerMap, failedList);
                httpResponse.setStatus(500);
                this.closeInputStreamAndDelTempFile(tempFilePath, (InputStream)inputStream);
                return 500;
            }
            httpResponse.setStatus(200);
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file..........." + backupId);
            logger.debug(".. start of adding search index...." + md5);
            bluKryptElement.setDeviceUUID(device.getDeviceUUID());
            this.closeInputStreamAndDelTempFile(tempFilePath, (InputStream)inputStream);
            this.delTempfolder(tempFilePath);
        }
        catch (Exception e) {
            if (device != null) {
                this.utilService.deleteBackupFile(cloudId, backupId, device);
            }
            httpResponse.setStatus(500);
            logger.trace("" + e);
            this.addFailedFileList(headerMap, failedList);
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading :" + e.getMessage());
            return 500;
        }
        return 200;
    }

    public static String getPropertyFileValueParabluFolderBasePath(String cloudName) {
        return PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/f/";
    }

    protected SearchIndex formSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, String fsPath, ObjectId deviceId) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setBackup(true);
        searchIndex.setDeviceUUID(bluKryptElement.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    public static String getFsPath(String md5) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd-MM-yyyy");
        Date date = new Date();
        String baseFolder = sdfDate.format(date) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + String.valueOf(date.getTime());
        String fileName = md5;
        return baseFolder + fileName;
    }

    private boolean saveToInterimDbForRebkp(FileInfo fileInfo, Cloud cloud, String batchId, BluKryptElement bluKryptElement, String chunkFilechecksum, String isCompressed, List<String> list, Device device) throws IOException {
        String deviceUUID = fileInfo.getDeviceUUID();
        List<String> orgChunks = list;
        if (!StringUtils.isEmpty((String)isCompressed)) {
            fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
        }
        fileInfo.setBatchId(batchId);
        String chunkPath = this.getUploadFilePath(deviceUUID, cloud.getCloudName(), batchId);
        List<String> destChunkNames = this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath);
        fileInfo.getChunkFiles().clear();
        fileInfo.getChunkFiles().addAll(destChunkNames);
        if (!StringUtils.isEmpty((String)chunkFilechecksum)) {
            List<String> resChunkList = this.getBackupIdAppendedToChunks(destChunkNames, fileInfo.getId());
            fileInfo.getChunkFiles().clear();
            fileInfo.getChunkFiles().addAll(resChunkList);
        }
        fileInfo.setGatewayName(bluKryptElement.getGatewayName());
        fileInfo.setReducePGSize(false);
        boolean sucess = this.updateSizeForRebackup(fileInfo, cloud, device, deviceUUID);
        if (sucess) {
            return this.uploadService.saveFileInfo(cloud.getCloudName(), bluKryptElement.getUserName(), fileInfo);
        }
        return true;
    }

    private boolean updateSizeForRebackup(FileInfo fileInfo, Cloud cloud, Device device, String deviceUUID) {
        boolean sucess = false;
        if (fileInfo != null && !StringUtils.isEmpty((String)fileInfo.getId())) {
            BackUpImage backupImage = this.uploadService.getBkpFileByIdAndDevice(cloud.getCloudId(), new ObjectId(fileInfo.getId()), device);
            if (backupImage != null) {
                sucess = true;
                if (backupImage.getSize() != 0L) {
                    long privBkpImageSize = backupImage.getSize();
                    long filesizeInKB = (long)Math.ceil((double)fileInfo.getSize().longValue() / 1024.0);
                    logger.debug("...filesizeInKB..." + filesizeInKB + "...privBkpImageSize..." + privBkpImageSize);
                    if (filesizeInKB != backupImage.getSize()) {
                        backupImage.setSize(filesizeInKB);
                        backupImage.setSizeInBytes(fileInfo.getSize().longValue());
                        logger.debug("..updated size in bytes...");
                        this.uploadService.saveImageToBackUp(cloud.getCloudId(), backupImage, device);
                        long deltaChangeInSize = filesizeInKB - privBkpImageSize;
                        this.utilService.updateStorageUtilized(1, deviceUUID, deltaChangeInSize, deltaChangeInSize, null);
                    }
                }
            } else {
                logger.debug("...bkpImage not found..." + fileInfo.getId() + "..." + device.getDeviceUUID());
            }
        }
        return sucess;
    }

    private String getBluKryptBackupType(String gatewayHeader) {
        String gatewayType = Optional.ofNullable(gatewayHeader).orElse(HYPHEN_BOTH);
        if ("Incremental".equalsIgnoreCase(gatewayType)) {
            gatewayType = HYPHEN_INCRE;
            logger.debug("Set Gateway Type INCRE");
        } else if ("Full".equalsIgnoreCase(gatewayType)) {
            logger.debug("Set Gateway Type FULL ..Recived : " + gatewayType);
            gatewayType = HYPHEN_FULL;
        } else {
            gatewayType = HYPHEN_BOTH;
        }
        return gatewayType;
    }

    private String getUploadFilePath(String deviceUUID, String cloudName, String batchId) {
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID;
        if (!StringUtils.isEmpty((String)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        return deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
    }

    private void checkNThrottleAndUploadFileV2(String cloudName, String gatewayName, InputStream inputStream, ChunkFileElement chunkFileElement, String osType, String indexPath, String batchId) throws InterruptedException {
        this.chunkableUploadService.uploadChunkableFileToBackUp(cloudName, inputStream, chunkFileElement, osType, false, indexPath, batchId);
    }

    private boolean checkMachineStorage(String fileSizeInString) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long incomingFileSize = Long.parseLong(fileSizeInString);
        long availableSpaceInServer = file.getFreeSpace();
        logger.debug("Total space for this machine.." + file.getTotalSpace() + "FREE_SIZE" + file.getFreeSpace() + "incoming File Size:" + incomingFileSize);
        if (availableSpaceInServer - incomingFileSize <= 0L) {
            logger.debug("Space in server is exceeded........");
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/delete/file"}, method={RequestMethod.GET})
    public void deleteFile(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering BlukryptBuilder deleteFile  ");
        try {
            String cloudName = request.getParameter("cloudName");
            String userName = request.getParameter("userName");
            String gatewayName = request.getParameter("gatewayName");
            String backupId = request.getParameter(BACKUP_ID);
            if (StringUtils.isEmpty((String)backupId)) {
                response.setStatus(400);
                return;
            }
            BackupFile backupFile = this.uploadService.getBackupFile(userName, cloudName, backupId, gatewayName);
            if (backupFile == null) {
                response.setStatus(400);
                return;
            }
            this.uploadService.deleteBackupFile(userName, cloudName, backupId, gatewayName);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.error("@@@@ Error while trying to delete files  " + e);
        }
    }

    @RequestMapping(value={"/ping/"}, method={RequestMethod.GET})
    public void pingCloud(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering Privacy Gateway ping  ");
        response.setStatus(200);
    }

    @RequestMapping(value={"/confirm/handshake"}, method={RequestMethod.GET})
    public void handshake(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering /confirm/handshake ");
        try {
            String deviceUUID = request.getHeader("deviceUUID");
            int cloudId = 1;
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            if (device == null) {
                response.setStatus(400);
                logger.error("...Invalid device......" + deviceUUID);
                return;
            }
            boolean isFullBackup = this.isDeviceFullBackup(cloudId, deviceUUID);
            String gatewayHeader = request.getHeader("gatewayType");
            String gatewayType = this.getBluKryptBackupType(gatewayHeader);
            this.updateInterruptedBackup(cloudId, deviceUUID);
            boolean isBackupAllowed = this.isBackupAllowed(deviceUUID, gatewayType, isFullBackup);
            if (isBackupAllowed) {
                response.setStatus(200);
            } else {
                response.setStatus(502);
                logger.error(PG_OVERLOAD_LIMIT_REACHED);
            }
        }
        catch (Exception e) {
            logger.error("..error trying to handshake .... " + e.getMessage());
            logger.trace("" + e);
            response.setStatus(502);
        }
    }

    private FileUploadDetailsElement insertEntryForBackupFromBK(Map<String, String> headerMap, String cloudName, String userName, Device device, List<String> list, String batchId, File tempFilePath, InputStream inputStream) {
        FileUploadDetailsElement fileUploadDetailsElement = new FileUploadDetailsElement();
        try {
            BackupElement fileElement = new BackupElement();
            fileElement.setFileName(headerMap.get("file-name"));
            fileElement.setFileCompletePath(headerMap.get("file-path"));
            if (headerMap.containsKey("accessTime")) {
                fileElement.setAccessTime(Long.valueOf(headerMap.get("accessTime")).longValue());
            }
            fileElement.setPresent(Boolean.valueOf(headerMap.get("is-exists")).booleanValue());
            fileElement.setFolder(Boolean.valueOf(headerMap.get("is-folder")).booleanValue());
            fileElement.setMd5Checksum(headerMap.get("fileMD5"));
            fileElement.setSize(Long.valueOf(headerMap.get("file-size")).longValue());
            String fileModifiedTimestamp = headerMap.get("modified");
            fileElement.setLastClientModifiedTime(Long.valueOf(fileModifiedTimestamp).longValue());
            fileElement.setBaseBackup(Boolean.valueOf(headerMap.get("is-base-folder")).booleanValue());
            if (StringUtils.isNotEmpty((String)PCHelperConstant.getPropertyFileValueLoadBalancerIp())) {
                fileElement.setGatewayName(PCHelperConstant.getPropertyFileValueLoadBalancerIp().trim());
            } else {
                fileElement.setGatewayName(headerMap.get("gatewayName"));
            }
            boolean isFullBackup = false;
            String fullBackup = headerMap.get("isFullBackup");
            if (!StringUtils.isEmpty((String)fullBackup)) {
                isFullBackup = Boolean.parseBoolean(fullBackup);
            }
            String userUnderLegalHold = headerMap.get("userUnderLegalHold");
            fileElement.setContainerName(headerMap.get("containerName"));
            fileElement.setContainerType(headerMap.get("containerType") == null ? "" : headerMap.get("containerType"));
            int uploadCount = 0;
            if (MemoryStore.get((String)UPLOAD_COUNT) != null) {
                uploadCount = (Integer)MemoryStore.get((String)UPLOAD_COUNT);
                logger.debug(" From MEMSTORE ........... " + uploadCount);
            }
            logger.debug(" Before calling uploadExternalFileToBackUp  insertEntryForBackupFromBK...........gateway name:" + fileElement.getGatewayName());
            fileUploadDetailsElement = this.backupService.uploadExternalFileToBackUp(1, cloudName, fileElement, device, userUnderLegalHold, isFullBackup);
            Map deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
            String deviceUUIDForBackup = "";
            if (deviceUUIDMap != null) {
                for (String key : deviceUUIDMap.keySet()) {
                    if (!key.contains(device.getDeviceUUID())) continue;
                    deviceUUIDForBackup = key;
                    break;
                }
            }
            logger.debug(" After calling uploadExternalFileToBackUp insertEntryForBackupFromBK..........." + deviceUUIDForBackup);
            if (StringUtils.isNotEmpty((String)deviceUUIDForBackup)) {
                deviceUUIDForBackup = deviceUUIDForBackup.replace(device.getDeviceUUID(), "");
            }
            logger.info("[backup][" + headerMap.get("gatewayName") + "][" + headerMap.get("backupBatchId") + "][" + userName + "][" + device.getDeviceName() + "][" + Thread.currentThread().getName() + "][" + fileElement.getFileName() + "][" + fileElement.getSize() + "][" + deviceUUIDForBackup + "][" + System.currentTimeMillis() + "]");
            MemoryStore.delete((String)UPLOAD_COUNT);
            MemoryStore.add((String)UPLOAD_COUNT, (Object)(++uploadCount));
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Inserting Entry For Backup From BK :" + e.getMessage());
        }
        return fileUploadDetailsElement;
    }

    private synchronized boolean isBackupAllowed(String deviceUUIDForBkp, String gatewayType, boolean isFullBackup) {
        String deviceUUIDForBackup = isFullBackup ? deviceUUIDForBkp + HYPHEN_FULL : deviceUUIDForBkp + HYPHEN_INCRE;
        Map<String, Long> deviceUUIDMap = new HashMap<String, Long>();
        boolean allowBackup = false;
        if (PCHelperConstant.getPGOverloadLimit() <= 0) {
            logger.error("...device overload limit reached ..... " + PCHelperConstant.getPGOverloadLimit());
            return allowBackup;
        }
        if (MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE) == null) {
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
            logger.debug("$$$$$$NewdeviceUUID First Time map initializtion  ........... " + deviceUUIDForBackup);
            return true;
        }
        deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
        if (deviceUUIDMap.containsKey(deviceUUIDForBackup) || deviceUUIDMap.size() < PCHelperConstant.getPGOverloadLimit()) {
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
            allowBackup = true;
        } else if (!HYPHEN_BOTH.equalsIgnoreCase(gatewayType)) {
            allowBackup = UploadController.checkForBackupsBasedOnGatewayType(deviceUUIDForBackup, deviceUUIDMap, gatewayType);
        }
        if (!allowBackup) {
            logger.debug("&&&%%% PG OVERLOAD Limit Reached  size........... " + deviceUUIDMap.size());
        } else {
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
            logger.debug("###@@@ NewdeviceUUID added for PG .......... " + deviceUUIDMap.size() + "...." + deviceUUIDForBackup);
        }
        return allowBackup;
    }

    public void updateDeviceMapForChunk(String deviceUUIDForBkp, boolean isFullBackup) {
        String deviceUUIDForBackup = isFullBackup ? deviceUUIDForBkp + HYPHEN_FULL : deviceUUIDForBkp + HYPHEN_INCRE;
        Map<String, Long> deviceUUIDMap = new HashMap<String, Long>();
        if (MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE) == null) {
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
        } else {
            deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
        }
    }

    private static void updateDeviceMap(String deviceUUIDForBackup, Map<String, Long> deviceUUIDMap) {
        deviceUUIDMap.put(deviceUUIDForBackup, System.currentTimeMillis());
        MemoryStore.add((String)DEVICEUUID_MAP_IN_MEMSTORE, deviceUUIDMap);
    }

    private void updateInterruptedBackup(int cloudId, String newDeviceDeviceUUID) {
        logger.debug("Inside update interrupted backup>>>>>>>");
        if (MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE) != null) {
            Map deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
            ArrayList<String> devicesToRemove = new ArrayList<String>();
            for (Map.Entry deviceObj : deviceUUIDMap.entrySet()) {
                String deviceUUIDVal = (String)deviceObj.getKey();
                if (deviceUUIDVal.contains(newDeviceDeviceUUID)) continue;
                Long deviceLastAccessedTime = (Long)deviceObj.getValue();
                logger.debug(" device uuid>>>>" + deviceUUIDVal);
                logger.debug(System.currentTimeMillis() + "current time<<<<  time +inactivity>>>" + (deviceLastAccessedTime + (long)PCHelperConstant.getPGOverLoadInactivityPeriod()));
                long inactivityPeriod = deviceLastAccessedTime + (long)PCHelperConstant.getPGOverLoadInactivityPeriod();
                logger.debug("in activity period>>>>" + inactivityPeriod);
                if (System.currentTimeMillis() > inactivityPeriod) {
                    String deviceUUID = deviceUUIDVal.substring(0, deviceUUIDVal.indexOf(45));
                    logger.debug("before updating inside device uuid>>>>" + deviceUUID);
                    this.utilService.updateInterruptedBackBatch(cloudId, deviceUUID);
                    devicesToRemove.add(deviceUUIDVal);
                    continue;
                }
                logger.debug("time stamp not exceeded the inactivity period" + deviceLastAccessedTime);
            }
            if (!CollectionUtils.isEmpty(devicesToRemove)) {
                for (String deviceToRemove : devicesToRemove) {
                    deviceUUIDMap.remove(deviceToRemove);
                }
            }
            MemoryStore.add((String)DEVICEUUID_MAP_IN_MEMSTORE, (Object)deviceUUIDMap);
        } else {
            logger.debug("memory store is nulll in memstore");
        }
    }

    public boolean isDeviceFullBackup(int cloudId, String deviceUUID) {
        boolean fullBackup = true;
        DeviceBackupOverView deviceBackupOverView = this.utilService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
        if (deviceBackupOverView != null && !StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime())) {
            logger.debug(" INCREMENTAL BACKUP for device .... " + deviceBackupOverView.getDeviceUUID());
            fullBackup = false;
        }
        logger.debug(" @@FULL BACKUP for device .... " + fullBackup);
        return fullBackup;
    }

    private static boolean checkForBackupsBasedOnGatewayType(String deviceUUIDForBackup, Map<String, Long> deviceUUIDMap, String gatewayType) {
        boolean allowBackupTemp = false;
        String deviceToRemove = UploadController.getDeviceToRemove(gatewayType);
        if (!StringUtils.isEmpty((String)deviceToRemove) && deviceUUIDForBackup.contains(gatewayType)) {
            logger.debug(" Removing incremental backup .... " + deviceToRemove + "..... Adding full backup ... " + deviceUUIDForBackup);
            deviceUUIDMap.remove(deviceToRemove);
            UploadController.updateDeviceMap(deviceUUIDForBackup, deviceUUIDMap);
            allowBackupTemp = true;
        }
        return allowBackupTemp;
    }

    private static String getDeviceToRemove(String gatewayType) {
        String backupTypeToRemove = HYPHEN_INCRE;
        if (gatewayType.equalsIgnoreCase(HYPHEN_INCRE)) {
            backupTypeToRemove = HYPHEN_FULL;
        }
        Map deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_MAP_IN_MEMSTORE);
        String deviceUUIDToRemove = "";
        for (String key : deviceUUIDMap.keySet()) {
            if (!key.contains(backupTypeToRemove)) continue;
            deviceUUIDToRemove = key;
            logger.debug("  deviceuuid to be removed in map ........... " + key);
            break;
        }
        return deviceUUIDToRemove;
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private void delTempfolder(File tempFilePath) {
        try {
            if (tempFilePath.exists()) {
                tempFilePath.delete();
            }
            if (tempFilePath.getParentFile().exists()) {
                FileUtils.deleteDirectory((File)tempFilePath.getParentFile());
            }
        }
        catch (IOException e) {
            logger.error("Unable to delette temp folder" + e.getMessage());
            logger.error("Unable to delette temp folder" + e);
        }
    }

    private List<String> moveFilesFromTmpPath(String deviceUUID, List<String> orgChunks, String chunkPath) throws IOException {
        ArrayList<String> chunkNames = new ArrayList<String>();
        for (String chunkName : orgChunks) {
            String path = PCHelperConstant.getMntTempChunkPath() + deviceUUID;
            String srcfilePath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
            File fileObj = new File(srcfilePath);
            if (!fileObj.exists()) continue;
            File chunkDir = new File(chunkPath);
            if (!chunkDir.exists()) {
                chunkDir.mkdirs();
            }
            String destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
            String newChunkName = chunkName;
            int dedupCount = 1;
            while (new File(destPath).exists()) {
                logger.debug("file is exist in destination path>>>>>>: " + destPath);
                destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName + "_" + dedupCount;
                newChunkName = chunkName + "_" + dedupCount;
                ++dedupCount;
            }
            chunkNames.add(newChunkName);
            File destFile = new File(destPath);
            Files.move(fileObj.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            logger.debug("destFile :" + destFile.getAbsolutePath());
        }
        return chunkNames;
    }

    private void closeInputStreamAndDelTempFile(File tempFilePath, InputStream inputStream) throws IOException {
        if (inputStream != null) {
            inputStream.close();
        }
        if (tempFilePath.exists()) {
            tempFilePath.delete();
        }
    }

    private ChunkFileElement createChunkFileElement(String deviceUUID, BluKryptElement bluKryptElement, String chunkFilechecksum, String chunkFileName, String checkSum, List<String> list) {
        ChunkFileElement chunkFileElement = new ChunkFileElement();
        if (CollectionUtils.isEmpty(list)) {
            logger.debug("List is empty sooo adding md5checksum" + checkSum);
            list.add(checkSum);
        }
        chunkFileElement.setFileChunks(list);
        chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
        chunkFileElement.setFileName(checkSum);
        chunkFileElement.setMd5checksum(checkSum);
        chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
        if (!StringUtils.isEmpty((String)chunkFilechecksum)) {
            chunkFileElement.setMd5checksum(chunkFilechecksum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(chunkFileName);
            chunkFileElement.setFileName(chunkFileName);
            chunkFileElement.setDeviceUUID(deviceUUID);
        }
        return chunkFileElement;
    }

    private File createFileInBackupPath(Map<String, String> headerMap, String cloudName, String fileName) throws IOException {
        String deviceTempPath = PCHelperConstant.getMntTempChunkPath() + headerMap.get("backupBatchId");
        File uploadBackupPath = new File(deviceTempPath);
        uploadBackupPath.mkdirs();
        String filePath = uploadBackupPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
        logger.debug(" *******************" + filePath);
        File tempFilePath = new File(filePath);
        if (tempFilePath.exists()) {
            logger.debug("Temp file exists so deleting the file####");
            tempFilePath.delete();
        }
        tempFilePath.createNewFile();
        return tempFilePath;
    }

    private List<String> getChunkNames(Map<String, String> headerMap) {
        String fileChunkNames = "";
        if (headerMap.get("fileChunkNames") != null) {
            fileChunkNames = headerMap.get("fileChunkNames");
        }
        List<String> list = new ArrayList<String>();
        if (!fileChunkNames.isEmpty()) {
            list = Arrays.asList(fileChunkNames.split(","));
        }
        return list;
    }

    private double getFileSizeInMb(Map<String, String> headerMap) {
        long fileSizeInBytes = Long.parseLong(headerMap.get("file-size"));
        long filesizeInKB = (long)Math.ceil((double)fileSizeInBytes / 1024.0);
        return UploadController.getSizeinMb(filesizeInKB);
    }

    private void addFailedFileList(Map<String, String> headerMap, List<BackupFile> failedList) {
        String fileName = headerMap.get("file-name");
        String sourceFilePath = headerMap.get("file-path");
        String md5 = headerMap.get("fileMD5");
        Long lastmodified = Long.valueOf(headerMap.get("modified"));
        Long size = Long.valueOf(headerMap.get("file-size"));
        BackupFile backupFile = new BackupFile();
        backupFile.setFileName(fileName);
        backupFile.setFilePath(sourceFilePath);
        backupFile.setMd5(md5);
        backupFile.setUploadedTimestamp(lastmodified);
        backupFile.setSize(size);
        failedList.add(backupFile);
    }

    private void updateBackupLog(Map<String, String> headerMap, boolean isuploadFailed, List<BackupFile> failedList) {
        String restartId = headerMap.get("restartId");
        String batchId = headerMap.get("backupBatchId");
        String cloudName = headerMap.get("cloudName");
        String deviceUUID = headerMap.get("deviceUUID");
        BackupLog backupLog = new BackupLog();
        backupLog.setId(new ObjectId(batchId));
        backupLog.setRestartId(Integer.valueOf(restartId).intValue());
        backupLog.setDeviceUUID(deviceUUID);
        backupLog.getFailedFiles().addAll(failedList);
        logger.debug(" Before updating backupLog...........");
        this.utilService.updateBackupLog(1, cloudName, backupLog);
        logger.debug(" After updating backupLog...........");
    }

    @RequestMapping(value={"/update/restartid"}, method={RequestMethod.POST})
    public void updateRestartID(HttpServletRequest request, HttpServletResponse httpResponse) {
        String restartId = request.getHeader("restartId");
        String batchId = request.getHeader("backupBatchId");
        String cloudName = request.getHeader("cloudName");
        String deviceUUID = request.getHeader("deviceUUID");
        BackupLog backupLog = new BackupLog();
        backupLog.setId(new ObjectId(batchId));
        backupLog.setRestartId(Integer.valueOf(restartId).intValue());
        backupLog.setDeviceUUID(deviceUUID);
        logger.debug(" Before updating backupLog...........");
        this.utilService.updateBackupLog(1, cloudName, backupLog);
        logger.debug(" After updating backupLog...........");
        httpResponse.setStatus(200);
    }

    private List<String> getBackupIdAppendedToChunks(List<String> newChunkList, String newBackupId) {
        ArrayList<String> resChunkList = new ArrayList<String>();
        for (String chunkName : newChunkList) {
            resChunkList.add(chunkName + "." + newBackupId);
        }
        Collections.sort(resChunkList);
        return resChunkList;
    }

    private boolean isFullBackupEnabled(Map<String, String> headerMap) {
        boolean isFullBackup = false;
        String fullBackup = headerMap.get("isFullBackup");
        if (!StringUtils.isEmpty((String)fullBackup)) {
            isFullBackup = Boolean.parseBoolean(fullBackup);
        }
        return isFullBackup;
    }

    @RequestMapping(value={"/upload/files/rebkp"}, method={RequestMethod.POST})
    public void reuploadMultiPartFiles(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Start reuploadMultiPartFiles file DEBUG.........");
        String boundary = "--PARABLUEOF";
        byte[] bryBytes = boundary.getBytes();
        String batchId = "";
        BufferedInputStream in = null;
        Map<String, String> headerMap = null;
        int response = 0;
        try {
            in = new BufferedInputStream((InputStream)request.getInputStream(), 10240);
            MultipartStream multipartStream = new MultipartStream((InputStream)in, bryBytes, 4096);
            boolean nextPart = multipartStream.skipPreamble();
            logger.debug(" nextpart ...... " + nextPart + "<<<<<<<<<");
            int i = 1;
            while (nextPart) {
                String header = multipartStream.readHeaders();
                logger.debug(header + " header:" + i);
                headerMap = UploadController.parseHeader(header);
                httpResponse.setStatus(500);
                response = this.reupload(headerMap, multipartStream, httpResponse, i);
                logger.debug("Upload response code#####....." + response);
                nextPart = multipartStream.readBoundary();
                ++i;
            }
        }
        catch (IOException e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            this.deleteTmpChunkFilesIfAnyException(batchId);
            logger.error(batchId + ".....IOException While Uploading Multipart Files :" + e.getMessage());
        }
        catch (Exception e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            logger.error(".....Exception While Uploading Multipart Files :" + e.getMessage());
        }
        logger.debug("End multipart file.........DEBUG");
    }

    private int reupload(Map<String, String> headerMap, MultipartStream multipartStream, HttpServletResponse httpResponse, int uploadCount) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        try {
            Cloud cloud = this.utilService.getCloud(1);
            String deviceUUID = headerMap.get("deviceUUID");
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            if (device == null) {
                httpResponse.setStatus(400);
                logger.error("...Invalid device......" + deviceUUID);
                return 500;
            }
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = headerMap.get("file-size");
            String chunkFilechecksum = headerMap.get("chunkFileMD5");
            String chunkFileName = headerMap.get("chunkFileName");
            batchId = headerMap.get("backupBatchId");
            String isChunkOfAFile = FALSE;
            String checkSum = headerMap.get("fileMD5");
            String isCompressed = headerMap.get("isCompressed");
            String isNormalFile = "true";
            long fileSize = Long.parseLong(headerMap.get("file-size"));
            if (headerMap.get(IS_A_CHUNK_FILE) != null) {
                isChunkOfAFile = headerMap.get(IS_A_CHUNK_FILE);
            }
            if (headerMap.get(IS_NORMAL_FILE) != null) {
                isNormalFile = headerMap.get(IS_NORMAL_FILE);
            }
            logger.debug(BATCH_ID_LOG + batchId);
            List<String> list = this.getChunkNames(headerMap);
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return 507;
            }
            cloudName = bluKryptElement.getCloudName();
            String orgChunkName = Boolean.parseBoolean(isNormalFile) ? checkSum : (Boolean.parseBoolean(isChunkOfAFile) ? chunkFileName : "chunkHeader");
            File tempFilePath = this.createFileInBackupPath(headerMap, cloudName, orgChunkName + ".tmp");
            FileOutputStream restoreFileOutput = new FileOutputStream(tempFilePath);
            multipartStream.readBodyData((OutputStream)restoreFileOutput);
            restoreFileOutput.flush();
            ((OutputStream)restoreFileOutput).close();
            Base64InputStream inputStream = new Base64InputStream((InputStream)new FileInputStream(tempFilePath), false);
            String fsPath = UploadController.getFsPath(headerMap.get("fileMD5"));
            String indexPath = UploadController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            logger.debug("index path" + indexPath);
            if (Boolean.parseBoolean(isChunkOfAFile) || Boolean.parseBoolean(isNormalFile)) {
                ChunkFileElement chunkFileElement = this.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
                String osType = headerMap.get("osType");
                this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), (InputStream)inputStream, chunkFileElement, osType, indexPath, batchId);
            } else if (inputStream != null) {
                list.clear();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)writer);
                String chunkList = writer.toString();
                list = new ArrayList<String>(Arrays.asList(chunkList.split(",")));
                checkSum = MD5Generator.generateMD5OfString((String)chunkList);
                headerMap.put("fileMD5", checkSum);
                if (tempFilePath.exists()) {
                    tempFilePath.delete();
                }
            }
            if (Boolean.parseBoolean(isChunkOfAFile)) {
                logger.debug(BATCH_ID_LOG + batchId + " $$$$$$$$$$$Inside a chunk file upload so return>>>>>>>>");
                this.closeInputStreamAndDelTempFile(tempFilePath, (InputStream)inputStream);
                return 200;
            }
            backupId = headerMap.get(BACKUP_ID);
            httpResponse.setStatus(200);
            if (StringUtils.isEmpty((String)backupId)) {
                this.closeInputStreamAndDelTempFile(tempFilePath, (InputStream)inputStream);
                logger.error(" Backup id is empty.............");
                return 500;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.debug(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            if (!StringUtils.isEmpty((String)backupId)) {
                FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, list);
                fileInfo.setSize(Long.valueOf(fileSize));
                if (!StringUtils.isEmpty((String)headerMap.get(JOB_ID))) {
                    fileInfo.setServerBackupJobId(headerMap.get(JOB_ID));
                }
                fileInfo.setRebackupFile(true);
                boolean uploadSucess = this.saveToInterimDbForRebkp(fileInfo, cloud, batchId, bluKryptElement, chunkFilechecksum, isCompressed, list, device);
                if (!uploadSucess) {
                    this.uploadService.removeBackupFile(cloud.getCloudId(), backupId, device.getDestCollection());
                    httpResponse.setStatus(500);
                    this.closeInputStreamAndDelTempFile(tempFilePath, (InputStream)inputStream);
                    return 500;
                }
                String gateWayName = headerMap.get("gatewayName");
                if (!StringUtils.isEmpty((String)gateWayName)) {
                    this.utilService.updateGatewayInBackupImage(backupId, gateWayName);
                }
                this.uploadService.deleteFileInfoFromReBackup(cloudName, new ObjectId(backupId));
                httpResponse.setStatus(200);
                logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
            }
            this.closeInputStreamAndDelTempFile(tempFilePath, (InputStream)inputStream);
            this.delTempfolder(tempFilePath);
        }
        catch (UncategorizedJmsException e) {
            logger.error(BATCH_ID_LOG + batchId + " JMSException connection refused exception backup upload ....... " + backupId);
            logger.trace("" + (Object)((Object)e));
            httpResponse.setStatus(500);
            return 500;
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace("" + e);
            logger.error(" Exception While Uploading :" + e.getMessage());
            return 500;
        }
        return 200;
    }

    private void deleteTmpChunkFilesIfAnyException(String batchId) {
        String path = PCHelperConstant.getMntTempChunkPath() + batchId;
        File deletePath = new File(path);
        if (deletePath.exists()) {
            try {
                FileUtils.forceDelete((File)deletePath);
                FileUtils.deleteDirectory((File)deletePath);
            }
            catch (IOException e1) {
                logger.debug(UNABLE_TO_DELETE + e1);
                logger.error(UNABLE_TO_DELETE + deletePath.getName() + "....." + deletePath.getPath() + "  ...  " + e1.getMessage());
            }
        }
    }

    private void sendWarningMail(Map<String, String> headerMap, double userStorageQuata, String deviceName) {
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD + bluKryptElement.getCloudName() + "/mail";
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("isInternalCall", "true");
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)bluKryptElement.getUserName());
            emailDetails.put("action", (Object)"backup-limit-reached");
            emailDetails.put("actionOn", (Object)bluKryptElement.getUserName());
            emailDetails.put("deviceName", (Object)deviceName);
            emailDetails.put("customMailMessage", (Object)String.valueOf(userStorageQuata));
            emailDetails.put("toAdmins", true);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            logger.debug("Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    private boolean saveToInterimDb(FileInfo fileInfo, String cloudName, FileUploadDetailsElement fileDetailsElement, String batchId, BluKryptElement bluKryptElement, String chunkFilechecksum, String isCompressed, List<String> list) throws IOException {
        String deviceUUID = fileInfo.getDeviceUUID();
        List<String> orgChunks = list;
        if (!StringUtils.isEmpty((String)isCompressed)) {
            fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
        }
        fileInfo.setBatchId(batchId);
        String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
        List<String> destChunkNames = this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath);
        fileInfo.getChunkFiles().clear();
        fileInfo.getChunkFiles().addAll(destChunkNames);
        if (!StringUtils.isEmpty((String)chunkFilechecksum)) {
            List<String> resChunkList = this.getBackupIdAppendedToChunks(destChunkNames, fileInfo.getId());
            fileInfo.getChunkFiles().clear();
            fileInfo.getChunkFiles().addAll(resChunkList);
        }
        fileInfo.setGatewayName(bluKryptElement.getGatewayName());
        this.updateStorageUtilization(cloudName, fileDetailsElement, batchId, destChunkNames, deviceUUID);
        fileInfo.setReducePGSize(true);
        return this.uploadService.saveFileInfo(cloudName, bluKryptElement.getUserName(), fileInfo);
    }

    private void updateStorageUtilization(String cloudName, FileUploadDetailsElement fileDetailsElement, String batchId, List<String> list, String deviceUUID) {
        long pgChunkSize = 0L;
        if (!CollectionUtils.isEmpty(list)) {
            String chunkFolderPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
            chunkFolderPath = chunkFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            for (String chunkName : list) {
                try {
                    File file = new File(chunkFolderPath + chunkName).getAbsoluteFile();
                    pgChunkSize += file.length() / 1024L;
                }
                catch (Exception e) {
                    logger.debug(".......Exception...." + e.getMessage());
                }
            }
        }
        logger.debug("..................total pgChunkSizeInKB............" + pgChunkSize);
        this.utilService.updateStorageUtilized(1, deviceUUID, fileDetailsElement.getFileSize(), fileDetailsElement.getLatestVersionSize(), pgChunkSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/upload/demoFile"}, method={RequestMethod.POST})
    public void uploadBackUpFile1(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(".....$$$$$$$$$$........Called new api upload/demoFile");
        ServletInputStream inputStream = null;
        try {
            File tempFilePath = new File("/parablu/temp.tmp");
            if (tempFilePath.exists()) {
                tempFilePath.delete();
            }
            tempFilePath.createNewFile();
            logger.debug("before read.....$$$$$$$$$$......" + System.currentTimeMillis());
            inputStream = request.getInputStream();
            logger.debug("after read.....$$$$$$$$$$......" + System.currentTimeMillis());
            if (inputStream != null) {
                UploadController.copyInputStreamToFile((InputStream)inputStream, tempFilePath);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.trace("" + e);
                    logger.error("Exception :", (Object)e.getMessage());
                }
            }
            try {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("Exception :", (Object)e.getMessage());
            }
        }
    }

    private static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        logger.debug("before write......" + System.currentTimeMillis());
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int read;
            byte[] bytes = new byte[4096];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        logger.debug("after write......" + System.currentTimeMillis());
    }

    @RequestMapping(value={"/cloud/{cloudName}/checkODBFolders"}, method={RequestMethod.POST})
    public void checkODBFolders(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(".....$$$$$$$$$$........Called new api checkODBFolders");
        try {
            File tempFilePath = new File("/parablu/reports/odbCheck.log");
            if (tempFilePath.exists()) {
                tempFilePath.delete();
            }
            tempFilePath.createNewFile();
            Cloud cloud = this.utilService.getCloud(1);
            StringBuilder checkOdbFolders = this.uploadService.checkOdbFolders(cloud, new StringBuilder());
            logger.debug("Final..." + checkOdbFolders);
            if (StringUtils.isEmpty((String)checkOdbFolders.toString())) {
                checkOdbFolders = new StringBuilder("No counterfeit found");
            }
            UploadController.appendStrToFile(tempFilePath.getAbsolutePath(), checkOdbFolders.toString());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    public static void appendStrToFile(String fileName, String str) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName, true));
            out.write(str);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

