/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.SearchIndex;
import com.pg.controller.BaseController;
import com.pg.domain.BackupFile;
import com.pg.domain.FileInfo;
import com.pg.element.BluKryptElement;
import com.pg.element.ChunkFileElement;
import com.pg.element.SyncFileElement;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.ChunkableUploadService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncUploadService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SyncUploadController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(SyncUploadController.class);
    @Autowired
    private UploadService uploadService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private ChunkableUploadService chunkableUploadService;
    @Autowired
    private SyncUploadService syncUploadService;
    private static final String USER_STORAGE_LIMIT_REACHED = " User Storage limit reached ..... ";
    private static final String AFTER_INSERT_ENTRY_FOR_SYNC = "  After insertEntryForSync ...";
    private static final String UNABLE_TO_GET_BACKUPID_FROM_EBMS = "Unable to get backupid from EBMS .. ";
    private static final String END_OF_ADD_SEARCH_INDEX = " End of Add search index ..........................";
    private static final String ERROR_WHILE_WRITE_CHUNK_FILES = "@@@@ Error while trying to write chunk files  ";
    private static final String END_OF_SAVE_TO_ONE_DRIVE = "End of save to one drive  ";
    private static final String PORTAL = "Portal";

    @RequestMapping(value={"/sync/upload/file/"}, method={RequestMethod.POST})
    public void uploadFileLatest(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("@@@Inside sync file upload ....  ");
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(request);
            logger.debug("@@@before calling check machine storage......");
            String fileSizeInString = request.getParameter("file-size");
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            MultipartFile file = multipartHttpServletRequest.getFile("file");
            InputStream inputStream = file.getInputStream();
            String checkSum = request.getParameter("fileMD5");
            ChunkFileElement chunkFileElement = new ChunkFileElement();
            ArrayList<String> list = new ArrayList<String>();
            list.add(checkSum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
            chunkFileElement.setFileName(checkSum);
            chunkFileElement.setMd5checksum(checkSum);
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
            String fsPath = SyncUploadController.getFsPath(checkSum);
            String indexPath = SyncUploadController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            this.uploadFile(bluKryptElement, inputStream, chunkFileElement, indexPath, null);
            httpResponse.setStatus(200);
            if (CollectionUtils.isEmpty(list)) {
                list.add(checkSum);
            }
            int cloudId = 1;
            logger.debug("  Before insertEntryForSync ..." + bluKryptElement.getFilePath());
            FileRevision revision = this.insertEntryForSync(cloudId, request, bluKryptElement);
            String syncRevisionId = revision.getId().toString();
            ConsolidatedImage consolidatedImage = revision.getConsolidatedImage();
            String consolidatedImageId = consolidatedImage.getId().toString();
            logger.debug(consolidatedImageId + AFTER_INSERT_ENTRY_FOR_SYNC + syncRevisionId);
            if (syncRevisionId != null) {
                FileInfo fileInfo = this.getFileInfo(bluKryptElement, syncRevisionId, list);
                fileInfo.setSize(bluKryptElement.getFileSize());
                fileInfo.setMd5(checkSum);
                boolean uploadSuccess = this.uploadService.saveFileInfoForSync(bluKryptElement.getCloudName(), bluKryptElement.getGatewayName(), fileInfo);
                if (!uploadSuccess) {
                    this.uploadService.removeSyncFile(cloudId, syncRevisionId, consolidatedImageId);
                    logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                    httpResponse.setStatus(500);
                } else {
                    httpResponse.setStatus(200);
                }
            } else {
                logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                httpResponse.setStatus(500);
            }
            SearchIndex index = this.formSearchIndex(1, bluKryptElement, consolidatedImage.getId(), consolidatedImage.isMiniCloud(), fsPath);
            this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
            logger.debug(END_OF_ADD_SEARCH_INDEX);
            this.closeInputStreamIfExists(request);
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e.getMessage());
            logger.trace("" + e);
        }
        logger.debug(END_OF_SAVE_TO_ONE_DRIVE);
    }

    private void uploadFile(BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement chunkFileElement, String indexPath, String batchId) {
        this.chunkableUploadService.uploadChunkableFileForSync(bluKryptElement, inputStream, chunkFileElement, indexPath, batchId);
    }

    private Map<String, String> uploadFileUsingPortal(String cloudName, BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement chunkFileElement, String indexPath, String fileTmpPath) throws InterruptedException {
        return this.chunkableUploadService.uploadChunkableFileForSyncPortal(cloudName, bluKryptElement, inputStream, chunkFileElement, true, indexPath, fileTmpPath);
    }

    private String checkNWThrottleAndUploadFileForChunks(BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement chunkFileElement, String backupId, String nextChunkFileName) throws InterruptedException {
        String nextChunkFileNameTemp = nextChunkFileName;
        if (StringUtils.isEmpty((String)backupId)) {
            nextChunkFileNameTemp = this.chunkableUploadService.uploadChunkableFileForSync(bluKryptElement, inputStream, chunkFileElement, null, null);
        }
        return nextChunkFileNameTemp;
    }

    @RequestMapping(value={"/sync/upload/file/chunks/"}, method={RequestMethod.POST})
    public void uploadFileChunks(HttpServletRequest request, HttpServletResponse httpResponse) {
        try {
            logger.debug("Entering uploadFileChunks ......  ");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(request);
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            InputStream inputStream = null;
            try {
                MultipartFile file = multipartHttpServletRequest.getFile("file");
                inputStream = file.getInputStream();
            }
            catch (IOException e) {
                logger.error("Error trying to get inpustream " + e.getMessage());
                logger.trace("" + e);
            }
            ChunkFileElement chunkFileElement = this.getChunkFileElementFromRequestHeader(request);
            String backupId = request.getParameter("backupId");
            String originalFileName = request.getParameter("originalFileName");
            bluKryptElement.setFileName(originalFileName);
            String nextChunkFileName = "-1";
            String fileSizeInString = request.getParameter("file-size");
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            nextChunkFileName = this.checkNWThrottleAndUploadFileForChunks(bluKryptElement, inputStream, chunkFileElement, backupId, nextChunkFileName);
            logger.debug(" NEXT CHUNK file name  ...." + nextChunkFileName);
            if ("-1".equals(nextChunkFileName)) {
                this.uploadFileExternalStorage(request, httpResponse);
            }
            httpResponse.setHeader("nextChunk", nextChunkFileName);
            httpResponse.setStatus(200);
            this.closeInputStreamIfExists(request);
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace("" + e);
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e);
        }
        logger.debug("@@@@ End of Uploading all chunks file drive  ");
    }

    public void uploadFileExternalStorage(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Entering uploadFileChunks ......  ");
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(request);
            String fileChunkNames = request.getParameter("fileChunkNames");
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(fileChunkNames.split(",")));
            logger.debug("check machine storage info..........................");
            String fileSizeInString = request.getParameter("file-size");
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            boolean isUserStorageLimitReached = this.checkIfUserStorageLimitReached(request, bluKryptElement.getCloudName(), bluKryptElement.getUserName());
            if (isUserStorageLimitReached) {
                httpResponse.setStatus(449);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            int cloudId = 1;
            FileRevision revision = this.insertEntryForSync(cloudId, request, bluKryptElement);
            String newSyncId = revision.getId().toString();
            if (newSyncId != null) {
                boolean uploadSuccess;
                String sizeString;
                FileInfo fileInfo = this.getFileInfo(bluKryptElement, newSyncId, list);
                String md5 = request.getParameter("fileMD5");
                if (!StringUtils.isEmpty((String)md5)) {
                    fileInfo.setMd5(md5);
                }
                if (!StringUtils.isEmpty((String)(sizeString = request.getParameter("file-size")))) {
                    long fileSize = Long.parseLong(sizeString);
                    fileInfo.setSize(Long.valueOf(fileSize));
                }
                if (!(uploadSuccess = this.uploadService.saveFileInfoForSync(bluKryptElement.getCloudName(), bluKryptElement.getGatewayName(), fileInfo))) {
                    this.uploadService.removeSyncFile(cloudId, newSyncId, revision.getConsolidatedImage().getId().toString());
                    logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                    httpResponse.setStatus(500);
                } else {
                    httpResponse.setStatus(200);
                }
            } else {
                httpResponse.setStatus(500);
            }
            logger.debug("@@@@ End of upload files to one drive  ");
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace("" + e);
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e.getMessage());
        }
    }

    private boolean checkMachineStorage(String fileSizeInString) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long incomingFileSize = 0L;
        if (!StringUtils.isEmpty((String)fileSizeInString)) {
            incomingFileSize = Long.valueOf(fileSizeInString);
        }
        long availableSpaceInServer = file.getFreeSpace();
        logger.debug("Total space for this machine.." + file.getTotalSpace() + "FREE_SIZE" + file.getFreeSpace() + "incoming File Size:" + incomingFileSize);
        if (availableSpaceInServer - incomingFileSize <= 0L) {
            logger.debug("Space in server is exceeded........");
            return true;
        }
        return false;
    }

    private boolean checkMachineStorageForPortalSync(HttpServletRequest request) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        String fileSizeInString = request.getHeader("file-size");
        long incomingFileSize = 0L;
        if (!StringUtils.isEmpty((String)fileSizeInString)) {
            incomingFileSize = Long.valueOf(fileSizeInString);
        }
        long availableSpaceInServer = file.getFreeSpace();
        logger.debug("Total space for this machine.." + file.getTotalSpace() + "FREE_SIZE" + file.getFreeSpace() + "incoming File Size:" + incomingFileSize);
        if (availableSpaceInServer - incomingFileSize <= 0L) {
            logger.debug("Space in server is exceeded........");
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/sync/ping/"}, method={RequestMethod.GET})
    public void pingCloud(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering Privacy Gateway ping  ");
        response.setStatus(200);
    }

    @RequestMapping(value={"/sync/delete/file"}, method={RequestMethod.GET})
    public void deleteFile(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering /sync/delete/file   ");
        try {
            String cloudName = request.getParameter("cloudName");
            String userName = request.getParameter("userName");
            String gatewayName = request.getParameter("gatewayName");
            String backupId = request.getParameter("backupId");
            if (StringUtils.isEmpty((String)backupId)) {
                response.setStatus(400);
                return;
            }
            BackupFile backupFile = this.uploadService.getBackupFile(userName, cloudName, backupId, gatewayName);
            if (backupFile == null) {
                response.setStatus(400);
                return;
            }
            this.uploadService.deleteBackupFile(userName, cloudName, backupId, gatewayName);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.error("@@@@ Error while trying to delete files  " + e);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/sync/portal/upload/cancel/"}, method={RequestMethod.POST})
    public void cancelFileLatest(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Inside portal/sync cancel file upload ....  " + request.getHeader("is-folder"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(request);
            bluKryptElement.setDeviceUUID(PORTAL);
            bluKryptElement.setOsType("Windows");
            logger.debug("before canceling upload......");
            boolean isSpecialCharsInFileName = false;
            char[] cArray = "/*\":<>".toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                if (!bluKryptElement.getFileName().contains(c.toString())) continue;
                isSpecialCharsInFileName = true;
                break;
            }
            if (isSpecialCharsInFileName) {
                logger.debug(" File name contains special characters .... ");
                httpResponse.setStatus(406);
                return;
            }
            String checkSum = request.getHeader("fileMD5");
            ChunkFileElement chunkFileElement = new ChunkFileElement();
            ArrayList<String> list = new ArrayList<String>();
            list.add(checkSum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
            chunkFileElement.setFileName(checkSum);
            chunkFileElement.setMd5checksum(checkSum);
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
            String fsPath = SyncUploadController.getFsPath(checkSum);
            bluKryptElement.setCloudName(cloudName);
            String indexPath = SyncUploadController.getPropertyFileValueParabluFolderBasePath(cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            boolean success = this.chunkableUploadService.cancelSyncFileUpload(cloudName, bluKryptElement, chunkFileElement, indexPath);
            if (success) {
                httpResponse.setStatus(200);
            } else {
                httpResponse.setStatus(507);
            }
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace("" + e);
            logger.error("@@@@ Error canceling file upload  " + e.getMessage());
        }
        logger.debug("End of canceling file upload ");
    }

    private FileRevision insertEntryForSync(int cloudId, Map<String, String> headerMap, BluKryptElement bluKryptElement) {
        SyncFileElement syncFileElement = new SyncFileElement();
        syncFileElement.setFileName(headerMap.get("file-name"));
        syncFileElement.setMetaData(headerMap.get("meta-data"));
        syncFileElement.setFileCompletePath(headerMap.get("file-path"));
        String compressionStatus = headerMap.get("isCompressed");
        boolean isCompressed = false;
        if (!StringUtils.isEmpty((String)compressionStatus)) {
            isCompressed = Boolean.parseBoolean(compressionStatus);
        }
        syncFileElement.setExists(Boolean.valueOf(headerMap.get("is-exists")).booleanValue());
        syncFileElement.setFolder(Boolean.valueOf(headerMap.get("is-folder")).booleanValue());
        syncFileElement.setMd5checksum(headerMap.get("fileMD5"));
        syncFileElement.setSize(headerMap.get("file-size"));
        String fileModifiedTimestamp = headerMap.get("modified");
        syncFileElement.setLastModifiedTimestamp(Long.valueOf(fileModifiedTimestamp).longValue());
        syncFileElement.setUserName(bluKryptElement.getUserName());
        syncFileElement.setGatewayName(bluKryptElement.getGatewayName());
        int miniCloudId = 0;
        String deviceUUID = headerMap.get("deviceUUID");
        Cloud cloud = this.utilService.getCloud(cloudId);
        FileRevision revision = null;
        try {
            revision = this.syncUploadService.insertSyncEntryForFile(cloudId, bluKryptElement.getCloudName(), cloud, syncFileElement, miniCloudId, deviceUUID, isCompressed);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Inserting Entry For Sync :" + e.getMessage());
        }
        return revision;
    }

    private FileRevision insertEntryForSync(int cloudId, HttpServletRequest request, BluKryptElement bluKryptElement) {
        SyncFileElement syncFileElement = new SyncFileElement();
        syncFileElement.setFileName(request.getParameter("file-name"));
        syncFileElement.setMetaData(request.getParameter("meta-data"));
        syncFileElement.setFileCompletePath(request.getParameter("file-path"));
        syncFileElement.setExists(Boolean.valueOf(request.getParameter("is-exists")).booleanValue());
        syncFileElement.setFolder(Boolean.valueOf(request.getParameter("is-folder")).booleanValue());
        syncFileElement.setMd5checksum(request.getParameter("fileMD5"));
        syncFileElement.setSize(request.getParameter("file-size"));
        String fileModifiedTimestamp = request.getParameter("modified");
        syncFileElement.setLastModifiedTimestamp(Long.valueOf(fileModifiedTimestamp).longValue());
        syncFileElement.setUserName(bluKryptElement.getUserName());
        int miniCloudId = 0;
        String deviceUUID = request.getParameter("deviceUUID");
        Cloud cloud = this.utilService.getCloud(cloudId);
        FileRevision revision = null;
        boolean isCompressed = false;
        try {
            revision = this.syncUploadService.insertSyncEntryForFile(cloudId, bluKryptElement.getCloudName(), cloud, syncFileElement, miniCloudId, deviceUUID, isCompressed);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Inserting Entry For Sync :" + e.getMessage());
        }
        return revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String insertEntryForSyncUsingHeaderVals(HttpServletRequest request, String cloudName, String userName, String maxVersionsToKeep, String md5) {
        String fileSize = request.getHeader("file-size");
        logger.debug("INSIDEinsert for sync ..... ");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/sync/portal/blukrypt/upload";
        HttpPost httpPost = new HttpPost(url);
        String syncRevisionId = null;
        try {
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("token", (ContentBody)new StringBody(request.getHeader("token")));
            entity.addPart("file-size", (ContentBody)new StringBody(fileSize));
            entity.addPart("file-name", (ContentBody)new StringBody(request.getHeader("file-name")));
            entity.addPart("file-path", (ContentBody)new StringBody(request.getHeader("file-path")));
            entity.addPart("is-exists", (ContentBody)new StringBody(request.getHeader("is-exists")));
            entity.addPart("is-folder", (ContentBody)new StringBody(request.getHeader("is-folder")));
            if (StringUtils.isEmpty((String)md5)) {
                entity.addPart("fileMD5", (ContentBody)new StringBody(request.getHeader("fileMD5")));
            } else {
                entity.addPart("fileMD5", (ContentBody)new StringBody(md5));
            }
            logger.debug(" FILE SIZE................... " + request.getHeader("file-size"));
            entity.addPart("file-size", (ContentBody)new StringBody(request.getHeader("file-size")));
            entity.addPart("is-base-folder", (ContentBody)new StringBody(request.getHeader("is-base-folder")));
            String deviceUUID = SyncUploadController.getValue(request, "deviceUUID");
            if (deviceUUID != null) {
                entity.addPart("deviceUUID", (ContentBody)new StringBody(deviceUUID));
            } else {
                entity.addPart("deviceUUID", (ContentBody)new StringBody(PORTAL));
            }
            entity.addPart("maxVersions", (ContentBody)new StringBody(maxVersionsToKeep));
            entity.addPart("userName", (ContentBody)new StringBody(userName));
            String gatewayName = SyncUploadController.getValue(request, "gatewayName");
            entity.addPart("gatewayName", (ContentBody)new StringBody(gatewayName));
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            Header[] headerarr = response.getAllHeaders();
            boolean isFileUnderMC = false;
            for (Header header : headerarr) {
                if ("syncRevisionId".equals(header.getName())) {
                    syncRevisionId = header.getValue();
                    logger.debug("Recieved sync revision Id for file ..... " + syncRevisionId);
                }
                if (!"isFileUnderMiniCloud".equals(header.getName())) continue;
                isFileUnderMC = Boolean.parseBoolean(header.getValue());
            }
            syncRevisionId = syncRevisionId + "-" + isFileUnderMC;
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception When Inserting Entry For Sync Using Header Values :" + e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
            httpclient.getConnectionManager().closeIdleConnections(1L, TimeUnit.MICROSECONDS);
            httpclient.getConnectionManager().shutdown();
        }
        return syncRevisionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfUserStorageLimitReached(HttpServletRequest request, String cloudName, String userName) {
        logger.debug("checkIfUserStorageLimitReached for backup ..... ");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/userStorage/limitReached/" + userName + "/";
        HttpPost httpPost = new HttpPost(url);
        boolean isUserStorageLimitReached = false;
        try {
            Header[] headerarr;
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            String fileSize = request.getParameter("file-size");
            entity.addPart("token", (ContentBody)new StringBody(request.getParameter("token")));
            entity.addPart("file-size", (ContentBody)new StringBody(fileSize));
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            for (Header header : headerarr = response.getAllHeaders()) {
                if (!"isUserStorageLimitReached".equals(header.getName())) continue;
                logger.debug("Recieved isUserStorageLimitReached for file ..... " + header.getValue());
                isUserStorageLimitReached = Boolean.parseBoolean(header.getValue());
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Checking User Storage Limit :" + e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
            httpclient.getConnectionManager().closeIdleConnections(1L, TimeUnit.MICROSECONDS);
            httpclient.getConnectionManager().shutdown();
        }
        return isUserStorageLimitReached;
    }

    protected SearchIndex formSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, boolean isFileUnderMC, String fsPath) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(isFileUnderMC);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        return searchIndex;
    }

    public static String getFsPath(String md5) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd-MM-yyyy");
        Date date = new Date();
        String baseFolder = sdfDate.format(date) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + String.valueOf(date.getTime());
        String fileName = md5;
        return baseFolder + fileName;
    }

    public static String getPropertyFileValueParabluFolderBasePath(String cloudName) {
        return PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/f/";
    }

    protected void tranferFileFromStream(InputStream inputStream, File intermediateFile) {
        byte[] b = new byte[4096];
        FileOutputStream outstream = null;
        try {
            int buff;
            MessageDigest md = MessageDigest.getInstance("MD5");
            intermediateFile.createNewFile();
            logger.debug(intermediateFile.length() + "  tranferFileFromStream  ................ " + intermediateFile.getPath());
            outstream = new FileOutputStream(intermediateFile);
            while ((buff = inputStream.read(b)) != -1) {
                outstream.write(b, 0, buff);
                md.update(b, 0, buff);
            }
            outstream.close();
            logger.debug(intermediateFile.length() + " after  tranferFileFromStream  ................ ");
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Transfering File From Stream :" + e.getMessage());
        }
    }

    @RequestMapping(value={"/sync/upload/files/all"}, method={RequestMethod.POST})
    public void uploadMultiPartFiles(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Start multipart file.........");
        String boundary = "--PARABLUEOF";
        byte[] bryBytes = boundary.getBytes();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream((InputStream)request.getInputStream(), 10240);
            logger.debug("file stream ........." + in);
            MultipartStream multipartStream = new MultipartStream((InputStream)in, bryBytes, 4096);
            boolean nextPart = multipartStream.skipPreamble();
            logger.debug(" nextpart ...... " + nextPart + "<<<<<<<<<");
            int i = 1;
            boolean isSyncRecorded = false;
            while (nextPart) {
                String header = multipartStream.readHeaders();
                logger.debug(header + " header:" + i);
                Map<String, String> headerMap = SyncUploadController.parseHeader(header);
                if (!isSyncRecorded) {
                    isSyncRecorded = true;
                }
                httpResponse.setStatus(500);
                this.upload(headerMap, multipartStream, httpResponse, i);
                nextPart = multipartStream.readBoundary();
                ++i;
            }
        }
        catch (Exception e) {
            this.closeInputStreamIfExists(request);
            logger.trace("" + e);
            logger.error("Exception When Uploading Multipart Files :" + e.getMessage());
        }
        logger.debug("End multipart file.........");
    }

    private void upload(Map<String, String> headerMap, MultipartStream multipartStream, HttpServletResponse httpResponse, int uploadCount) {
        String syncRevisionId = "";
        String consolidatedImageId = "";
        int cloudId = 1;
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String fileSizeInString = headerMap.get("file-size");
            String chunkFilechecksum = headerMap.get("chunkFileMD5");
            String chunkFileName = headerMap.get("chunkFileName");
            String batchId = headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = headerMap.get("fileMD5");
            String isNormalFile = "true";
            if (headerMap.get("isAChunkFile") != null) {
                isChunkOfAFile = headerMap.get("isAChunkFile");
            }
            if (headerMap.get("isNormalFile") != null) {
                isNormalFile = headerMap.get("isNormalFile");
            }
            logger.debug("@@@before calling check machine storage......");
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            String cloudName = bluKryptElement.getCloudName();
            String fileName = bluKryptElement.getFileName();
            logger.debug("$$$$$$before checking user storage$$$$$");
            double fileSizeInMb = this.getSizeinMb(Long.parseLong(headerMap.get("file-size")));
            logger.debug("$$$$$$ fileSizeInMb $$$$$$" + fileSizeInMb);
            boolean isUserStorageLimitReached = this.utilService.isSyncUserStorageLimitReached(1, fileSizeInMb, bluKryptElement.getUserName(), cloudName);
            if (isUserStorageLimitReached) {
                httpResponse.setStatus(449);
                this.sendWarningMail(headerMap, this.utilService.userSyncStorageLimit(cloudId, bluKryptElement.getUserName()));
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            File tempFilePath = this.createFileInSyncPath(headerMap, cloudName, fileName);
            FileOutputStream restoreFileOutput = new FileOutputStream(tempFilePath);
            multipartStream.readBodyData((OutputStream)restoreFileOutput);
            restoreFileOutput.flush();
            ((OutputStream)restoreFileOutput).close();
            Base64InputStream inputStream = new Base64InputStream((InputStream)new FileInputStream(tempFilePath), false);
            ChunkFileElement chunkFileElement = new ChunkFileElement();
            ArrayList<String> list = new ArrayList<String>();
            list.add(checkSum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
            chunkFileElement.setFileName(checkSum);
            chunkFileElement.setMd5checksum(checkSum);
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
            String fsPath = SyncUploadController.getFsPath(checkSum);
            String indexPath = SyncUploadController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            logger.debug("index path" + indexPath);
            if (Boolean.parseBoolean(isChunkOfAFile) || Boolean.parseBoolean(isNormalFile)) {
                chunkFileElement = this.createChunkFileElement(bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
                this.uploadFile(bluKryptElement, (InputStream)inputStream, chunkFileElement, indexPath, batchId);
            } else {
                list.clear();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)writer);
                String chunkList = writer.toString();
                list = new ArrayList<String>(Arrays.asList(chunkList.split(",")));
            }
            httpResponse.setStatus(200);
            if (CollectionUtils.isEmpty(list)) {
                list.add(checkSum);
            }
            logger.debug("  Before insertEntryForSync ..." + bluKryptElement.getFilePath());
            if (Boolean.parseBoolean(isChunkOfAFile)) {
                logger.debug("$$$$$$$$$$$Inside a chunk file upload so return>>>>>>>>");
                return;
            }
            FileRevision revision = this.insertEntryForSync(cloudId, headerMap, bluKryptElement);
            syncRevisionId = revision.getId().toString();
            ConsolidatedImage consolidatedImage = revision.getConsolidatedImage();
            consolidatedImageId = consolidatedImage.getId().toString();
            logger.debug(consolidatedImageId + AFTER_INSERT_ENTRY_FOR_SYNC + syncRevisionId);
            if (syncRevisionId != null) {
                FileInfo fileInfo = this.getFileInfo(bluKryptElement, syncRevisionId, list);
                fileInfo.setSize(bluKryptElement.getFileSize());
                fileInfo.setMd5(checkSum);
                fileInfo.setBatchId(batchId);
                fileInfo.setCompressed(revision.isCompressed());
                boolean uploadSuccess = this.uploadService.saveFileInfoForSync(bluKryptElement.getCloudName(), bluKryptElement.getGatewayName(), fileInfo);
                if (!uploadSuccess) {
                    this.uploadService.removeSyncFile(cloudId, syncRevisionId, consolidatedImageId);
                    logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                    httpResponse.setStatus(500);
                } else {
                    httpResponse.setStatus(200);
                }
            } else {
                logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                httpResponse.setStatus(500);
            }
            SearchIndex index = this.formSearchIndex(1, bluKryptElement, consolidatedImage.getId(), consolidatedImage.isMiniCloud(), fsPath);
            this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
            logger.debug(END_OF_ADD_SEARCH_INDEX);
        }
        catch (UncategorizedJmsException jmsException) {
            logger.error(" JMSException connection refused exception upload ....... " + syncRevisionId);
            logger.trace("" + (Object)((Object)jmsException));
            this.utilService.deleteRevision(cloudId, syncRevisionId, consolidatedImageId);
            httpResponse.setStatus(500);
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace("" + e);
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e.getMessage());
        }
        logger.debug(END_OF_SAVE_TO_ONE_DRIVE);
    }

    private double getSizeinMb(long size) {
        long filesizeInKB = (long)Math.ceil((double)size / 1024.0);
        double m = (double)filesizeInKB / 1024.0;
        logger.debug("$$$$$$Size----$$$$$" + m);
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private File createFileInSyncPath(Map<String, String> headerMap, String cloudName, String fileName) throws IOException {
        String batchId = headerMap.get("backupBatchId");
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + headerMap.get("deviceUUID") + "/" + batchId;
        File uploadSyncPath = new File(deviceTempPath);
        uploadSyncPath.mkdirs();
        String filePath = uploadSyncPath + "/" + fileName;
        logger.debug(" *******************" + filePath);
        File tempFilePath = new File(filePath);
        if (!tempFilePath.exists()) {
            tempFilePath.createNewFile();
        }
        return tempFilePath;
    }

    private ChunkFileElement createChunkFileElement(BluKryptElement bluKryptElement, String chunkFilechecksum, String chunkFileName, String checkSum, List<String> list) {
        ChunkFileElement chunkFileElement = new ChunkFileElement();
        if (CollectionUtils.isEmpty(list)) {
            logger.debug("List is empty sooo adding md5checksum" + checkSum);
            list.add(checkSum);
        }
        chunkFileElement.setFileChunks(list);
        chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
        chunkFileElement.setFileName(checkSum);
        chunkFileElement.setMd5checksum(checkSum);
        chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
        if (!StringUtils.isEmpty((String)chunkFilechecksum)) {
            chunkFileElement.setMd5checksum(chunkFilechecksum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(chunkFileName);
            chunkFileElement.setFileName(chunkFileName);
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
        }
        return chunkFileElement;
    }

    private static String getValue(HttpServletRequest request, String paramValue) {
        if (!StringUtils.isEmpty((String)request.getParameter(paramValue))) {
            return request.getParameter(paramValue);
        }
        return request.getHeader(paramValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/sync/portal/new/upload/file/"}, method={RequestMethod.POST})
    public ModelAndView uploadPortalFileLatest(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Inside new portal/sync file upload ....  " + request.getHeader("is-folder"));
        String syncRevisionId = "";
        String consolidatedImageId = "";
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        int cloudId = 0;
        InputStream inputStream = null;
        try {
            String fileTmpPath = SyncUploadController.getValue(request, "fileTmpPath");
            logger.debug("Inside portal/sync file upload path........." + fileTmpPath);
            inputStream = new FileInputStream(fileTmpPath);
            logger.debug("Inside portal/sync after reading stream ........");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(request);
            Cloud cloud = this.utilService.getCloud(1);
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
                cloudId = cloud.getCloudId();
            }
            String deviceUUID = SyncUploadController.getValue(request, "deviceUUID");
            String osType = SyncUploadController.getValue(request, "osType");
            logger.debug("$$$$$$ DeviceUUID $$$$$$" + deviceUUID);
            if (deviceUUID != null && osType != null) {
                bluKryptElement.setDeviceUUID(deviceUUID);
                bluKryptElement.setOsType(osType);
            } else {
                bluKryptElement.setDeviceUUID(PORTAL);
                bluKryptElement.setOsType("Windows");
            }
            logger.debug("before calling check machine storage......" + bluKryptElement.getGatewayName());
            boolean isMachineStorageReached = this.checkMachineStorageForPortalSync(request);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                ModelAndView modelAndView2 = null;
                return modelAndView2;
            }
            double fileSizeInMb = this.getSizeinMb(bluKryptElement.getFileSize());
            logger.debug("$$$$$$ fileSizeInMb $$$$$$" + fileSizeInMb);
            boolean isUserStorageLimitReached = this.utilService.isSyncUserStorageLimitReached(1, fileSizeInMb, bluKryptElement.getUserName(), cloudName);
            if (isUserStorageLimitReached) {
                httpResponse.setStatus(449);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                ModelAndView modelAndView3 = null;
                return modelAndView3;
            }
            boolean isSpecialCharsInFileName = false;
            char[] e = "/*\":<>".toCharArray();
            int n = e.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(e[i]);
                if (!bluKryptElement.getFileName().contains(c.toString())) continue;
                isSpecialCharsInFileName = true;
                break;
            }
            if (isSpecialCharsInFileName) {
                logger.debug(" File name contains special characters .... ");
                httpResponse.setStatus(406);
                e = null;
                return e;
            }
            String checkSum = UUID.randomUUID().toString();
            ChunkFileElement chunkFileElement = new ChunkFileElement();
            ArrayList<String> list = new ArrayList<String>();
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
            chunkFileElement.setFileName(checkSum);
            chunkFileElement.setMd5checksum(String.valueOf(System.currentTimeMillis()));
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
            String fsPath = SyncUploadController.getFsPath(checkSum);
            bluKryptElement.setCloudName(cloudName);
            String indexPath = SyncUploadController.getPropertyFileValueParabluFolderBasePath(cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            Map<String, String> chunkNameAndChecksum = this.uploadFileUsingPortal(cloudName, bluKryptElement, inputStream, chunkFileElement, indexPath, fileTmpPath);
            for (Map.Entry<String, String> entry : chunkNameAndChecksum.entrySet()) {
                logger.debug(entry.getKey() + " .........after chunk............ " + entry.getValue());
                list.add(entry.getValue());
            }
            checkSum = chunkFileElement.getMd5checksum();
            httpResponse.setStatus(200);
            logger.debug(checkSum + "  Before insertEntryForSync portal ..." + bluKryptElement.getFilePath());
            String syncRevisionIdAndConsId = this.insertEntryForSyncUsingHeaderVals(request, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), checkSum);
            String[] vals = syncRevisionIdAndConsId.split("-");
            syncRevisionId = vals[0];
            consolidatedImageId = vals[1];
            boolean isFileUnderMC = Boolean.parseBoolean(vals[2]);
            logger.debug(isFileUnderMC + AFTER_INSERT_ENTRY_FOR_SYNC + syncRevisionId);
            if (syncRevisionId != null) {
                if ("DEDUPED_FILE".equalsIgnoreCase(syncRevisionId)) {
                    modelAndView.addObject((Object)bluKryptElement);
                    httpResponse.setStatus(448);
                } else {
                    SearchIndex index = this.formSearchIndex(1, bluKryptElement, new ObjectId(consolidatedImageId), isFileUnderMC, fsPath);
                    this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                    logger.debug(END_OF_ADD_SEARCH_INDEX);
                    FileInfo fileInfo = this.getFileInfo(bluKryptElement, syncRevisionId, list);
                    fileInfo.setSize(bluKryptElement.getFileSize());
                    fileInfo.setMd5(checkSum);
                    fileInfo.setCompressed(false);
                    boolean uploadSuccess = this.uploadService.saveFileInfoForSync(cloudName, bluKryptElement.getGatewayName(), fileInfo);
                    if (!uploadSuccess) {
                        this.uploadService.removeSyncFile(cloudId, syncRevisionId, consolidatedImageId);
                        logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                        httpResponse.setStatus(500);
                    } else {
                        long filesizeInKB = (long)Math.ceil((double)bluKryptElement.getFileSize().longValue() / 1024.0);
                        this.utilService.saveSyncOverview(1, filesizeInKB, 0L, 0L, 0L);
                        modelAndView.addObject((Object)bluKryptElement);
                        httpResponse.setStatus(200);
                    }
                }
                httpResponse.setHeader("syncRevisionId", syncRevisionId);
                inputStream.close();
            } else {
                logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                httpResponse.setStatus(500);
            }
            this.closeInputStreamIfExists(request);
            logger.debug(" End of close stream ..........................");
        }
        catch (UncategorizedJmsException jmsException) {
            logger.error(" JMSException connection refused exception sync/portal/upload/file ....... " + syncRevisionId);
            logger.trace("" + (Object)((Object)jmsException));
            this.utilService.deleteRevision(cloudId, syncRevisionId, consolidatedImageId);
            httpResponse.setStatus(500);
        }
        catch (Exception e) {
            e.printStackTrace();
            httpResponse.setStatus(500);
            logger.trace("" + e);
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.trace(" exception .. " + e);
                    logger.error(".. error trying to close stream ..." + e.getMessage());
                }
            }
        }
        logger.debug(END_OF_SAVE_TO_ONE_DRIVE);
        return modelAndView;
    }

    private void sendWarningMail(Map<String, String> headerMap, double userStorageQuata) {
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + bluKryptElement.getCloudName() + "/mail";
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("isInternalCall", "true");
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)bluKryptElement.getUserName());
            emailDetails.put("action", (Object)"sync-limit-reached");
            emailDetails.put("actionOn", (Object)bluKryptElement.getUserName());
            emailDetails.put("customMailMessage", (Object)String.valueOf(userStorageQuata));
            emailDetails.put("toAdmins", true);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            logger.debug("Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }
}

