/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.Cloud;
import com.pg.exception.ParacloudBackupException;
import com.pg.paracloud.to.DownloadFileTO;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.DownloadService;
import com.pg.service.UtilService;
import com.pg.sync.service.impl.SyncDownloadServiceImpl;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class CommonDownloadController {
    private Logger logger = LoggerFactory.getLogger(CommonDownloadController.class);
    @Autowired
    private UtilService utilService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private SyncDownloadServiceImpl syncDownloadService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/portal/download/files/"}, method={RequestMethod.GET})
    public void downloadFileForPortal(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String browserType = request.getHeader("user-agent");
        InputStream inputStream = null;
        try {
            boolean isSync = false;
            String isSyncFlag = request.getParameter("isSync");
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            String loginUserName = request.getParameter("loginUserName");
            this.logger.debug("...loginUserName..." + loginUserName);
            if (!StringUtils.isEmpty((Object)isSyncFlag)) {
                isSync = Boolean.parseBoolean(isSyncFlag);
                downloadFileTO.setSync(isSync);
            } else {
                response.setStatus(400);
            }
            DownloadTO downloadTO = null;
            Cloud cloud = this.utilService.getCloud(1);
            if (isSync) {
                response.setStatus(400);
            } else {
                this.logger.debug("<<<Downloading backup file>>>" + request.getParameter("backupID"));
                downloadFileTO.setBackupID(request.getParameter("backupID"));
                downloadTO = this.backupFileDownloadForPortal(downloadFileTO, cloud, cloudName, response, browserType);
            }
            if (downloadTO != null) {
                this.logger.debug(" File size after  ...." + downloadTO.getSize());
            }
            if (downloadTO != null && downloadTO.getSize() > 0L) {
                response.setStatus(200);
                this.saveAuditHistory(downloadFileTO, loginUserName, cloud);
            } else {
                this.logger.debug("file download file input stream is null>>>>>>>>>>>$$$$$$$$$$$$ ");
                response.setStatus(449);
            }
        }
        catch (ParacloudBackupException e) {
            this.logger.trace("" + (Object)((Object)e));
            this.logger.debug(" File not found during download  ...." + e.getMessage());
            response.setStatus(449);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("  UNALBE TO DOWNLOAD FILE " + e.getMessage());
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        this.logger.debug(" end of  download file  Completed for portal ....");
    }

    private void saveAuditHistory(DownloadFileTO downloadFileTO, String loginUserName, Cloud cloud) {
        if (!StringUtils.isEmpty((Object)loginUserName)) {
            AuditHistory auditHistory = new AuditHistory();
            StringBuilder action = new StringBuilder("Downloaded file ");
            auditHistory.setAction(action.toString());
            auditHistory.setActionByUserName(loginUserName);
            auditHistory.setActionOnObject(downloadFileTO.getFilePath() + "/" + downloadFileTO.getFileName());
            auditHistory.setTimestamp(System.currentTimeMillis());
            auditHistory.setActionUsingObject("Portal");
            auditHistory.setActionType(4);
            this.logger.debug("Action type" + auditHistory.getActionType());
            this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
        }
    }

    private DownloadTO backupFileDownloadForPortal(DownloadFileTO downloadFileTO, Cloud cloud, String cloudName, HttpServletResponse response, String browserType) {
        return this.downloadService.downloadBackupFileForPortal(downloadFileTO, cloud, cloudName, response, browserType);
    }

    private DownloadFileTO getRequestParameters(HttpServletRequest request, String cloudName) {
        DownloadFileTO downloadFileTO = new DownloadFileTO();
        String actionType = request.getParameter("actionType");
        String filePath = request.getParameter("filePath");
        if (!StringUtils.isEmpty((Object)filePath)) {
            filePath = this.decodeBase64UTFString(request.getParameter("filePath"));
        }
        String userName = request.getParameter("userName");
        String fileName = request.getParameter("fileName");
        if (!StringUtils.isEmpty((Object)fileName)) {
            fileName = this.decodeBase64UTFString(request.getParameter("fileName"));
        }
        String gatewayName = request.getParameter("gatewayName");
        String isFolder = request.getParameter("isFolder");
        if (!StringUtils.isEmpty((Object)isFolder)) {
            downloadFileTO.setFolder(Boolean.parseBoolean(isFolder));
        }
        downloadFileTO.setCloudName(cloudName);
        downloadFileTO.setFileName(fileName);
        downloadFileTO.setFilePath(filePath);
        downloadFileTO.setGatewayName(gatewayName);
        downloadFileTO.setUserName(userName);
        downloadFileTO.setActionType(actionType);
        return downloadFileTO;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.trace("" + e);
            this.logger.error("" + e.getMessage());
            this.logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/download/folderAsZip/"}, method={RequestMethod.GET})
    public void downloadSyncPortalFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        InputStream inputStream = null;
        String browserType = request.getHeader("user-agent");
        try {
            String fileName = "";
            String syncRevisionId = "";
            String filePath = "";
            String userName = "";
            String gatewayName = "";
            boolean isFolder = false;
            boolean isSync = false;
            Map parameters = request.getParameterMap();
            for (String key : parameters.keySet()) {
                String[] vals;
                for (String val : vals = (String[])parameters.get(key)) {
                    if ("fileName".equalsIgnoreCase(key)) {
                        fileName = val;
                    }
                    if ("syncRevisionId".equalsIgnoreCase(key)) {
                        syncRevisionId = val;
                    }
                    if ("filePath".equalsIgnoreCase(key)) {
                        filePath = val;
                    }
                    if ("userName".equalsIgnoreCase(key)) {
                        userName = val;
                    }
                    if ("isFolder".equalsIgnoreCase(key)) {
                        isFolder = Boolean.parseBoolean(val);
                    }
                    if (!"isSync".equalsIgnoreCase(key)) continue;
                    isSync = Boolean.parseBoolean(val);
                }
            }
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            downloadFileTO.setBackupID(syncRevisionId);
            this.logger.debug(syncRevisionId + " Filename ..." + downloadFileTO.getFileName());
            this.logger.debug(syncRevisionId + "  DOWNLOAD FILE  STARTED for portal1 ...." + fileName);
            String deviceUUID = "Portal";
            DownloadTO downloadTO = null;
            String saltKey = this.utilService.getEncryptionKey(1, "sync");
            Cloud cloud = this.utilService.getCloud(1);
            downloadTO = this.downloadFolderAsZip(cloud, userName, downloadFileTO.getFileName(), downloadFileTO.getFilePath(), saltKey, deviceUUID, syncRevisionId, response, browserType, isSync, downloadFileTO);
        }
        catch (ParacloudBackupException e) {
            this.logger.trace("" + (Object)((Object)e));
            this.logger.debug(" File not found during download  ...." + e.getMessage());
            response.setStatus(449);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        this.logger.debug(" end of  download file  Completed for portal ....");
    }

    private DownloadTO downloadFolderAsZip(Cloud cloud, String userName, String fileName, String filePath, String saltKey, String deviceUUID, String syncRevisionId, HttpServletResponse response, String browserType, boolean isSync, DownloadFileTO downloadFileTO) {
        if (isSync) {
            return this.syncDownloadService.downloadZipSyncFileForPortal(cloud, fileName, filePath, syncRevisionId, userName, response);
        }
        return this.downloadService.downloadBackupFolderForPortal(downloadFileTO, cloud, response, browserType);
    }

    public void setSyncDownloadService(SyncDownloadServiceImpl syncDownloadService) {
        this.syncDownloadService = syncDownloadService;
    }

    @RequestMapping(value={"/cloud/{cloudName}/delete/zipFile/"}, method={RequestMethod.DELETE})
    public void deleteZipFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String filePath = request.getHeader("filePath");
        try {
            this.logger.debug("filePath...." + filePath);
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
                response.setStatus(200);
            } else {
                this.logger.debug("File not presnt..." + filePath);
                response.setStatus(507);
            }
        }
        catch (ParacloudBackupException e) {
            this.logger.trace("" + (Object)((Object)e));
            this.logger.debug(" File not found during download  ...." + e.getMessage());
            response.setStatus(449);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            response.setStatus(500);
        }
        this.logger.debug(" end of  download file  delete for portal ....");
    }
}

