/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.requests.extensions.GraphServiceClient;
import com.microsoft.graph.requests.extensions.IDriveItemStreamRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveRequestBuilder;
import com.parablu.cloudbackup.CloudBackupStorageBridge;
import com.parablu.cloudbackup.StorageService;
import com.parablu.cloudbackup.UploadStatus;
import com.parablu.cloudcontroller.Util.ODBDownloadFile;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.SearchIndex;
import com.pg.controller.BaseController;
import com.pg.controller.Graph;
import com.pg.domain.DriveFileInfo;
import com.pg.domain.FileInfo;
import com.pg.element.BackupElement;
import com.pg.element.BluKryptElement;
import com.pg.element.ChunkFileElement;
import com.pg.element.FileUploadDetailsElement;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.service.BackupService;
import com.pg.service.ChunkableUploadService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import org.apache.commons.io.IOUtils;
import org.bson.types.ObjectId;
import org.jvnet.hk2.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@Service
public class CloudBackupController
extends BaseController
implements DisposableBean,
ApplicationContextAware,
Runnable,
CloudBackupStorageBridge {
    private static final Logger logger = LoggerFactory.getLogger(CloudBackupController.class);
    @Autowired
    private UploadService uploadService;
    @Autowired
    private ChunkableUploadService chunkableUploadService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private UtilService utilService;
    static Thread thisThread;
    private static final Semaphore sem;
    private static ApplicationContext applicationContext;
    private static final String USER_STORAGE_LIMIT_REACHED = " User Storage limit reached ..... ";
    private static final String DIRECT_CALL_STORAGE_LIMIT = " direct call .... storage limit .......";
    private static final String UPLOAD_COUNT = "uploadCount";
    private static final String JOB_ID = "JobId";
    private static final String CHUNK = "chunk";
    private static final String ALREADY_EXISTS = "ALREADY_EXISTS";
    private static final String BATCH_ID_LOG = "##batch id >>>>";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        logger.debug("---- Application context is set! ---- ");
        CloudBackupController.applicationContext = applicationContext;
        sem.release();
    }

    public static ApplicationContext getContext() {
        return applicationContext;
    }

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setChunkableUploadService(ChunkableUploadService chunkableUploadService) {
        this.chunkableUploadService = chunkableUploadService;
    }

    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    CloudBackupController() {
        logger.debug("----------------$$$$$$ CloudBackupBridge $$$$$$----------------");
        this.runOnce();
    }

    void runOnce() {
        logger.info("Triggered run Once");
        if (thisThread == null) {
            logger.info("Launching thread!");
            thisThread = new Thread(this);
            logger.info("@@@@@@@@@@@@@ ----- @@@@@@@@@@@");
            thisThread.start();
        }
    }

    public void destroy() {
        try {
            StorageService.GETINST.shutdown();
            try {
                logger.debug("going to sleep no work found");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("Sleep interrupted", (Throwable)e);
            }
            thisThread.join();
        }
        catch (InterruptedException e) {
            logger.error("Exception while destroying", (Throwable)e);
        }
        logger.info("----------------$$$$$$ CloudBackupBridge $$$$$$----------------");
    }

    private static ChunkFileElement createChunkFileElement(String deviceUUID, BluKryptElement bluKryptElement, String chunkFilechecksum, String chunkFileName, String checkSum, List<String> list) {
        ChunkFileElement chunkFileElement = new ChunkFileElement();
        if (CollectionUtils.isEmpty(list)) {
            logger.info("List is empty sooo adding md5checksum" + checkSum);
            list.add(checkSum);
        }
        chunkFileElement.setFileChunks(list);
        chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
        logger.info("createChunkFileElemet " + bluKryptElement.getFileCompletePath());
        chunkFileElement.setFileName(checkSum);
        chunkFileElement.setMd5checksum(checkSum);
        chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
        if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
            chunkFileElement.setMd5checksum(chunkFilechecksum);
            chunkFileElement.setFileChunks(list);
            logger.info("Create chunk file element " + chunkFileName);
            chunkFileElement.setFileCompletePath(chunkFileName);
            chunkFileElement.setFileName(chunkFileName);
            chunkFileElement.setDeviceUUID(deviceUUID);
        }
        return chunkFileElement;
    }

    private static boolean isFeatureEnabled(Cloud cloud, String feature) {
        logger.info("private boolean isFeatureEnabled(CloudLicenseTo cl, String feature) > BEGIN > feature > " + feature);
        List list = cloud.getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!customisableDetails.getName().equalsIgnoreCase(feature)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkMachineStorage(String fileSizeInString) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long incomingFileSize = Long.parseLong(fileSizeInString);
        long availableSpaceInServer = file.getFreeSpace();
        logger.info("Total space for this machine.." + file.getTotalSpace() + "FREE_SIZE" + file.getFreeSpace() + "incoming File Size:" + incomingFileSize);
        if (availableSpaceInServer - incomingFileSize <= 0L) {
            logger.info("Space in server is exceeded........");
            return true;
        }
        return false;
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private double getFileSizeInMb(Map<String, String> headerMap) {
        long fileSizeInBytes = Long.parseLong(headerMap.get("file-size"));
        long filesizeInKB = (long)Math.ceil((double)fileSizeInBytes / 1024.0);
        return CloudBackupController.getSizeinMb(filesizeInKB);
    }

    protected FileUploadDetailsElement insertEntryForBackupFromBK(Map<String, String> request, String cloudName, String userName, String maxVersionsToKeep, Device device) {
        FileUploadDetailsElement fileUploadDetailsElement = new FileUploadDetailsElement();
        try {
            String deviceUUID;
            BackupElement fileElement = new BackupElement();
            fileElement.setFileName(request.get("file-name"));
            fileElement.setFileCompletePath(request.get("file-path"));
            fileElement.setPresent(Boolean.valueOf(request.get("is-exists")).booleanValue());
            fileElement.setFolder(Boolean.valueOf(request.get("is-folder")).booleanValue());
            fileElement.setMd5Checksum(request.get("fileMD5"));
            fileElement.setSize(Long.valueOf(request.get("file-size")).longValue());
            String fileModifiedTimestamp = request.get("modified");
            fileElement.setLastClientModifiedTime(Long.valueOf(fileModifiedTimestamp).longValue());
            fileElement.setBaseBackup(Boolean.valueOf(request.get("is-base-folder")).booleanValue());
            fileElement.setGatewayName(request.get("gatewayName"));
            String version = request.get("maxVersions");
            logger.debug(request.get("itemID") + ".... item id iss.... " + request.get("odItemId"));
            fileElement.setOdItemId(request.get("odItemId"));
            String userUnderLegalHold = request.get("userUnderLegalHold");
            boolean isFullBackup = false;
            String fullBackup = request.get("isFullBackup");
            if (!StringUtils.isEmpty((Object)fullBackup)) {
                isFullBackup = Boolean.parseBoolean(fullBackup);
            }
            if ((deviceUUID = request.get("deviceUUID")) != null) {
                logger.info("Device UUID is not null");
            }
            int uploadCount = 0;
            if (MemoryStore.get((String)UPLOAD_COUNT) != null) {
                uploadCount = (Integer)MemoryStore.get((String)UPLOAD_COUNT);
                logger.info(" From MEMSTORE ........... " + uploadCount);
            }
            logger.info(" Before calling uploadExternalFileToBackUp ...........");
            fileUploadDetailsElement = this.backupService.uploadExternalFileToBackUp(1, cloudName, fileElement, device, userUnderLegalHold, isFullBackup);
            logger.info(" After calling uploadExternalFileToBackUp ...........");
            MemoryStore.delete((String)UPLOAD_COUNT);
            MemoryStore.add((String)UPLOAD_COUNT, (Object)(++uploadCount));
        }
        catch (Exception e) {
            logger.error("Exception When Inserting Entry For Backup From BK :", (Throwable)e);
        }
        return fileUploadDetailsElement;
    }

    private File createFileInBackupPath(Map<String, String> headerMap, String cloudName, String fileName) throws IOException {
        logger.info("Entering createFileInBackupPath ");
        String backupBatchId = headerMap.get("backupBatchId");
        if (StringUtils.isEmpty((Object)backupBatchId)) {
            backupBatchId = "FIXME-INBA";
        }
        String deviceTempPath = PCHelperConstant.getMntTempChunkPath() + backupBatchId;
        File uploadBackupPath = new File(deviceTempPath);
        uploadBackupPath.mkdirs();
        String filePath = uploadBackupPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
        logger.info("File path: " + filePath);
        File tempFilePath = new File(filePath);
        if (tempFilePath.exists()) {
            logger.info("Temp file exists so deleting the file####");
            tempFilePath.delete();
        }
        tempFilePath.createNewFile();
        logger.info("Leaving createFileInBackupPath");
        return tempFilePath;
    }

    private void checkNThrottleAndUploadFileV2(String cloudName, String gatewayName, InputStream inputStream, long fileSize, ChunkFileElement chunkFileElement, String sourceFilePath, String osType, String indexPath, String batchId) throws InterruptedException {
        this.chunkableUploadService.uploadChunkableFileToBackUp(cloudName, inputStream, chunkFileElement, osType, false, indexPath, batchId);
    }

    private List<String> getBackupIdAppendedToChunks(List<String> newChunkList, String newBackupId) {
        ArrayList<String> resChunkList = new ArrayList<String>();
        for (String chunkName : newChunkList) {
            resChunkList.add(chunkName + "." + newBackupId);
        }
        Collections.sort(resChunkList);
        return resChunkList;
    }

    private boolean isFullBackupEnabled(Map<String, String> value) {
        return true;
    }

    protected FileInfo getFileInfo(BluKryptElement bluKryptElement, String backupId, String prevBackupId, List<String> list) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setChunkFiles(new ArrayList());
        fileInfo.setFileName(bluKryptElement.getFileName());
        fileInfo.setId(backupId);
        fileInfo.setFilePath(bluKryptElement.getFilePath());
        fileInfo.setDeviceUUID(bluKryptElement.getDeviceUUID());
        fileInfo.setOsType(bluKryptElement.getOsType());
        fileInfo.setPrevBackupId(prevBackupId);
        fileInfo.setUserName(bluKryptElement.getUserName());
        fileInfo.getChunkFiles().addAll(list);
        return fileInfo;
    }

    private String getUploadFilePath(String deviceUUID, String cloudName, String batchId) {
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID;
        if (!StringUtils.isEmpty((Object)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        return deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
    }

    private void moveFilesFromTmpPath(String deviceUUID, List<String> orgChunks, String chunkPath) throws IOException {
        for (String chunkName : orgChunks) {
            String path = PCHelperConstant.getMntTempChunkPath() + deviceUUID;
            String srcfilePath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
            File fileObj = new File(srcfilePath);
            if (!fileObj.exists()) continue;
            File chunkDir = new File(chunkPath);
            if (!chunkDir.exists()) {
                chunkDir.mkdirs();
            }
            String destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
            int dedupCount = 1;
            while (new File(destPath).exists()) {
                destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName + "_" + dedupCount;
                ++dedupCount;
            }
            File destFile = new File(destPath);
            Files.move(fileObj.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            logger.debug("destFile :" + destFile.getAbsolutePath());
        }
    }

    private void closeInputStreamAndDelTempFile(File tempFilePath, InputStream inputStream) {
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (tempFilePath != null && tempFilePath.exists()) {
            tempFilePath.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int upload(Map<String, String> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        logger.debug("Entering upload!");
        InputStream inputStream = dataStream;
        try {
            FileInfo fileInfoObj;
            String deviceUUID = headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String driveFileInfoId = headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = headerMap.get("file-size");
            String chunkFilechecksum = headerMap.get("chunkFileMD5");
            String chunkFileName = headerMap.get("chunkFileName");
            batchId = headerMap.get("backupBatchId");
            if (StringUtils.isEmpty((Object)batchId)) {
                batchId = "FIXME-INBA";
            }
            String isChunkOfAFile = "false";
            String checkSum = headerMap.get("fileMD5");
            String prevBackupId = headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath(headerMap.get("fileMD5"));
            String indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            assert (Boolean.parseBoolean(isNormalFile));
            logger.debug(" Before calling insert query ...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device);
            backupId = fileUploadDetailsElement.getBkpId();
            if (StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId)) {
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId);
                int n = 409;
                return n;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId(headerMap.get(JOB_ID));
            }
            if (!StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = this.isFullBackupEnabled(headerMap);
            boolean fileExists = false;
            if (isFullBackup && (fileInfoObj = this.uploadService.getFileFromPG(bluKryptElement.getUserName(), cloudName, fileInfo.getId(), false)) != null) {
                fileExists = true;
            }
            logger.debug("Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath);
            if (fileExists) {
                this.uploadService.updateFileInfo(cloudName, "", fileInfo);
                this.removeDriveItem(driveFileInfoId);
            } else {
                this.updateStorageUtilization(cloudName, batchId, deviceUUID, list, fileUploadDetailsElement);
                fileInfo.setReducePGSize(true);
                this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId);
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    private void updateStorageUtilization(String cloudName, String batchId, String deviceUUID, List<String> list, FileUploadDetailsElement fileUploadDetailsElement) {
        long pgChunkSize = 0L;
        if (!CollectionUtils.isEmpty(list)) {
            String chunkFolderPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
            chunkFolderPath = chunkFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            for (String chunkName : list) {
                try {
                    File file = new File(chunkFolderPath + chunkName).getAbsoluteFile();
                    pgChunkSize += file.length() / 1024L;
                }
                catch (Exception e) {
                    logger.debug(".......Exception...." + e.getMessage());
                }
            }
        }
        logger.debug("..................total pgChunkSizeInKB............" + pgChunkSize);
        this.utilService.updateStorageUtilized(1, deviceUUID, fileUploadDetailsElement.getFileSize(), fileUploadDetailsElement.getLatestVersionSize(), pgChunkSize);
    }

    public static String getPropertyFileValueParabluFolderBasePath(String cloudName) {
        return PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/f/";
    }

    protected SearchIndex formSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, String fsPath) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        return searchIndex;
    }

    public static String getFsPath(String md5) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd-MM-yyyy");
        Date date = new Date();
        String baseFolder = sdfDate.format(date) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + String.valueOf(date.getTime());
        String fileName = md5;
        return baseFolder + fileName;
    }

    @Override
    public void removeDriveItem(String driveFileInfoId) {
        this.uploadService.removeFileInfoForAlreadyExists(driveFileInfoId);
    }

    public boolean initialize() {
        boolean success = true;
        if (CloudBackupController.getContext() == null) {
            logger.info("Application context not set!");
            return false;
        }
        try {
            if (this.backupService == null) {
                this.backupService = (BackupService)CloudBackupController.getContext().getBean("BackupServiceImpl", BackupService.class);
                if (this.backupService == null) {
                    success = false;
                    logger.error("failed to get backupService");
                }
            }
            if (this.utilService == null) {
                this.utilService = (UtilService)CloudBackupController.getContext().getBean("UtilServiceImpl", UtilService.class);
                if (this.utilService == null) {
                    success = false;
                    logger.error("failed to get utilService");
                }
            }
            if (this.uploadService == null) {
                this.uploadService = (UploadService)CloudBackupController.getContext().getBean("UploadService", UploadService.class);
                if (this.uploadService == null) {
                    success = false;
                    logger.error("failed to get chunkableUploadService");
                }
            }
            if (this.chunkableUploadService == null) {
                this.chunkableUploadService = (ChunkableUploadService)CloudBackupController.getContext().getBean("ChunkableUploadService", ChunkableUploadService.class);
                if (this.chunkableUploadService != null) {
                    success = false;
                    logger.error("failed to get chunkableUploadService");
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            e.printStackTrace(System.out);
            success = false;
        }
        return success;
    }

    @Override
    public void run() {
        try {
            logger.info("Invoking storage service!");
            try {
                sem.acquire(1);
            }
            catch (InterruptedException e) {
                logger.error("Failed to acquire semaphore! ", (Throwable)e);
                e.printStackTrace();
            }
            Thread.sleep(100L);
            logger.info("Invoking storage service!");
            if (!StorageService.GETINST.initialize(this, this.utilService)) {
                logger.error("Failed to init storage service!");
                return;
            }
            ODBDownloadFile.Initialize();
            Thread.sleep(100L);
            StorageService.GETINST.run();
            logger.info("^^^^^^^^^^^^^^DONE^^^^^^^^^^^^^^^^^^^");
        }
        catch (InterruptedException e) {
            logger.error("Woke up!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Something bad happened while executing test", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    UploadStatus uploadAsync(UploadStatus status, Map<String, Object> fileProperties) {
        File tempFilePath;
        Cloud cloud = this.utilService.getCloud(1);
        String currentUploadIPToUse = PCHelperConstant.getComponentName();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("gatewayName", currentUploadIPToUse);
        parameters.put("dedupifiedBackupId", "false");
        parameters.put("maxVersions", String.valueOf("10"));
        parameters.put("is-base-folder", String.valueOf(false));
        parameters.put("is-folder", String.valueOf(false));
        parameters.put("is-exists", String.valueOf(true));
        parameters.put("backupBatchId", (String)fileProperties.get("backupBatchId"));
        parameters.put("userUnderLegalHold", String.valueOf(true));
        parameters.put("userName", (String)fileProperties.get("userName"));
        String deviceUUID = (String)fileProperties.get("deviceUUID");
        parameters.put("deviceUUID", deviceUUID);
        parameters.put("file-path", (String)fileProperties.get("file-path"));
        parameters.put("file-name", (String)fileProperties.get("file-name"));
        parameters.put("driveFileInfoId", (String)fileProperties.get("driveFileInfoId"));
        parameters.put("odItemId", (String)fileProperties.get("itemID"));
        parameters.put("cloudName", cloud.getCloudName());
        parameters.put("prevGatewayName", currentUploadIPToUse);
        parameters.put("osType", "Android");
        parameters.put("restartId", String.valueOf(0));
        parameters.put("isFullBackup", Boolean.valueOf(fileProperties.get("isFullBackup").toString()).toString());
        try {
            tempFilePath = this.createFileInBackupPath(parameters, cloud.getCloudName(), (String)fileProperties.get("file-name") + ".tmp");
            File temp = new File(tempFilePath.getAbsolutePath());
            parameters.put("modified", String.valueOf(temp.lastModified()));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new UploadStatus((String)fileProperties.get("itemID"), false, -1);
        }
        String accessToken = this.utilService.getAccessTokenForODBBackup(cloud.getCloudId());
        if (StringUtils.isEmpty((Object)accessToken)) {
            logger.error("....Token not mapped....");
            return new UploadStatus((String)fileProperties.get("itemID"), false, -1);
        }
        logger.debug("....deviceUUID available... " + deviceUUID);
        IGraphServiceClient graphClient = this.getGraphClient(accessToken);
        IDriveRequestBuilder drives = graphClient.drives(deviceUUID);
        IDriveItemStreamRequestBuilder content = drives.items((String)fileProperties.get("itemID")).content();
        InputStream inputStream = content.buildRequest().get();
        logger.debug(tempFilePath.getAbsolutePath() + "................." + inputStream);
        Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
        try {
            Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        LinkedList<String> empty = new LinkedList<String>();
        try (FileInputStream is = new FileInputStream(tempFilePath);){
            UploadStatus uploadStatus2;
            try {
                String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloading..... " + md5);
                parameters.put("fileMD5", md5);
            }
            catch (Exception e) {
                logger.error("MD5 computation failed", (Throwable)e);
            }
            parameters.put("file-size", String.valueOf(Files.size(tempFilePath.toPath())));
            logger.debug("Going to launch read");
            int statusval = this.upload(parameters, is, 1, empty, cloud);
            logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
            boolean isSuccess = false;
            if (statusval == 200) {
                isSuccess = true;
            }
            UploadStatus uploadStatus = uploadStatus2 = new UploadStatus((String)fileProperties.get("itemID"), isSuccess, statusval);
            return uploadStatus;
        }
        catch (Exception e) {
            logger.error("Failed to get the file in right path!", (Throwable)e);
            return status;
        }
    }

    @Override
    public CompletableFuture<UploadStatus> notifyService(Map<String, ? super Object> fileProperties, InputStream buffer) {
        UploadStatus status = new UploadStatus((String)fileProperties.get("messageID"), true, 0);
        CompletableFuture<UploadStatus> statusWhenDone = new CompletableFuture<UploadStatus>();
        UploadStatus newStatus = this.uploadAsync(status, fileProperties);
        statusWhenDone.complete(newStatus);
        return statusWhenDone;
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoList(int cloudId) {
        return this.utilService.getDriveFileInfoList();
    }

    private IGraphServiceClient getGraphClient(String accessToken) {
        Graph graph = Graph.getInstance(accessToken);
        IGraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)graph).buildClient();
        return graphClient;
    }

    @Override
    public void deleteBatchFromOdServer(ObjectId id, String policyName) {
        this.utilService.deleteBatchFromOdServer(id, policyName);
    }

    @Override
    public List<BackupBatch> getBatchList(int cloudId, String policyName) {
        return this.utilService.getBatchList(policyName);
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        return this.utilService.getDriveFileInfoFromListForBatchId(batchId);
    }

    static {
        sem = new Semaphore(1);
        System.setProperty("DEBUG.MONGO", "true");
        System.setProperty("DB.TRACE", "true");
        try {
            sem.acquire(1);
        }
        catch (InterruptedException e) {
            logger.error("Failed to acquire semaphore! ", (Throwable)e);
        }
    }
}

