/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.pg.domain.FileInfo;
import com.pg.element.BluKryptElement;
import com.pg.element.ChunkFileElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class BaseController {
    private static Logger logger = LoggerFactory.getLogger(BaseController.class);
    private static final String PARACLOUD_CLOUD = "/paracloud/cloud/";
    protected static final String XML_VIEW = "xmlview";
    protected static final String HTTP_ERROR_MESSAGE = "errorMessage";
    protected static final int BACKUP_USER = 0;
    protected static final int SYNC_USER = 1;
    protected static final String GZIP_VIEW = "xmlview";
    protected static final String JSON_VIEW = "jsonview";
    protected static final String APLLICATION_XML = "application/xml";

    protected void closeInputStreamIfExists(HttpServletRequest request) {
        try {
            if (request.getInputStream() != null) {
                request.getInputStream().close();
            }
        }
        catch (IOException e) {
            logger.debug("Error trying to close inputstream .... ", (Throwable)e);
        }
    }

    protected PciAuthorizationTokenElement getPciAuthorizationTokenElement(String cloudName, String userName) {
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        headers.add("userName", userName);
        org.springframework.http.HttpEntity entity = new org.springframework.http.HttpEntity((Object)"parameters", (MultiValueMap)headers);
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD + cloudName + "/pcitoken";
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, PciAuthorizationTokenElement.class, new Object[0]);
        PciAuthorizationTokenElement pciAuthorizationTokenElement = (PciAuthorizationTokenElement)result.getBody();
        pciAuthorizationTokenElement.setUserName(userName);
        pciAuthorizationTokenElement.setCloudName(cloudName);
        try {
            reqFactory.destroy();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Getting Authorization Token Element :" + e.getMessage());
        }
        return pciAuthorizationTokenElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getEncryptedKey(String token, String cloudName) {
        logger.debug("INSIDE getEncryptedKey ..... ");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        String saltKey = null;
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD + cloudName + "/load/encryptionKey/";
        HttpPost httpPost = new HttpPost(url);
        try {
            Header[] headerarr;
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("token", (ContentBody)new StringBody(token));
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            for (Header header : headerarr = response.getAllHeaders()) {
                if (!"saltKey".equals(header.getName())) continue;
                saltKey = header.getValue();
                logger.debug("Recieved backup Id for file ..... " + saltKey);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Getting Encryption Key :" + e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
            httpclient.getConnectionManager().closeIdleConnections(1L, TimeUnit.MICROSECONDS);
            httpclient.getConnectionManager().shutdown();
        }
        return saltKey;
    }

    protected ChunkFileElement getChunkFileElementFromRequestHeader(HttpServletRequest request) {
        ChunkFileElement chunkFileElement = new ChunkFileElement();
        String deviceUUID = request.getParameter("deviceUUID");
        String fileChunkNames = request.getParameter("fileChunkNames");
        String fileName = request.getParameter("fileName");
        String fileCompletePath = request.getParameter("fileCompletePath");
        String checkSum = request.getParameter("checkSum");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(fileChunkNames.split(",")));
        chunkFileElement.setFileChunks(list);
        chunkFileElement.setFileCompletePath(fileCompletePath);
        chunkFileElement.setFileName(fileName);
        chunkFileElement.setMd5checksum(checkSum);
        chunkFileElement.setDeviceUUID(deviceUUID);
        return chunkFileElement;
    }

    protected static List<String> getExistingChunkFileNames(String chunkPath) {
        ArrayList<String> namesList = new ArrayList<String>();
        File folder = new File(chunkPath);
        Object[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            Arrays.sort(listOfFiles);
            for (Object file : listOfFiles) {
                namesList.add(((File)file).getName());
            }
        }
        return namesList;
    }

    protected FileInfo updateDedupifiedBackup(String fileName, String fileCompletePath, String dedupifiedBackupId, FileInfo fileInfo) {
        FileInfo newFileInfo = new FileInfo();
        newFileInfo.setFileName(fileName);
        newFileInfo.setFilePath(fileCompletePath);
        newFileInfo.getChunkFiles().addAll(fileInfo.getChunkFiles());
        newFileInfo.setDeviceUUID(fileInfo.getDeviceUUID());
        newFileInfo.setMd5(fileInfo.getMd5());
        newFileInfo.setOsType(fileInfo.getOsType());
        newFileInfo.setSize(fileInfo.getSize());
        newFileInfo.setDedupBackupId(dedupifiedBackupId);
        return newFileInfo;
    }

    protected Long getmillisecondsForTime(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            logger.trace("" + e);
            logger.error("Exception While Getting Milliseconds For Time :" + e.getMessage());
            return null;
        }
        return date.getTime();
    }

    protected FileInfo getFileInfo(BluKryptElement bluKryptElement, String backupId, List<String> list) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setChunkFiles(new ArrayList());
        fileInfo.setFileName(bluKryptElement.getFileName());
        fileInfo.setId(backupId);
        fileInfo.setFilePath(bluKryptElement.getFilePath());
        fileInfo.setDeviceUUID(bluKryptElement.getDeviceUUID());
        fileInfo.setOsType(bluKryptElement.getOsType());
        fileInfo.setUserName(bluKryptElement.getUserName());
        fileInfo.setSize(bluKryptElement.getFileSize());
        fileInfo.getChunkFiles().addAll(list);
        return fileInfo;
    }

    protected FileInfo getFileInfo(String fileName, String backupId, String sourceFilePath, String deviceUUID, String osType, List<String> list, String userName) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setChunkFiles(new ArrayList());
        fileInfo.setFileName(fileName);
        fileInfo.setId(backupId);
        fileInfo.setFilePath(sourceFilePath);
        fileInfo.setDeviceUUID(deviceUUID);
        fileInfo.setOsType(osType);
        fileInfo.setUserName(userName);
        fileInfo.getChunkFiles().addAll(list);
        return fileInfo;
    }

    protected BluKryptElement getBluKryptElementValues(HttpServletRequest request) {
        BluKryptElement bluKryptElement = new BluKryptElement();
        bluKryptElement.setCloudName(BaseController.getValue(request, "cloudName"));
        bluKryptElement.setUserName(BaseController.getValue(request, "userName"));
        String gatewayName = BaseController.getValue(request, "gatewayName");
        String prevGatewayName = BaseController.getValue(request, "prevGatewayName");
        if (!(StringUtils.isEmpty((String)gatewayName) || StringUtils.isEmpty((String)prevGatewayName) || gatewayName.equals(prevGatewayName))) {
            gatewayName = prevGatewayName;
        }
        if (StringUtils.isNotEmpty((String)PCHelperConstant.getPropertyFileValueLoadBalancerIp())) {
            gatewayName = PCHelperConstant.getPropertyFileValueLoadBalancerIp().trim();
        }
        bluKryptElement.setGatewayName(gatewayName);
        bluKryptElement.setDeviceUUID(BaseController.getValue(request, "deviceUUID"));
        bluKryptElement.setFileName(BaseController.getValue(request, "file-name"));
        bluKryptElement.setFileCompletePath(BaseController.getValue(request, "file-path"));
        bluKryptElement.setVersionsToKeep(BaseController.getValue(request, "maxVersions"));
        bluKryptElement.setFileSize(Long.valueOf(BaseController.getValue(request, "file-size")));
        bluKryptElement.setFilePath(BaseController.getValue(request, "file-path"));
        bluKryptElement.setOsType(BaseController.getValue(request, "osType"));
        return bluKryptElement;
    }

    protected BluKryptElement getBluKryptElementValues(Map<String, String> headerMap) {
        BluKryptElement bluKryptElement = new BluKryptElement();
        bluKryptElement.setCloudName(headerMap.get("cloudName"));
        bluKryptElement.setUserName(headerMap.get("userName"));
        String gatewayName = headerMap.get("gatewayName");
        String prevGatewayName = headerMap.get("prevGatewayName");
        if (!(StringUtils.isEmpty((String)gatewayName) || StringUtils.isEmpty((String)prevGatewayName) || gatewayName.equals(prevGatewayName))) {
            gatewayName = prevGatewayName;
        }
        if (StringUtils.isNotEmpty((String)PCHelperConstant.getPropertyFileValueLoadBalancerIp())) {
            gatewayName = PCHelperConstant.getPropertyFileValueLoadBalancerIp().trim();
        }
        bluKryptElement.setGatewayName(gatewayName);
        bluKryptElement.setDeviceUUID(headerMap.get("deviceUUID"));
        bluKryptElement.setFileName(headerMap.get("file-name"));
        bluKryptElement.setFileCompletePath(headerMap.get("file-path"));
        bluKryptElement.setVersionsToKeep(headerMap.get("maxVersions"));
        logger.debug(headerMap.get("deviceUUID") + " $$$$File size .......&&&&" + headerMap.get("file-size") + "^^");
        String size = headerMap.get("file-size");
        size = size.trim();
        logger.debug(" $$$$File size .after trim......&*" + size + "**");
        bluKryptElement.setFileSize(Long.valueOf(size));
        bluKryptElement.setFilePath(headerMap.get("file-path"));
        bluKryptElement.setOsType(headerMap.get("osType"));
        if (!StringUtils.isEmpty((String)headerMap.get("containerName"))) {
            bluKryptElement.setContainerName(headerMap.get("containerName"));
        }
        if (!StringUtils.isEmpty((String)headerMap.get("containerType"))) {
            bluKryptElement.setContainerType(headerMap.get("containerType"));
        }
        return bluKryptElement;
    }

    private static String getValue(HttpServletRequest request, String paramValue) {
        if (!StringUtils.isEmpty((String)request.getParameter(paramValue))) {
            return request.getParameter(paramValue);
        }
        return request.getHeader(paramValue);
    }

    protected static Map<String, String> parseHeader(String header) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String[] headers = header.split("\n");
        logger.debug("Before Parse headers>>>>>>>>>>");
        for (String s : headers) {
            String[] keyValues = s.split(":", 2);
            if (keyValues.length <= 1) continue;
            String key = keyValues[0].replaceAll("[\n\r]", "");
            String value = keyValues[1].replaceAll("[\n\r]", "");
            key = key.trim();
            value = value.trim();
            headerMap.put(key, value);
        }
        return headerMap;
    }
}

