/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.messagequeue;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.AsyncCallback;
import org.apache.activemq.command.ActiveMQDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Producer {
    private final String brokerUrl;
    private final String queueName;
    private final boolean asyncEnabled;
    private final int acknowledgeMode;
    private final int deliveryMode;
    private final ActiveMQConnectionFactory connectionFactory;
    private final ActiveMQConnection connection;
    private final ActiveMQSession session;
    private final ActiveMQDestination destination;
    private final ActiveMQMessageProducer producer;
    private final ObjectMapper mapper;
    private final Logger logger = LoggerFactory.getLogger(Producer.class);

    private Producer(Builder value) throws JMSException {
        this.brokerUrl = value.brokerUrl;
        this.queueName = value.queueName;
        this.asyncEnabled = value.asyncEnabled;
        this.acknowledgeMode = value.acknowledgeMode;
        this.deliveryMode = value.deliveryMode;
        this.logger.info("Initializing ActiveMQ producer (" + this.brokerUrl + ") : [" + this.queueName + "] Async(" + this.asyncEnabled + ") ACK (" + this.acknowledgeMode + ")Delivery Mode (" + this.deliveryMode + ")");
        this.mapper = new ObjectMapper();
        this.connectionFactory = new ActiveMQConnectionFactory(this.brokerUrl);
        this.connection = (ActiveMQConnection)this.connectionFactory.createConnection();
        this.connection.setAlwaysSessionAsync(this.asyncEnabled);
        this.session = (ActiveMQSession)this.connection.createSession(false, this.acknowledgeMode);
        this.destination = (ActiveMQDestination)this.session.createQueue(this.queueName);
        this.producer = (ActiveMQMessageProducer)this.session.createProducer((Destination)this.destination);
        this.producer.setDeliveryMode(this.deliveryMode);
        this.logger.info("Producer initialized");
        this.connection.start();
    }

    public <T> void sendMessageSync(T payload, Class<T> type) throws JMSException, JsonProcessingException {
        String text = this.mapper.writeValueAsString(payload);
        this.logger.info("Sending message! " + text);
        TextMessage message = this.session.createTextMessage(text);
        this.producer.send((Message)message);
    }

    public <T> CompletableFuture<Optional<JMSException>> sendMessageAsync(T payload) throws JsonProcessingException, JMSException {
        String text = this.mapper.writeValueAsString(payload);
        this.logger.info("Sending message! " + text);
        TextMessage message = this.session.createTextMessage();
        final CompletableFuture<Optional<JMSException>> result = new CompletableFuture<Optional<JMSException>>();
        this.producer.send((Message)message, new AsyncCallback(){

            public void onException(JMSException e) {
                Optional<JMSException> value = Optional.of(e);
                Producer.this.logger.error("Exception happened for the message!" + e.getMessage());
                result.complete(value);
            }

            public void onSuccess() {
                result.complete(Optional.empty());
            }
        });
        return result;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public static class Builder {
        private String brokerUrl;
        private String queueName;
        private boolean asyncEnabled = false;
        private int acknowledgeMode = 2;
        private int deliveryMode;

        public Builder(String brokerUrl) {
            this.brokerUrl = brokerUrl;
        }

        public Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Builder acknowledgeMode(int acknowledgeMode) {
            this.acknowledgeMode = acknowledgeMode;
            return this;
        }

        public Builder deliveryMode(int deliveryMode) {
            this.deliveryMode = deliveryMode;
            return this;
        }

        public Builder asyncEnabled(boolean asyncEnabled) {
            this.asyncEnabled = asyncEnabled;
            return this;
        }

        public Producer build() throws JMSException {
            return new Producer(this);
        }
    }
}

