/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.messagequeue;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.command.ActiveMQDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consumer {
    private final String brokerUrl;
    private final String queueName;
    private final boolean asyncEnabled;
    private final int acknowledgeMode;
    private final int deliveryMode;
    private final Logger logger = LoggerFactory.getLogger(Consumer.class);
    private final ActiveMQConnectionFactory connectionFactory;
    private final ActiveMQConnection connection;
    private final ActiveMQSession session;
    private final ActiveMQDestination destination;
    private ActiveMQMessageConsumer consumer;
    private final MessageListener messageListener;

    public Consumer(Builder value) throws JMSException {
        this.brokerUrl = value.brokerUrl;
        this.queueName = value.queueName;
        this.asyncEnabled = value.asyncEnabled;
        this.acknowledgeMode = value.acknowledgeMode;
        this.deliveryMode = value.deliveryMode;
        this.messageListener = value.messageListener;
        this.logger.debug("Initializing ActiveMQ Consumer (" + this.brokerUrl + ") : [" + this.queueName + "] Async(" + this.asyncEnabled + ") ACK (" + this.acknowledgeMode + ")Delivery Mode (" + this.deliveryMode + ")");
        this.connectionFactory = new ActiveMQConnectionFactory(this.brokerUrl);
        this.connection = (ActiveMQConnection)this.connectionFactory.createConnection();
        this.connection.setAlwaysSessionAsync(this.asyncEnabled);
        this.session = (ActiveMQSession)this.connection.createSession(false, this.acknowledgeMode);
        this.destination = (ActiveMQDestination)this.session.createQueue(this.queueName);
        this.consumer = (ActiveMQMessageConsumer)this.session.createConsumer((Destination)this.destination);
        this.logger.debug("Consumer initialized");
        this.consumer.setMessageListener(this.messageListener);
    }

    public void start() throws JMSException {
        this.consumer.start();
        this.connection.start();
    }

    public void stop() throws JMSException {
        this.consumer.stop();
    }

    public String queueName() {
        return this.queueName;
    }

    public static class Builder {
        private String brokerUrl;
        private String queueName;
        private boolean asyncEnabled = false;
        private int acknowledgeMode = 2;
        private int deliveryMode;
        private MessageListener messageListener;

        public Builder(String brokerUrl) {
            this.brokerUrl = brokerUrl;
        }

        public Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Builder acknowledgeMode(int acknowledgeMode) {
            this.acknowledgeMode = acknowledgeMode;
            return this;
        }

        public Builder deliveryMode(int deliveryMode) {
            this.deliveryMode = deliveryMode;
            return this;
        }

        public Builder asyncEnabled(boolean asyncEnabled) {
            this.asyncEnabled = asyncEnabled;
            return this;
        }

        public Builder messageListener(MessageListener messageListener) {
            this.messageListener = messageListener;
            return this;
        }

        public Consumer build() throws JMSException {
            return new Consumer(this);
        }
    }
}

