/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.cloudcontroller.Util;

import com.parablu.cloudcontroller.Util.AsynchHttpHelper;
import com.parablu.graphsdk.entities.GraphResponse;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLException;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBDownloadFile {
    static final Logger logger = LoggerFactory.getLogger(ODBDownloadFile.class);
    private static ODBDownloadFile _this = null;
    private final AsynchHttpHelper httpHelper = new AsynchHttpHelper(null);

    public static ODBDownloadFile getInstance() {
        return _this;
    }

    public static void Initialize() throws SSLException {
        _this = new ODBDownloadFile();
    }

    public InputStream DownloadFile(String driveID, String itemID, String pathtoDownload) {
        try {
            GraphResponse<String> graphRespnse = this.httpHelper.GetContentUrl(driveID, itemID).get();
            if (graphRespnse.value().isPresent()) {
                Response r = (Response)this.httpHelper.getAsync().prepareGet(graphRespnse.value().get()).execute().get();
                if (r.getStatusCode() < 400) {
                    logger.info("Downloading file");
                }
                logger.info("....status code..... " + r.getStatusCode());
                InputStream data = r.getResponseBodyAsStream();
                Path target = Paths.get(pathtoDownload, new String[0]);
                Files.copy(data, target, StandardCopyOption.REPLACE_EXISTING);
                return new FileInputStream(pathtoDownload);
            }
            logger.info("...file not present in onedrive .........");
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Failed to get future", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error("Failed to open file", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Failed to download data", (Throwable)e);
        }
        return null;
    }
}

