/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.cloudcontroller.Util;

import com.parablu.graphsdk.GraphClient;
import com.parablu.graphsdk.entities.GraphResponse;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchHttpHelper {
    static final Logger logger = LoggerFactory.getLogger(AsynchHttpHelper.class);
    private final AsyncHttpClient asyncHttpClient;

    public AsynchHttpHelper(ProxySettings proxy) throws SSLException {
        SslContext sslContext = SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder().setSslContext(sslContext);
        if (proxy != null) {
            ProxyServer ps = new ProxyServer.Builder(proxy.host, proxy.port).setSecuredPort(proxy.securedPort).build();
            builder.setProxyServer(ps);
        }
        DefaultAsyncHttpClientConfig asyncHttpClientConfig = builder.build();
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)asyncHttpClientConfig);
    }

    public AsyncHttpClient getAsync() {
        return this.asyncHttpClient;
    }

    public GraphResponse<String> handleGetContent(Response response) {
        String downloadUrl;
        boolean errorHappened = true;
        GraphResponse<Object> downloadUrlResponse = null;
        if (response.getStatusCode() == 302 && (downloadUrl = response.getHeader((CharSequence)"Location")) != null) {
            logger.info("Download url is " + downloadUrl);
            downloadUrlResponse = new GraphResponse.Builder<String>().setValue(downloadUrl).build();
            errorHappened = false;
        }
        if (errorHappened) {
            downloadUrlResponse = GraphClient.handleErrorResponse(new IOException("something went wrong"), response);
            logger.error("handleDelta failed to parse the delta ITEMs");
        }
        return downloadUrlResponse;
    }

    public CompletableFuture<GraphResponse<String>> GetContentUrl(String driveID, String itemID) {
        String api = "drives/" + driveID + "/items/" + itemID + "/content";
        return GraphClient.getInstance().getGraphHelper().get(api).thenApply(r -> this.handleGetContent((Response)r));
    }

    static void downloadfile(Response r) {
        logger.info("Recieved response!");
        try {
            if (r.getStatusCode() < 400) {
                logger.info("Downloading file");
            }
            InputStream data = r.getResponseBodyAsStream();
            Path target = Paths.get("", new String[0]);
            Files.copy(data, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.error("Failed to download file", (Throwable)e);
        }
    }

    public static class ProxySettings {
        public String host;
        public int port;
        public int securedPort;

        public ProxySettings(String host, int port, int securedPort) {
            this.host = host;
            this.port = port;
            this.securedPort = securedPort;
        }
    }
}

