/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.cloudbackup;

import com.parablu.cloucontroller.channel.BackupChannel;
import com.parablu.cloudbackup.CloudBackupStorageBridge;
import com.parablu.cloudbackup.UploadStatus;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.OneDriveBackupPolicy;
import com.pg.domain.DriveFileInfo;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.UtilService;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.jms.TextMessage;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public enum StorageService {
    GETINST;

    private static final String BACKUP = "BACKUP";
    private static final String COMPLETED = "COMPLETED";
    private static final String STOPPED_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSED_BACKUP_ERROR_CODE = "1992";
    private static final String STARTED = "STARTED";
    static final Logger logger;
    private ConcurrentLinkedQueue<TextMessage> messageQueue = new ConcurrentLinkedQueue();
    BackupChannel channel;
    CloudBackupStorageBridge uploadService;
    UtilService utilServiceObj;
    volatile boolean shutdown = false;
    private static final String STOP_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSE_BACKUP_ERROR_CODE = "1992";
    static final String BASE_FOLDER = "Files/";
    private Set<String> fileUnderProcess = new HashSet<String>();
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private static List<DriveFileInfo> driveFileInfoList1;
    private Set<String> batchUnderProcess = new HashSet<String>();
    private static List<BackupBatch> batchList;

    public boolean initialize(CloudBackupStorageBridge uploadService, UtilService utilService) {
        try {
            logger.debug("Storage service!");
            this.uploadService = uploadService;
            this.utilServiceObj = utilService;
            logger.info("response handler started");
        }
        catch (Exception e) {
            logger.error("Failed to start the consumer! " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void run() {
        logger.debug("Storage service has started running! - " + Thread.currentThread().getName());
        logger.debug("...inside while loop check... ");
        Cloud cloud = this.utilServiceObj.getCloud(1);
        ExecutorService executor = null;
        try {
            long threadSize = this.utilServiceObj.getThreadSize(cloud.getCloudId(), cloud.getCloudName());
            if (threadSize == 0L) {
                threadSize = PCHelperConstant.getThreadLimit();
            }
            threadSize = 4L;
            logger.debug(" threads val........" + threadSize);
            int threadSizeVal = (int)threadSize;
            executor = Executors.newFixedThreadPool(threadSizeVal);
            batchList = this.getBatchFromList(cloud.getCloudId());
            ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
            this.checkThreadStatusAndStartUpload(cloud, executor, pool);
            for (int i = 0; i < threadSizeVal; ++i) {
                logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                this.callUploadFiles(cloud, executor, pool);
            }
            logger.debug(" exit upload part..........");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("exception in backup upload job ......." + e);
        }
        logger.debug("Done!");
    }

    private void callUploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        logger.debug("Files to backup ............... :");
        Runnable uploadJob = () -> this.uploadFiles(cloud, executor, pool);
        pool.submit(uploadJob, "");
    }

    private void uploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        logger.debug("....inside while loop..........");
        BackupBatch backupBatch = null;
        try {
            backupBatch = this.getBackupBatchFromOneDriveServer();
            if (backupBatch != null) {
                this.processMessage(backupBatch, cloud);
                logger.error(backupBatch.getId() + " %%%%%%% upload completed for file ...." + backupBatch.getUserName());
            }
            logger.debug("Thread ready for next File .... ");
        }
        catch (Exception e) {
            logger.error("exception inside storageservice .... " + e.getMessage());
            logger.trace("exception inside storageservice ...." + e);
        }
        if (backupBatch != null && backupBatch.getId() != null) {
            this.batchUnderProcess.remove(backupBatch.getId());
        }
        logger.error("no files to upload so wait and then retry>>>>");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.callUploadFiles(cloud, executor, pool);
    }

    public void processMessage(BackupBatch backupBatch, Cloud cloudval) {
        String policyName = backupBatch.getOdbPolicyName();
        List<DriveFileInfo> fileInfoList = this.getDriveFileInfoFromListForBatchId(1, backupBatch.getId().toString());
        if (CollectionUtils.isEmpty(fileInfoList)) {
            fileInfoList = new ArrayList<DriveFileInfo>();
            logger.debug("...no files to backup....");
        }
        this.sleep1();
        BackupBatch pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), backupBatch.getId().toString());
        logger.debug(backupBatch.getId().toString() + ".. files to process for id..... " + fileInfoList.size());
        int uploadedFiles = 0;
        Long startTime = System.currentTimeMillis();
        if (pbBkpBatch != null && pbBkpBatch.getNoOfFiles() > 0L) {
            String[] parts = pbBkpBatch.getUploadedFiles().split("/");
            try {
                uploadedFiles = Integer.parseInt(parts[0]);
            }
            catch (Exception e) {
                logger.trace("Exception  :" + e);
                logger.error("Exception  :" + e.getMessage());
            }
        }
        long totalSizeToUpload = 0L;
        for (DriveFileInfo fileInfo : fileInfoList) {
            if (fileInfo.isFolder()) continue;
            totalSizeToUpload += fileInfo.getSize().longValue();
        }
        logger.debug("....total size to upload .&*&*... " + totalSizeToUpload);
        backupBatch.setTotalSizeToUpload(totalSizeToUpload / 1024L);
        this.startBackupBatch(backupBatch, cloudval, uploadedFiles);
        logger.debug("... woke after 2 mins");
        int errorCode = 0;
        Iterator<DriveFileInfo> iterator = fileInfoList.iterator();
        DeviceBackupOverView deviceBackupOverView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID());
        while (iterator.hasNext()) {
            DriveFileInfo item = iterator.next();
            pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), backupBatch.getId().toString());
            double fileSizeInMb = this.getFileSizeInMb(item.getSize());
            boolean isUserStorageLimitReached = this.utilServiceObj.isUserO365StorageLimitReached(1, fileSizeInMb, backupBatch.getUserName(), backupBatch.getDeviceUUID());
            logger.debug(fileSizeInMb + "....is user Storage limit reached ..." + isUserStorageLimitReached);
            if (isUserStorageLimitReached) {
                this.sendWarningMail(cloudval.getCloudName(), backupBatch.getUserName(), backupBatch.getOneDriveBackupPolicy().getUserSizeAllowed(), deviceBackupOverView.getDeviceName());
                logger.error(backupBatch.getUserName() + ".... User Storage limit reached ..... ");
                errorCode = 449;
                break;
            }
            if (pbBkpBatch != null) {
                logger.debug(pbBkpBatch.getErrorCode() + "...... before processing file ... " + errorCode);
            }
            if (pbBkpBatch != null && StringUtils.isNotEmpty((String)pbBkpBatch.getErrorCode()) && (pbBkpBatch.getErrorCode().equals("1207") || pbBkpBatch.getErrorCode().equals("1992"))) {
                errorCode = pbBkpBatch.getErrorCode().equals("1207") ? Integer.parseInt("1207") : Integer.parseInt("1992");
                logger.debug("...... sleep ... " + errorCode);
                this.sleep1();
                if (errorCode > 0) break;
                logger.debug(".....batch status current..." + pbBkpBatch.getErrorCode());
            }
            logger.debug(backupBatch.getId().toString() + "...inside while loop after msg ... " + item);
            try {
                logger.debug("Message started! : " + Thread.currentThread().getName() + " ...  " + item.getItemId() + "....." + item.getOperation());
                if (item.getOperation().equalsIgnoreCase("FILE") && !item.isFolder()) {
                    HashedMap arguments = new HashedMap();
                    arguments.put("itemID", item.getItemId());
                    arguments.put("messageID", item.getItemId());
                    arguments.put("backupBatchId", item.getBackupBatchId());
                    arguments.put("userName", item.getUserName());
                    arguments.put("deviceUUID", item.getDeviceUUID());
                    logger.debug("$$$$ calculated path is " + item.getItemPath());
                    arguments.put("file-path", item.getItemPath());
                    arguments.put("file-name", item.getItemName());
                    arguments.put("driveFileInfoId", item.getId().toString());
                    arguments.put("isFullBackup", item.isFullBackup());
                    CompletableFuture<UploadStatus> notifyService = this.uploadService.notifyService((Map<String, ? super Object>)arguments, null);
                    UploadStatus uploadStatus = notifyService.get();
                    logger.debug(uploadedFiles + "...............UPPLOAD STATUS ............... " + uploadStatus.getStatus());
                    if (uploadStatus != null && uploadStatus.getStatus() == 200) {
                        ++uploadedFiles;
                    } else {
                        logger.debug("..$%$%$%$%.file failed......" + item.getItemName());
                    }
                }
                logger.debug(this.shutdown + ".... item processed... " + item.getItemName() + "...." + uploadedFiles);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Failed to handle the message!", (Throwable)e);
                this.fileUnderProcess.remove(item.getItemId());
            }
            logger.debug(uploadedFiles + ".... before deleting batchid check..... " + backupBatch.getId());
            this.updateBackupBatch(backupBatch, cloudval, 1, item.getSize());
            this.uploadService.removeDriveItem(item.getId().toString());
            logger.debug(backupBatch.getTotalNoOfFiles() + ".. batch id completed...." + backupBatch.getId());
            if (iterator.hasNext()) continue;
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.batchUnderProcess.remove(backupBatch.getId().toString());
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), errorCode);
            logger.debug(backupBatch.getTotalNoOfFiles() + "..  completed...." + backupBatch.getId());
            if (deviceBackupOverView == null || !StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) continue;
            NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement();
            notifierEmailBodyElement.setCloudName(cloudval.getCloudName());
            notifierEmailBodyElement.setDeviceName(deviceBackupOverView.getDeviceName());
            notifierEmailBodyElement.setNoOfFilesBackedUp(backupBatch.getTotalNoOfFiles());
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                notifierEmailBodyElement.setTotalBackupSize(StorageService.formatFileSize(Long.parseLong(backupBatch.getUploadedSize())));
            } else {
                notifierEmailBodyElement.setTotalBackupSize("0");
            }
            logger.debug("...before mail..." + backupBatch.getTotalNoOfFiles());
            BackupBatch batch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), backupBatch.getId().toString());
            if (batch != null) {
                logger.debug("...before mail batch..." + batch.getTotalNoOfFiles());
                notifierEmailBodyElement.setNoOfFilesBackedUp(batch.getTotalNoOfFiles());
            }
            this.sendEmail("first-backup-completed", deviceBackupOverView.getUserName(), deviceBackupOverView.getUserName(), deviceBackupOverView.getEmailId(), notifierEmailBodyElement);
        }
        logger.debug("....error code..... " + errorCode);
        if (errorCode == Integer.parseInt("1207")) {
            for (DriveFileInfo item : fileInfoList) {
                this.uploadService.removeDriveItem(item.getId().toString());
            }
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.utilServiceObj.updatePrevDeviceDeltaToken(cloudval.getCloudId(), backupBatch.getDeviceUUID());
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), "ABORTED", backupBatch.getDeviceUUID(), errorCode);
            this.batchUnderProcess.remove(backupBatch.getId().toString());
        }
        if (errorCode == 449) {
            for (DriveFileInfo item : fileInfoList) {
                this.uploadService.removeDriveItem(item.getId().toString());
            }
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.utilServiceObj.updatePrevDeviceDeltaToken(cloudval.getCloudId(), backupBatch.getDeviceUUID());
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), "STOPPED", backupBatch.getDeviceUUID(), 1981);
            this.batchUnderProcess.remove(backupBatch.getId().toString());
            logger.debug("....user storage limit reached... ");
        }
        if (errorCode == Integer.parseInt("1992")) {
            this.utilServiceObj.updateBatchStatusInOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), "PAUSED", backupBatch.getDeviceUUID(), errorCode);
            this.batchUnderProcess.remove(backupBatch.getId().toString());
        }
        logger.debug("........" + backupBatch.getTotalNoOfFiles() + "...." + fileInfoList.size() + "....." + backupBatch.getUploadedFiles());
        if (CollectionUtils.isEmpty(fileInfoList) && StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.batchUnderProcess.remove(backupBatch.getId().toString());
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), errorCode);
            if (deviceBackupOverView != null && StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) {
                NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement();
                notifierEmailBodyElement.setCloudName(cloudval.getCloudName());
                notifierEmailBodyElement.setDeviceName(deviceBackupOverView.getDeviceName());
                if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                    notifierEmailBodyElement.setTotalBackupSize(StorageService.formatFileSize(Long.parseLong(backupBatch.getUploadedSize())));
                } else {
                    notifierEmailBodyElement.setTotalBackupSize("0");
                }
                logger.debug("...before mail1..." + backupBatch.getTotalNoOfFiles());
                BackupBatch batch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), backupBatch.getId().toString());
                if (batch != null) {
                    logger.debug("...before mail batch f..." + batch.getTotalNoOfFiles());
                    notifierEmailBodyElement.setNoOfFilesBackedUp(batch.getTotalNoOfFiles());
                }
                this.sendEmail("first-backup-completed", deviceBackupOverView.getUserName(), deviceBackupOverView.getUserName(), deviceBackupOverView.getEmailId(), notifierEmailBodyElement);
            }
        }
        this.utilServiceObj.deleteEventHubForDeviceUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID(), "START_BACKUP");
    }

    private double getFileSizeInMb(Long fileSize) {
        long filesizeInKB = (long)Math.ceil((double)fileSize.longValue() / 1024.0);
        return StorageService.getSizeinMb(filesizeInKB);
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private void sendWarningMail(String cloudName, String userName, double userStorageQuata, String deviceName) {
        try {
            logger.debug(".. user limit reached mail start....");
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/mail";
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("isInternalCall", "true");
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)userName);
            emailDetails.put("action", (Object)"backup-limit-reached");
            emailDetails.put("actionOn", (Object)userName);
            emailDetails.put("deviceName", (Object)deviceName);
            emailDetails.put("customMailMessage", (Object)String.valueOf(userStorageQuata));
            emailDetails.put("toAdmins", true);
            emailDetails.put("toUser", true);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            logger.debug("user limit reached mail Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    private void sendEmail(String action, String actionOn, String actionBy, String emailId, NotifierEmailBodyElement bodyElement) {
        try {
            logger.debug(".. first email1 completion....");
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + bodyElement.getCloudName() + "/mail";
            logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email url with dev details s...." + url);
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("isInternalCall", "true");
            httpPost.setHeader("bkupsDone", String.valueOf(bodyElement.getNoOfFilesBackedUp()));
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)actionBy);
            emailDetails.put("action", (Object)action);
            emailDetails.put("actionOn", (Object)actionOn);
            emailDetails.put("toUser", true);
            emailDetails.put("customMailMessage", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
            emailDetails.put("deviceName", (Object)String.valueOf(bodyElement.getDeviceName()));
            emailDetails.put("totalStorageUtilized", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
            emailDetails.put("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
            emailDetails.put("toAdmins", true);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            logger.debug("Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    private static String formatFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    private synchronized BackupBatch getBackupBatchFromOneDriveServer() {
        BackupBatch backupBatch;
        int cloudId = 1;
        logger.debug("... inside getBackupBatchFromOneDriveServer... ");
        if (CollectionUtils.isEmpty(batchList)) {
            this.sleep7();
            batchList = this.getBatchFromList(cloudId);
            if (CollectionUtils.isEmpty(batchList)) {
                try {
                    logger.debug("...batch Completed ... ");
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        if ((backupBatch = batchList.get(0)) != null) {
            if (this.batchUnderProcess.contains(backupBatch.getId().toString())) {
                batchList.remove(backupBatch);
                return this.getBackupBatchFromOneDriveServer();
            }
            batchList.remove(backupBatch);
            this.batchUnderProcess.add(backupBatch.getId().toString());
        }
        logger.debug("...after bkp batch list size....." + batchList.size());
        return backupBatch;
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            StorageService.this.callUploadFiles(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    private List<BackupBatch> getBatchFromList(int cloudId) {
        List<OneDriveBackupPolicy> list = this.utilServiceObj.getPolicyForBluKrypt(cloudId);
        for (OneDriveBackupPolicy oneDriveBackupPolicy : list) {
            logger.debug(".... policy name... " + oneDriveBackupPolicy.getPolicyName());
            List<BackupBatch> batchListVal = this.uploadService.getBatchList(cloudId, oneDriveBackupPolicy.getPolicyName());
            if (batchList == null) {
                batchList = new ArrayList<BackupBatch>();
            }
            for (BackupBatch backupBatch : batchListVal) {
                BackupBatch newBackupBatch = new BackupBatch();
                BeanUtils.copyProperties((Object)backupBatch, (Object)newBackupBatch);
                newBackupBatch.setOdbPolicyName(oneDriveBackupPolicy.getPolicyName());
                newBackupBatch.setOneDriveBackupPolicy(oneDriveBackupPolicy);
                batchList.add(newBackupBatch);
            }
        }
        return batchList;
    }

    private void updateBatchAndOverview(int cloudId, ObjectId backupBatchId, String status, String deviceUUID, int errorCode) {
        this.utilServiceObj.updateBackupBatch(cloudId, backupBatchId, status, errorCode);
        Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
        BackupBatch backupBatch = this.utilServiceObj.getBackupBatchById(cloudId, backupBatchId.toString());
        this.updateBackupOverview(cloudId, BACKUP, deviceUUID, device, backupBatch);
    }

    private void sleep1() {
        try {
            logger.debug("... going to sleep for 5 sec..");
            Thread.sleep(3000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private void sleep7() {
        try {
            logger.debug("... going to sleep for 5 sec..");
            Thread.sleep(7000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    private List<DriveFileInfo> getDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        List<DriveFileInfo> list = this.uploadService.getDriveFileInfoFromListForBatchId(cloudId, batchId);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<DriveFileInfo>();
        }
        return list;
    }

    public void updateBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, Long size) {
        logger.debug("calling backup Batch ..." + backupBatchOdb.getNoOfFiles());
        try {
            int cloudId = cloud.getCloudId();
            logger.debug(" ************ ");
            this.utilServiceObj.updateBackupBatch(cloudId, backupBatchOdb.getId().toString(), uploadedFiles, size);
            this.utilServiceObj.updateUplodedFilesInBackupOverView(cloudId, backupBatchOdb.getDeviceUUID(), uploadedFiles, size, backupBatchOdb.getTotalSizeToUpload());
            logger.debug("[backupBatch][" + backupBatchOdb.getUserName() + "][" + backupBatchOdb.getDeviceUUID() + "][" + backupBatchOdb.getId() + "][" + backupBatchOdb.getStatus() + "][" + backupBatchOdb.getBatchStartTimestamp() + "][" + backupBatchOdb.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }

    private void updateBackupOverview(int cloudId, String jobType, String deviceUUID, Device device, BackupBatch backupBatch) {
        logger.debug(".... job type..... " + jobType);
        if (BACKUP.equalsIgnoreCase(jobType)) {
            DeviceBackupOverView overView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (overView == null) {
                logger.debug(" No device backup ....");
                this.utilServiceObj.saveDeviceBackupOverView(cloudId, device);
            } else {
                logger.debug(backupBatch + " update device backup ...." + backupBatch.getBatchStartTimestamp());
                if (StringUtils.isEmpty((String)overView.getFirstBkpStartTime())) {
                    String firstBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
                    overView.setFirstBkpStartTime(firstBkpStartTime);
                }
                String lastBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
                overView.setLastBkpStartTime(lastBkpStartTime);
                if (backupBatch.getBatchEndTimestamp() > 0L) {
                    overView.setLastBkpEndTime(this.getDateInFormat(backupBatch.getBatchEndTimestamp()));
                } else {
                    overView.setLastBkpEndTime(this.getDateInFormat(System.currentTimeMillis()));
                }
                overView.setLastBkpStatus(backupBatch.getStatus());
                overView.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
                logger.debug("TotalNoOfFiles : " + backupBatch.getTotalNoOfFiles() + " UploadedFiles : " + backupBatch.getUploadedFiles());
                overView.setNoOfFilesRemaining(this.getNoOfFilesRemaining(backupBatch.getTotalNoOfFiles(), backupBatch.getUploadedFiles()));
                logger.debug("Backup/Restore Status*" + backupBatch.getStatus() + "**" + backupBatch.getTotalNoOfFiles());
                if (COMPLETED.equalsIgnoreCase(backupBatch.getStatus())) {
                    String lastSuccessfulBkp = this.getDateInFormat(backupBatch.getBatchEndTimestamp());
                    overView.setLastSuccessfulBkp(lastSuccessfulBkp);
                    overView.setLastSuccessfulBackupStartTime(backupBatch.getBatchStartTimestamp());
                    overView.setLastSuccessfulBackupEndTime(backupBatch.getBatchEndTimestamp());
                    logger.debug(device.getUserName() + " @#@# Backup  Completed ........." + device.getDeviceName());
                    long noOfSuccessfulBackups = overView.getNoOfSuccessfulBackups();
                    overView.setNoOfSuccessfulBackups(noOfSuccessfulBackups + 1L);
                    if (StringUtils.isEmpty((String)overView.getFirstBkpEndTime())) {
                        logger.debug(" ..firstbkp empty....");
                        Long firstBkpEndTime = this.utilServiceObj.getFirstBackupEndDate(cloudId, device.getUserName(), device.getDeviceUUID());
                        logger.debug(" ..firstbkp empty...." + firstBkpEndTime);
                        if (firstBkpEndTime != null) {
                            String firstSuccessfulEndBkp = this.getDateInFormat(firstBkpEndTime);
                            overView.setFirstBkpEndTime(firstSuccessfulEndBkp);
                        } else {
                            overView.setFirstBkpEndTime(lastSuccessfulBkp);
                        }
                        if (StringUtils.isNotEmpty((String)backupBatch.getUploadedSize())) {
                            overView.setFirstFullBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                        } else {
                            overView.setFirstFullBkpTotalSizeOfFiles(0L);
                        }
                        overView.setFirstFullBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                    }
                    if (StringUtils.isNotEmpty((String)backupBatch.getUploadedSize())) {
                        overView.setLastSucessfulBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                    } else {
                        overView.setLastSucessfulBkpTotalSizeOfFiles(0L);
                    }
                    overView.setLastSucessfulBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                    overView.setCurrentlyRunningBkpNoOfFiles(0L);
                    overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
                }
                overView.setReason(backupBatch.getErrorCode());
                if (!StringUtils.isEmpty((String)backupBatch.getStatus()) && backupBatch.getStatus().equals("ABORTED")) {
                    overView.setCurrentlyRunningBkpNoOfFiles(0L);
                    overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
                }
                overView.setTotalSizeToUpload(backupBatch.getTotalSizeToUpload());
                this.utilServiceObj.updateDeviceBackupOverView(cloudId, overView);
            }
        }
    }

    long getActualUploadedFiles(String uploadedFiles) {
        if (StringUtils.isEmpty((String)uploadedFiles)) {
            uploadedFiles = "0/0";
        }
        String[] parts = uploadedFiles.split("/");
        return Long.parseLong(parts[0]);
    }

    public void startBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles) {
        String cloudName = cloud.getCloudName();
        logger.debug("calling start backup Batch ...");
        try {
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            String jobType = BACKUP;
            String totalNoOfFiles = "" + backupBatchOdb.getNoOfFiles();
            String deviceUUID = backupBatchOdb.getDeviceUUID();
            logger.debug(" ************ ");
            Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
            BackupBatch backupBatch = new BackupBatch();
            backupBatch.setId(backupBatchOdb.getId());
            backupBatch.setUserName(backupBatchOdb.getUserName());
            backupBatch.setDeviceName(backupBatchOdb.getDeviceName());
            backupBatch.setDeviceUUID(deviceUUID);
            backupBatch.setStatus(STARTED);
            backupBatch.setJobType(jobType);
            backupBatch.setBatchStartTimestamp(System.currentTimeMillis());
            backupBatch.setTotalNoOfFiles(totalNoOfFiles);
            backupBatch.setUploadedFiles(uploadedFiles + "/" + totalNoOfFiles);
            backupBatch.setDeviceName(device.getDeviceName());
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            backupBatch.setNoOfFiles(backupBatchOdb.getNoOfFiles());
            backupBatch.setTotalSizeToUpload(backupBatchOdb.getTotalSizeToUpload());
            this.utilServiceObj.saveBackupBatch(cloudId, backupBatch);
            logger.debug("[backupBatch][" + backupBatch.getUserName() + "][" + backupBatch.getDeviceUUID() + "][" + backupBatch.getId() + "][" + backupBatch.getStatus() + "][" + backupBatch.getBatchStartTimestamp() + "][" + backupBatch.getBatchEndTimestamp() + "]");
            logger.debug(" before updateoverview..");
            this.updateBackupOverview(cloudId, jobType, deviceUUID, device, backupBatch);
            logger.debug(" after updateoverview..");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling method backup Batch ...");
    }

    private String getNoOfFilesRemaining(String totalNoOfFilesFromBatch, String uploadedFilesBatchTemp) {
        String uploadedFilesBatch = uploadedFilesBatchTemp;
        Integer noOfFilesRemaining = 0;
        logger.debug(" Files ********************** " + uploadedFilesBatch);
        if (StringUtils.isEmpty((String)uploadedFilesBatch)) {
            uploadedFilesBatch = "0/" + totalNoOfFilesFromBatch;
        }
        String[] parts = uploadedFilesBatch.split("/");
        try {
            Integer actualNoOfFiles = Integer.parseInt(parts[1]);
            Integer noOfFilesBackedup = Integer.parseInt(parts[0]);
            noOfFilesRemaining = actualNoOfFiles - noOfFilesBackedup;
        }
        catch (Exception e) {
            logger.trace("Exception  :" + e);
            logger.error("Exception  :" + e.getMessage());
        }
        return noOfFilesRemaining.toString();
    }

    private String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    static {
        logger = LoggerFactory.getLogger(StorageService.class);
        driveFileInfoList1 = null;
        batchList = null;
    }

    class NotifierEmailBodyElement {
        private int cloudId;
        private String cloudName;
        private String userName;
        private String deviceName;
        private String restoreDeviceName;
        private String restoreFolder;
        private String noOfFilesBackedUp;
        private String totalBackupSize;
        private boolean notifyAllAdmins;

        NotifierEmailBodyElement() {
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getRestoreDeviceName() {
            return this.restoreDeviceName;
        }

        public void setRestoreDeviceName(String restoreDeviceName) {
            this.restoreDeviceName = restoreDeviceName;
        }

        public String getRestoreFolder() {
            return this.restoreFolder;
        }

        public void setRestoreFolder(String restoreFolder) {
            this.restoreFolder = restoreFolder;
        }

        public String getTotalBackupSize() {
            return this.totalBackupSize;
        }

        public void setTotalBackupSize(String totalBackupSize) {
            this.totalBackupSize = totalBackupSize;
        }

        public String getNoOfFilesBackedUp() {
            return this.noOfFilesBackedUp;
        }

        public void setNoOfFilesBackedUp(String noOfFilesBackedUp) {
            this.noOfFilesBackedUp = noOfFilesBackedUp;
        }

        public boolean isNotifyAllAdmins() {
            return this.notifyAllAdmins;
        }

        public void setNotifyAllAdmins(boolean notifyAllAdmins) {
            this.notifyAllAdmins = notifyAllAdmins;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public int getCloudId() {
            return this.cloudId;
        }

        public void setCloudId(int cloudId) {
            this.cloudId = cloudId;
        }

        public String getCloudName() {
            return this.cloudName;
        }

        public void setCloudName(String cloudName) {
            this.cloudName = cloudName;
        }
    }
}

