/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.cloucontroller.channel;

import com.parablu.cloucontroller.channel.BackupChannel;
import com.parablu.cloudcontroller.Util.Config;
import com.parablu.cloudcontroller.Util.GlobalStrings;
import com.parablu.messagequeue.Consumer;
import com.parablu.messagequeue.Producer;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelService
extends Enum<ChannelService> {
    public static final /* enum */ ChannelService INSTANCE = new ChannelService();
    private final Logger logger = LoggerFactory.getLogger(ChannelService.class);
    private final boolean isController;
    private final boolean initialized;
    private final String controllerName;
    private final String protocol;
    private final String port;
    private final String activeMQURI;
    private final String activeMQrequestQueue;
    private final String activeMQresponseQueue;
    private BackupChannel backupChannel = null;
    private MessageListener messageHandler;
    private static final /* synthetic */ ChannelService[] $VALUES;

    public static ChannelService[] values() {
        return (ChannelService[])$VALUES.clone();
    }

    public static ChannelService valueOf(String name) {
        return Enum.valueOf(ChannelService.class, name);
    }

    private ChannelService() {
        this.logger.info("&&& ChannelService Initializing channel service &&&");
        this.isController = Config.GETINST.isController();
        this.controllerName = "0.0.0.0";
        this.protocol = "tcp";
        Config.GETINST.getProperty(GlobalStrings.ACTIVEMQ_PROTOCOL).orElse("tcp");
        this.port = "61616";
        this.activeMQURI = "tcp://0.0.0.0:61640";
        this.activeMQrequestQueue = Config.GETINST.getProperty(GlobalStrings.ACTIVE_MQ_REQUEST_QUEUE).orElse(GlobalStrings.ACTIVE_MQ_REQUEST_QUEUE_DEFAULT_NAME.toString());
        this.activeMQresponseQueue = Config.GETINST.getProperty(GlobalStrings.ACTIVE_MQ_RESPONSE_QUEUE).orElse(GlobalStrings.ACTIVE_MQ_RESPONSE_QUEUE_DEFAULT_NAME.toString());
        this.logger.info("ChannelService() ActiveMQURI is " + this.activeMQURI + " active MQ request Queue " + this.activeMQrequestQueue + " ActiveMQResponseQueue " + this.activeMQresponseQueue);
        if (this.isController) {
            this.initialized = false;
            assert (false);
        } else {
            this.logger.info("Initializing for StorageService ->" + this.activeMQresponseQueue + "[]" + this.activeMQrequestQueue);
            this.initialized = this.initializeChannel(this.activeMQresponseQueue, this.activeMQrequestQueue);
        }
    }

    private boolean initializeChannel(String requestQueue, String responseQueue) {
        boolean result = false;
        try {
            this.logger.info("&&& initializeChannel -- starting up");
            this.logger.info("Message requester " + this.activeMQURI);
            Producer backupRequestQueue = new Producer.Builder(this.activeMQURI).queueName(requestQueue).deliveryMode(1).build();
            Consumer backupResponseQueue = new Consumer.Builder(this.activeMQURI).queueName(responseQueue).deliveryMode(1).messageListener(this.messageHandler).build();
            this.backupChannel = new BackupChannel(backupRequestQueue, backupResponseQueue);
            backupResponseQueue.start();
            this.logger.info("&&& initializeChannel -- started!");
            result = true;
        }
        catch (JMSException jms) {
            this.logger.error("Failed to create backup channel " + jms.getMessage(), (Throwable)jms);
            this.backupChannel = null;
        }
        return result;
    }

    public BackupChannel getBackupChannel() {
        return this.backupChannel;
    }

    public boolean isInit() {
        return this.initialized;
    }

    static {
        $VALUES = new ChannelService[]{INSTANCE};
    }
}

