/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.CleanAndMovePGInfoService;
import java.util.ArrayList;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class CleanAndMovePGInfoTimer
extends QuartzJobBean
implements Job {
    private static Logger logger = LoggerFactory.getLogger(CleanAndMovePGInfoTimer.class);
    private static final String GATEWAY_NAME = PCHelperConstant.getPropertyFileValueForLocalDBUrl();
    private CleanAndMovePGInfoService cleanAndMovePGInfoService;

    public void setCleanAndMovePGInfoService(CleanAndMovePGInfoService cleanAndMovePGInfoService) {
        this.cleanAndMovePGInfoService = cleanAndMovePGInfoService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"pgInfoCleanJobTrigger")) {
            logger.debug("CleanAndMovePGInfoTimer ............ disabled");
            return;
        }
        try {
            logger.debug("Entering to get PG INFO........@@@@");
            List<String> cloudNames = this.getAllCloudNames();
            for (String cloudName : cloudNames) {
                logger.debug(" Enter cloudName ..... " + cloudName);
                this.cleanAndMovePGInfoService.getInfoFromLocalPGAndSaveToMainDB(cloudName, GATEWAY_NAME);
            }
        }
        catch (Exception e) {
            logger.error("Error in clean and move pg info...", (Throwable)e);
        }
    }

    private List<String> getAllCloudNames() {
        logger.debug("Entering get cloudNames................");
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        ArrayList<String> authorizationTokenElements = new ArrayList<String>();
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/load/all/cloudNames/";
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, String[].class, new Object[0]);
        for (String cloudName : (String[])result.getBody()) {
            authorizationTokenElements.add(cloudName);
        }
        try {
            reqFactory.destroy();
        }
        catch (Exception e) {
            logger.debug("" + e);
        }
        return authorizationTokenElements;
    }
}

