/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BlackListUser;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.util.Collection;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@DisallowConcurrentExecution
public class BlackListUserCleanerJob
extends QuartzJobBean {
    private static Logger logger = LoggerFactory.getLogger(BlackListUserCleanerJob.class);
    private UtilService utilService;

    public UtilService getUtilService() {
        return this.utilService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"blackListUserCleanerJobTrigger")) {
            logger.debug("BlackListUserCleanerJob ............... disabled");
            return;
        }
        int cloudId = 1;
        List blackListUsers = this.utilService.getAllBlackListUsers(cloudId);
        logger.debug("************* Black List User Cleaner Job started ***********" + CollectionUtils.isEmpty((Collection)blackListUsers));
        if (!CollectionUtils.isEmpty((Collection)blackListUsers)) {
            for (BlackListUser blackListUser : blackListUsers) {
                logger.debug("............" + blackListUser.getResponseCode());
                if (blackListUser.getResponseCode().equalsIgnoreCase("404")) {
                    if (this.utilService.checkBackupFileExistForUserByName(blackListUser.getUserName())) {
                        this.utilService.deleteBlackListUser(cloudId, blackListUser.getUserName(), PCHelperConstant.getComponentName());
                        continue;
                    }
                    logger.debug("...checkBackupFileExistForUserByName..." + blackListUser.getUserName() + "..is false...");
                    continue;
                }
                if (this.utilService.isFileUploadedToday(blackListUser.getUserName())) {
                    this.utilService.deleteBlackListUser(cloudId, blackListUser.getUserName(), PCHelperConstant.getComponentName());
                    continue;
                }
                logger.debug(System.currentTimeMillis() + "...isFileUploadedToday..." + blackListUser.getUserName() + "..is false...");
            }
        }
    }
}

