/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.utils;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryUtils {
    private static Logger logger = LoggerFactory.getLogger(RegistryUtils.class);

    public static void setRegistryValue(String hKeyType, String regKeyPath, String keyName, String value) {
        WinReg.HKEY hKey = null;
        if (StringUtils.isEmpty((String)hKeyType) || StringUtils.isEmpty((String)regKeyPath) || StringUtils.isEmpty((String)value)) {
            return;
        }
        if ("HKLM".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_LOCAL_MACHINE;
        } else if ("HKCU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_CURRENT_USER;
        } else if ("HKU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_USERS;
        }
        Advapi32Util.registrySetStringValue((WinReg.HKEY)hKey, (String)regKeyPath, (String)keyName, (String)value);
    }

    public static String getRegistryValue(String hKeyType, String regKeyPath, String key) {
        WinReg.HKEY hKey = null;
        if (StringUtils.isEmpty((String)hKeyType) || StringUtils.isEmpty((String)regKeyPath) || StringUtils.isEmpty((String)key)) {
            return null;
        }
        if ("HKLM".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_LOCAL_MACHINE;
        } else if ("HKCU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_CURRENT_USER;
        } else if ("HKU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_USERS;
        }
        String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)hKey, (String)regKeyPath, (String)key);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        return "null";
    }

    public static void setRegistryvaluesToShowOrHidePrograms(String platForm, int value) {
        try {
            WinReg.HKEY hKey = WinReg.HKEY_LOCAL_MACHINE;
            if (platForm.equalsIgnoreCase("64bit")) {
                Advapi32Util.registrySetIntValue((WinReg.HKEY)hKey, (String)"SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}}_is1", (String)"SystemComponent", (int)value);
            } else {
                Advapi32Util.registrySetIntValue((WinReg.HKEY)hKey, (String)"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{44EEB8EA-37A5-4866-8852-0AC4B90F86CD}}_is1", (String)"SystemComponent", (int)value);
            }
        }
        catch (Exception e) {
            logger.debug("error in adding registry value.. to hide agent" + e.getMessage());
        }
    }

    public static Map<String, String> getRegistryValueSet(String hKeyType, String regKeyPath) {
        WinReg.HKEY hKey = null;
        HashMap<String, String> keySetMap = new HashMap<String, String>();
        try {
            if (StringUtils.isEmpty((String)hKeyType) || StringUtils.isEmpty((String)regKeyPath)) {
                return keySetMap;
            }
            if ("HKLM".equalsIgnoreCase(hKeyType)) {
                hKey = WinReg.HKEY_LOCAL_MACHINE;
            } else if ("HKCU".equalsIgnoreCase(hKeyType)) {
                hKey = WinReg.HKEY_CURRENT_USER;
            } else if ("HKU".equalsIgnoreCase(hKeyType)) {
                hKey = WinReg.HKEY_USERS;
            }
            boolean keyExists = Advapi32Util.registryKeyExists((WinReg.HKEY)hKey, (String)regKeyPath);
            logger.debug("IsKey exists.....for" + regKeyPath + " is " + keyExists);
            if (keyExists) {
                TreeMap valueMap = Advapi32Util.registryGetValues((WinReg.HKEY)hKey, (String)regKeyPath);
                Set keySet = valueMap.keySet();
                List<String> keyList = keySet.stream().collect(Collectors.toList());
                Collections.reverse(keyList);
                keyList.forEach(key -> {
                    String value = (String)valueMap.get(key);
                    logger.debug("key...." + key + " value......" + value);
                    keySetMap.put(value, key.toLowerCase());
                });
            }
            logger.debug(keySetMap.size() + " size.keysetTo string method..." + ((Object)keySetMap).toString());
        }
        catch (Exception e) {
            logger.error("Error in gettting the snaoshot id set..", (Throwable)e);
        }
        return keySetMap;
    }
}

