/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.sync;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.ActivityHistoryImpl;
import com.parablu.epa.common.dao.DownloadTableImpl;
import com.parablu.epa.common.dao.FolderDaoImpl;
import com.parablu.epa.common.dao.ImageTableHistoryImpl;
import com.parablu.epa.common.dao.ImageTableImpl;
import com.parablu.epa.common.dao.MediaFolderDAOImpl;
import com.parablu.epa.common.dao.MediaImageDAOImpl;
import com.parablu.epa.common.dao.SyncPolicyDAOImpl;
import com.parablu.epa.common.dao.SyncedFilesDaoImpl;
import com.parablu.epa.common.dao.UploadTableImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.stringliterals.SyncLiterals;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.pcb.MediaAdapter;
import com.parablu.epa.core.adapter.pcb.SyncAdapter;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.CrawlResponseElement;
import com.parablu.epa.core.element.MediaElement;
import com.parablu.epa.core.element.MediaListElement;
import com.parablu.epa.core.element.MediaListResponseElement;
import com.parablu.epa.core.element.MediaValidationElement;
import com.parablu.epa.core.element.MiniCloudCompleteElementList;
import com.parablu.epa.core.element.MiniCloudElement;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.exception.DatabaseException;
import com.parablu.epa.core.helper.FileSystemUtility;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.service.sync.SyncBaseJob;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.BackupOrRestoreStatusTo;
import com.parablu.epa.core.to.CrawlDbTo;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.GzipTO;
import com.parablu.epa.core.to.MediaFolderTO;
import com.parablu.epa.core.to.MediaTO;
import com.parablu.epa.core.to.RenamedTO;
import com.parablu.epa.core.to.ResponseTO;
import com.parablu.epa.core.to.SyncPolicyTo;
import com.parablu.epa.helper.constant.GeneralHelperConstant;
import com.parablu.epa.helper.exceptions.BaseException;
import com.parablu.epa.helper.utils.ConflictFileNameGenerator;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncJob
extends SyncBaseJob {
    public MediaFolderDAOImpl mediaFolderDAOImpl = null;
    public long acitivityId = 0L;
    public String batchId = "";
    private Logger logger = LoggerFactory.getLogger(SyncJob.class);
    private MediaImageDAOImpl mediaImageDAOImpl = null;
    private MediaAdapter mediaAdapter = null;
    private static final String NULL = "null";
    protected int totalFilestoUploadCount = 0;
    protected int totalFilestoDownloadCount = 0;
    protected String crawlTimeStamp;
    private ActivityHistoryImpl activityHistory;
    private UploadTableImpl uploadtable;
    private DownloadTableImpl downloadtable;
    private List<FileTO> crawledFileTOList = null;
    private List<FileTO> newFileTOList = null;
    private List<FileTO> modifyFileTOList = null;
    private List<FileTO> deletedInClientFileTOList = null;
    private Set<String> oldSetOfFolders = null;
    private List<FileTO> deletedFromServerFileTOList = null;
    private List<FileTO> downloadFilesFileTOList = null;
    private List<RenamedTO> conflictedFilesFileTOList = null;
    private List<FileTO> filesnotToAddFileTOList = null;
    public long lastSuccessfulCrawlTimeStamp = 0L;
    private static final long NEW_ACTIVITY_ENTRY_ID = 0L;
    private static final int CONNECTION_ERROR = 0;
    private static final int CLIENT_ERROR = 1;
    protected String token = null;
    private SyncAdapter syncAdapter = null;
    protected String currentIP = null;
    protected Integer currentPort = null;
    public Connection conn;
    private static final String DEVICE_BLOCKED = "Device Blocked";
    private static final String FAILEDTO_DELETE_UNSHARED_FOLDER = "Failed to delete unshared folder. Continuing sync";
    SyncPolicyDAOImpl syncPolicyDAOImpl = new SyncPolicyDAOImpl(SettingHelper.getSyncdburl());

    public SyncJob() {
        this.folderDBURL = SettingHelper.getFolderDBUrl();
        this.imageTableHistoryDBURL = SettingHelper.getImageTableHistoryDBUrl();
        this.activityHistoryDBURL = SettingHelper.getActivityDBUrl();
        this.downloadTableURL = SettingHelper.getDownloadTableDBUrl();
        this.uploadTableURL = SettingHelper.getUploadTableDBUrl();
        this.dodTableURL = SettingHelper.getDodTableDBUrl();
        this.baseURlForImageTables = SettingHelper.getBaseDBUrl();
        this.deviceUserPath = this.getDevicePath();
        this.activityHistory = new ActivityHistoryImpl(this.activityHistoryDBURL);
        this.uploadtable = new UploadTableImpl(this.uploadTableURL);
        this.downloadtable = new DownloadTableImpl(this.downloadTableURL);
        this.mediaFolderDAOImpl = new MediaFolderDAOImpl(SettingHelper.getMediaDbUrl());
        this.mediaImageDAOImpl = new MediaImageDAOImpl(SettingHelper.getMediaDbUrl());
        this.mediaAdapter = new MediaAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
    }

    private String getDevicePath() {
        String deviceUserPath = SettingHelper.getParabluSyncFolder();
        while (deviceUserPath.endsWith("\\")) {
            deviceUserPath = deviceUserPath.substring(0, deviceUserPath.length() - 1);
        }
        return deviceUserPath;
    }

    public void run() {
        if (this.shouldKillCrawl) {
            return;
        }
        long crawlStartTime = 0L;
        boolean networkStatus = true;
        try {
            this.token = this.readTokenFromFile();
            try {
                this.setUploadDownloadIp();
                this.validatePreviousCrawl();
                this.resetNotificationValues(7, 101);
                crawlStartTime = System.currentTimeMillis();
                this.crawlTimeStamp = Long.toString(crawlStartTime);
                this.batchId = this.backupBatchInitiated("STARTED", "", 0, 0, 0L, "", 0, "");
                List<MiniCloudElement> foldersToCrawl = this.syncParaBluFolder();
                if (foldersToCrawl == null) {
                    return;
                }
                String syncUploadCount = NotificationHelper.getUploadCount();
                String syncDownloadCount = NotificationHelper.getDowloadCount();
                this.resetNotificationValues(15, 101);
                this.uploadMediaFiles();
                this.updateNotifications(crawlStartTime, foldersToCrawl, syncUploadCount, syncDownloadCount);
                networkStatus = true;
                this.backupBatchInitiated("COMPLETED", this.batchId, 0, 0, 0L, "", 0, "");
            }
            catch (CrawlAdapterException e) {
                this.logger.error("CrawlAdapterException", (Throwable)e);
                this.rollBackCrawlAndNotification(0);
                this.checkIfClientTokensValid((BaseException)((Object)e));
                networkStatus = false;
            }
            catch (BaseException e) {
                this.logger.error("BaseException", (Throwable)e);
                this.rollBackCrawlAndNotification(1);
                this.checkIfClientTokensValid(e);
            }
            NotificationHelper.setTotalDownloadCount(0);
            if (networkStatus) {
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
            } else {
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
            }
            this.checkIfClientTokensValid();
            return;
        }
        catch (InterruptedException e) {
            this.logger.error("To exit crawl Thread");
            this.abortUploadAndDownloadProcess();
        }
        catch (Exception e) {
            this.logger.error("Exception occured in crawl service ", (Throwable)e);
        }
        this.jobSucceded = false;
    }

    private void setUploadDownloadIp() {
        NotificationHelper.setCurrentStatus(7, 101);
        GatewayTO syncUploadGatewayTO = this.getSyncPrivacyGatewayTo();
        if (syncUploadGatewayTO == null || !StringUtils.isNotEmpty((String)syncUploadGatewayTO.getGatewayName())) {
            throw new CrawlAdapterException("could not find privacy gateway ip");
        }
        SettingHelper.setSyncUploadIpAddress(syncUploadGatewayTO);
    }

    private void updateNotifications(long crawlStartTime, List<MiniCloudElement> foldersToCrawl, String syncUploadCount, String syncDownloadCount) throws IOException {
        this.updateFileIconOverlays(foldersToCrawl);
        this.crawlFinPostProcessor(syncUploadCount, syncDownloadCount);
        if (NotificationHelper.getTotalDownloadCount() > 0 && NotificationHelper.getTotalUploadCount() > 0) {
            this.updateSystrayToolTipNotification("Sync Completed", syncDownloadCount + " " + SyncLiterals.SYNC_COMPLETE_MESSAGE_TOOLTIP + "\n" + syncUploadCount + " file(s) uploaded");
        } else if (NotificationHelper.getTotalDownloadCount() > 0) {
            this.updateSystrayToolTipNotification("Sync Completed", syncDownloadCount + " " + SyncLiterals.SYNC_COMPLETE_MESSAGE_TOOLTIP);
        } else if (NotificationHelper.getTotalUploadCount() > 0) {
            this.updateSystrayToolTipNotification("Sync Completed", syncUploadCount + " file(s) uploaded");
        }
        if (NotificationHelper.cloudSpaceExceeded) {
            this.resetNotificationValues(10, 100);
        } else {
            this.resetNotificationValues(12, 100);
        }
        NotificationHelper.setLastSyncTime(crawlStartTime);
    }

    private void uploadMediaFiles() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InterruptedException {
        List<MediaFolderTO> mediaFolders = this.mediaFolderDAOImpl.getAllFolderToBackUpFiles();
        HashSet<MediaTO> mediaSet = new HashSet<MediaTO>();
        this.createTablesIfNotExist();
        boolean firstTimeBackUp = this.scanFileSystem(mediaFolders, mediaSet);
        if (!mediaSet.isEmpty()) {
            this.createAndSendRequestAndUpdatedatabase(firstTimeBackUp, mediaSet);
            ArrayList<MediaTO> mediaBackUpList = new ArrayList<MediaTO>(mediaSet);
            NotificationHelper.setCurrentStatus(8, 101);
            this.startMediaUpload(mediaBackUpList);
        }
    }

    private List<MiniCloudElement> syncParaBluFolder() throws InterruptedException {
        this.createCurrentImageTable();
        MiniCloudCompleteElementList cloudElements = this.initiateCrawl();
        this.createFoldersToCrawl(cloudElements);
        this.totalFilestoUploadCount = 0;
        this.totalFilestoDownloadCount = 0;
        ArrayList<String> completeList = new ArrayList<String>();
        this.addAllMiniCloudNames(completeList, cloudElements);
        List<MiniCloudElement> foldersToCrawl = this.createDefaultMiniCloud(cloudElements);
        for (MiniCloudElement miniCloudElement : foldersToCrawl) {
            this.modifyFileTOList = new ArrayList<FileTO>();
            this.newFileTOList = new ArrayList<FileTO>();
            this.deletedInClientFileTOList = new ArrayList<FileTO>();
            this.crawledFileTOList = new ArrayList<FileTO>();
            NotificationHelper.setCurrentCrawlTimeStamp(this.crawlTimeStamp);
            this.startCrawl(miniCloudElement.getId(), miniCloudElement.getMiniCloudName(), completeList);
            this.makeRequestAndClientSideOperations(miniCloudElement.getId(), miniCloudElement.getMiniCloudName());
            if (this.shouldKillCrawl) {
                return null;
            }
            this.totalFilestoUploadCount += (this.newFileTOList == null ? 0 : this.newFileTOList.size()) + (this.modifyFileTOList == null ? 0 : this.modifyFileTOList.size());
            this.totalFilestoDownloadCount += this.downloadFilesFileTOList == null ? 0 : this.downloadFilesFileTOList.size();
        }
        this.notifyUploadAndDownloadProcessAndCleanTransferObjects();
        this.startUploadDownload();
        if (SettingHelper.isErrorOccuredDuringSync()) {
            foldersToCrawl = null;
        }
        return foldersToCrawl;
    }

    private void createTablesIfNotExist() {
        this.mediaFolderDAOImpl.createMediaTable();
        this.mediaImageDAOImpl.createTable();
    }

    private void createAndSendRequestAndUpdatedatabase(boolean firstTimeBackUp, Set<MediaTO> mediaSet) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        byte[] bs = this.createWebRequest(mediaSet);
        if (bs == null) {
            throw new BaseException("gzip byte array is null,serialization failed");
        }
        List<MediaTO> mediaFilesNotToUpload = this.sendWebRequest(bs, firstTimeBackUp);
        mediaSet.removeAll(mediaFilesNotToUpload);
        if (!mediaFilesNotToUpload.isEmpty() && !this.mediaImageDAOImpl.insertListIntoTable(mediaFilesNotToUpload)) {
            throw new DatabaseException("insert list into table failed");
        }
    }

    private List<MediaTO> sendWebRequest(byte[] bs, boolean firstTimeBackUp) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        GzipTO gzipResponse = this.mediaAdapter.validateDeltaForMedia(bs, this.currentIP, firstTimeBackUp, SettingHelper.readTokenFromFile());
        if (gzipResponse == null) {
            throw new CrawlAdapterException(" null gzipResponse (connection error)");
        }
        int responseCode = gzipResponse.getResponseCode();
        if (responseCode == 421 || responseCode == 400 || responseCode == 404) {
            throw new CrawlAdapterException(" HTTP_DEVICE_SESSION_EXPIRED or HTTP_BAD_REQUEST or HTTP_NOT_FOUND:" + responseCode);
        }
        if (responseCode == 416) {
            SettingHelper.setLicenseActive(false);
            throw new CrawlAdapterException(" License Expired");
        }
        if (responseCode == 420) {
            SettingHelper.setDeviceBlocked(true);
            throw new CrawlAdapterException(" User Device Blocked");
        }
        if (responseCode != 200) {
            throw new CrawlAdapterException(" Server Error" + responseCode);
        }
        byte[] responseByte = gzipResponse.getResponse();
        MediaListResponseElement mediaListResponseElement = Xmlparser.parseMediaListResponse((byte[])responseByte);
        if (mediaListResponseElement == null) {
            throw new CrawlAdapterException(" backupListResponseElement; parsed response null");
        }
        return ObjectUtils.convertMediaElementToMediaTO((List)mediaListResponseElement.getFilesNotToAddList().getMediaFileElementList(), (String)"0");
    }

    private byte[] createWebRequest(Set<MediaTO> mediaList) {
        ArrayList<MediaElement> newMediaElements = new ArrayList<MediaElement>();
        this.convertMediaTOListToMediaElementList(mediaList, newMediaElements);
        MediaListElement newMediaListElement = new MediaListElement();
        newMediaListElement.setMediaFileElementList(newMediaElements);
        MediaValidationElement mediaValidationElement = new MediaValidationElement();
        mediaValidationElement.setFilesToAddList(newMediaListElement);
        byte[] bs = CreateXmlObject.createGzipByteArrayForValidateMediaRequest((MediaValidationElement)mediaValidationElement);
        return bs;
    }

    private void convertMediaTOListToMediaElementList(Set<MediaTO> mediaList, List<MediaElement> newMediaFileElements) {
        for (MediaTO fileTO : mediaList) {
            MediaElement mediaElement = new MediaElement();
            ObjectUtils.copyMediaTOtoMediaElement((MediaTO)fileTO, (MediaElement)mediaElement);
            newMediaFileElements.add(mediaElement);
        }
    }

    private boolean scanFileSystem(List<MediaFolderTO> mediaFolders, Set<MediaTO> mediaSet) {
        boolean firstTimeCrawl = true;
        List fileTOs = null;
        List<MediaTO> mediaFileTOs = this.mediaImageDAOImpl.readAllEntriesFromTable();
        if (mediaFileTOs == null) {
            throw new DatabaseException("Sql Exception occurred while readAllEntries From BackupTable");
        }
        if (!mediaFileTOs.isEmpty()) {
            firstTimeCrawl = false;
        }
        for (MediaFolderTO mediaFolder : mediaFolders) {
            FileSystemUtility fileServices = new FileSystemUtility();
            if (mediaFolder.getMediaType().contentEquals("Music")) {
                if (SettingHelper.isTempEnableMusicMediaSync()) {
                    fileTOs = fileServices.crawlFolderEfficientStoringFullPathsForMedia(mediaFolder.getFolderPath(), null, GeneralHelperConstant.supportedExtensionsForMusic, "Music");
                }
            } else if (mediaFolder.getMediaType().contentEquals("Picture")) {
                if (SettingHelper.isTempEnablePicturesMediaSync()) {
                    fileTOs = fileServices.crawlFolderEfficientStoringFullPathsForMedia(mediaFolder.getFolderPath(), null, GeneralHelperConstant.supportedExtensionsForPictures, "Picture");
                }
            } else if (mediaFolder.getMediaType().contentEquals("Video") && SettingHelper.isTempEnableVideosMediaSync()) {
                fileTOs = fileServices.crawlFolderEfficientStoringFullPathsForMedia(mediaFolder.getFolderPath(), null, GeneralHelperConstant.supportedExtensionsForVideos, "Video");
            }
            if (fileTOs == null) continue;
            mediaSet.addAll(fileTOs);
        }
        mediaSet.removeAll(mediaFileTOs);
        return firstTimeCrawl;
    }

    private void updateFileIconOverlays(List<MiniCloudElement> foldersToCrawl) throws IOException {
        ArrayList<FileTO> filesList = new ArrayList<FileTO>();
        for (MiniCloudElement miniCloudElement : foldersToCrawl) {
            String miniCloudPath = "ParaBlu";
            FileTO miniCloud = new FileTO();
            miniCloud.setFileName(miniCloudElement.getMiniCloudName());
            miniCloud.setAbstractFilePath(miniCloudPath);
            filesList.add(miniCloud);
        }
        this.writeToSyncedFilesDB(filesList);
    }

    private void writeToSyncedFilesDB(List<FileTO> filesList) {
        SyncedFilesDaoImpl syncedFilesHandle = null;
        try {
            syncedFilesHandle = this.createSyncedFilesTable();
            syncedFilesHandle.insertFileTOListToTable(this.currentImageTableName);
            syncedFilesHandle.insertFileTOListToTable(filesList);
            if (!SettingHelper.isErrorOccuredDuringSync()) {
                this.logger.debug("Writing files to Syncedfiles Database");
                syncedFilesHandle.insertParentFolder();
            }
            this.refreshExplorer();
        }
        catch (Exception e) {
            this.logger.error("Exception in writeToSyncedFilesDB:", (Throwable)e);
        }
    }

    protected abstract void refreshExplorer();

    private SyncedFilesDaoImpl createSyncedFilesTable() throws SQLException {
        SyncedFilesDaoImpl syncedFilesHandler = new SyncedFilesDaoImpl(SettingHelper.getSyncedFilesDBUrl());
        boolean tableCreated = syncedFilesHandler.createSyncedFilesDB();
        if (!tableCreated) {
            throw new SQLException("Couldnt Create Synced files Table");
        }
        return syncedFilesHandler;
    }

    private void addAllMiniCloudNames(List<String> miniCloudNameList, MiniCloudCompleteElementList cloudElements) {
        if (cloudElements.getRestrictedMiniClouds() != null) {
            for (MiniCloudElement cloudElement : cloudElements.getRestrictedMiniClouds().getMiniClouds()) {
                miniCloudNameList.add(cloudElement.getMiniCloudName());
            }
        }
        if (cloudElements.getUserMiniClouds() != null) {
            for (MiniCloudElement cloudElement : cloudElements.getUserMiniClouds().getMiniClouds()) {
                miniCloudNameList.add(cloudElement.getMiniCloudName());
            }
        }
    }

    private List<MiniCloudElement> createDefaultMiniCloud(MiniCloudCompleteElementList cloudElements) {
        MiniCloudElement parabluCloudElement = new MiniCloudElement();
        parabluCloudElement.setId("0");
        parabluCloudElement.setCreationTimeStamp(0L);
        parabluCloudElement.setMiniCloudName("ParaBlu");
        ArrayList<MiniCloudElement> foldersToCrawl = new ArrayList<MiniCloudElement>(cloudElements.getUserMiniClouds().getMiniClouds());
        foldersToCrawl.add(parabluCloudElement);
        return foldersToCrawl;
    }

    private void checkIfClientTokensValid() throws Exception {
        if (!SettingHelper.isLicenseActive()) {
            this.licenseExpired = true;
            throw new Exception("license Expired");
        }
        if (SettingHelper.isDeviceBlocked()) {
            this.deviceBlocked = true;
            throw new Exception(DEVICE_BLOCKED);
        }
    }

    private void checkIfClientTokensValid(BaseException e) throws Exception {
        if (this.licenseExpired) {
            throw new Exception("license Expired", e);
        }
        if (this.deviceBlocked) {
            throw new Exception("deviceBlocked", e);
        }
        if (this.sessionExpired) {
            throw new Exception("Session Expired", e);
        }
    }

    private void createFoldersToCrawl(MiniCloudCompleteElementList cloudElements) {
        List miniCloudElements = cloudElements.getUserMiniClouds().getMiniClouds();
        List restrictedMiniCloudElements = cloudElements.getRestrictedMiniClouds().getMiniClouds();
        this.readFromFolderDaoAndInitialiseSet();
        for (MiniCloudElement cloudElement : restrictedMiniCloudElements) {
            File file = new File(this.deviceUserPath + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + cloudElement.getMiniCloudName());
            if (!file.exists()) continue;
            if (this.oldSetOfFolders.contains(cloudElement.getMiniCloudName())) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    this.logger.error(FAILEDTO_DELETE_UNSHARED_FOLDER, (Throwable)e);
                }
                continue;
            }
            if (!this.oldSetOfFolders.isEmpty() || !file.exists()) continue;
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                this.logger.error(FAILEDTO_DELETE_UNSHARED_FOLDER, (Throwable)e);
            }
        }
        HashSet<String> newSetOfFolders = new HashSet<String>();
        for (MiniCloudElement cloudElement : miniCloudElements) {
            File file = new File(this.deviceUserPath + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + cloudElement.getMiniCloudName());
            if (!file.exists()) {
                file.mkdirs();
            } else if (!file.isDirectory() && file.renameTo(new File(file.getParent() + StringLiterals.FILE_SEPARATOR + ConflictFileNameGenerator.generateConflictFileName((String)file.getName())))) {
                new File(this.deviceUserPath + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + cloudElement.getMiniCloudName()).mkdirs();
            }
            newSetOfFolders.add(cloudElement.getMiniCloudName());
        }
        if (newSetOfFolders.equals(this.oldSetOfFolders)) {
            this.logger.debug("No change in new and old Set Of Folders");
            return;
        }
        this.clearAndReplaceFolderDb(newSetOfFolders);
    }

    private void clearAndReplaceFolderDb(Set<String> newSet) {
        FolderDaoImpl folderDaoImpl = new FolderDaoImpl(this.folderDBURL);
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : newSet) {
            strings.add(string);
        }
        if (!folderDaoImpl.applySelectedFolders(strings)) {
            throw new DatabaseException("Couldnt reload new entries ");
        }
        this.oldSetOfFolders = newSet;
    }

    private void readFromFolderDaoAndInitialiseSet() {
        FolderDaoImpl folderDaoImpl = new FolderDaoImpl(this.folderDBURL);
        if (this.oldSetOfFolders == null) {
            this.oldSetOfFolders = new HashSet<String>();
            List<String> folderList = folderDaoImpl.getFolderListForCrawl();
            if (folderList == null) {
                throw new DatabaseException("Couldnt access Folder table; getFolderListForCrawl");
            }
            for (String folderString : folderList) {
                this.oldSetOfFolders.add(folderString);
            }
        }
    }

    protected ImageTableHistoryImpl createCurrentImageTable() throws DatabaseException {
        ImageTableHistoryImpl imageTableListDao = new ImageTableHistoryImpl(this.imageTableHistoryDBURL, this.crawlTimeStamp, this.baseURlForImageTables);
        this.createImageTableAndUpdateActivity(imageTableListDao);
        this.previousImageTableName = imageTableListDao.getPreviousImageTableName();
        this.lastSuccessfulCrawlTimeStamp = this.getLastSuccessfullCrawlTimestamp(this.previousImageTableName);
        this.logger.debug("The previous image table name is: " + this.previousImageTableName);
        this.logger.debug("The current image table name is: " + this.currentImageTableName);
        return imageTableListDao;
    }

    private MiniCloudCompleteElementList initiateCrawl() {
        this.currentIP = SettingHelper.getCurrentCloudIpAddress();
        if (SettingHelper.getCurrentHttpsPort() != null) {
            if (SettingHelper.getCurrentHttpsPort().equals(NULL)) {
                this.logger.debug("Port value is null");
            }
            this.currentPort = Integer.valueOf(SettingHelper.getCurrentHttpsPort());
        }
        this.syncAdapter = new SyncAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        ResponseTO responseTO = this.syncAdapter.initiateCrawlRequest(this.currentIP, this.currentPort, this.token);
        if (responseTO == null || responseTO.getResponseCode() == 404 || responseTO.getResponseCode() == 400) {
            responseTO = this.retryWithUpdatedIp(responseTO);
        }
        if (responseTO == null || responseTO.getResponseCode() == 404 || responseTO.getResponseCode() == 400) {
            throw new CrawlAdapterException(" Could resolve ip ,cloud not found");
        }
        this.logger.debug("Response for Initiate Crawl: " + responseTO.getResponseCode());
        if (responseTO.getResponseCode() == 500) {
            this.logger.debug("Error occurred in crawl Service in cloud; HTTP_INTERNAL_ERROR");
            throw new CrawlAdapterException("Error in cloud");
        }
        if (responseTO.getResponseCode() == 416) {
            this.licenseExpired = true;
            throw new BaseException("License Expired");
        }
        if (responseTO.getResponseCode() == 421) {
            this.sessionExpired = true;
            throw new BaseException("Device Session Expired");
        }
        if (responseTO.getResponseCode() == 420) {
            this.deviceBlocked = true;
            throw new BaseException(DEVICE_BLOCKED);
        }
        if (responseTO.getResponse() == null) {
            throw new CrawlAdapterException("reponse null");
        }
        return Xmlparser.parseinitiateCrawlXml((String)responseTO.getResponse());
    }

    private ResponseTO retryWithUpdatedIp(ResponseTO recivedResponseTO) {
        ResponseTO responseTO = recivedResponseTO;
        SettingHelper.checkAndUpdateIpAddress();
        if (responseTO == null || responseTO.getResponseCode() == 404 || responseTO.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getGaeLocalIpAddress();
            this.currentPort = null;
            this.syncAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            responseTO = this.syncAdapter.initiateCrawlRequest(this.currentIP, this.currentPort, this.token);
            this.remapNetworkDrive(responseTO, this.currentIP);
        }
        if (responseTO == null || responseTO.getResponseCode() == 404 || responseTO.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = null;
            this.syncAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            responseTO = this.syncAdapter.initiateCrawlRequest(this.currentIP, this.currentPort, this.token);
            this.remapNetworkDrive(responseTO, this.currentIP);
        }
        if (responseTO == null || responseTO.getResponseCode() == 404 || responseTO.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            if (SettingHelper.getHttpsPort() != null) {
                this.currentPort = Integer.valueOf(SettingHelper.getHttpsPort());
                this.syncAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                responseTO = this.syncAdapter.initiateCrawlRequest(this.currentIP, this.currentPort, this.token);
                this.remapNetworkDrive(responseTO, this.currentIP);
            }
        }
        if (responseTO != null && responseTO.getResponseCode() != 404 && responseTO.getResponseCode() != 400) {
            SettingHelper.setCurrentHttpsPort(this.currentPort == null ? null : String.valueOf(this.currentPort));
            SettingHelper.setCurrentCloudIpAddress(this.currentIP);
            ProxyElement.setIp((String)this.currentIP);
            SettingHelper.applyChangesToSharedPreferences(false);
        }
        return responseTO;
    }

    protected abstract void remapNetworkDrive(ResponseTO var1, String var2);

    private String readTokenFromFile() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return SettingHelper.readTokenFromFile();
    }

    public abstract void abortUploadAndDownloadProcess();

    private void rollBackCrawlAndNotification(int error) {
        this.logger.debug("Rolling Back Crawl And Notification");
        ActivityTO activityto = this.activityHistory.getCurrentStatusFromActivityHistoryTable();
        if (activityto != null && (activityto.getActivityName().equals(CrawlLifecycle.SCANNING.name()) || activityto.getActivityName().equals(CrawlLifecycle.CLOUD_DISCOVERY.name()))) {
            this.crawlFailedPostProcessor();
        }
        if (error == 0) {
            NotificationHelper.setCurrentStatus(1, 100);
        } else {
            NotificationHelper.setCurrentStatus(3, 100);
        }
    }

    private void validatePreviousCrawl() throws Exception {
        ImageTableHistoryImpl imagtablehistory = new ImageTableHistoryImpl(this.imageTableHistoryDBURL, this.crawlTimeStamp, this.baseURlForImageTables);
        imagtablehistory.createImageTableHistory();
        ActivityTO activityto = this.activityHistory.getCurrentStatusFromActivityHistoryTable();
        if (activityto == null || activityto.getActivityName() == null) {
            return;
        }
        String activityName = activityto.getActivityName();
        Date tempStamp = activityto.getActivityTimeStamp();
        long time = tempStamp.getTime();
        this.crawlTimeStamp = String.valueOf(time);
        this.batchId = activityto.getBatchId();
        this.logger.debug(this.batchId + "Validating previous crawl, The previous crawl time stamp is:" + this.crawlTimeStamp);
        if (activityName.equals(CrawlLifecycle.SCANNING.name()) || activityName.equals(CrawlLifecycle.CLOUD_DISCOVERY.name())) {
            activityto.setActivityName(CrawlLifecycle.ABORTED.name());
            this.getAndDeleteCurrentImageTable(activityto);
        } else if (activityName.equals(CrawlLifecycle.EXITED.name())) {
            String uploadCount = this.getTotalUploadcount();
            String downloadCount = this.getTotalDownloadCount();
            this.resumeUploadDownloadAndUpdateActivityHistory(imagtablehistory, uploadCount, downloadCount);
        } else if (activityName.equals(CrawlLifecycle.UPLOAD_DOWNLOAD_RUNNING.name()) || activityName.equals(CrawlLifecycle.UNEXPECTED_TERMINATION.name())) {
            String uploadCount = this.getTotalUploadcount();
            String downloadCount = this.getTotalDownloadCount();
            this.addOrUpdateToActivityHistory(activityto.getActivityID(), CrawlLifecycle.UNEXPECTED_TERMINATION.name(), this.parseCount(uploadCount, activityto.getUploadCount()), this.parseCount(downloadCount, activityto.getDownloadCount()), true);
            this.resumeUploadDownloadAndUpdateActivityHistory(imagtablehistory, uploadCount, downloadCount);
        }
    }

    private String parseCount(String currentTableRowCount, String countFromPreviousActivity) {
        if (currentTableRowCount == null || countFromPreviousActivity == null) {
            return "";
        }
        if (currentTableRowCount.lastIndexOf(47) == -1 || countFromPreviousActivity.lastIndexOf(47) == -1) {
            return "";
        }
        try {
            int lastSlashIndexOfTableRowCount = currentTableRowCount.lastIndexOf(47);
            int currentTotalRowCount = Integer.valueOf(currentTableRowCount.substring(lastSlashIndexOfTableRowCount + 1, currentTableRowCount.length()));
            lastSlashIndexOfTableRowCount = countFromPreviousActivity.lastIndexOf(47);
            int previousTotalRowCount = Integer.valueOf(countFromPreviousActivity.substring(lastSlashIndexOfTableRowCount + 1, countFromPreviousActivity.length()));
            int filesTransferred = previousTotalRowCount - currentTotalRowCount;
            if (filesTransferred >= 0) {
                return filesTransferred + "/" + previousTotalRowCount;
            }
        }
        catch (NumberFormatException e) {
            this.logger.error("NumberFormatException while tring to get upload count /download count before download/upload terminated: " + e);
        }
        return "";
    }

    private String getTotalDownloadCount() {
        DownloadTableImpl downloadTableHandler = new DownloadTableImpl(this.downloadTableURL);
        long totalDownloadCount = downloadTableHandler.getRowCountFromTable();
        String downloadCount = "0/" + totalDownloadCount;
        return downloadCount;
    }

    private String getTotalUploadcount() {
        UploadTableImpl uploadTableHandler = new UploadTableImpl(this.uploadTableURL);
        long totalUploadCount = uploadTableHandler.getRowCountFromTable();
        String uploadCount = "0/" + totalUploadCount;
        return uploadCount;
    }

    private void resumeUploadDownloadAndUpdateActivityHistory(ImageTableHistoryImpl imagtablehistory, String uploadCount, String downloadCount) throws InterruptedException {
        this.acitivityId = this.updateActivityHistoryBasedOnUploadDownloadFailureStatus(uploadCount, downloadCount);
        NotificationHelper.setCurrentStatus(8, 101);
        NotificationHelper.setCurrentCrawlTimeStamp(this.crawlTimeStamp);
        NotificationHelper.setCurrentActivityId(this.acitivityId);
        this.currentImageTableName = imagtablehistory.getCurrentImageTableName();
        this.startUploadDownload();
        String newUploadCount = NotificationHelper.getUploadCount();
        String newDownloadCount = NotificationHelper.getDowloadCount();
        this.crawlFinPostProcessor(newUploadCount, newDownloadCount);
        this.resetNotificationValues(12, 100);
    }

    private long updateActivityHistoryBasedOnUploadDownloadFailureStatus(String uploadCount, String downloadCount) {
        return this.addOrUpdateToActivityHistory(0L, CrawlLifecycle.UPLOAD_DOWNLOAD_RUNNING.name(), uploadCount, downloadCount, false);
    }

    protected void getAndDeleteCurrentImageTable(ActivityTO activityto) {
        ImageTableHistoryImpl imageTableListDao = new ImageTableHistoryImpl(this.imageTableHistoryDBURL, this.crawlTimeStamp, this.baseURlForImageTables);
        String curImageTableName = imageTableListDao.getCurrentImageTableName();
        if (curImageTableName != null) {
            this.logger.debug("Deleting the current image table");
            imageTableListDao.deleteImageTable(curImageTableName, activityto);
            File delTable = new File(this.baseURlForImageTables + StringLiterals.FILE_SEPARATOR + curImageTableName);
            if (delTable.exists()) {
                delTable.delete();
            }
        }
    }

    private void removeFromFilesToAddList() {
        if (!this.newFileTOList.isEmpty() && !this.filesnotToAddFileTOList.isEmpty()) {
            for (FileTO fileTO : this.filesnotToAddFileTOList) {
                this.newFileTOList.remove(fileTO);
            }
        }
    }

    private void renameFilesInHost() {
        if (this.conflictedFilesFileTOList == null || this.conflictedFilesFileTOList.isEmpty()) {
            return;
        }
        ImageTableImpl curTableImpl = new ImageTableImpl(this.baseURlForImageTables + StringLiterals.CONSTANTS_FILE_SEPARATOR + this.currentImageTableName, this.baseURlForImageTables);
        for (RenamedTO renTO : this.conflictedFilesFileTOList) {
            String path = this.deviceUserPath + StringLiterals.FILE_SEPARATOR + renTO.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + renTO.getOldFileName();
            String newPath = this.deviceUserPath + StringLiterals.FILE_SEPARATOR + renTO.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + renTO.getNewfileName();
            File file = new File(path);
            File newfile = new File(newPath);
            this.logger.debug(file.getName() + " being renamed to " + newfile.getName());
            file.renameTo(newfile);
            this.updateSystrayToolTipNotification("File conflict detected", "The file " + renTO.getOldFileName() + " was renamed to " + renTO.getNewfileName() + " due to conflicting content.");
        }
        this.uploadtable.updateTable(this.conflictedFilesFileTOList);
        curTableImpl.updateTable(this.conflictedFilesFileTOList, this.currentImageTableName);
    }

    private void deleteFilesFromHost() {
        if (this.deletedFromServerFileTOList.isEmpty()) {
            return;
        }
        this.logger.debug("deleting Files From Host");
        for (FileTO fileTO : this.deletedFromServerFileTOList) {
            this.logger.debug("Deleting " + fileTO.getFileName());
            String filePath = this.deviceUserPath + StringLiterals.FILE_SEPARATOR + fileTO.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileTO.getFileName();
            File file = new File(filePath);
            if (!file.exists()) continue;
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                this.logger.error("Error while force deleting directory,IOException " + e);
                this.logger.error("Exception", (Throwable)e);
            }
        }
        ImageTableImpl imagetable = new ImageTableImpl(this.baseURlForImageTables + StringLiterals.CONSTANTS_FILE_SEPARATOR + this.currentImageTableName, this.baseURlForImageTables);
        imagetable.removeFilTOListFromTable(this.deletedFromServerFileTOList, this.currentImageTableName);
    }

    protected void startCrawl(String miniCloudId, String miniCloudFolder, List<String> minicloudList) throws DatabaseException {
        boolean insertOperationSucces;
        List curFileTOList;
        HashMap<CallSite, FileTO> fileHashMap = null;
        List<FileTO> prevFileTOList = null;
        this.logger.debug("Here for mini cloud id:" + miniCloudId);
        FileSystemUtility fileServices = new FileSystemUtility();
        ImageTableImpl imageTableHandler = new ImageTableImpl(this.baseURlForImageTables + StringLiterals.CONSTANTS_FILE_SEPARATOR + this.currentImageTableName, this.baseURlForImageTables);
        if (this.previousImageTableName != null) {
            prevFileTOList = imageTableHandler.getImageInformationWithMiniCloudId(this.previousImageTableName, miniCloudId);
        }
        if (prevFileTOList != null && !prevFileTOList.isEmpty()) {
            fileHashMap = new HashMap<CallSite, FileTO>();
            for (FileTO fileTO : prevFileTOList) {
                String absPath = this.deviceUserPath + StringLiterals.FILE_SEPARATOR + fileTO.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileTO.getFileName();
                fileHashMap.put((CallSite)((Object)absPath), fileTO);
            }
        }
        Map<String, String> extensionsMap = this.syncPolicyDAOImpl.getInclusionExtensions();
        List<SyncPolicyTo> tos = this.syncPolicyDAOImpl.getSyncPolicyDetails();
        int allowedSizeForSync = 0;
        if (tos != null && !tos.isEmpty()) {
            allowedSizeForSync = tos.get(0).getMaxFileSize();
        }
        if ((curFileTOList = "0".equalsIgnoreCase(miniCloudId) ? fileServices.crawlFolderEfficientExcludingMiniClouds(this.deviceUserPath + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu", this.deviceUserPath, fileHashMap, miniCloudId, minicloudList, extensionsMap, allowedSizeForSync) : fileServices.crawlFolderEfficient(this.deviceUserPath + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu" + StringLiterals.CONSTANTS_FILE_SEPARATOR + miniCloudFolder, this.deviceUserPath, fileHashMap, miniCloudId, extensionsMap, allowedSizeForSync, minicloudList)) != null) {
            this.crawledFileTOList.addAll(curFileTOList);
        }
        if (this.shouldKillCrawl) {
            return;
        }
        if (this.crawledFileTOList.isEmpty()) {
            this.logger.debug("No Files/folders present Selected");
        }
        if (!this.crawledFileTOList.isEmpty() && !(insertOperationSucces = imageTableHandler.storeImageInformation(this.crawledFileTOList, this.currentImageTableName))) {
            throw new DatabaseException("Database Operation Failed for inserting records to current image table");
        }
        if (this.previousImageTableName != null) {
            this.crawledFileTOList.clear();
            this.crawledFileTOList = null;
            this.getFilesToAddModifyAndDelete(miniCloudId, imageTableHandler);
        } else {
            this.logger.debug("First time crawl,no previous table present");
            this.addAll(this.newFileTOList, this.crawledFileTOList, miniCloudId);
            this.crawledFileTOList.clear();
            this.crawledFileTOList = null;
        }
        this.crawledFileTOList = null;
    }

    private void addAll(List<FileTO> newFileTOList2, List<FileTO> crawledFileTOList2, String miniCloudId) {
        for (FileTO fileTO : crawledFileTOList2) {
            fileTO.setMiniCloudId(miniCloudId);
            newFileTOList2.add(fileTO);
        }
    }

    public void createImageTableAndUpdateActivity(ImageTableHistoryImpl imageTableListDao) throws DatabaseException {
        long tempLongTimeStamp = Long.parseLong(this.crawlTimeStamp);
        Date tempStamp = new Date(tempLongTimeStamp);
        ActivityTO activity = new ActivityTO();
        activity.setActivityName(CrawlLifecycle.SCANNING.name());
        activity.setActivityTimeStamp(tempStamp);
        activity.setUploadCount(NULL);
        activity.setDownloadCount(NULL);
        activity.setBatchId(this.batchId);
        CrawlDbTo crawlDbTo = imageTableListDao.createImageTable(activity);
        if (crawlDbTo == null) {
            throw new DatabaseException("Exception occured while  creating image table");
        }
        this.currentImageTableName = crawlDbTo.getImageTableName();
        this.acitivityId = crawlDbTo.getActivityId();
        NotificationHelper.setCurrentActivityId(this.acitivityId);
    }

    public abstract void startUploadDownload() throws InterruptedException;

    public abstract void startMediaUpload(List<MediaTO> var1) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException;

    protected void sendWebRequest(String miniCloudId, String miniCloudName) throws BaseException, CrawlAdapterException {
        GzipTO crawlresponseObject;
        String lastCrawlTimeStampString = String.valueOf(this.lastSuccessfulCrawlTimeStamp);
        if (this.token == null) {
            throw new BaseException("Auth token not found");
        }
        byte[] bytes = this.createDeltadifferenceGzip(lastCrawlTimeStampString);
        if (bytes == null) {
            throw new BaseException("Bean utils or Simple Xml Exception occcurred; bytes = null");
        }
        if (this.syncAdapter == null) {
            this.syncAdapter = new SyncAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        }
        if ((crawlresponseObject = this.syncAdapter.getDeltaGzip(bytes, this.currentIP, this.currentPort, miniCloudId, miniCloudName, this.token)) == null) {
            throw new CrawlAdapterException("cloud not reachable;  crawlresponseObject is null");
        }
        if (crawlresponseObject.getResponseCode() == 500) {
            this.logger.debug("Error occurred in crawl Service in cloud; HTTP_INTERNAL_ERROR");
            throw new BaseException("Error in cloud");
        }
        if (crawlresponseObject.getResponseCode() == 416) {
            this.licenseExpired = true;
            throw new BaseException("License Expired");
        }
        if (crawlresponseObject.getResponseCode() == 421) {
            this.sessionExpired = true;
            throw new BaseException("Device Session Expired");
        }
        if (crawlresponseObject.getResponseCode() == 401) {
            this.sessionExpired = true;
            throw new BaseException("Unauthorized");
        }
        if (crawlresponseObject.getResponseCode() == 420) {
            this.deviceBlocked = true;
            throw new BaseException(DEVICE_BLOCKED);
        }
        if (crawlresponseObject.getResponse() == null) {
            throw new CrawlAdapterException("crawlresponseObject; reponse null");
        }
        this.parseAndExtractResponse(crawlresponseObject, miniCloudId);
    }

    private void parseAndExtractResponse(GzipTO response, String miniCloudId) {
        CrawlResponseElement crawlResponseElement = Xmlparser.parseCrawlGzip((byte[])response.getResponse());
        if (crawlResponseElement == null) {
            this.logger.debug("Exception occured during string parsing");
            throw new BaseException("couldnt parse String");
        }
        this.deletedFromServerFileTOList = ObjectUtils.convertToFileTO((List)crawlResponseElement.getDeletedFileList().getFileElementList(), (String)miniCloudId);
        crawlResponseElement.getDeletedFileList().setFileElementList(null);
        this.downloadFilesFileTOList = ObjectUtils.convertToFileTO((List)crawlResponseElement.getDownloadFileList().getFileElementList(), (String)miniCloudId);
        crawlResponseElement.getDownloadFileList().setFileElementList(null);
        this.filesnotToAddFileTOList = ObjectUtils.convertToFileTO((List)crawlResponseElement.getFilesNotToAddList().getFileElementList(), (String)miniCloudId);
        crawlResponseElement.getFilesNotToAddList().setFileElementList(null);
        this.conflictedFilesFileTOList = ObjectUtils.convertToRenamedTO((List)crawlResponseElement.getRenameList().getFileElementList());
        crawlResponseElement.getRenameList().setFileElementList(null);
        this.logger.debug("Number of files to download:" + this.downloadFilesFileTOList.size());
        this.logger.debug("Number of files to delete:" + this.deletedFromServerFileTOList.size());
        this.logger.debug("Number of files to not to upload:" + this.filesnotToAddFileTOList.size());
        this.logger.debug("Number of files conflicting :" + this.conflictedFilesFileTOList.size());
    }

    protected long getLastSuccessfullCrawlTimestamp(String previousImageName) {
        ActivityTO activityto = this.activityHistory.getlastSuccessfullEntryFromActivityHistoryTable();
        if (activityto != null && previousImageName != null) {
            this.lastSuccessfulCrawlTimeStamp = activityto.getActivityTimeStamp().getTime();
        }
        return this.lastSuccessfulCrawlTimeStamp;
    }

    private byte[] createDeltadifferenceGzip(String lastSuccessfulCrawlTimeStamp) {
        return CreateXmlObject.createXmlByteArrayForCrawl(this.newFileTOList, this.modifyFileTOList, this.deletedInClientFileTOList, (String)this.crawlTimeStamp, (String)lastSuccessfulCrawlTimeStamp);
    }

    protected void createUploadDownloadTables() {
        if (!(this.downloadtable.insertListToTable(this.downloadFilesFileTOList) && this.uploadtable.insertListToTable(this.newFileTOList) && this.uploadtable.insertListToTable(this.modifyFileTOList))) {
            throw new CrawlAdapterException("couldnt insert to upload/download table");
        }
    }

    private void crawlFailedPostProcessor() {
        ActivityTO activityTO = new ActivityTO();
        activityTO.setActivityID(this.acitivityId);
        activityTO.setActivityName(CrawlLifecycle.ABORTED.name());
        activityTO.setUploadCount(NULL);
        activityTO.setDownloadCount(NULL);
        if (StringUtils.isEmpty((String)this.crawlTimeStamp)) {
            activityTO.setActivityTimeStamp(new Date(0L));
        } else {
            activityTO.setActivityTimeStamp(new Date(Long.parseLong(this.crawlTimeStamp)));
        }
        this.getAndDeleteCurrentImageTable(activityTO);
        this.crawledFileTOList = null;
        this.newFileTOList = null;
        this.modifyFileTOList = null;
        this.deletedInClientFileTOList = null;
        this.downloadFilesFileTOList = null;
        this.conflictedFilesFileTOList = null;
        this.filesnotToAddFileTOList = null;
        this.deletedFromServerFileTOList = null;
    }

    protected void crawlFinPostProcessor(String uploadCount, String downloadcount) {
        if (SettingHelper.isErrorOccuredDuringSync()) {
            this.logger.error("Error occurred during sync so don't update the crawl status");
            return;
        }
        ImageTableHistoryImpl imageTableListDao = new ImageTableHistoryImpl(this.imageTableHistoryDBURL, this.crawlTimeStamp, this.baseURlForImageTables);
        String oldestImageTableName = imageTableListDao.getOldestImageTableName();
        this.logger.debug("Deleteing oldest image table" + oldestImageTableName);
        if (oldestImageTableName != null && !oldestImageTableName.equals(this.currentImageTableName)) {
            this.logger.debug("Deleting the oldest image table");
            ActivityTO activityTO = new ActivityTO();
            activityTO.setActivityID(this.acitivityId);
            activityTO.setActivityName(CrawlLifecycle.FINISHED.name());
            activityTO.setUploadCount(uploadCount);
            activityTO.setDownloadCount(downloadcount);
            activityTO.setActivityTimeStamp(new Date(Long.parseLong(this.crawlTimeStamp)));
            imageTableListDao.deleteImageTable(oldestImageTableName, activityTO);
            File delTable = new File(this.baseURlForImageTables + StringLiterals.FILE_SEPARATOR + oldestImageTableName);
            if (delTable.exists()) {
                delTable.delete();
            }
        } else {
            this.addOrUpdateToActivityHistory(this.acitivityId, CrawlLifecycle.FINISHED.name(), uploadCount, downloadcount, true);
        }
        this.crawledFileTOList = null;
        this.newFileTOList = null;
        this.modifyFileTOList = null;
        this.deletedInClientFileTOList = null;
        this.downloadFilesFileTOList = null;
        this.conflictedFilesFileTOList = null;
        this.filesnotToAddFileTOList = null;
        this.deletedFromServerFileTOList = null;
    }

    private void makeRequestAndClientSideOperations(String miniCloudId, String miniCloudFolder) {
        this.addOrUpdateToActivityHistory(this.acitivityId, CrawlLifecycle.CLOUD_DISCOVERY.name(), null, null, true);
        this.sendWebRequest(miniCloudId, miniCloudFolder);
        this.removeFromFilesToAddList();
        this.createUploadDownloadTables();
        this.deleteFilesFromHost();
        this.renameFilesInHost();
    }

    protected void sleepThread(long timeElapsedDuringCrawl) {
    }

    protected long addOrUpdateToActivityHistory(long activityID, String activityName, String uploadCount, String downloadCount, boolean update) {
        long tempLongTimeStamp = Long.parseLong(this.crawlTimeStamp);
        Date tempStamp = new Date(tempLongTimeStamp);
        ActivityTO activity = new ActivityTO();
        activity.setActivityName(activityName);
        if (uploadCount == null) {
            activity.setUploadCount(NULL);
        } else {
            activity.setUploadCount(uploadCount);
        }
        if (downloadCount == null) {
            activity.setDownloadCount(NULL);
        } else {
            activity.setDownloadCount(downloadCount);
        }
        activity.setActivityTimeStamp(tempStamp);
        activity.setActivityID(activityID);
        activity.setBatchId(this.batchId);
        if (!update) {
            return this.activityHistory.addEventToActivityHistoryTable(activity);
        }
        this.activityHistory.updateEventToActivityHistoryTable(activity);
        return 0L;
    }

    private void resetNotificationValues(int activityState, int currentActivity) {
        NotificationHelper.setCurrentStatus(activityState, currentActivity);
        NotificationHelper.setDowloadCount("0/0");
        NotificationHelper.setUploadCount("0/0");
        NotificationHelper.setFileBeingUploaded("");
        NotificationHelper.setFileBeingDownloaded("");
    }

    private void getFilesToAddModifyAndDelete(String miniCloudId, ImageTableImpl imageTableHandler) throws DatabaseException {
        if (!imageTableHandler.addPreviousFilesFromPreviousImageTable(this.previousImageTableName, this.currentImageTableName, this.deviceUserPath, miniCloudId)) {
            throw new DatabaseException("Couldnt add old files from previous image table");
        }
        this.deletedInClientFileTOList = imageTableHandler.getDeletedFilesBetweenImageTables(this.currentImageTableName, miniCloudId);
        this.modifyFileTOList = imageTableHandler.getFilesModifilesBetweenImageTables(this.previousImageTableName, this.currentImageTableName, miniCloudId);
        this.newFileTOList = imageTableHandler.getNewlyCreatedFilesBetweenImageTables(this.previousImageTableName, this.currentImageTableName, miniCloudId);
        if (this.deletedInClientFileTOList == null || this.modifyFileTOList == null || this.newFileTOList == null) {
            throw new DatabaseException("Couldnt add old files from previous image table");
        }
        this.logger.debug("Number of files to be deleted :" + this.deletedInClientFileTOList.size());
        this.logger.debug("Number of files to be modified :" + this.modifyFileTOList.size());
        this.logger.debug("Number of files which are totally new ,to be uploaded also :" + this.newFileTOList.size());
    }

    private void notifyUploadAndDownloadProcessAndCleanTransferObjects() {
        String uploadCount = "0/" + this.totalFilestoUploadCount;
        String downloadCount = "0/" + this.totalFilestoDownloadCount;
        NotificationHelper.setCurrentStatus(8, 101);
        this.addOrUpdateToActivityHistory(this.acitivityId, CrawlLifecycle.UPLOAD_DOWNLOAD_RUNNING.name(), uploadCount, downloadCount, true);
        this.newFileTOList = null;
        this.modifyFileTOList = null;
    }

    private String backupBatchInitiated(String batchStatus, String batchId, int totalCount, int errorCode, long totalUploadSize, String totalUploadedCount, int crawlCount, String crawlTimeStamp) {
        String currentBatchId = batchId;
        BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        String jobType = "SYNC";
        try {
            this.logger.debug("the STATUS:" + batchStatus);
            BackupOrRestoreStatusTo backupOrRestoreStatusTo = new BackupOrRestoreStatusTo();
            backupOrRestoreStatusTo.setStatus(batchStatus);
            backupOrRestoreStatusTo.setIp(SettingHelper.getCurrentCloudIpAddress());
            backupOrRestoreStatusTo.setToken(SettingHelper.readTokenFromFile());
            backupOrRestoreStatusTo.setBatchId(currentBatchId);
            backupOrRestoreStatusTo.setJobType(jobType);
            backupOrRestoreStatusTo.setDeviceName(SettingHelper.getDeviceName());
            backupOrRestoreStatusTo.setTotalCount(totalCount);
            backupOrRestoreStatusTo.setErrorCode(errorCode);
            backupOrRestoreStatusTo.setDeviceUUID(SettingHelper.getDeviceUUId());
            backupOrRestoreStatusTo.setTotalUploadSize(totalUploadSize);
            backupOrRestoreStatusTo.setTotalUploadedCount(totalUploadedCount);
            backupOrRestoreStatusTo.setCrawlCount(crawlCount);
            backupOrRestoreStatusTo.setCrawlTimeStamp(crawlTimeStamp);
            backupOrRestoreStatusTo.setFullBackup(false);
            backupOrRestoreStatusTo.setDiskSpaceDetails(new ParabluFileSystemUtils().getSystemSpace());
            currentBatchId = backupAdapter.sendEmailNotification(backupOrRestoreStatusTo);
        }
        catch (Exception e) {
            currentBatchId = "-1";
            this.logger.trace("" + e);
            this.logger.error(" Exception inside  put batch " + e.getMessage());
        }
        return currentBatchId;
    }

    private GatewayTO getSyncPrivacyGatewayTo() {
        return PolicyManagementServerHelper.getPrivacyGatewayIP("BOTH", "SYNC");
    }
}

