/*
 * Decompiled with CFR 0.152.
 */
package com.para;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class PGCollectionDataClean {
    public static void main(String[] args) throws ConfigurationException, IOException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mainMongoIP").toString();
        String mongoPort = config.getProperty("mainMongoPort").toString();
        String cloudName = config.getProperty("cloudName").toString();
        String filePath = config.getProperty("filePath").toString();
        String blukryptIP = config.getProperty("blukryptIP").toString();
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort) || StringUtils.isEmpty(cloudName) || StringUtils.isEmpty(blukryptIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("Main mongo connectivity success  ");
        MongoClientURI uriLocal = new MongoClientURI("mongodb://neil:parablu@localhost:27017/blukrypt");
        MongoClient clientLocal = new MongoClient(uriLocal);
        MongoDatabase dbLocal = client.getDatabase(uriLocal.getDatabase());
        System.out.println("Local mongo connectivity success  ");
        String localBKPCollName = "PRIVACY_GATEWAY_BACKUP_" + cloudName.toUpperCase() + "_BKP_LOCAL".toUpperCase();
        String localCollName = "PRIVACY_GATEWAY_BACKUP_" + cloudName.toUpperCase() + "_LOCAL".toUpperCase();
        MongoCollection<Document> pgDBCollection = db.getCollection("PRIVACY_GATEWAY");
        Document pgConfig = (Document)pgDBCollection.find(new BasicDBObject("gatewayName", blukryptIP)).first();
        String pgOverloadLimit = "";
        if (pgConfig != null && pgConfig.get("componentsProperties") != null) {
            Map componentsProperties = (Map)pgConfig.get("componentsProperties");
            pgOverloadLimit = (String)componentsProperties.get("pgOverloadLimit");
            System.out.println("pgOverloadLimit is :" + pgOverloadLimit);
        } else {
            System.out.println("PRIVACY_GATEWAY is empty for gatewayName " + blukryptIP);
            System.exit(0);
        }
        StringBuilder incomeStopAndRemoveFailedFilesData = new StringBuilder();
        incomeStopAndRemoveFailedFilesData.append("use parablu001;\n");
        try {
            FileOutputStream out = new FileOutputStream(String.valueOf(filePath) + "/" + "incomeStop.js");
            incomeStopAndRemoveFailedFilesData.append("db.PRIVACY_GATEWAY.update({\"gatewayName\":\"" + blukryptIP + "\"},{$set:{\"componentsProperties.pgOverloadLimit\":\"0\"}});");
            incomeStopAndRemoveFailedFilesData.append("\n");
            incomeStopAndRemoveFailedFilesData.append("db.FAILED_FILES.remove({\"gatewayName\":\"" + blukryptIP + "\"})");
            out.write(incomeStopAndRemoveFailedFilesData.toString().getBytes());
            out.close();
        }
        catch (Exception e) {
            System.out.println("Exception " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("Creation of incomeStop.js is completed.");
        StringBuilder incomeStartData = new StringBuilder();
        incomeStartData.append("use parablu001;\n");
        try {
            FileOutputStream out = new FileOutputStream(String.valueOf(filePath) + "/" + "incomeStart.js");
            incomeStartData.append("db.PRIVACY_GATEWAY.update({\"gatewayName\":\"" + blukryptIP + "\"},{$set:{\"componentsProperties.pgOverloadLimit\":\"" + pgOverloadLimit + "\"}})");
            out.write(incomeStartData.toString().getBytes());
            out.close();
        }
        catch (Exception e) {
            System.out.println("Exception " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("Creation of incomeStart.js is completed.");
        StringBuilder dropBKPColl = new StringBuilder();
        dropBKPColl.append("use blukrypt;\n");
        try {
            FileOutputStream out = new FileOutputStream(String.valueOf(filePath) + "/" + "dropBKPColl.js");
            dropBKPColl.append("db." + localBKPCollName + ".drop()");
            out.write(dropBKPColl.toString().getBytes());
            out.close();
        }
        catch (Exception e) {
            System.out.println("Exception " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("Creation of incomeStart.js is completed.");
        StringBuilder actualScript = new StringBuilder();
        actualScript.append("service tomcat-job1 stop");
        actualScript.append("\n");
        actualScript.append("sudo mongo " + mongoIP + ":" + mongoPort + " -u \"neil\" -p \"parablu\" --authenticationDatabase \"admin\" < incomeStop.js");
        actualScript.append("\n");
        actualScript.append("service tomcat-pcb1 restart");
        actualScript.append("\n");
        actualScript.append("mongoexport -h  " + mongoIP + ":" + mongoPort + " -u \"neil\" -p \"parablu\" --db parablu001 --collection BACKUP_PG -q '{\"gatewayName\":\"" + blukryptIP + "\"}' --out " + "BACKUP_PG.csv");
        actualScript.append("\n");
        actualScript.append("sudo mongo localhost:27017 -u \"neil\" -p \"parablu\" --authenticationDatabase \"admin\" < dropBKPColl.js");
        actualScript.append("\n");
        actualScript.append("mongoimport -h  localhost:27017 -u \"neil\" -p \"parablu\" --db blukrypt --collection " + localCollName + " --file " + "BACKUP_PG.csv");
        actualScript.append("\n");
        actualScript.append("sudo mongo " + mongoIP + ":" + mongoPort + " -u \"neil\" -p \"parablu\" --authenticationDatabase \"admin\" < incomeStart.js");
        actualScript.append("\n");
        actualScript.append("service tomcat-job1 start");
        actualScript.append("\n");
        try {
            FileOutputStream out = new FileOutputStream(String.valueOf(filePath) + "/" + "main.sh");
            out.write(actualScript.toString().getBytes());
            out.close();
        }
        catch (Exception e) {
            System.out.println("Exception " + e.getMessage());
            e.printStackTrace();
        }
        try {
            System.out.println("New changes........");
            String[] cmd = new String[]{"/bin/sh", String.valueOf(filePath) + "/" + "main.sh"};
            Process pr = Runtime.getRuntime().exec(cmd);
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = "";
            while ((line = input.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

