/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.helper.utils.ObjectDiffFinder;
import com.parablu.helper.utils.SmtpDiffFinder;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.CloudAndHostMachineDataElement;
import com.parablu.paracloud.element.CloudCredentialElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.CloudRegistrationElement;
import com.parablu.paracloud.element.SmtpElement;
import com.parablu.paracloud.util.JaxBSerializerHelper;
import com.parablu.paracloud.util.ParacloudUtils;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.PortalProperties;
import com.parablu.pcbd.domain.SmtpCredentials;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CloudSettingsServiceImpl
implements CloudSettingsService {
    private static Logger logger = LogManager.getLogger(CloudSettingsServiceImpl.class);
    private static final String ALGO = "AES";
    private static final byte[] keyValue = new byte[]{84, 104, 101, 66, 101, 115, 116, 83, 101, 99, 114, 101, 116, 75, 101, 121};
    private CloudDao cloudDao;
    @Resource
    private PortalPropertiesDao portalPropertiesDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    private static final String IO_EXCEPTION = " IOException  :";
    private static final String EXCEPTION = "Exception  ";

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    @Override
    public Cloud registerCloud(CloudAndHostMachineDataElement cloudAndHostMachineDataElement) {
        String localIp = ParacloudUtils.getLocalIP();
        String publicIp = ParacloudUtils.getPublicIP();
        Cloud cloud = null;
        if (localIp == null || localIp.isEmpty()) {
            localIp = publicIp;
        }
        try {
            cloudAndHostMachineDataElement.setCloudLocalIP(localIp);
            cloudAndHostMachineDataElement.setCloudPublicIP(publicIp);
            String xmlResponse = this.sendRegisterRequestToAmazon(cloudAndHostMachineDataElement);
            if (xmlResponse == null) {
                logger.debug("Response null");
                return null;
            }
            cloud = this.createCloudElementFromResponseData(xmlResponse);
            if (cloud != null && cloud.getCloudName() == null) {
                logger.debug("cloud name is null");
                return null;
            }
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return cloud;
    }

    @Override
    public Cloud registerCloudWithAmazon(CloudAndHostMachineDataElement cloudAndHostMachineDataElement) throws IOException {
        String publicIP = ParacloudUtils.getPublicIP();
        Cloud cloud = null;
        cloudAndHostMachineDataElement.setCloudPublicIP(publicIP);
        cloudAndHostMachineDataElement.setCloudLocalIP(publicIP);
        String xmlResponse = this.sendRegisterRequestToAmazon(cloudAndHostMachineDataElement);
        if (xmlResponse == null) {
            return null;
        }
        try {
            cloud = this.createCloudElementFromResponseData(xmlResponse);
            if (cloud != null && cloud.getCloudName() == null) {
                return null;
            }
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return cloud;
    }

    private Cloud createCloudElementFromResponseData(String xmlResponse) {
        Cloud cloud = new Cloud();
        CloudRegistrationElement cloudRegElement = JaxBSerializerHelper.unmarshallCloudRegistrationElement((String)xmlResponse);
        cloud.setCloudRegistrationUUId(cloudRegElement.getCloudUUID());
        cloud.setCloudSizeAllowed(cloudRegElement.getCloudSizeAllowed());
        cloud.setNoOfDevicesAllowed(0);
        cloud.setNoOfUsersAllowed(cloudRegElement.getTotalNoOfUsers());
        cloud.setStatusCode(cloudRegElement.getStatus());
        cloud.setValidityPeriod(cloudRegElement.getValidityPeriod());
        cloud.setCloudName(cloudRegElement.getCloudName());
        return cloud;
    }

    private String sendRegisterRequestToAmazon(CloudAndHostMachineDataElement cloudAndHostMachineDataElement) throws IOException {
        return null;
    }

    @Override
    public void saveCloudToDatabase(Cloud cloud) {
        new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + cloud.getCloudName()).mkdirs();
        new File(PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloud.getCloudName())).mkdirs();
        new File(PCHelperConstant.getPropertyFileValueParabluBackupFolderBasePath((String)cloud.getCloudName())).mkdirs();
        new File(PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloud.getCloudName())).mkdirs();
        this.cloudDao.saveCloud(cloud);
    }

    @Override
    public void createNewCloud(Cloud cloud) {
        this.cloudDao.createNewCloud(cloud);
    }

    @Override
    public void saveCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        this.cloudDao.saveCloudCredentials(cloudId, cloudCredentials);
    }

    @Override
    public List<CloudCredentialElement> getAllCloudCredentials(int cloudId) {
        List list = this.cloudDao.getAllCloudCredentials(cloudId);
        ArrayList<CloudCredentialElement> ccElementList = new ArrayList<CloudCredentialElement>();
        for (CloudCredentials cc : list) {
            CloudCredentialElement element = new CloudCredentialElement();
            BeanUtils.copyProperties((Object)cc, (Object)element);
            ccElementList.add(element);
        }
        return ccElementList;
    }

    @Override
    public boolean deleteCloudCredentials(int cloudId, String identity) {
        return this.cloudDao.deleteCloudCredentials(cloudId, identity);
    }

    @Override
    public void saveSmtpCredentials(int cloudId, SmtpElement smtpElement, String userName) {
        SmtpCredentials credentials = this.cloudDao.getSmtpCredentials(cloudId);
        SmtpElement changedFields = new SmtpElement();
        if (credentials == null) {
            credentials = new SmtpCredentials();
        }
        BeanUtils.copyProperties((Object)credentials, (Object)changedFields);
        changedFields.setSmtpAuth(smtpElement.getSmtpAuth());
        BeanUtils.copyProperties((Object)smtpElement, (Object)credentials);
        credentials.setSmtpAuth(String.valueOf(smtpElement.getSmtpAuth()));
        SmtpDiffFinder diffFinder = new SmtpDiffFinder();
        String changedFields1 = diffFinder.findDiff(changedFields, smtpElement);
        logger.debug(".......changedFields1....." + changedFields1);
        this.cloudDao.saveSmtpCredentials(cloudId, credentials);
        if (!StringUtils.isEmpty((Object)changedFields1)) {
            this.saveStatisticToDatabase(cloudId, "", " modified SMTP settings. The changed fields are " + changedFields1, userName, "Portal", PCActionTypes.SMTP_EDIT.getActionTypeValue());
        }
    }

    @Override
    public String saveCloudProperties(int cloudId, CloudPropertyElement cloudPropertyElement) {
        CloudPropertyElement existingCloudPropertyElement = new CloudPropertyElement();
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        if (cloudProperties == null) {
            cloudProperties = new CloudProperties();
            cloudProperties.setMailDelayInSecs(1L);
        }
        long mailDelayInSecs = cloudProperties.getMailDelayInSecs();
        String searchExclusionExtName = cloudProperties.getSearchExclusionExtName();
        BeanUtils.copyProperties((Object)cloudProperties, (Object)existingCloudPropertyElement);
        logger.debug(searchExclusionExtName + "cloud property azure vm>" + cloudProperties.getAzureVM());
        logger.debug("cloud property azure vm>" + cloudPropertyElement.getAzureVM());
        logger.debug("new cloud property ssl>" + cloudProperties.getSslAuthEnabled());
        logger.debug("bulk email delay>>" + cloudProperties.getBulkEmailDelay());
        cloudPropertyElement.setOnlySyncFromEndpoint(existingCloudPropertyElement.isOnlySyncFromEndpoint());
        BeanUtils.copyProperties((Object)cloudPropertyElement, (Object)cloudProperties);
        String response = this.findCloudPropertyDiff(existingCloudPropertyElement, cloudPropertyElement);
        cloudProperties.setSearchExclusionExtName(searchExclusionExtName);
        if (!StringUtils.isEmpty((Object)cloudProperties.getDbBackupPassword())) {
            try {
                cloudProperties.setDbBackupPassword(this.encrypt(cloudProperties.getDbBackupPassword()));
            }
            catch (Exception e) {
                logger.trace(IO_EXCEPTION + e);
                logger.error(IO_EXCEPTION + e.getMessage());
            }
        }
        cloudProperties.setLocalSolr(existingCloudPropertyElement.isLocalSolr());
        cloudProperties.setMailDelayInSecs(mailDelayInSecs);
        this.cloudDao.saveCloudProperties(cloudId, cloudProperties);
        this.initiateCloudProperties(cloudId);
        this.updatePortalProperties(cloudId, cloudProperties);
        return response;
    }

    private String findCloudPropertyDiff(CloudPropertyElement existingCloudPropertyElement, CloudPropertyElement cloudPropertyElement) {
        StringBuilder changedFields = new StringBuilder();
        ObjectDiffFinder objectDiffFinder = new ObjectDiffFinder();
        objectDiffFinder.finder((Object)existingCloudPropertyElement, (Object)cloudPropertyElement);
        objectDiffFinder.visiter(objectDiffFinder);
        ArrayList changes = new ArrayList(objectDiffFinder.changes);
        HashMap<String, String> fieldChanges = new HashMap<String, String>();
        for (Map change : changes) {
            Set keys = change.keySet();
            String propertyName = "";
            String newValue = "";
            String oldValue = "";
            for (String key : keys) {
                if (!StringUtils.isEmpty(change.get(key)) && key.contains("newValue")) {
                    newValue = change.get(key).toString();
                }
                if (key.contains("propertyName")) {
                    propertyName = change.get(key).toString();
                }
                if (StringUtils.isEmpty(change.get(key)) || !key.contains("oldValue")) continue;
                oldValue = change.get(key).toString();
            }
            if (!StringUtils.isEmpty((Object)propertyName)) {
                if (propertyName.startsWith("/")) {
                    propertyName = propertyName.replaceFirst("/", "");
                }
                fieldChanges.put(propertyName, "\"" + oldValue + "\" => \"" + newValue + "\"");
                logger.debug("Actual Data" + propertyName + "\"" + oldValue + "\" => \"" + newValue + "\"");
                continue;
            }
            logger.debug("field changes is empty ");
        }
        for (String field : fieldChanges.keySet()) {
            String key = field;
            key = key.contains("solrServerUrl") ? "Solr Server Url" : (key.contains("solrUrl") ? "Solr URL" : (key.contains("supportMail") ? "Support Mail" : (key.contains("emailToAdminOnly") ? "Emails To Admin Only" : (key.contains("canAdminRestoreAll") ? "Can Admin Restore All" : (key.contains("defaultBkpPolicyName") ? "Default Backup Policy Name" : (key.contains("defaultSyncPolicyName") ? "Default Sync Policy Name" : (key.contains("defaultGuestSyncPolicyName") ? "Default Guest Sync Policy Name" : (key.contains("defaultO365PolicyName") ? "Default O365 Policy Name" : (key.contains("azureVM") ? "Azure VM" : (key.contains("localAD") ? "Local AD" : (key.contains("sslAuthEnabled") ? "SSl Auth Enabled" : (key.contains("reportRows") ? "Report Rows" : (key.contains("isCrawlEnabled") ? "Is Crawl Enabled" : (key.contains("isShareFileNameEnabled") ? "Is Share File Name Enabled" : (key.contains("maxCrawlHit") ? "Maximum Crawl Hit" : (key.contains("mongoReadPreference") ? "Mongo Read Preference" : (key.contains("emailBkpGroupName") ? "Email Backup Group Name" : (key.contains("emailSyncGroupName") ? "Email Sync Group Name" : (key.contains("bkpGroupEmail") ? "Backup Group Email" : (key.contains("syncGroupEmail") ? "Sync Group Email" : (key.contains("chunkUpdateMaxRetry") ? "Maximum Retry for Chunk Update" : (key.contains("clientMailName") ? "Client Mail Name" : (key.contains("clientSupportMailName") ? "Client Support Mail Name" : (key.contains("adfsUrl") ? "ADFS URL" : (key.contains("isDomainCheckEnabled") ? "Is Domain Check Enabled" : (key.contains("bulkEmailDelay") ? "Bulk Email Delay (In Seconds)" : (key.contains("isEmailNotifierForRestoreEnabled") ? "Notify Through Email For Restores" : (key.contains("isEmailNotifierEnabledForFirstBackupCompletion") ? "Notify Through Email For First Backup Completion" : (key.contains("daysToWaitForNextBackup") ? "Fairness Algorithm" : (key.contains("canAdminChangeUserPassword") ? "Allow Admin To Change User Password" : (key.contains("canUserChangePassword") ? "Allow User To Change Password" : (key.contains("passwordChangeEnforce") ? "Enforce Password Rules" : (key.contains("isAdminDeleteBackupFile") ? "Allow Admin To Delete Backup File" : (key.contains("softBlockEnabled") ? "Administration approval for blocked users" : (key.contains("overridePolicySettings") ? "Override Policy Settings for Admin Restore All" : (key.contains("allowEndUserTocontrolRestore") ? "Allow enduser To control Restore" : (key.contains("googleAuthenticator") ? "Multi-factor authentication" : (key.contains("enableRecaptcha") ? "Brute force password protection" : (key.contains("autoExpireUsers") ? "Allow automatic user-aging" : (key.contains("allowPasswordReset") ? "Allow reset password for Parablu namespace users" : ""))))))))))))))))))))))))))))))))))))))));
            if (!StringUtils.isEmpty((Object)key)) {
                fieldChanges.get(field);
                changedFields.append(" (");
                changedFields.append(key);
                changedFields.append(" values ");
                changedFields.append((String)fieldChanges.get(field));
                changedFields.append(")");
                if (key.length() > 1) {
                    changedFields.append(", ");
                }
                logger.debug("changed fields *************** " + changedFields.toString());
                continue;
            }
            logger.debug("Key is empty *******************");
        }
        if (changedFields.length() > 0) {
            changedFields.replace(changedFields.length() - 1, changedFields.length(), " ");
        }
        String changedfiled = changedFields.toString().replace("ALL USERS", "ENABLED");
        logger.debug("the changed fields are " + changedfiled);
        return changedfiled;
    }

    @Override
    public CloudPropertyElement getCloudPropertyElement(int cloudId) {
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        CloudPropertyElement cloudPropertyElement = null;
        if (cloudProperties != null) {
            cloudPropertyElement = new CloudPropertyElement();
            BeanUtils.copyProperties((Object)cloudProperties, (Object)cloudPropertyElement);
        }
        if (!StringUtils.isEmpty((Object)cloudProperties.getDbBackupPassword())) {
            try {
                cloudPropertyElement.setDbBackupPassword(this.decrypt(cloudProperties.getDbBackupPassword()));
            }
            catch (Exception e) {
                logger.trace(IO_EXCEPTION + e);
                logger.error(IO_EXCEPTION + e.getMessage());
            }
        }
        return cloudPropertyElement;
    }

    @Override
    public SmtpElement getSmtpElement(int cloudId) {
        SmtpCredentials smtpCred = this.cloudDao.getSmtpCredentials(cloudId);
        SmtpElement smtpElement = null;
        if (smtpCred != null) {
            smtpElement = new SmtpElement();
            BeanUtils.copyProperties((Object)smtpCred, (Object)smtpElement);
            smtpElement.setSmtpAuth(Boolean.parseBoolean(smtpCred.getSmtpAuth()));
        }
        return smtpElement;
    }

    private void initiateCloudProperties(int cloudId) {
        logger.debug("Starting up ... !");
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        if (cloudProperties == null) {
            return;
        }
        CloudPropertyElement cloudPropertyElement = new CloudPropertyElement();
        BeanUtils.copyProperties((Object)cloudProperties, (Object)cloudPropertyElement);
        logger.debug("cloud property element is not null inside initate cloud properties>>>");
        PCHelperConstant.setPropertyFileValueAdfsUrl((String)cloudPropertyElement.getAdfsUrl());
        PCHelperConstant.setPropertyFileValueAllowAdminToRestoreAll((String)String.valueOf(cloudPropertyElement.getCanAdminRestoreAll()));
        PCHelperConstant.setPropertyFileValueBkpEmailGroupName((String)cloudPropertyElement.getEmailBkpGroupName());
        PCHelperConstant.setPropertyFileValueBkpSupportEmail((String)cloudPropertyElement.getBkpGroupEmail());
        PCHelperConstant.setPropertyFileValueBkpSyncEmailGroupName((String)cloudPropertyElement.getEmailSyncGroupName());
        PCHelperConstant.setPropertyFileValueBkpSyncSupportEmail((String)cloudPropertyElement.getSyncGroupEmail());
        PCHelperConstant.setPropertyFileValueClientDownloadPath((String)cloudPropertyElement.getBlusyncDownloadPath());
        PCHelperConstant.setPropertyFileValueClientMailName((String)cloudPropertyElement.getClientMailName());
        PCHelperConstant.setPropertyFileValueClientSupportMailName((String)cloudPropertyElement.getClientSupportMailName());
        PCHelperConstant.setPropertyFileValueDefaultBkpPolicy((String)cloudPropertyElement.getDefaultBkpPolicyName());
        PCHelperConstant.setPropertyFileValueDefaultSyncPolicy((String)cloudPropertyElement.getDefaultSyncPolicyName());
        PCHelperConstant.setPropertyFileValueEmailDomainCheck((String)String.valueOf(cloudPropertyElement.getIsDomainCheckEnabled()));
        PCHelperConstant.setPropertyFileValueEmailsToadminsOnly((String)String.valueOf(cloudPropertyElement.getEmailToAdminOnly()));
        PCHelperConstant.setPropertyFileValueIsCrawlEnabled((String)String.valueOf(cloudPropertyElement.getIsCrawlEnabled()));
        PCHelperConstant.setPropertyFileValueIsShareFileNameEnabled((String)String.valueOf(cloudPropertyElement.getIsShareFileNameEnabled()));
        PCHelperConstant.setPropertyFileValueMaxCrawlHit((String)String.valueOf(cloudPropertyElement.getMaxCrawlHit()));
        PCHelperConstant.setPropertyFileValueMaxRetryChunkUpdate((String)String.valueOf(cloudPropertyElement.getChunkUpdateMaxRetry()));
        PCHelperConstant.setPropertyFileValueMigrationOu((String)cloudPropertyElement.getAdGroupName());
        PCHelperConstant.setPropertyFileValueParacloudCloudnameFile((String)cloudPropertyElement.getCloudFileName());
        PCHelperConstant.setPropertyFileValueParacloudMountPoint((String)cloudPropertyElement.getMntParacloudPath());
        PCHelperConstant.setPropertyFileValueParacloudType((String)cloudPropertyElement.getCloudType());
        PCHelperConstant.setPropertyFileValuePgWriteDelayLimit((String)String.valueOf(cloudPropertyElement.getEbmsWriteDelayLimit()));
        PCHelperConstant.setPropertyFileValueReadPreference((String)String.valueOf(cloudPropertyElement.getMongoReadPreference()));
        PCHelperConstant.setPropertyFileValueReplicaSafeLimit((String)String.valueOf(cloudPropertyElement.getWriteConcernLimit()));
        PCHelperConstant.setPropertyFileValueReportDisplayRecords((String)String.valueOf(cloudPropertyElement.getReportRows()));
        PCHelperConstant.setPropertyFileValueScriptsBinDir((String)cloudPropertyElement.getScriptsBinDir());
        PCHelperConstant.setPropertyFileValueSolrBaseUrl((String)cloudPropertyElement.getSolrUrl());
        PCHelperConstant.setSolrServerUrl((String)cloudPropertyElement.getSolrServerUrl());
        PCHelperConstant.setPropertyFileValueSslAuthEnabled((String)String.valueOf(cloudPropertyElement.getSslAuthEnabled()));
        PCHelperConstant.setPropertyFileValueSupportMail((String)cloudPropertyElement.getSupportMail());
        PCHelperConstant.setPropertyFileValueSyncEmailGroupName((String)cloudPropertyElement.getEmailSyncGroupName());
        PCHelperConstant.setPropertyFileValueVideoThumbnailScript((String)cloudPropertyElement.getScriptsVideoThumbnail());
        PCHelperConstant.setBulkEmailDelay((int)cloudPropertyElement.getBulkEmailDelay());
        PCHelperConstant.setDaysToWaitForNextBackup((int)cloudPropertyElement.getDaysToWaitForNextBackup());
        PCHelperConstant.setCanUserChangePassword((boolean)cloudPropertyElement.isCanUserChangePassword());
        PCHelperConstant.setCanAdminChangeUserPassword((boolean)cloudPropertyElement.isCanAdminChangeUserPassword());
        PCHelperConstant.setPasswordChangeEnforce((boolean)cloudPropertyElement.isPasswordChangeEnforce());
        PCHelperConstant.setHideStorageSizeInCloud((boolean)cloudPropertyElement.isHideStorageSizeInCloud());
        logger.debug("end of initiating properties... !");
    }

    @Override
    public boolean createCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        return this.cloudDao.createCloudCredentials(cloudId, cloudCredentials);
    }

    @Override
    public boolean editCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        return this.cloudDao.editCloudCredentials(cloudId, cloudCredentials);
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = this.auditHistoryDefaultValue(action, actionByUser, actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    private AuditHistory auditHistoryDefaultValue(String action, String actionByUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        return audit;
    }

    private void updatePortalProperties(int cloudId, CloudProperties cloudProperties) {
        logger.debug("....updating........." + PCHelperConstant.getPropertyValueComponentName());
        PortalProperties portalProperties = this.portalPropertiesDao.getPortalProperties(cloudId, PCHelperConstant.getPropertyValueComponentName());
        if (portalProperties != null && !CollectionUtils.isEmpty((Map)portalProperties.getComponentsProperties())) {
            Map componentsProperties = portalProperties.getComponentsProperties();
            componentsProperties.put("eyeOption", cloudProperties.isEyeOption());
            componentsProperties.put("flipTotalCompletedBackups", cloudProperties.isFlipTotalCompletedBackups());
            componentsProperties.put("flipTotalActualStorageUtilized", cloudProperties.isFlipTotalActualStorageUtilized());
            componentsProperties.put("enableRecaptcha", cloudProperties.isEnableRecaptcha());
            componentsProperties.put("googleAuthenticator", cloudProperties.isGoogleAuthenticator());
            componentsProperties.put("totalCompletedBackups", cloudProperties.isTotalCompletedBackups());
            componentsProperties.put("totalActualStorageUtilized", cloudProperties.isTotalActualStorageUtilized());
            componentsProperties.put("complexPassword", cloudProperties.isComplexPassword());
            componentsProperties.put("portalSSOutEnable", cloudProperties.isPortalSSOutEnable());
            componentsProperties.put("useLocalPackage", componentsProperties.get("useLocalPackage"));
            componentsProperties.put("allowPasswordReset", cloudProperties.isAllowPasswordReset());
            portalProperties.setComponentsProperties(componentsProperties);
            this.portalPropertiesDao.savePortalProperties(cloudId, portalProperties);
            logger.debug("....update complete........." + PCHelperConstant.getPropertyValueComponentName());
        }
    }

    public void setPortalPropertiesDao(PortalPropertiesDao portalPropertiesDao) {
        this.portalPropertiesDao = portalPropertiesDao;
    }

    public String encrypt(String data) throws Exception {
        Key key = CloudSettingsServiceImpl.generateKey();
        Cipher c = Cipher.getInstance(ALGO);
        c.init(1, key);
        byte[] encVal = c.doFinal(data.getBytes());
        return new BASE64Encoder().encode(encVal);
    }

    public String decrypt(String encryptedData) throws Exception {
        Key key = CloudSettingsServiceImpl.generateKey();
        Cipher c = Cipher.getInstance(ALGO);
        c.init(2, key);
        byte[] decordedValue = new BASE64Decoder().decodeBuffer(encryptedData);
        byte[] decValue = c.doFinal(decordedValue);
        return new String(decValue);
    }

    private static Key generateKey() throws Exception {
        return new SecretKeySpec(keyValue, ALGO);
    }
}

