/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.AlertHistoryService;
import com.parablu.paracloud.element.AlertHistoryElement;
import com.parablu.pcbd.dao.AlertHistoryDao;
import com.parablu.pcbd.dao.SearchIndexDao;
import com.parablu.pcbd.domain.AlertHistory;
import com.parablu.pcbd.domain.SearchIndex;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AlertHistoryServiceImpl
implements AlertHistoryService {
    private static Logger logger = LogManager.getLogger(AlertHistoryServiceImpl.class);
    @Resource
    private AlertHistoryDao alertHistoryDao;
    @Resource
    private SearchIndexDao searchIndexDao;
    private static final String PARSE_EXCEPTION = " ParseException  :";

    @Override
    public void saveAlertHistory(int cloudId, String cloudName, AlertHistory alertHistory) {
        this.alertHistoryDao.saveAlertHistory(cloudId, cloudName, alertHistory);
    }

    @Override
    public List<AlertHistoryElement> getAllAlertHistory(int cloudId, String cloudName) {
        List alertHistoryList = this.alertHistoryDao.getAllAlertHistory(cloudId, cloudName);
        return this.getAlertHistoryElements(alertHistoryList);
    }

    @Override
    public List<AlertHistoryElement> getAllAlertHistoryForJobType(int cloudId, String cloudName, String userName, String deviceName, String startOfDay, String endOfDay) {
        List alertHistoryList = this.alertHistoryDao.getAllAlertHistoryForJobType(cloudId, cloudName, userName, deviceName, AlertHistoryServiceImpl.getStartOfDay(startOfDay), AlertHistoryServiceImpl.getEndOfDay(endOfDay));
        return this.getAlertHistoryElements(alertHistoryList);
    }

    private List<AlertHistoryElement> getAlertHistoryElements(List<AlertHistory> alertHistoryList) {
        ArrayList<AlertHistoryElement> alertHistoryElements = new ArrayList<AlertHistoryElement>();
        for (AlertHistory alertHistory : alertHistoryList) {
            if (alertHistory.getDevice() == null || alertHistory.getUser() == null) continue;
            AlertHistoryElement alertHistoryElement = new AlertHistoryElement();
            alertHistoryElement.setDeviceName(alertHistory.getDevice().getDeviceName());
            alertHistoryElement.setUserName(alertHistory.getUser().getUserName());
            alertHistoryElement.setStartTime(this.getDate(alertHistory.getBatchStartTimestamp()));
            alertHistoryElement.setEndTime(this.getDate(alertHistory.getBatchEndTimestamp()));
            alertHistoryElement.setAction(alertHistory.getAction());
            alertHistoryElements.add(alertHistoryElement);
        }
        return alertHistoryElements;
    }

    public static long getStartOfDay(String startDate1) {
        String startDate = startDate1;
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        Date date = null;
        if (startDate == null || startDate == "") {
            startDate = "01/01/1971";
        }
        logger.debug(" !!!DATE!!!  " + startDate);
        try {
            date = sdf.parse(startDate);
        }
        catch (ParseException e) {
            logger.trace(PARSE_EXCEPTION + e);
            logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    private String getDate(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            logger.trace(" NumberFormatException  :" + e);
            logger.error(" NumberFormatException  :" + e.getMessage());
        }
        return date;
    }

    public static long getEndOfDay(String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        Date date = null;
        logger.debug(" !!!DATE!!!  " + endDate);
        if (endDate == null || endDate == "") {
            return System.currentTimeMillis();
        }
        try {
            date = sdf.parse(endDate);
        }
        catch (ParseException e) {
            logger.trace(PARSE_EXCEPTION + e);
            logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    @Override
    public void addFileToTable(SearchIndex searchIndex, String cloudName) {
        searchIndex.setCloudName(cloudName);
        this.searchIndexDao.addFileToBeIndexed(searchIndex);
    }

    @Override
    public void addFilesToTable(List<SearchIndex> searchIndexs, String cloudName) {
        for (SearchIndex searchIndex : searchIndexs) {
            searchIndex.setCloudName(cloudName);
            this.searchIndexDao.addFileToBeIndexed(searchIndex);
        }
    }
}

