/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.UserLimitReachedException;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.AADAuthorizationTokenElement;
import com.parablu.paracloud.element.AADCredentialsElement;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.AADUserNamesList;
import com.parablu.paracloud.element.AADUsersListElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AADManagementController
extends BaseController {
    private static Logger logger = LogManager.getLogger(AADManagementController.class);
    private static final String EXCEPTION = " Exception  :";
    private static final String MIGRATION = "MIGRATION";
    @Autowired
    private AADManagementService aadManagementService;
    @Autowired
    private UserManagementService userManagementService;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Resource
    private PortalPropertiesDao portalPropertiesDao;

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/load/all/"}, method={RequestMethod.GET})
    public ModelAndView loadAllAADCredentials(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/load/all/");
        try {
            User currentUser;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            ModelAndView andView = new ModelAndView();
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String isInternalCall = request.getHeader("isInternalCall");
            if (StringUtils.isEmpty((Object)isInternalCall) && !this.performAuthorization(cloudId, cloudName1, token, currentUser = new User(), response)) {
                return null;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list);
            if (!isAADEnabled) {
                response.setStatus(443);
                return null;
            }
            List<AADCredentialsElement> aadCredentialsElementList = this.aadManagementService.getAllAADCredentials(cloudId);
            if (CollectionUtils.isEmpty(aadCredentialsElementList)) {
                response.setStatus(204);
                return null;
            }
            logger.debug(".........................." + aadCredentialsElementList.size());
            andView.addObject(aadCredentialsElementList);
            return andView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/aadUser/{userName}/"}, method={RequestMethod.GET})
    public ModelAndView checkAADUserCredentials(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/aadUser/{userName}/");
        try {
            User currentUser;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            ModelAndView andView = new ModelAndView();
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String isInternalCall = request.getHeader("isInternalCall");
            if (StringUtils.isEmpty((Object)isInternalCall) && !this.performAuthorization(cloudId, cloudName1, token, currentUser = new User(), response)) {
                return null;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list);
            if (!isAADEnabled) {
                response.setStatus(443);
                return null;
            }
            String tenantId = "";
            if (cl.getCloud().getGraphAADEnabled() == 1) {
                tenantId = this.aadManagementService.getTenantIdForGraphAADUsersFromUserNames(cl.getCloud(), userName1);
            }
            logger.debug(userName1 + ".......user in..................." + tenantId);
            response.addHeader("tenantId", tenantId);
            response.setStatus(200);
            return andView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/AADCredentials/"}, method={RequestMethod.GET})
    public ModelAndView getAADCredentials(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/AADCredentials/ ...." + request.getHeader("aadCredId"));
        try {
            User currentUser;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            String aadCredId = request.getHeader("aadCredId");
            ModelAndView andView = new ModelAndView();
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String isInternalCall = request.getHeader("isInternalCall");
            if (StringUtils.isEmpty((Object)isInternalCall) && !this.performAuthorization(cloudId, cloudName1, token, currentUser = new User(), response)) {
                return null;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list);
            if (!isAADEnabled) {
                response.setStatus(443);
                return null;
            }
            AADCredentialsElement aadCredentialsElement = this.aadManagementService.getAADCredentials(cloudId, aadCredId);
            if (aadCredentialsElement == null) {
                response.setStatus(404);
                return null;
            }
            logger.debug("............end of loading versions/{versionNumber}/clouds/{cloudName}/AADCredentials/ .................." + aadCredentialsElement.getId());
            andView.addObject((Object)aadCredentialsElement);
            return andView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/AADCredentials/"}, method={RequestMethod.POST})
    public void saveAADCredentials(@PathVariable(value="cloudName") String cloudName1, @RequestBody AADCredentialsElement aadCredentials, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/AADCredentials/ ....");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName1, token, currentUser, response)) {
                return;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list);
            if (!isAADEnabled) {
                response.setStatus(443);
                return;
            }
            this.aadManagementService.saveAADCredentials(cloudId, aadCredentials);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/synAADUsers/"}, method={RequestMethod.POST})
    public void syncAADUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/synAADUsers/ ....");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName1 = cl.getCloud().getCloudName();
            this.aadManagementService.synUserAttributes(cl.getCloud());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/aadauthorizationtoken"}, method={RequestMethod.POST})
    public void saveAADAuthorizationtoken(@PathVariable(value="cloudName") String cloudName1, @RequestBody AADAuthorizationTokenElement aadCredentials, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("versions/{versionNumber}/clouds/{cloudName}/aadauthorizationtoken ....");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list);
            if (!isAADEnabled) {
                response.setStatus(443);
                return;
            }
            logger.debug("AADAuthorizationTokenElement ............" + aadCredentials.toString());
            this.aadManagementService.saveAADAuthorizationtoken(cloudId, aadCredentials);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/aad/users"}, method={RequestMethod.POST})
    public ModelAndView ldapconnectivityUser(@PathVariable(value="cloudName") String cloudName, @RequestBody AADUserNamesList aadUserNamesList, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list);
            if (!isAADEnabled) {
                response.setStatus(443);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            List<Object> aadUsersListElement = new ArrayList();
            aadUsersListElement = cl.getCloud().getGraphAADEnabled() == 1 ? this.aadManagementService.getGraphAADUsersFromUserNames(cl.getCloud(), aadUserNamesList) : this.aadManagementService.getAADUsersFromUserNames(cloudId, aadUserNamesList);
            if (CollectionUtils.isEmpty(aadUsersListElement)) {
                response.setStatus(204);
                return null;
            }
            response.setStatus(200);
            modelAndView.addObject(aadUsersListElement);
        }
        catch (Exception e) {
            logger.trace("error trying to load elements  ..........." + e);
            response.setStatus(400);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/aad/users/migrate"}, method={RequestMethod.POST})
    public ModelAndView ldapconnectivityUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody AADUsersListElement aadUsersListElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(request.getHeader("o365BackupEnabled") + " Inside migrate users ........ sync enabled>>" + request.getHeader("syncEnabled"));
        int totalUsersCount = aadUsersListElement.getAadUsersList().size();
        int totalUsersMigrated = 0;
        logger.debug(" Inside migrate users ........ backup enabled>>" + request.getHeader("backupEnabled"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String adminName = request.getHeader("adminName");
            boolean isSyncEnabled = Boolean.parseBoolean(request.getHeader("syncEnabled"));
            boolean isBackupEnabled = Boolean.parseBoolean(request.getHeader("backupEnabled"));
            boolean isO365BackupEnabled = Boolean.parseBoolean(request.getHeader("o365BackupEnabled"));
            ArrayList<String> users = new ArrayList<String>();
            for (AADUserElement aadUserElement : aadUsersListElement.getAadUsersList()) {
                try {
                    logger.debug(".... odb policy name... " + aadUserElement.getUserName() + "..getDefaultO365Policy.." + aadUserElement.getDefaultOdbPolicy());
                    boolean userMigrated = false;
                    try {
                        userMigrated = this.migrateUserFromAAD(cl.getCloud(), aadUserElement, isSyncEnabled, isBackupEnabled, isO365BackupEnabled, adminName);
                    }
                    catch (UserLimitReachedException e) {
                        logger.error("...user limit reached during migration... ");
                        this.sendEmailForUserLimitExceded(cl.getCloud().getCloudId(), cloudName, aadUserElement.getUserName(), "User");
                    }
                    if (userMigrated) {
                        ++totalUsersMigrated;
                    }
                }
                catch (Exception e) {
                    logger.error(" USERS CANNOT BE MIGRATED ................." + e);
                    logger.debug("USERS CANNOT BE MIGRATED ................." + e.getMessage());
                }
                users.add(aadUserElement.getUserName());
            }
            if (totalUsersMigrated == 0) {
                response.setStatus(417);
            } else if (totalUsersMigrated != totalUsersCount) {
                modelAndView.addObject("totalUsersMigrated", (Object)totalUsersMigrated);
                modelAndView.addObject("totalUsersCount", (Object)totalUsersCount);
                response.setStatus(206);
            } else {
                response.setStatus(200);
            }
        }
        catch (Exception e) {
            logger.trace("error trying to load elements  ..........." + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("End of Inside migrate users ........ ");
        return modelAndView;
    }

    private void sendEmailForUserLimitExceded(int cloudId, String cloudName, String userName, String userLicense) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("user-limit-reached");
        EmailRecipent emailRecipent = new EmailRecipent();
        try {
            List<User> allAdmins = this.userManagementService.getAllAdmins(cloudId, cloudName);
            for (User adminUser : allAdmins) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                emailRecipents.add(emailRecipent);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("Toatal email recipents count...:" + emailRecipents.size());
        email.setActionBy("");
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(userName);
        email.setRecipents(emailRecipents);
        email.setToUser(true);
        email.setBodyData("Portal");
        email.setSupportDescription(userLicense);
        email.setUserName(userName);
        email.setActionOn(userName);
        email.setUserName(userName);
        this.cloudMailService.sendMail(email);
    }

    private boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    private boolean migrateUserFromAAD(Cloud cloud, AADUserElement aadUserElement, boolean isSyncEnable, boolean isBackupEnable, boolean isO365BackupEnable, String migratedBy) {
        boolean userMigrated = false;
        boolean isSyncEnabled = isSyncEnable;
        boolean isBackupEnabled = isBackupEnable;
        boolean isO365BackupEnabled = isO365BackupEnable;
        int cloudId = cloud.getCloudId();
        try {
            boolean userCreated;
            AADUserElement user = null;
            if (cloud.getGraphAADEnabled() == 1) {
                AADCredentialsElement aadCredentialsElement = this.aadManagementService.getAADCredentials(cloudId);
                ArrayList<String> tenants = new ArrayList<String>();
                if (cloud.getMultiTenantAADEnabled() == 1) {
                    if (!CollectionUtils.isEmpty((Collection)aadCredentialsElement.getTenants())) {
                        tenants.addAll(aadCredentialsElement.getTenants());
                    } else {
                        tenants.add(aadCredentialsElement.getTenentId());
                    }
                } else {
                    tenants.add(aadCredentialsElement.getTenentId());
                }
                for (String tenantId : tenants) {
                    user = this.aadManagementService.getNewAADUserFromUserName(aadUserElement.getUserName(), aadCredentialsElement.getClientId(), aadCredentialsElement.getSecretKey(), tenantId);
                    if (user == null) continue;
                    break;
                }
            } else {
                user = this.aadManagementService.getAADUserFromUserName(cloudId, aadUserElement.getUserName());
            }
            if (user == null) {
                return userMigrated;
            }
            if (StringUtils.isEmpty((Object)user.getProductType())) {
                logger.debug("User is not part of any type .... so skip " + user.getUserPrincipalName());
            }
            if ("SYNC".equalsIgnoreCase(user.getProductType())) {
                isBackupEnabled = false;
            } else if ("BACKUP".equalsIgnoreCase(user.getProductType())) {
                isSyncEnabled = false;
            } else if ("O365".equalsIgnoreCase(user.getProductType())) {
                isSyncEnabled = false;
            } else if ("BOTH".equalsIgnoreCase(user.getProductType())) {
                isBackupEnabled = true;
                isSyncEnabled = true;
                isO365BackupEnabled = true;
            }
            if (StringUtils.isEmpty((Object)aadUserElement.getDefaultSyncPolicy())) {
                aadUserElement.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
            }
            if (StringUtils.isEmpty((Object)aadUserElement.getDefaultOdbPolicy())) {
                aadUserElement.setDefaultOdbPolicy(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
            }
            if (isBackupEnabled && StringUtils.isEmpty((Object)aadUserElement.getDefaultPolicy())) {
                aadUserElement.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
            }
            if (aadUserElement != null) {
                logger.debug(isO365BackupEnabled + "...AAD User Element ...." + aadUserElement.toString());
            }
            if (userCreated = this.userManagementService.createUserFromAAD(cloudId, cloud.getCloudName(), aadUserElement, migratedBy, isSyncEnabled, isBackupEnabled, isO365BackupEnabled, cloud)) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloud.getCloudName(), MIGRATION, migratedBy, aadUserElement.getUserPrincipalName(), "AAD", System.currentTimeMillis(), PCActionTypes.AAD_USER_MIGRATION.getActionTypeValue());
                userMigrated = true;
            }
        }
        catch (UserLimitReachedException e) {
            throw new UserLimitReachedException("user limit reached");
        }
        catch (Exception e) {
            MigrationStatus migrationStatus = new MigrationStatus();
            migrationStatus.setMigratedBy(migratedBy);
            migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
            migrationStatus.setMigrated(false);
            migrationStatus.setReason("Failed to get user form AD");
            migrationStatus.setUserName(aadUserElement.getUserPrincipalName());
            if (StringUtils.isEmpty((Object)aadUserElement.getMail())) {
                migrationStatus.setEmailId(aadUserElement.getUserPrincipalName());
            } else {
                migrationStatus.setEmailId(aadUserElement.getMail());
            }
            this.userManagementService.saveMigrationStatus(cloudId, migrationStatus);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return userMigrated;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/delete/AADCredentials/"}, method={RequestMethod.DELETE})
    public void deleteAADCredentials(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("..delete..versions/{versionNumber}/clouds/{cloudName}/AADCredentials/ ...." + request.getHeader("aadCredId"));
        try {
            User currentUser;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            String aadCredId = request.getHeader("aadCredId");
            ModelAndView andView = new ModelAndView();
            cloudName1 = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String isInternalCall = request.getHeader("isInternalCall");
            if (StringUtils.isEmpty((Object)isInternalCall) && !this.performAuthorization(cloudId, cloudName1, token, currentUser = new User(), response)) {
                return;
            }
            List list = cl.getCloud().getCloudCustomisableDetails();
            boolean isAADEnabled = this.isAADEnabled(list);
            if (!isAADEnabled) {
                response.setStatus(443);
                return;
            }
            this.aadManagementService.deleteAADCredentials(cloudId, aadCredId);
            response.setStatus(200);
            logger.debug("..end of delete..versions/{versionNumber}/clouds/{cloudName}/AADCredentials/ ....");
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return;
        }
    }
}

