/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class LatestVerUpdate1 {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceUUIDValue = config.getProperty("deviceUUID").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        FindIterable<Document> devices = null;
        devices = deviceColl.find(new BasicDBObject("deviceUUID", deviceUUIDValue));
        System.out.println("Converting device Db object to list of  device ...");
        ArrayList<Device> devList = new ArrayList<Device>();
        for (Document dev : devices) {
            Device device = new Device();
            device.setDeviceUUID(dev.getString("deviceUUID"));
            device.setDestCollection(dev.getString("destCollection"));
            device.setDecoupled((Boolean)dev.get("decoupled"));
            devList.add(device);
        }
        System.out.println("total device size is...." + devList.size());
        for (Device device : devList) {
            FindIterable<Document> folders;
            System.out.println("Satreted for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
            MongoCollection<Document> bkpColl = db.getCollection(device.getDestCollection());
            String deviceUUID = device.getDeviceUUID();
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("folder", true));
            whereQuery.add(new BasicDBObject("present", true));
            andQuery.put("$and", whereQuery);
            ArrayList<Document> allFoldersList = new ArrayList<Document>();
            int skip = 0;
            System.out.println("getting folders......satrted.............");
            ArrayList<String> bkpImages = new ArrayList<String>();
            while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
                for (Document document : folders) {
                    allFoldersList.add(document);
                }
                System.out.println("500....folders is added....." + ++skip + "...allFoldersList..." + allFoldersList.size());
            }
            System.out.println("Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
            long latestFileSizes = 0L;
            String folderName = "";
            long folderSize = 0L;
            long filesCount = 0L;
            for (Document folder : allFoldersList) {
                FindIterable<Document> files;
                folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
                andQuery = new BasicDBObject();
                whereQuery = new ArrayList();
                whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                whereQuery.add(new BasicDBObject("folder", false));
                whereQuery.add(new BasicDBObject("present", true));
                whereQuery.add(new BasicDBObject("devicePath", folderName));
                andQuery.put("$and", whereQuery);
                int skip1 = 0;
                while ((files = bkpColl.find(andQuery).sort(new BasicDBObject("lastServerModifiedTime", (Object)-1)).skip(skip1 * 50).limit(50)).first() != null) {
                    ++skip1;
                    ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
                    int k = 0;
                    for (Document document : files) {
                        ++k;
                        BackUpImage backUpImage = new BackUpImage();
                        backUpImage.setDevicePath(document.getString("devicePath"));
                        backUpImage.setFileName(document.getString("fileName"));
                        backUpImage.setLastServerModifiedTime(document.getLong("lastServerModifiedTime"));
                        if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                        backUpImage.setSize(document.getLong("size"));
                        allFilesList.add(backUpImage);
                    }
                    List<BackUpImage> list = LatestVerUpdate1.getFilteredBackupImageList(allFilesList);
                    for (BackUpImage image : list) {
                        String completePath = String.valueOf(image.getDevicePath()) + "/" + image.getFileName();
                        if (bkpImages.contains(completePath)) continue;
                        latestFileSizes += image.getSize();
                        folderSize += image.getSize();
                        bkpImages.add(completePath);
                        ++filesCount;
                    }
                }
                System.out.println("$$$$$$$$" + folderName + "$$$$$$$$" + filesCount + "$$$$$$$$" + folderSize + "$$$$$$$$" + latestFileSizes + "$$$$$$$..... for deviceUUID " + deviceUUID);
                folderSize = 0L;
                filesCount = 0L;
            }
            System.out.println("Total size...................................... :" + latestFileSizes + " for deviceUUID " + deviceUUID);
            System.out.println("Ended for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }
}

