/*
 * Decompiled with CFR 0.152.
 */
import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.joda.time.DateTime;
import org.joda.time.Days;

public class BlockDeviceBasedOnLastHeard {
    public static void main(String[] args) {
        if (args.length < 2) {
            throw new ArrayIndexOutOfBoundsException("Enter MongoIp:port and noOfDays");
        }
        String mongoIP = args[0];
        String daysInString = args[1];
        int days = Integer.parseInt(daysInString);
        if (days <= 0) {
            System.out.println("wrong days value :" + days);
            System.exit(0);
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> userColl = db.getCollection("USER");
        MongoCollection<Document> auditHistoryColl = db.getCollection("AUDIT_HISTORY");
        MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        MongoCollection<Document> tokenColl = db.getCollection("AUTHORIZATION_TOKENS");
        FindIterable<Document> find = deviceBkpOverviewColl.find();
        for (Document devBkpOverview : find) {
            try {
                if (devBkpOverview == null || StringUtils.isEmpty(devBkpOverview.getString("deviceUUID"))) continue;
                long lastHeard = 0L;
                if (devBkpOverview.get("lastHeardTime") == null || (Long)devBkpOverview.get("lastHeardTime") == 0L) {
                    if (devBkpOverview.get("lastSuccessfulBackupEndTime") != null && (Long)devBkpOverview.get("lastSuccessfulBackupEndTime") != 0L) {
                        lastHeard = (Long)devBkpOverview.get("lastSuccessfulBackupEndTime");
                    }
                } else {
                    lastHeard = (Long)devBkpOverview.get("lastHeardTime");
                }
                if (lastHeard == 0L) {
                    System.out.println(String.valueOf(devBkpOverview.getString("deviceName")) + " last heard and lastSuccessfulBackupEndTime is 0 so skip");
                    continue;
                }
                DateTime dt1 = new DateTime(lastHeard);
                DateTime dt2 = new DateTime();
                int daysGap = Days.daysBetween(dt1, dt2).getDays();
                System.out.println(String.valueOf(devBkpOverview.getString("deviceName")) + " last head is " + daysGap + " days back");
                if (daysGap == 0 || daysGap < days) continue;
                if (!devBkpOverview.getBoolean("isDeviceBolcked").booleanValue()) {
                    BasicDBObject updateQuery = new BasicDBObject();
                    BasicDBObject deviceBkpOverviewupdateFields = new BasicDBObject();
                    deviceBkpOverviewupdateFields.append("isDeviceBolcked", true);
                    updateQuery.append("$set", deviceBkpOverviewupdateFields);
                    BasicDBObject andQuery1 = new BasicDBObject();
                    ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
                    whereQuery1.add(new BasicDBObject("deviceUUID", devBkpOverview.getString("deviceUUID")));
                    andQuery1.put("$and", whereQuery1);
                    deviceBkpOverviewColl.updateOne(andQuery1, updateQuery);
                    BasicDBObject deviceUpdateFields = new BasicDBObject();
                    deviceUpdateFields.append("blocked", true);
                    BasicDBObject deviceUpdateQuery = new BasicDBObject();
                    deviceUpdateQuery.append("$set", deviceUpdateFields);
                    deviceColl.updateOne(andQuery1, deviceUpdateQuery);
                    Document user = (Document)userColl.find(new BasicDBObject("userNameLowerCase", devBkpOverview.getString("userName").toLowerCase())).first();
                    if (user != null) {
                        BasicDBObject userDbRefQuery = new BasicDBObject();
                        ArrayList<BasicDBObject> userDbRefWhereQuery = new ArrayList<BasicDBObject>();
                        userDbRefWhereQuery.add(new BasicDBObject("user", new DBRef("USER", user.getObjectId("_id"))));
                        userDbRefWhereQuery.add(new BasicDBObject("uniqueId", devBkpOverview.getString("deviceUUID")));
                        userDbRefQuery.put("$and", userDbRefWhereQuery);
                        Document token = (Document)tokenColl.find(userDbRefQuery).first();
                        if (token != null) {
                            tokenColl.findOneAndDelete(new BasicDBObject("_id", token.getObjectId("_id")));
                        }
                    }
                    Document auditHistory = new Document();
                    auditHistory.put("action", (Object)("Blocked device: " + devBkpOverview.getString("deviceName") + " belonging to user : " + devBkpOverview.getString("userName") + ". Device was last heard from " + daysGap + " days ago"));
                    auditHistory.put("actionByUserName", (Object)"AUTO");
                    auditHistory.put("timestamp", (Object)System.currentTimeMillis());
                    auditHistory.put("actionUsingObject", (Object)"");
                    auditHistory.put("actionType", (Object)14);
                    auditHistoryColl.insertOne(auditHistory);
                    System.out.println(String.valueOf(devBkpOverview.getString("deviceName")) + " Got blocked");
                    continue;
                }
                System.out.println("Device already blocked");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

