/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.utils;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import org.apache.commons.lang.StringUtils;

public class RegistryUtils {
    public static void setRegistryValue(String hKeyType, String regKeyPath, String keyName, String value) {
        WinReg.HKEY hKey = null;
        if (StringUtils.isEmpty((String)hKeyType) || StringUtils.isEmpty((String)regKeyPath) || StringUtils.isEmpty((String)value)) {
            return;
        }
        if ("HKLM".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_LOCAL_MACHINE;
        } else if ("HKCU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_CURRENT_USER;
        } else if ("HKU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_USERS;
        }
        Advapi32Util.registrySetStringValue((WinReg.HKEY)hKey, (String)regKeyPath, (String)keyName, (String)value);
    }

    public static String getRegistryValue(String hKeyType, String regKeyPath, String key) {
        WinReg.HKEY hKey = null;
        if (StringUtils.isEmpty((String)hKeyType) || StringUtils.isEmpty((String)regKeyPath) || StringUtils.isEmpty((String)key)) {
            return null;
        }
        if ("HKLM".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_LOCAL_MACHINE;
        } else if ("HKCU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_CURRENT_USER;
        } else if ("HKU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_USERS;
        }
        String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)hKey, (String)regKeyPath, (String)key);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        return "null";
    }
}

