/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.utils;

import com.parablu.epa.helper.utils.MD5Generator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPOutputStream;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParabluFileSystemUtils {
    private static Logger logger = LoggerFactory.getLogger(ParabluFileSystemUtils.class);
    private static String userProfile;
    private static String installationDir;
    private static boolean snapshotValid;

    public void splitAndWrite(String sourceFilePath, String destinationPath, int chunkSize, boolean isCompressionEnabled) throws IOException, NoSuchAlgorithmException {
        logger.debug("Inside chunk file split and write");
        int chunkableSizeFromPolicy = chunkSize;
        int policyChunkSize = chunkableSizeFromPolicy * 0x100000;
        logger.debug("CHUNK_SIZE =" + policyChunkSize + " orig=" + chunkableSizeFromPolicy);
        int bufferSize = 524288;
        File willBeRead = new File(sourceFilePath);
        if (!willBeRead.exists()) {
            return;
        }
        long fileSize = willBeRead.length();
        int numberOfChunks = 0;
        byte[] temporary = null;
        long totalBytesRead = 0L;
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(willBeRead));){
            logger.debug("Inside split and write function");
            while (totalBytesRead < fileSize) {
                String partName = Integer.toString(numberOfChunks);
                long bytesWritten = 0L;
                CountingOutputStream compressedStream = new CountingOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(destinationPath + partName)));
                Object gzOutputStream = isCompressionEnabled ? new GZIPOutputStream((OutputStream)compressedStream) : compressedStream;
                CountingOutputStream output = new CountingOutputStream((OutputStream)gzOutputStream);
                while (bytesWritten < (long)policyChunkSize) {
                    int bytesRead;
                    long bytesRemaining = fileSize - totalBytesRead;
                    if (bytesRemaining < (long)bufferSize) {
                        bufferSize = Integer.parseInt(Long.toString(bytesRemaining));
                        logger.debug("BUFFER SIZE: " + bufferSize);
                    }
                    if ((bytesRead = ((InputStream)inStream).read(temporary = new byte[bufferSize], 0, bufferSize)) > 0) {
                        totalBytesRead += (long)bytesRead;
                    }
                    output.write(temporary);
                    bytesWritten = compressedStream.getByteCount();
                    logger.debug("compressed =" + compressedStream.getByteCount() + " uncompressed =" + output.getByteCount());
                    logger.debug("bytesWritten: " + bytesWritten + " bytesRemaining: " + bytesRemaining);
                    if (totalBytesRead == fileSize) {
                        logger.debug("finished writing file");
                        break;
                    }
                    logger.trace("Writing Process Was Performed");
                }
                output.close();
                File tempFile = new File(destinationPath + partName);
                String tempFileMd5 = MD5Generator.generateMD5OfFile(tempFile);
                String newName = String.format("part%09d.%s", ++numberOfChunks, tempFileMd5);
                File renameFile = new File(destinationPath + newName);
                tempFile.renameTo(renameFile);
                logger.trace(tempFileMd5 + "Total Bytes Read: " + tempFile.getPath());
            }
            logger.debug("End of split and write function");
        }
    }

    void write(byte[] dataByteArray, String destinationFileName) throws IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destinationFileName));
        ((OutputStream)output).write(dataByteArray);
        logger.trace("Writing Process Was Performed");
        ((OutputStream)output).close();
    }

    public String convertStringTOBase64(String name) {
        String retValue = "";
        if (!StringUtils.isEmpty((String)name)) {
            byte[] bytes = DigestUtils.md5((String)name);
            byte[] bytesEncoded = Base64.encodeBase64((byte[])bytes);
            String base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            logger.debug("encoded value for given file is " + base64EncodeString);
            retValue = base64EncodeString.replaceAll("/", "_");
        }
        return retValue;
    }

    public String getSystemSpace() {
        File[] files;
        StringBuilder systemSpace = new StringBuilder("");
        FileSystemView fsv = FileSystemView.getFileSystemView();
        for (File file : files = File.listRoots()) {
            long freeSpace = 0L;
            long diskSpace = 0L;
            if (this.isDriveSkip(fsv, file) || this.isDriveNotValid(fsv, file)) continue;
            long utilizedSpace = (diskSpace += file.getTotalSpace()) - (freeSpace += file.getUsableSpace());
            systemSpace.append("").append(file.getAbsolutePath().toLowerCase()).append(";").append(diskSpace).append(";").append(utilizedSpace).append("|");
        }
        return systemSpace.toString();
    }

    boolean isDriveSkip(FileSystemView fsv, File file) {
        return !fsv.isDrive(file) || !file.canRead() || !file.canWrite();
    }

    boolean isDriveNotValid(FileSystemView fsv, File file) {
        return "Removable Disk".equalsIgnoreCase(fsv.getSystemTypeDescription(file)) || "Network Drive".equalsIgnoreCase(fsv.getSystemTypeDescription(file)) || "CD Drive".equalsIgnoreCase(fsv.getSystemTypeDescription(file));
    }

    public static long sleepForGivenTime(long sleepTime) {
        int sleepMultiplier;
        long sleepTimeTemp = sleepTime;
        try {
            Thread.sleep(sleepTimeTemp);
            sleepMultiplier = 2;
        }
        catch (InterruptedException e1) {
            return sleepTimeTemp;
        }
        return sleepTimeTemp *= (long)sleepMultiplier;
    }

    public static String getOsType() {
        String osType = System.getProperty("os.name");
        if (!osType.toLowerCase().contains("win")) {
            return osType;
        }
        return osType + "mac";
    }

    public static boolean handleFileExist(String absPath) {
        File file = new File(absPath);
        return file.exists();
    }

    public static String getMd5FromFileName(String fileName) {
        int occurance = StringUtils.countMatches((String)fileName, (String)".");
        String md5 = "";
        if (occurance == 0) {
            md5 = fileName;
        } else if (occurance == 1) {
            md5 = fileName.substring(fileName.lastIndexOf(46) + 1);
        }
        return md5;
    }

    public boolean deleteChunkFolderIfPresent(String filePath) {
        boolean success = false;
        try {
            File currentProcessingFile = new File(filePath);
            logger.debug("Inside deleting the chunk folder if present");
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz") || currentProcessingFile.getName().startsWith("CHUNK")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                success = true;
            }
        }
        catch (Exception e) {
            logger.debug("error in deleting chunks" + e);
            logger.error("error in deleting chunks" + e.getMessage());
            success = false;
        }
        return success;
    }

    public static String getUserProfile() {
        return userProfile;
    }

    public static void setUserProfile(String userProfile) {
        ParabluFileSystemUtils.userProfile = userProfile;
    }

    public static String getInstallationDir() {
        return installationDir;
    }

    public static void setInstallationDir(String installationDir) {
        ParabluFileSystemUtils.installationDir = installationDir;
    }

    public static Object[] writeOnStream(int bufferSize, boolean isCompressionEnabled, byte[] temporaryData, long totalSizeReceived) throws Exception {
        Object[] obj = new Object[2];
        long totalSize = totalSizeReceived;
        try {
            logger.debug("Inside write On Stream");
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(bufferSize);
            OutputStream gzOutputStream = isCompressionEnabled ? new GZIPOutputStream(byteOutputStream) : byteOutputStream;
            gzOutputStream.write(temporaryData);
            gzOutputStream.close();
            byte[] actualData = byteOutputStream.toByteArray();
            obj[0] = actualData;
            obj[1] = totalSize += (long)actualData.length;
        }
        catch (Exception e) {
            logger.debug("error while chunking" + e);
            logger.error("error while chunking" + e.getMessage());
            throw new Exception();
        }
        return obj;
    }

    public static boolean isSnapshotValid() {
        return snapshotValid;
    }

    public static void setSnapshotValid(boolean snapshotValid) {
        ParabluFileSystemUtils.snapshotValid = snapshotValid;
    }

    static {
        snapshotValid = false;
    }
}

