/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.sync;

import com.parablu.epa.common.dao.ActivityHistoryImpl;
import com.parablu.epa.common.dao.ImageTableImpl;
import com.parablu.epa.common.dao.UploadTableImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.GetPrivacyGateway;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.MultiPartBackupAdapter;
import com.parablu.epa.core.adapter.pcb.SyncAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.ChunkFileElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.exception.DatabaseException;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.service.network.NetworkHelper;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.RenamedTO;
import com.parablu.epa.helper.exceptions.BaseException;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncUploadJob
extends BaseJob {
    private Logger logger = LoggerFactory.getLogger(SyncUploadJob.class);
    private static final String TMP_UPLOAD_NAME = ".pbsup.tmp";
    private List<FileTO> uploadList;
    private String uploadIP;
    private final String cloudName;
    private Integer port;
    private final String uploadTableURL;
    private final String fullDevicePath;
    private final String basePathForImageTables;
    private final String currentImageTablePath;
    private final String currentImageTableName;
    private final String token;
    private SyncAdapter uploadAdapter = null;
    private int uploadCount = 0;
    private int totalsize = 0;
    private int sizeFor5MB = 0x500000;
    private String uploadIPForGateway;
    private MultiPartBackupAdapter multiPartBackupAdapter = null;
    private String requestURL = "/sync/upload/files/all";
    private ActivityHistoryImpl activityHistory = null;
    private String batchId = "";
    private static final String FALSE_STRING = "false";

    public SyncUploadJob(String iP, Integer port, String cn, String setTableURL, String devicePath, String currentImageTablePath, String baseURlForImageTables, String currentImageTableName, String token, String keyStorePath, String gatewayIp) {
        this.uploadIP = iP;
        this.cloudName = cn;
        this.uploadTableURL = setTableURL;
        this.fullDevicePath = devicePath;
        this.uploadAdapter = new SyncAdapter(this.cloudName, keyStorePath);
        this.basePathForImageTables = baseURlForImageTables;
        this.currentImageTablePath = currentImageTablePath;
        this.currentImageTableName = currentImageTableName;
        this.token = token;
        this.port = port;
        this.activityHistory = new ActivityHistoryImpl(SettingHelper.getActivityDBUrl());
        this.uploadIPForGateway = gatewayIp;
    }

    public void run() {
        try {
            this.uploadCount = 0;
            this.uploadList = new ArrayList<FileTO>();
            SettingHelper.setErrorOccuredDuringSync(false);
            boolean readFromTable = this.readFromUploadTable();
            if (!readFromTable) {
                this.logger.debug("No records in Upload Table");
                this.updateUI(0, null);
                Thread.sleep(150L);
                return;
            }
            this.logger.debug("upload  Gateway IP: " + this.uploadIPForGateway);
            if (this.uploadIPForGateway == null) {
                SettingHelper.setErrorOccuredDuringSync(true);
                this.updateUI(0, null);
                return;
            }
            this.totalsize = this.uploadList.size();
            this.batchId = this.getBatchId(this.activityHistory);
            this.initializeMultiStream();
            if (this.multiPartBackupAdapter == null) {
                return;
            }
            for (FileTO tempUploadFileTO : this.uploadList) {
                long timeBeforeUpload = System.currentTimeMillis();
                this.logger.debug("Time before uploading file :" + timeBeforeUpload);
                if (this.isTerminated) {
                    this.logger.debug("Terminated");
                    break;
                }
                File file = new File(this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + tempUploadFileTO.getAbstractFilePath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + tempUploadFileTO.getFileName());
                tempUploadFileTO.setFileSize(file.length());
                this.logger.debug("File to be uploaded :" + tempUploadFileTO.getFileName() + "  fileSize: " + tempUploadFileTO.getFileSize());
                if (tempUploadFileTO.getFileSize() <= (long)this.sizeFor5MB) {
                    this.uploadFile(tempUploadFileTO);
                } else {
                    this.uploadFileAsChunks(tempUploadFileTO);
                }
                this.logger.debug("Total time taken to upload : " + (System.currentTimeMillis() - timeBeforeUpload));
            }
            this.updateUI(this.uploadCount, null);
            this.uploadList = null;
            this.finishMultiStream();
        }
        catch (BaseException e) {
            this.logger.trace("" + (Object)((Object)e));
            this.logger.error("BaseException" + e.getMessage());
        }
        catch (InterruptedException e) {
            this.logger.trace("" + e);
            this.logger.error("Interrupted probably cause of disconnection of account" + e.getMessage());
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception Occurred" + e);
        }
    }

    private void finishMultiStream() {
        try {
            this.multiPartBackupAdapter.finish();
        }
        catch (CrawlAdapterException e) {
            this.logger.trace("" + (Object)((Object)e));
            this.logger.error("error in multipart backup adapter finish" + e.getMessage());
        }
    }

    private void initializeMultiStream() {
        try {
            if (this.multiPartBackupAdapter == null) {
                this.multiPartBackupAdapter = new MultiPartBackupAdapter(this.uploadIPForGateway, null, this.requestURL, this.cloudName, SettingHelper.getKeystorePath());
            } else {
                this.logger.debug("connection not null>>>>>>>>");
            }
        }
        catch (Exception e1) {
            this.logger.trace("" + e1);
            this.logger.error("error in while processing multipart backup adapter" + e1.getMessage());
        }
    }

    private String getBatchId(ActivityHistoryImpl activityHistory2) {
        String currentBatchId = "";
        ActivityTO activityTO = activityHistory2.getCurrentStatusFromActivityHistoryTable();
        if (activityTO != null) {
            currentBatchId = activityTO.getBatchId();
        }
        return currentBatchId;
    }

    private boolean readFromUploadTable() {
        try {
            UploadTableImpl upload = new UploadTableImpl(this.uploadTableURL);
            this.uploadList.addAll(upload.selectSortedListFromTable());
            if (!this.uploadList.isEmpty()) {
                return true;
            }
            this.logger.debug("Upload List is empty");
            return false;
        }
        catch (DatabaseException e) {
            this.logger.error("DatabaseException: " + (Object)((Object)e));
            return false;
        }
    }

    private boolean uploadFile(FileTO fileToUpload) {
        this.updateUI(this.uploadCount, fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName());
        this.checkChunkFolderExistsAndDelete(fileToUpload);
        String absPath = this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getFileName();
        this.logger.debug(absPath);
        if (!this.handleFileExist(absPath)) {
            this.logger.debug("File not found");
            this.removeFromUploadTable(fileToUpload);
            return false;
        }
        if (!this.handleFileModified(absPath, fileToUpload.getLastModifiedTimestamp())) {
            this.logger.debug("File modified");
            if (!this.isMD5Equal(absPath, fileToUpload.getMd5checksum())) {
                this.removeFromUploadTable(fileToUpload);
                return false;
            }
        }
        long asda1 = System.currentTimeMillis();
        if (this.handleHttpRequests(fileToUpload)) {
            ++this.uploadCount;
            this.updateUI(this.uploadCount, fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName());
            long asda = System.currentTimeMillis();
            this.removeFromUploadTable(fileToUpload);
            this.logger.debug("DB time: " + (System.currentTimeMillis() - asda));
        } else {
            this.removeFromCurrentImageTable(fileToUpload);
            SettingHelper.setErrorOccuredDuringSync(true);
            this.logger.debug("Error occured during sync");
        }
        this.logger.debug("Total upload and db time: " + (System.currentTimeMillis() - asda1));
        return true;
    }

    private void removeFromCurrentImageTable(FileTO fileToUpload) {
        ImageTableImpl imageTableHandler = new ImageTableImpl(SettingHelper.getBaseDBUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + this.currentImageTableName, SettingHelper.getBaseDBUrl());
        imageTableHandler.removeFilTOFromTable(fileToUpload, this.currentImageTableName);
    }

    private boolean updateUI(int count, String fileName) {
        NotificationHelper.setTotalUploadCount(count);
        NotificationHelper.setUploadCount(String.valueOf(count) + "/" + this.totalsize);
        if (fileName != null) {
            NotificationHelper.setFileBeingUploaded(fileName);
        }
        return false;
    }

    private boolean handleFileExist(String absPath) {
        File file = new File(absPath);
        return file.exists();
    }

    private boolean handleFileModified(String absPath, long lastModifiedTimestamp) {
        File file = new File(absPath);
        if (file.isDirectory()) {
            return true;
        }
        return file.lastModified() <= lastModifiedTimestamp;
    }

    private boolean isMD5Equal(String filePath, String md5checksum) {
        File fileToCheckMD5 = new File(filePath);
        if (fileToCheckMD5.isDirectory()) {
            return true;
        }
        return md5checksum.equals(MD5Generator.generateMD5OfFile((File)fileToCheckMD5));
    }

    private boolean handleHttpRequests(FileTO fileToUpload) {
        int retrycount = 0;
        boolean copyUploadFile = false;
        boolean gaeLocal = false;
        boolean gaePublic = true;
        String currentUploadIPToUse = this.uploadIP;
        this.logger.debug("Trying to upload file:" + fileToUpload.getFileName());
        String originalFileName = fileToUpload.getFileName();
        String uploadFilePath = null;
        StringBuilder conflictedFileName = new StringBuilder();
        try {
            if (this.checkIfFileIsEditable(fileToUpload.getFileName(), fileToUpload.isFolder())) {
                copyUploadFile = true;
                String path = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + TMP_UPLOAD_NAME;
                File file = new File(path);
                uploadFilePath = this.copyFileToTempFolder(fileToUpload, file);
            } else {
                uploadFilePath = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName();
            }
        }
        catch (IOException e) {
            this.logger.error("Exception while copying file to tempFolder" + e);
        }
        if (uploadFilePath == null) {
            return false;
        }
        while (true) {
            boolean retry = false;
            try {
                this.logger.trace("Uploading file from temp folder");
                long timeBeforeUpload = System.currentTimeMillis();
                this.logger.trace("time before upload==" + timeBeforeUpload);
                if (!fileToUpload.isFolder()) {
                    File file = new File(uploadFilePath);
                    this.multiPartBackupAdapter.addFormField();
                    this.addHeaderToMultipart(fileToUpload, currentUploadIPToUse);
                    this.multiPartBackupAdapter.addFilePart(file, null);
                    return true;
                }
                int response = this.uploadAdapter.uploadFile(fileToUpload, currentUploadIPToUse, this.port, uploadFilePath, conflictedFileName, this.token);
                this.logger.trace("Time after upload==" + (System.currentTimeMillis() - timeBeforeUpload));
                this.logger.trace("Response after trying to upload:" + response);
                this.logger.trace(" Time for function  hannle http Requests ");
                if (response != 3 && response != 4) {
                    if (response == 1005) {
                        SettingHelper.setLicenseActive(false);
                        this.isTerminated = true;
                    } else if (response == 1006) {
                        this.updateSystrayToolTipNotification("Cloud disk space full", " Your cloud has reached its maximum storage limit.");
                        NotificationHelper.cloudSpaceExceeded = true;
                        this.isTerminated = true;
                    } else if (response == 1009) {
                        SettingHelper.setDeviceBlocked(true);
                        this.isTerminated = true;
                    } else if (response == 1010) {
                        this.removeFromUploadTable(fileToUpload);
                    } else if (response == 1008) {
                        this.isTerminated = true;
                    } else if (response == 1007) {
                        this.updateSystrayToolTipNotification("Upload failed  ", " The file " + fileToUpload.getFileName() + " could not be uploaded due to space restrictions.");
                    }
                    this.deleteTempFile(uploadFilePath, copyUploadFile);
                    return false;
                }
                if (response == 4) {
                    this.handleConflictDuringUpload(fileToUpload.getAbstractFilePath(), conflictedFileName, originalFileName);
                }
                NotificationHelper.cloudSpaceExceeded = false;
                this.deleteTempFile(uploadFilePath, copyUploadFile);
                this.logger.debug("Time Before Upload: " + (System.currentTimeMillis() - timeBeforeUpload));
                if (!currentUploadIPToUse.equals(this.uploadIP)) {
                    this.uploadIP = currentUploadIPToUse;
                }
                return true;
            }
            catch (CrawlAdapterException e) {
                this.logger.trace("" + (Object)((Object)e));
                this.logger.error("Exception occurred  CrawlAdapterException: " + e.getMessage());
                try {
                    retry = true;
                    ++retrycount;
                    Thread.sleep(60000L);
                    int responseForPing = this.uploadAdapter.pingGatewayIP(currentUploadIPToUse);
                    if (responseForPing != 200) {
                        String ipForPrivacyGateway = GetPrivacyGateway.getPrivacyGatewayIP();
                        this.logger.debug("the PG Gateway IP in catch" + ipForPrivacyGateway);
                    }
                }
                catch (InterruptedException ex) {
                    this.logger.trace("" + ex);
                    this.logger.error("Exception in upload file via gateway" + ex.getMessage());
                }
                catch (Exception ex) {
                    this.logger.trace("" + ex);
                    this.logger.error("error in get privacy gatewayip" + ex.getMessage());
                }
                currentUploadIPToUse = this.updateIpToUse(0, 1, currentUploadIPToUse);
                if (currentUploadIPToUse != null) continue;
                return false;
                if (retry && retrycount < 2) continue;
                return false;
            }
            break;
        }
    }

    private boolean checkIfFileIsEditable(String fileName, boolean isFolder) {
        if (isFolder) {
            return false;
        }
        String[] tokens = fileName.split("\\.(?=[^\\.]+$)");
        if (tokens.length != 2) {
            return false;
        }
        return false;
    }

    private void deleteTempFile(String tempraryFilePath, boolean copyUploadFile) {
        if (!copyUploadFile) {
            return;
        }
        File newFile = new File(tempraryFilePath);
        if (newFile.exists()) {
            newFile.delete();
        }
    }

    private String updateIpToUse(int gaeLocal, int gaePublic, String currentUploadIPToUse) {
        String[] ipToUse = new String[3];
        String[] ports = new String[2];
        String currentUploadIPToBeUsed = currentUploadIPToUse;
        boolean isIpFound = NetworkHelper.updateGaeIpFromServer((String)this.cloudName, (String)SettingHelper.getKeystorePath(), (String[])ipToUse, (String[])ports);
        if (!isIpFound) {
            if (!PropertyHelper.MAIN_EBMS_DOMAIN.isEmpty()) {
                BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
                String bluVaultIP = bluVaultIPHelper.getNearestBluVaultByResponseTime();
                if (!StringUtils.isEmpty((String)bluVaultIP)) {
                    SettingHelper.setGaeLocalIpAddress(bluVaultIP);
                    SettingHelper.setPublicIpAddress(bluVaultIP);
                    SettingHelper.setCurrentCloudIpAddress(bluVaultIP);
                }
                currentUploadIPToBeUsed = SettingHelper.getCurrentCloudIpAddress();
            }
            return currentUploadIPToBeUsed;
        }
        if (ipToUse[0] == null && ports[0] == null) {
            return null;
        }
        if (ipToUse[gaeLocal] != null && !ipToUse[gaeLocal].equals(currentUploadIPToBeUsed)) {
            currentUploadIPToBeUsed = ipToUse[gaeLocal];
        } else if (ipToUse[gaeLocal] != null) {
            currentUploadIPToBeUsed = ipToUse[gaePublic];
        }
        return currentUploadIPToBeUsed;
    }

    private void handleConflictDuringUpload(String filePath, StringBuilder conflictedFileName, String oldUploadedFileName) {
        File oldUploadedFile = new File(this.fullDevicePath + StringLiterals.FILE_SEPARATOR + filePath + StringLiterals.FILE_SEPARATOR + oldUploadedFileName);
        File renamedUploadedFile = new File(this.fullDevicePath + StringLiterals.FILE_SEPARATOR + filePath + StringLiterals.FILE_SEPARATOR + conflictedFileName.toString());
        oldUploadedFile.renameTo(renamedUploadedFile);
        ImageTableImpl imtble = new ImageTableImpl(this.currentImageTablePath, this.basePathForImageTables);
        ArrayList<RenamedTO> listOfRenamedFiles = new ArrayList<RenamedTO>();
        RenamedTO rn = new RenamedTO();
        rn.setAbstractFilePath(filePath);
        rn.setOldFileName(oldUploadedFileName);
        rn.setNewfileName(conflictedFileName.toString());
        listOfRenamedFiles.add(rn);
        imtble.updateTable(listOfRenamedFiles, this.currentImageTableName);
    }

    private String copyFileToTempFolder(FileTO fileToUpload, File tempUploadFile) throws IOException {
        String path = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName();
        this.logger.debug("The temprary upload folder for this file is: " + tempUploadFile);
        File makeTempFolder = new File(tempUploadFile.getParent());
        if (!makeTempFolder.exists()) {
            boolean success = makeTempFolder.mkdirs();
            this.logger.debug("Trying to make temp folder structure (did it succeed?)-> :" + success);
        }
        if (fileToUpload.isFolder()) {
            this.logger.debug("Whether uploaded file is folder -> " + fileToUpload.isFolder());
            return tempUploadFile.getAbsolutePath();
        }
        File actualFile = new File(path);
        if (tempUploadFile.exists()) {
            tempUploadFile.delete();
        }
        FileUtils.copyFile((File)actualFile, (File)tempUploadFile);
        tempUploadFile.deleteOnExit();
        return tempUploadFile.getAbsolutePath();
    }

    private boolean uploadFileAsChunks(FileTO fileToUpload) {
        this.updateUI(this.uploadCount, fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName());
        String absPath = this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getFileName();
        this.logger.debug(absPath);
        if (!this.handleFileExist(absPath)) {
            this.logger.debug("File not found");
            this.removeFromUploadTable(fileToUpload);
            return false;
        }
        if (!this.handleFileModified(absPath, fileToUpload.getLastModifiedTimestamp())) {
            this.logger.debug("File modified");
            if (!this.isMD5Equal(absPath, fileToUpload.getMd5checksum())) {
                this.removeFromUploadTable(fileToUpload);
                return false;
            }
        }
        long asda1 = System.currentTimeMillis();
        if (this.handleHttpRequestsForUploadChunks(fileToUpload)) {
            ++this.uploadCount;
            this.updateUI(this.uploadCount, fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName());
            long asda = System.currentTimeMillis();
            this.removeFromUploadTable(fileToUpload);
            this.logger.debug("DB time: " + (System.currentTimeMillis() - asda));
        } else {
            this.removeFromCurrentImageTable(fileToUpload);
            SettingHelper.setErrorOccuredDuringSync(true);
            this.logger.debug("Error occured during sync");
        }
        this.logger.debug("Total upload and db time: " + (System.currentTimeMillis() - asda1));
        return true;
    }

    private boolean removeFromUploadTable(FileTO fileToRemove) {
        boolean success = false;
        UploadTableImpl upload = new UploadTableImpl(this.uploadTableURL);
        upload.removeFromTable(fileToRemove);
        return success;
    }

    public void abortUploadProcesses() {
        if (this.uploadAdapter != null) {
            this.uploadAdapter.cancelHttpPut();
        }
    }

    private boolean handleHttpRequestsForUploadChunks(FileTO fileToUpload) {
        List<String> listOfChunkFiles;
        String uploadFilePath = null;
        String chunkPath = this.createPreRequisiteForChunk(fileToUpload);
        try {
            if (this.checkIfFileIsEditable(fileToUpload.getFileName(), fileToUpload.isFolder())) {
                String path = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + TMP_UPLOAD_NAME;
                File file = new File(path);
                uploadFilePath = this.copyFileToTempFolder(fileToUpload, file);
            } else {
                uploadFilePath = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName();
            }
        }
        catch (IOException e) {
            this.logger.error("Exception while copying file to tempFolder" + e);
        }
        if (uploadFilePath == null) {
            return false;
        }
        String sourcePath = SettingHelper.getParabluSyncFolder() + File.separator + fileToUpload.getAbstractFilePath() + File.separator + fileToUpload.getFileName();
        this.logger.debug("FilePath " + sourcePath);
        String destinationPath = chunkPath + File.separator;
        File file = new File(destinationPath);
        if (file.list().length == 0) {
            try {
                this.splitAndWrite(sourcePath, destinationPath);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("exception in split and write" + e.getMessage());
            }
        }
        if ((listOfChunkFiles = SyncUploadJob.getExistingFileNames(destinationPath)).isEmpty()) {
            this.deleteChunkFolder(file);
            this.logger.debug("LIst of chunks size is zero");
            return false;
        }
        ChunkFileElement chunkFileElement = new ChunkFileElement();
        chunkFileElement.setFileChunks(listOfChunkFiles);
        boolean uploadChunkResponse = true;
        try {
            uploadChunkResponse = this.uploadChunkFilesNew(fileToUpload, destinationPath, chunkFileElement, true);
        }
        catch (Exception e1) {
            this.logger.trace("" + e1);
            this.logger.error("Exception" + e1.getMessage());
        }
        if (!uploadChunkResponse) {
            try {
                FileUtils.cleanDirectory((File)file);
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("error in cleaning the directory" + e.getMessage());
            }
            this.deleteChunkFolder(file);
            return false;
        }
        this.logger.debug("Chunk File merged successfully. ");
        try {
            FileUtils.cleanDirectory((File)file);
        }
        catch (IOException e) {
            this.logger.trace("" + e);
            this.logger.error("error in cleaning the directory" + e.getMessage());
        }
        this.deleteChunkFolder(file);
        return true;
    }

    private String createPreRequisiteForChunk(FileTO fileToUpload) {
        String chunkPath;
        String osType = SettingHelper.getOsName();
        if (osType.toLowerCase().contains("win")) {
            chunkPath = new StringBuffer().append(this.fullDevicePath + File.separator + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("CHUNK").toString();
            this.createChunkFolderAndHideIt(chunkPath);
        } else {
            chunkPath = new StringBuffer().append(this.fullDevicePath + File.separator + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".CHUNK").toString();
            this.createChunkFolder(chunkPath);
        }
        return chunkPath;
    }

    private void createChunkFolderAndHideIt(String chunkPath) {
        try {
            Process proc;
            int exitVal;
            Runtime rt = Runtime.getRuntime();
            boolean success = this.createFolder(chunkPath);
            if (success && (exitVal = (proc = rt.exec("attrib +h " + chunkPath)).waitFor()) != 0) {
                Process proc1 = rt.exec("attrib +h " + chunkPath);
                proc1.waitFor();
            }
        }
        catch (Exception t) {
            this.logger.trace("" + t);
            this.logger.error("Make Hidden Folder exception" + t.getMessage());
        }
    }

    private void createChunkFolder(String chunkPath) {
        try {
            this.createFolder(chunkPath);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Error in create chunk folder" + e.getMessage());
        }
    }

    private boolean createFolder(String filename) {
        boolean success = true;
        File file = new File(filename);
        if (file.exists()) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Error in creating folder" + e.getMessage());
            }
        }
        if (!file.exists()) {
            success = file.mkdirs();
        }
        return success;
    }

    public void splitAndWrite(String sourceFilePath, String destinationPath) throws IOException, NoSuchAlgorithmException {
        int chunkSize = 524288;
        File willBeRead = new File(sourceFilePath);
        if (!willBeRead.exists()) {
            return;
        }
        long fileSize = willBeRead.length();
        HashMap<String, String> md5AndFileValueMap = new HashMap<String, String>();
        int numberOfChunks = 0;
        byte[] temporary = null;
        long totalBytesRead = 0L;
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(willBeRead));){
            this.logger.debug("Inside split and write function");
            while (totalBytesRead < fileSize) {
                int bytesRead;
                String partName = String.valueOf(numberOfChunks);
                long bytesRemaining = fileSize - totalBytesRead;
                if (bytesRemaining < (long)chunkSize) {
                    chunkSize = Integer.parseInt(Long.toString(bytesRemaining));
                    this.logger.debug("CHUNK_SIZE: " + chunkSize);
                }
                if ((bytesRead = ((InputStream)inStream).read(temporary = new byte[chunkSize], 0, chunkSize)) > 0) {
                    totalBytesRead += (long)bytesRead;
                    ++numberOfChunks;
                }
                this.write(temporary, destinationPath + partName);
                File tempFile = new File(destinationPath + partName);
                String tempFileMd5 = MD5Generator.generateMD5OfFile((File)tempFile);
                String newName = String.format("part%09d.%s", numberOfChunks, tempFileMd5);
                File renameFile = new File(destinationPath + newName);
                tempFile.renameTo(renameFile);
                md5AndFileValueMap.put(tempFileMd5, tempFile.getPath());
            }
            this.logger.debug("End of split and write function");
        }
    }

    void write(byte[] dataByteArray, String destinationFileName) throws IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destinationFileName));
        ((OutputStream)output).write(dataByteArray);
        ((OutputStream)output).close();
    }

    public static List<String> getExistingFileNames(String path) {
        ArrayList<String> results = new ArrayList<String>();
        File[] files = new File(path).listFiles();
        Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        for (File file : files) {
            if (!file.isFile()) continue;
            results.add(file.getName());
        }
        return results;
    }

    private boolean uploadChunkFilesNew(FileTO tempUploadFileTO, String destinationPath, ChunkFileElement chunkFileElement, boolean viaGateway) throws NoSuchAlgorithmException, FileNotFoundException, InvalidKeyException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.updateUI(this.uploadCount, tempUploadFileTO.getAbstractFilePath());
        String nearestGatewayIP = this.uploadIP;
        String isAchunkFile = "true";
        if (viaGateway) {
            nearestGatewayIP = this.uploadIPForGateway;
        }
        for (String chunk : chunkFileElement.getFileChunks()) {
            chunkFileElement.setDeviceUUID(SettingHelper.getDeviceUUId());
            chunkFileElement.setChecksum(MD5Generator.generateMD5OfFile((File)new File(destinationPath + chunk)));
            chunkFileElement.setFileCompletePath(destinationPath + chunk);
            chunkFileElement.setFileName(chunk);
            File file = new File(chunkFileElement.getFileCompletePath());
            this.multiPartBackupAdapter.addFormField();
            this.addHeaderToMultipart(tempUploadFileTO, nearestGatewayIP);
            this.addHeaderToMultipartforChunks(chunkFileElement);
            this.multiPartBackupAdapter.addHeaderField("isAChunkFile", isAchunkFile);
            this.multiPartBackupAdapter.addFilePart(file, null);
        }
        this.sendChunkValues(tempUploadFileTO, destinationPath, chunkFileElement, nearestGatewayIP);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChunkValues(FileTO tempUploadFileTO, String destinationPath, ChunkFileElement chunkFileElement, String nearestGatewayIP) {
        this.multiPartBackupAdapter.addFormField();
        this.addHeaderToMultipart(tempUploadFileTO, nearestGatewayIP);
        this.addHeaderToMultipartforChunks(chunkFileElement);
        this.multiPartBackupAdapter.addHeaderField("isAChunkFile", FALSE_STRING);
        File chunkValuefile = null;
        OutputStreamWriter fileWriter = null;
        try {
            chunkValuefile = new File(destinationPath + "chunkvalues");
            if (!chunkValuefile.exists()) {
                chunkValuefile.createNewFile();
            }
            String fileChunks = StringUtils.join((Collection)chunkFileElement.getFileChunks(), (char)',');
            fileWriter = new FileWriter(chunkValuefile);
            fileWriter.write(fileChunks);
            fileWriter.flush();
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception : " + e.getMessage());
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    this.logger.trace("" + e);
                    this.logger.error("Exception" + e.getMessage());
                }
            }
        }
        this.multiPartBackupAdapter.addFilePart(chunkValuefile, null);
    }

    private void deleteChunkFolder(File file) {
        if (file.isDirectory() && file.list().length == 0) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Chunk folder deletion Failed" + e.getMessage());
            }
            this.logger.debug("chunk folder deleted successfully");
        }
    }

    private void checkChunkFolderExistsAndDelete(FileTO fileToUpload) {
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            String chunkPath = new StringBuffer().append(this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("CHUNK").toString();
            File file = new File(chunkPath);
            if (file.exists()) {
                this.deleteChunkFolder(file);
            }
        } else {
            String chunkPath = new StringBuffer().append(this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".CHUNK").toString();
            File file = new File(chunkPath);
            if (file.exists()) {
                this.deleteChunkFolder(file);
            }
        }
    }

    private void addHeaderToMultipart(FileTO fileToUpload, String currentUploadIPToUse) {
        this.logger.debug("adding header>>>>>>>>>>>");
        this.multiPartBackupAdapter.addHeaderField("gatewayName", currentUploadIPToUse);
        this.multiPartBackupAdapter.addHeaderField("fileMD5", fileToUpload.getMd5checksum());
        this.multiPartBackupAdapter.addHeaderField("maxVersions", String.valueOf(SettingHelper.getMaxVersionsToKeep()));
        this.multiPartBackupAdapter.addHeaderField("is-base-folder", String.valueOf(false));
        this.multiPartBackupAdapter.addHeaderField("is-folder", String.valueOf(fileToUpload.isFolder()));
        this.multiPartBackupAdapter.addHeaderField("is-exists", String.valueOf(true));
        this.multiPartBackupAdapter.addHeaderField("fileMD5", fileToUpload.getMd5checksum());
        this.multiPartBackupAdapter.addHeaderField("modified", String.valueOf(fileToUpload.getLastModifiedTimestamp()));
        this.multiPartBackupAdapter.addHeaderField("backupBatchId", this.batchId);
        this.multiPartBackupAdapter.addHeaderField("userUnderLegalHold", FALSE_STRING);
        this.multiPartBackupAdapter.addHeaderField("userName", SettingHelper.getUserName().toLowerCase());
        this.multiPartBackupAdapter.addHeaderField("deviceUUID", SettingHelper.getDeviceUUId());
        this.multiPartBackupAdapter.addHeaderField("file-path", fileToUpload.getAbstractFilePath());
        this.multiPartBackupAdapter.addHeaderField("file-name", fileToUpload.getFileName());
        this.multiPartBackupAdapter.addHeaderField("cloudName", this.cloudName);
        this.multiPartBackupAdapter.addHeaderField("token", this.token);
        this.multiPartBackupAdapter.addHeaderField("osType", SettingHelper.getOsName());
        this.multiPartBackupAdapter.addHeaderField("file-size", String.valueOf(fileToUpload.getFileSize()));
    }

    private void addHeaderToMultipartforChunks(ChunkFileElement chunkFileElement) {
        this.logger.debug("adding header>>>>>>>>>>>");
        this.multiPartBackupAdapter.addHeaderField("chunkFileMD5", chunkFileElement.getChecksum());
        this.logger.debug("chunk Md5 checkSum>>>>" + chunkFileElement.getChecksum());
        this.multiPartBackupAdapter.addHeaderField("chunkFileName", chunkFileElement.getFileName());
        this.multiPartBackupAdapter.addHeaderField("isNormalFile", FALSE_STRING);
    }
}

