/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.support;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.api.SupportAdapter;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.LogFileElementList;
import com.parablu.epa.core.element.LogFileInfoElement;
import com.parablu.epa.core.element.NewSupportElement;
import com.parablu.epa.core.to.DisplayTo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SupportHelper {
    private static SupportAdapter supportAdapter = new SupportAdapter(SettingHelper.getKeystorePath());
    private static boolean supportRequestInitiated = false;
    private static String supportRequestId = null;
    private static Logger logger = LoggerFactory.getLogger(SupportHelper.class);

    private SupportHelper() {
    }

    public static int sendNewSupportLogs(String cloudName, String userName, String deviceName, boolean sendLogs) {
        supportRequestInitiated = true;
        String requestId = null;
        NewSupportElement supportElement = new NewSupportElement();
        LogFileElementList logFileElementList = new LogFileElementList();
        List<LogFileInfoElement> fileInfoElementList = SupportHelper.getLogFileInfo();
        logFileElementList.setLogFiles(fileInfoElementList);
        supportElement.setId(String.valueOf(System.currentTimeMillis()));
        supportElement.setCloudName(cloudName);
        supportElement.setDeviceName(deviceName);
        supportElement.setTimestamp(String.valueOf(System.currentTimeMillis()));
        supportElement.setUserName(userName);
        supportElement.setFileElementList(logFileElementList);
        String token = null;
        try {
            token = SettingHelper.readTokenFromFile();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception geting token:" + e.getMessage());
        }
        logger.debug("Sending prelim request");
        if (supportAdapter.sendSupportMessage(cloudName, supportElement, SettingHelper.getCurrentCloudIpAddress(), token)) {
            requestId = supportAdapter.getRequestID();
        }
        if (requestId == null) {
            logger.debug("Support Request ID is null");
            supportRequestInitiated = false;
            return 1;
        }
        supportRequestId = requestId;
        if (!sendLogs) {
            supportRequestInitiated = false;
            return 1;
        }
        logger.debug("Compressing Files");
        File file = SupportHelper.compressLogs();
        if (file == null) {
            supportRequestInitiated = false;
            return 1;
        }
        logger.debug("Sending Support File");
        if (supportAdapter.sendSupportLogsNew(file, cloudName, userName, SettingHelper.getCurrentCloudIpAddress(), token, SettingHelper.getDeviceUUId())) {
            file.delete();
            supportRequestInitiated = false;
            return 2;
        }
        file.delete();
        supportRequestInitiated = false;
        return 1;
    }

    private static List<LogFileInfoElement> getLogFileInfo() {
        ArrayList<LogFileInfoElement> logFilesList = new ArrayList<LogFileInfoElement>();
        String basePathforService = null;
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            String basePath = SettingHelper.getParabluBlusyncAppDataFolderUrl();
            basePathforService = SettingHelper.getInstallationDir() + StringLiterals.FILE_SEPARATOR + "Blusync";
            File debugFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.debug");
            File warnFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.warn");
            File errorFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.error");
            File infoFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.info");
            File debugFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.debug");
            File warnFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.warn");
            File errorFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.error");
            File infoFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.info");
            File vssapiProvider = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "vssapiProvider.log");
            ArrayList<File> files = new ArrayList<File>();
            files.add(debugFile);
            files.add(warnFile);
            files.add(errorFile);
            files.add(infoFile);
            files.add(debugFileforService);
            files.add(warnFileforService);
            files.add(errorFileforService);
            files.add(infoFileforService);
            files.add(vssapiProvider);
            for (File file : files) {
                LogFileInfoElement fileInfoElement = new LogFileInfoElement();
                fileInfoElement.setFilename(file.getName());
                fileInfoElement.setSize(String.valueOf(file.length()));
                fileInfoElement.setLastModified(String.valueOf(file.lastModified()));
                logFilesList.add(fileInfoElement);
            }
            return logFilesList;
        }
        String basePath = SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync";
        File debugFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.debug");
        File warnFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.warn");
        File errorFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.error");
        File infoFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.info");
        ArrayList<File> files = new ArrayList<File>();
        files.add(debugFile);
        files.add(warnFile);
        files.add(errorFile);
        files.add(infoFile);
        for (File file : files) {
            LogFileInfoElement fileInfoElement = new LogFileInfoElement();
            fileInfoElement.setFilename(file.getName());
            fileInfoElement.setSize(String.valueOf(file.length()));
            fileInfoElement.setLastModified(String.valueOf(file.lastModified()));
            logFilesList.add(fileInfoElement);
        }
        return logFilesList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File compressLogs() {
        String basePathforService = null;
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            String basePath = SettingHelper.getParabluBlusyncAppDataFolderUrl();
            basePathforService = SettingHelper.getInstallationDir() + StringLiterals.FILE_SEPARATOR + "Blusync";
            File debugFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.debug");
            File warnFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.warn");
            File errorFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.error");
            File infoFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.info");
            File debugFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.debug");
            File warnFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.warn");
            File errorFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.error");
            File infoFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.info");
            File vssapiProvider = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "vssapiProvider.log");
            File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "pblog.zip");
            if (logZip.exists()) {
                logZip.delete();
            }
            try (ZipOutputStream zipOutputStream2 = new ZipOutputStream(new FileOutputStream(logZip));){
                logZip.createNewFile();
                SupportHelper.addEntryToZip(debugFile, zipOutputStream2);
                SupportHelper.addEntryToZip(warnFile, zipOutputStream2);
                SupportHelper.addEntryToZip(errorFile, zipOutputStream2);
                SupportHelper.addEntryToZip(infoFile, zipOutputStream2);
                SupportHelper.addEntryToZip(debugFileforService, zipOutputStream2);
                SupportHelper.addEntryToZip(warnFileforService, zipOutputStream2);
                SupportHelper.addEntryToZip(errorFileforService, zipOutputStream2);
                SupportHelper.addEntryToZip(infoFileforService, zipOutputStream2);
                SupportHelper.addEntryToZip(vssapiProvider, zipOutputStream2);
                IOUtils.closeQuietly((OutputStream)zipOutputStream2);
                File file2 = logZip;
                return file2;
            }
            catch (IOException e) {
                logger.error("IOException while entering to zip", (Throwable)e);
                return null;
            }
        }
        String basePath = SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync";
        File debugFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.debug");
        File warnFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.warn");
        File errorFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.error");
        File infoFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.info");
        File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "pblog.zip");
        if (logZip.exists()) {
            logZip.delete();
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));){
            logZip.createNewFile();
            SupportHelper.addEntryToZip(debugFile, zipOutputStream);
            SupportHelper.addEntryToZip(warnFile, zipOutputStream);
            SupportHelper.addEntryToZip(errorFile, zipOutputStream);
            SupportHelper.addEntryToZip(infoFile, zipOutputStream);
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
            File file = logZip;
            return file;
        }
        catch (IOException e) {
            logger.error("IOException while entering to zip", (Throwable)e);
            return null;
        }
    }

    public static void addEntryToZip(File logFile, ZipOutputStream zipOutputStream) throws IOException {
        if (logFile.exists()) {
            ZipEntry zipEntry = new ZipEntry(logFile.getName());
            zipOutputStream.putNextEntry(zipEntry);
            FileInputStream fileInputStream = new FileInputStream(logFile);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
            fileInputStream.close();
            zipOutputStream.closeEntry();
        }
    }

    public static boolean isSupportRequestInitiated() {
        return supportRequestInitiated;
    }

    public static void setSupportRequestInitiated(boolean supportRequestInitiated) {
        SupportHelper.supportRequestInitiated = supportRequestInitiated;
    }

    public static String getSupportRequestId() {
        return supportRequestId;
    }

    public static void setSupportRequestId(String supportRequestId) {
        SupportHelper.supportRequestId = supportRequestId;
    }

    public static boolean checkDeviceBlocked() {
        logger.debug("check the selected device to restore is blocked or not");
        BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        try {
            List listDevices = backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.readTokenFromFile());
            Iterator deviceList = listDevices.iterator();
            if (deviceList != null) {
                while (deviceList.hasNext()) {
                    if (!SettingHelper.getDeviceUUId().equalsIgnoreCase(((DisplayTo)deviceList.next()).getDeviceUid())) continue;
                    logger.debug("device is not blocked");
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.toString());
            logger.trace("" + e);
            logger.error("exception" + e.getMessage());
        }
        return false;
    }
}

