/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.service.settings.SettingHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceManagementService {
    private static Logger logger = LoggerFactory.getLogger(InterfaceManagementService.class);
    private static final String MESSAGE = "Inavlid option recieved";

    private InterfaceManagementService() {
    }

    public static void initialiseUISettings(String productType, List<String> uiPermissionsList) {
        block29: {
            block28: {
                if (!"BACKUP".equalsIgnoreCase(productType)) break block28;
                InterfaceManagementService.initialiseDefaultUISettings("BACKUP", false);
                for (String permission : uiPermissionsList) {
                    try {
                        switch (interfaceFeatures.valueOf(permission)) {
                            case EXIT: {
                                SettingHelper.setExitBackupInterfaceEnabled(true);
                                break;
                            }
                            case DECOUPLE: {
                                SettingHelper.setDecoupleBackupInterfaceEnabled(true);
                                break;
                            }
                            case SUPPORT: {
                                SettingHelper.setSupportBackupInterfaceEnabled(true);
                                break;
                            }
                            case INTIATE_BACKUP: {
                                SettingHelper.setInitiateBackupInterfaceEnabled(true);
                                break;
                            }
                            case RESTORE: {
                                SettingHelper.setRestoreInterfaceEnabled(true);
                                break;
                            }
                            case STOP_BACKUP: {
                                SettingHelper.setStopBackupInterfaceEnabled(true);
                                break;
                            }
                            case BACKUP_SETTINGS: {
                                SettingHelper.setBackupSettingsInterfaceEnabled(true);
                                break;
                            }
                            case BACKUP_FILES: {
                                SettingHelper.setBackupFilesInterfaceEnabled(true);
                                break;
                            }
                            case REFRESH_BACKUP_POLICY: {
                                SettingHelper.setRefreshBackupPolicyInterfaceEnabled(true);
                                break;
                            }
                            default: {
                                logger.debug("Invalid Option recived : " + permission);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error(MESSAGE + e);
                    }
                }
                break block29;
            }
            if (!"SYNC".equalsIgnoreCase(productType)) break block29;
            InterfaceManagementService.initialiseDefaultUISettings("SYNC", false);
            for (String permission : uiPermissionsList) {
                try {
                    switch (interfaceFeatures.valueOf(permission)) {
                        case INITIATE_SYNC: {
                            SettingHelper.setSyncNowInterfaceEnabled(true);
                            break;
                        }
                        case SYNC_SETTINGS: {
                            SettingHelper.setSyncSettingsInterfaceEnabled(true);
                            break;
                        }
                        case SYNC_FILES: {
                            SettingHelper.setSyncFilesInterfaceEnabled(true);
                            break;
                        }
                        case REFRESH_SYNC_POLICY: {
                            SettingHelper.setRefreshSyncPolicyInterfaceEnabled(true);
                            break;
                        }
                        case SEARCH: {
                            SettingHelper.setSearchInterfaceEnabled(true);
                            break;
                        }
                        case OPEN_SYNC_FOLDER: {
                            SettingHelper.setOpenSyncFolderInterfaceEnabled(true);
                            break;
                        }
                        case EXIT: {
                            SettingHelper.setExitSyncInterfaceEnabled(true);
                            break;
                        }
                        case DECOUPLE: {
                            SettingHelper.setDecoupleSyncInterfaceEnabled(true);
                            break;
                        }
                        case SUPPORT: {
                            SettingHelper.setSupportSyncInterfaceEnabled(true);
                            break;
                        }
                        default: {
                            logger.debug("Invalid Option recived : " + permission);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(MESSAGE + e);
                }
            }
        }
    }

    public static void initialiseDefaultUISettings(String productType, boolean defaultValue) {
        if ("BACKUP".equalsIgnoreCase(productType)) {
            SettingHelper.setExitBackupInterfaceEnabled(defaultValue);
            SettingHelper.setDecoupleBackupInterfaceEnabled(defaultValue);
            SettingHelper.setSupportBackupInterfaceEnabled(defaultValue);
            SettingHelper.setInitiateBackupInterfaceEnabled(defaultValue);
            SettingHelper.setRestoreInterfaceEnabled(defaultValue);
            SettingHelper.setStopBackupInterfaceEnabled(defaultValue);
            SettingHelper.setBackupSettingsInterfaceEnabled(defaultValue);
            SettingHelper.setBackupFilesInterfaceEnabled(defaultValue);
            SettingHelper.setRefreshBackupPolicyInterfaceEnabled(defaultValue);
        } else if ("SYNC".equalsIgnoreCase(productType)) {
            SettingHelper.setExitSyncInterfaceEnabled(defaultValue);
            SettingHelper.setDecoupleSyncInterfaceEnabled(defaultValue);
            SettingHelper.setSupportSyncInterfaceEnabled(defaultValue);
            SettingHelper.setSyncNowInterfaceEnabled(defaultValue);
            SettingHelper.setSyncSettingsInterfaceEnabled(defaultValue);
            SettingHelper.setSyncFilesInterfaceEnabled(defaultValue);
            SettingHelper.setRefreshSyncPolicyInterfaceEnabled(defaultValue);
            SettingHelper.setSearchInterfaceEnabled(defaultValue);
            SettingHelper.setOpenSyncFolderInterfaceEnabled(defaultValue);
        }
    }

    public static enum interfaceFeatures {
        EXIT,
        DECOUPLE,
        SUPPORT,
        INTIATE_BACKUP,
        RESTORE,
        STOP_BACKUP,
        BACKUP_SETTINGS,
        BACKUP_FILES,
        REFRESH_BACKUP_POLICY,
        INITIATE_SYNC,
        SYNC_SETTINGS,
        SYNC_FILES,
        REFRESH_SYNC_POLICY,
        SEARCH,
        OPEN_SYNC_FOLDER;

    }
}

